/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.transport.sharedport;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.peer.PEPeerServerListener;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerServerAdapter;
import org.gudy.azureus2.core3.peer.impl.PEPeerServerHelper;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.transport.base.PEPeerServerImpl;
import org.gudy.azureus2.core3.peer.impl.transport.base.PEPeerTransportImpl;
import org.gudy.azureus2.core3.peer.impl.transport.sharedport.PESharedPortSelector;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class PESharedPortServerImpl
implements PEPeerServerHelper {
    private static final AEMonitor class_mon = new AEMonitor("PESharedPortServerImpl:class");
    protected static PEPeerServerHelper server_delegate;
    protected static PESharedPortSelector selector;
    protected PEPeerServerAdapter adapter;
    protected List listeners;

    public PESharedPortServerImpl() {
        block6: {
            this.listeners = new ArrayList();
            try {
                class_mon.enter();
                if (server_delegate != null) break block6;
                try {
                    selector = new PESharedPortSelector();
                    server_delegate = PEPeerServerImpl.create();
                    if (server_delegate == null || server_delegate.getPort() == 0) {
                        server_delegate = null;
                        break block6;
                    }
                    server_delegate.setServerAdapter(new PEPeerServerAdapter(){

                        public void addPeerTransport(Object param) {
                            selector.addSocket((SocketChannel)param);
                        }

                        public PEPeerControl getControl() {
                            System.out.println("PESharedPortServer::getControl - should never be called!!!!");
                            throw new RuntimeException("whoops!");
                        }
                    });
                    server_delegate.startServer();
                }
                catch (IOException e) {
                    LGLogger.log(0, 0, 0, "PESharedPortServer: failed to establish selector" + e.toString());
                    LGLogger.logUnrepeatableAlertUsingResource(3, "SharedPortServer.alert.selectorfailed");
                    Debug.printStackTrace(e);
                }
            }
            finally {
                class_mon.exit();
            }
        }
    }

    public int getPort() {
        return server_delegate == null ? 0 : server_delegate.getPort();
    }

    public void startServer() {
        selector.addHash(this, this.adapter.getControl().getHash());
    }

    public void stopServer() {
        selector.removeHash(this, this.adapter.getControl().getHash());
    }

    public void setServerAdapter(PEPeerServerAdapter _adapter) {
        this.adapter = _adapter;
    }

    public void clearServerAdapter() {
        this.adapter = null;
    }

    protected void connectionReceived(SocketChannel socket, byte[] data_read) {
        PEPeerServerAdapter a = this.adapter;
        if (a != null) {
            a.addPeerTransport(new Object[]{socket, data_read});
        }
    }

    public PEPeerTransport createPeerTransport(Object param) {
        Object[] temp = (Object[])param;
        SocketChannel channel = (SocketChannel)temp[0];
        byte[] data = (byte[])temp[1];
        return new PEPeerTransportImpl(this.adapter.getControl(), channel, data);
    }

    public void addListener(PEPeerServerListener l) {
        if (server_delegate == null) {
            Debug.out("PESharedPortServer:addListener - failes as no delegate");
        } else {
            server_delegate.addListener(l);
        }
    }

    public void removeListener(PEPeerServerListener l) {
        if (server_delegate == null) {
            Debug.out("PESharedPortServer:removeListener - failes as no delegate");
        } else {
            server_delegate.removeListener(l);
        }
    }
}

