/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderCandidate;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderFallback;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderReal;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.LocaleUtilListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class LocaleUtil {
    private static final String systemEncoding = System.getProperty("file.encoding");
    private static final String[] manual_charset = new String[]{systemEncoding, "Big5", "EUC-JP", "EUC-KR", "GB18030", "GB2312", "GBK", "ISO-2022-JP", "ISO-2022-KR", "Shift_JIS", "KOI8-R", "TIS-620", "UTF8", "windows-1251", "ISO-8859-1"};
    protected static final String[] generalCharsets = new String[]{"ISO-8859-1", "UTF8", systemEncoding};
    private static LocaleUtil singleton = new LocaleUtil();
    private LocaleUtilDecoder[] all_decoders;
    private LocaleUtilDecoder[] general_decoders;
    private LocaleUtilDecoder system_decoder;
    private LocaleUtilDecoder fallback_decoder;
    private List listeners = new ArrayList();

    public static LocaleUtil getSingleton() {
        return singleton;
    }

    private LocaleUtil() {
        ArrayList<LocaleUtilDecoder> decoders = new ArrayList<LocaleUtilDecoder>();
        ArrayList<String> decoder_names = new ArrayList<String>();
        int i = 0;
        while (i < manual_charset.length) {
            try {
                String name = manual_charset[i];
                CharsetDecoder decoder = Charset.forName(name).newDecoder();
                if (decoder != null) {
                    LocaleUtilDecoderReal lu_decoder = new LocaleUtilDecoderReal(decoders.size(), decoder);
                    decoder_names.add(lu_decoder.getName());
                    if (i == 0) {
                        this.system_decoder = lu_decoder;
                    }
                    decoders.add(lu_decoder);
                } else if (i == 0) {
                    Debug.out("System decoder failed to be found!!!!");
                }
            }
            catch (Exception name) {
                // empty catch block
            }
            ++i;
        }
        this.general_decoders = new LocaleUtilDecoder[generalCharsets.length];
        i = 0;
        while (i < this.general_decoders.length) {
            int gi = decoder_names.indexOf(generalCharsets[i]);
            if (gi != -1) {
                this.general_decoders[i] = (LocaleUtilDecoder)decoders.get(gi);
            }
            ++i;
        }
        boolean show_all = COConfigurationManager.getBooleanParameter("File.Decoder.ShowAll");
        if (show_all) {
            SortedMap<String, Charset> m = Charset.availableCharsets();
            Iterator it = m.keySet().iterator();
            while (it.hasNext()) {
                String charset_name = (String)it.next();
                if (decoder_names.contains(charset_name)) continue;
                try {
                    CharsetDecoder decoder = Charset.forName(charset_name).newDecoder();
                    if (decoder == null) continue;
                    LocaleUtilDecoderReal lu_decoder = new LocaleUtilDecoderReal(decoders.size(), decoder);
                    decoders.add(lu_decoder);
                    decoder_names.add(lu_decoder.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.fallback_decoder = new LocaleUtilDecoderFallback(decoders.size());
        decoders.add(this.fallback_decoder);
        this.all_decoders = new LocaleUtilDecoder[decoders.size()];
        decoders.toArray(this.all_decoders);
    }

    public String getSystemEncoding() {
        return systemEncoding;
    }

    public LocaleUtilDecoder[] getDecoders() {
        return this.all_decoders;
    }

    public LocaleUtilDecoder[] getGeneralDecoders() {
        return this.general_decoders;
    }

    public LocaleUtilDecoder getSystemDecoder() {
        return this.system_decoder;
    }

    protected LocaleUtilDecoderCandidate[] getCandidates(byte[] array) {
        LocaleUtilDecoderCandidate[] candidates = new LocaleUtilDecoderCandidate[this.all_decoders.length];
        boolean show_less_likely_conversions = COConfigurationManager.getBooleanParameter("File.Decoder.ShowLax");
        int i = 0;
        while (i < this.all_decoders.length) {
            candidates[i] = new LocaleUtilDecoderCandidate(i);
            try {
                LocaleUtilDecoder decoder = this.all_decoders[i];
                String str = decoder.tryDecode(array, show_less_likely_conversions);
                if (str != null) {
                    candidates[i].setDetails(decoder, str);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return candidates;
    }

    protected LocaleUtilDecoder[] getCandidateDecoders(byte[] array) {
        LocaleUtilDecoderCandidate[] candidates = this.getCandidates(array);
        ArrayList<LocaleUtilDecoder> decoders = new ArrayList<LocaleUtilDecoder>();
        int i = 0;
        while (i < candidates.length) {
            LocaleUtilDecoder d = candidates[i].getDecoder();
            if (d != null) {
                decoders.add(d);
            }
            ++i;
        }
        LocaleUtilDecoder[] res = new LocaleUtilDecoder[decoders.size()];
        decoders.toArray(res);
        return res;
    }

    public void addListener(LocaleUtilListener l) {
        this.listeners.add(l);
    }

    public void removeListener(LocaleUtilListener l) {
        this.listeners.remove(l);
    }

    public LocaleUtilDecoder getTorrentEncodingIfAvailable(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException {
        String encoding = torrent.getAdditionalStringProperty("encoding");
        if (encoding != null) {
            String canonical_name = Charset.forName(encoding).name();
            int i = 0;
            while (i < this.all_decoders.length) {
                if (this.all_decoders[i].getName().equals(canonical_name)) {
                    return this.all_decoders[i];
                }
                ++i;
            }
        }
        return null;
    }

    public LocaleUtilDecoder getTorrentEncoding(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException, LocaleUtilEncodingException {
        String encoding = torrent.getAdditionalStringProperty("encoding");
        if (encoding != null) {
            try {
                String canonical_name = encoding.equals(this.fallback_decoder.getName()) ? encoding : Charset.forName(encoding).name();
                int i = 0;
                while (i < this.all_decoders.length) {
                    if (this.all_decoders[i].getName().equals(canonical_name)) {
                        return this.all_decoders[i];
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        LocaleUtilDecoder[] valid_decoders = this.getTorrentCandidateDecoders(torrent);
        LocaleUtilDecoderCandidate[] candidates = this.getCandidates(torrent.getName());
        boolean system_decoder_is_valid = false;
        int i = 0;
        while (i < candidates.length) {
            LocaleUtilDecoderCandidate candidate = candidates[i];
            if (candidate.getDecoder() != null) {
                boolean ok = false;
                int j = 0;
                while (j < valid_decoders.length) {
                    if (candidate.getDecoder() == valid_decoders[j]) {
                        if (candidate.getDecoder() == this.system_decoder) {
                            system_decoder_is_valid = true;
                        }
                        ok = true;
                        break;
                    }
                    ++j;
                }
                if (!ok) {
                    candidate.setDetails(null, null);
                }
            }
            ++i;
        }
        LocaleUtilDecoder selected_decoder = null;
        int i2 = 0;
        while (i2 < this.listeners.size()) {
            LocaleUtilDecoderCandidate candidate = ((LocaleUtilListener)this.listeners.get(i2)).selectDecoder(this, torrent, candidates);
            if (candidate != null) {
                selected_decoder = candidate.getDecoder();
                break;
            }
            ++i2;
        }
        if (selected_decoder == null) {
            selected_decoder = system_decoder_is_valid ? this.system_decoder : this.fallback_decoder;
        }
        torrent.setAdditionalStringProperty("encoding", selected_decoder.getName());
        TorrentUtils.writeToFile(torrent);
        return selected_decoder;
    }

    protected LocaleUtilDecoder[] getTorrentCandidateDecoders(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException {
        byte[] created;
        HashSet<LocaleUtilDecoder> cand_set = new HashSet<LocaleUtilDecoder>();
        cand_set.addAll(Arrays.asList(this.getCandidateDecoders(torrent.getName())));
        TOTorrentFile[] files = torrent.getFiles();
        int i = 0;
        while (i < files.length) {
            TOTorrentFile file = files[i];
            byte[][] comps = file.getPathComponents();
            int j = 0;
            while (j < comps.length) {
                cand_set.retainAll(Arrays.asList(this.getCandidateDecoders(comps[j])));
                ++j;
            }
            ++i;
        }
        byte[] comment = torrent.getComment();
        if (comment != null) {
            cand_set.retainAll(Arrays.asList(this.getCandidateDecoders(comment)));
        }
        if ((created = torrent.getCreatedBy()) != null) {
            cand_set.retainAll(Arrays.asList(this.getCandidateDecoders(created)));
        }
        LocaleUtilDecoder[] res = new LocaleUtilDecoder[cand_set.size()];
        cand_set.toArray(res);
        Arrays.sort(res, new Comparator(){

            public int compare(Object o1, Object o2) {
                LocaleUtilDecoder lu1 = (LocaleUtilDecoder)o1;
                LocaleUtilDecoder lu2 = (LocaleUtilDecoder)o2;
                return lu1.getIndex() - lu2.getIndex();
            }
        });
        return res;
    }

    public void setTorrentEncoding(TOTorrent torrent, String encoding) throws LocaleUtilEncodingException {
        try {
            String canonical_requested_name;
            LocaleUtilDecoder[] decoders = this.getTorrentCandidateDecoders(torrent);
            if (encoding.equalsIgnoreCase("system")) {
                canonical_requested_name = this.getSystemEncoding();
            } else if (encoding.equalsIgnoreCase(LocaleUtilDecoderFallback.NAME)) {
                canonical_requested_name = LocaleUtilDecoderFallback.NAME;
            } else {
                CharsetDecoder requested_decoder = Charset.forName(encoding).newDecoder();
                canonical_requested_name = requested_decoder.charset().name();
            }
            boolean ok = false;
            int i = 0;
            while (i < decoders.length) {
                if (decoders[i].getName().equals(canonical_requested_name)) {
                    ok = true;
                    break;
                }
                ++i;
            }
            if (!ok) {
                String[] charsets = new String[decoders.length];
                String[] names = new String[decoders.length];
                int i2 = 0;
                while (i2 < decoders.length) {
                    LocaleUtilDecoder decoder = decoders[i2];
                    charsets[i2] = decoder.getName();
                    names[i2] = decoder.decodeString(torrent.getName());
                    ++i2;
                }
                throw new LocaleUtilEncodingException(charsets, names);
            }
            torrent.setAdditionalStringProperty("encoding", canonical_requested_name);
        }
        catch (Throwable e) {
            if (e instanceof LocaleUtilEncodingException) {
                throw (LocaleUtilEncodingException)e;
            }
            throw new LocaleUtilEncodingException(e);
        }
    }

    public void setDefaultTorrentEncoding(TOTorrent torrent) throws LocaleUtilEncodingException {
        this.setTorrentEncoding(torrent, "UTF8");
    }

    public String getCurrentTorrentEncoding(TOTorrent torrent) {
        return torrent.getAdditionalStringProperty("encoding");
    }
}

