/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.DownloadManagerTrackerListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStateImpl;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStatsImpl;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerFactory;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerServer;
import org.gudy.azureus2.core3.peer.PEPeerServerFactory;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClientException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClientFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClientListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.NonDaemonTask;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class DownloadManagerImpl
implements DownloadManager {
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_DOWNLOADCOMPLETE = 2;
    private static final int LDT_COMPLETIONCHANGED = 3;
    private static final int LDT_POSITIONCHANGED = 4;
    private ListenerManager listeners = ListenerManager.createManager("DMM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            DownloadManagerListener listener = (DownloadManagerListener)_listener;
            if (type == 1) {
                listener.stateChanged(DownloadManagerImpl.this, (Integer)value);
            } else if (type == 2) {
                listener.downloadComplete(DownloadManagerImpl.this);
            } else if (type == 3) {
                listener.completionChanged(DownloadManagerImpl.this, (Boolean)value);
            } else if (type == 4) {
                listener.positionChanged(DownloadManagerImpl.this, (Integer)value, DownloadManagerImpl.this.position);
            }
        }
    });
    private static final int LDT_TL_ANNOUNCERESULT = 1;
    private static final int LDT_TL_SCRAPERESULT = 2;
    private ListenerManager tracker_listeners = ListenerManager.createManager("DMM:TrackerListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            DownloadManagerTrackerListener listener = (DownloadManagerTrackerListener)_listener;
            if (type == 1) {
                listener.announceResult((TRTrackerResponse)value);
            } else if (type == 2) {
                listener.scrapeResult((TRTrackerScraperResponse)value);
            }
        }
    });
    private static final int LDT_PE_PEER_ADDED = 1;
    private static final int LDT_PE_PEER_REMOVED = 2;
    private static final int LDT_PE_PIECE_ADDED = 3;
    private static final int LDT_PE_PIECE_REMOVED = 4;
    private static final int LDT_PE_PM_ADDED = 5;
    private static final int LDT_PE_PM_REMOVED = 6;
    private ListenerManager peer_listeners = ListenerManager.createAsyncManager("DMM:PeerListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            DownloadManagerPeerListener listener = (DownloadManagerPeerListener)_listener;
            if (type == 1) {
                listener.peerAdded((PEPeer)value);
            } else if (type == 2) {
                listener.peerRemoved((PEPeer)value);
            } else if (type == 3) {
                listener.pieceAdded((PEPiece)value);
            } else if (type == 4) {
                listener.pieceRemoved((PEPiece)value);
            } else if (type == 5) {
                listener.peerManagerAdded((PEPeerManager)value);
            } else if (type == 6) {
                listener.peerManagerRemoved((PEPeerManager)value);
            }
        }
    });
    private AEMonitor peer_listeners_mon = new AEMonitor("DownloadManager:PL");
    private List current_peers = new ArrayList();
    private List current_pieces = new ArrayList();
    private DownloadManagerStatsImpl stats;
    private boolean persistent;
    private boolean forceStarted;
    protected boolean onlySeeding;
    private int state = -1;
    private int prevState = -1;
    private String errorDetail;
    private GlobalManager globalManager;
    private String torrentFileName;
    private int nbPieces;
    private String display_name;
    private String torrent_save_dir;
    private String torrent_save_file;
    private int position = -1;
    private PEPeerServer server;
    private DownloadManagerState download_manager_state;
    private TOTorrent torrent;
    private String torrent_comment;
    private String torrent_created_by;
    private TRTrackerClient tracker_client;
    private TRTrackerClientListener tracker_client_listener;
    private long scrape_random_seed = SystemTime.getCurrentTime();
    private DiskManager diskManager;
    private DiskManagerListener disk_manager_listener;
    private PEPeerManager peerManager;
    private PEPeerManagerListener peer_manager_listener;
    private HashMap data;
    private boolean data_already_allocated = false;
    private long creation_time = SystemTime.getCurrentTime();

    public DownloadManagerImpl(GlobalManager _gm, byte[] _torrent_hash, String _torrentFileName, String _torrent_save_dir, String _torrent_save_file, int _initialState, boolean _persistent, boolean _recovered, boolean _open_for_seeding) {
        this.persistent = _persistent;
        this.stats = new DownloadManagerStatsImpl(this);
        this.globalManager = _gm;
        this.stats.setMaxUploads(COConfigurationManager.getIntParameter("Max Uploads"));
        this.forceStarted = false;
        this.torrentFileName = _torrentFileName;
        this.torrent_save_dir = _torrent_save_dir;
        this.torrent_save_file = _torrent_save_file;
        this.readTorrent(_torrent_hash, this.persistent && !_recovered, _open_for_seeding);
        if (this.state == -1) {
            this.setState(_initialState);
        }
    }

    public void initialize() {
        this.setState(5);
        if (this.onlySeeding && !this.filesExist()) {
            return;
        }
        if (this.torrent == null) {
            this.setFailed();
            return;
        }
        this.errorDetail = "";
        this.startServer();
        if (this.state == 0 || this.state == 100) {
            return;
        }
        try {
            if (this.tracker_client != null) {
                this.tracker_client.destroy();
            }
            this.tracker_client = TRTrackerClientFactory.create(this.torrent, this.server);
            this.tracker_client.setTrackerResponseCache(this.download_manager_state.getTrackerResponseCache());
            this.tracker_client_listener = new TRTrackerClientListener(){

                public void receivedTrackerResponse(TRTrackerResponse response) {
                    PEPeerManager pm = DownloadManagerImpl.this.peerManager;
                    if (pm != null) {
                        pm.processTrackerResponse(response);
                    }
                    DownloadManagerImpl.this.tracker_listeners.dispatch(1, response);
                }

                public void urlChanged(String url, boolean explicit) {
                    if (explicit) {
                        DownloadManagerImpl.this.checkTracker(true);
                    }
                }

                public void urlRefresh() {
                    DownloadManagerImpl.this.checkTracker(true);
                }
            };
            this.tracker_client.addListener(this.tracker_client_listener);
            if (this.getState() != 100) {
                this.setState(10);
                this.initializeDiskManager();
            }
        }
        catch (TRTrackerClientException e) {
            this.setFailed(e);
        }
    }

    public void startDownload() {
        this.setState(50);
        PEPeerManager temp = PEPeerManagerFactory.create(this, this.server, this.tracker_client, this.diskManager);
        this.peer_manager_listener = new PEPeerManagerListener(){

            public void stateChanged(int new_state) {
            }
        };
        temp.addListener(this.peer_manager_listener);
        temp.start();
        try {
            this.peer_listeners_mon.enter();
            this.peerManager = temp;
            this.peer_listeners.dispatch(5, temp);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
        this.tracker_client.update(true);
    }

    private void readTorrent(byte[] torrent_hash, boolean new_torrent, boolean open_for_seeding) {
        this.display_name = this.torrentFileName;
        this.torrent_comment = "";
        this.torrent_created_by = "";
        this.nbPieces = 0;
        try {
            this.download_manager_state = DownloadManagerStateImpl.getDownloadState(this, this.torrentFileName, torrent_hash);
            this.torrent = this.download_manager_state.getTorrent();
            LocaleUtilDecoder locale_decoder = LocaleUtil.getSingleton().getTorrentEncoding(this.torrent);
            this.display_name = locale_decoder.decodeString(this.torrent.getName());
            this.display_name = FileUtil.convertOSSpecificChars(this.display_name);
            File save_dir_file = new File(this.torrent_save_dir);
            if (this.torrent_save_file == null) {
                if (this.torrent.isSimpleTorrent()) {
                    if (save_dir_file.exists()) {
                        if (save_dir_file.isDirectory()) {
                            this.torrent_save_file = this.display_name;
                        } else {
                            this.torrent_save_dir = save_dir_file.getParent().toString();
                            this.torrent_save_file = save_dir_file.getName();
                        }
                    } else {
                        this.torrent_save_dir = save_dir_file.getParent().toString();
                        this.torrent_save_file = save_dir_file.getName();
                    }
                } else {
                    if (save_dir_file.exists()) {
                        if (!save_dir_file.isDirectory()) {
                            throw new Exception("'" + this.torrent_save_dir + "' is not a directory");
                        }
                        if (save_dir_file.getName().equals(this.display_name)) {
                            this.torrent_save_dir = save_dir_file.getParent().toString();
                        }
                    }
                    this.torrent_save_file = this.display_name;
                }
            }
            File file = save_dir_file = this.torrent.isSimpleTorrent() ? new File(this.torrent_save_dir) : new File(this.torrent_save_dir, this.torrent_save_file);
            if (!save_dir_file.exists()) {
                if (!new_torrent && !Constants.isWindows) {
                    throw new Exception(String.valueOf(MessageText.getString("DownloadManager.error.datamissing")) + " " + save_dir_file.toString());
                }
                if (!save_dir_file.mkdirs()) {
                    throw new Exception("Directory '" + this.torrent_save_dir + "' creation fails");
                }
            }
            if (new_torrent) {
                this.download_manager_state.setTrackerResponseCache(new HashMap());
                if (open_for_seeding) {
                    DiskManagerFactory.setTorrentResumeDataNearlyComplete(this.download_manager_state, this.torrent_save_dir, this.torrent_save_file);
                } else {
                    this.download_manager_state.clearResumeData();
                }
            }
            this.torrent_comment = locale_decoder.decodeString(this.torrent.getComment());
            if (this.torrent_comment == null) {
                this.torrent_comment = "";
            }
            this.torrent_created_by = locale_decoder.decodeString(this.torrent.getCreatedBy());
            if (this.torrent_created_by == null) {
                this.torrent_created_by = "";
            }
            this.nbPieces = this.torrent.getNumberOfPieces();
            if (DiskManagerFactory.isTorrentResumeDataComplete(this.download_manager_state, this.torrent_save_dir, this.torrent_save_file)) {
                this.download_manager_state.clearTrackerResponseCache();
                this.stats.setDownloadCompleted(1000);
                this.setOnlySeeding(true);
            } else {
                this.setOnlySeeding(false);
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this.nbPieces = 0;
            this.setFailed(TorrentUtils.exceptionToText(e));
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
            this.nbPieces = 0;
            this.setFailed(MessageText.getString("DownloadManager.error.unsupportedencoding"));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.nbPieces = 0;
            this.setFailed(e);
        }
        if (this.download_manager_state == null) {
            this.download_manager_state = DownloadManagerStateImpl.getDownloadState(this);
        }
    }

    private void startServer() {
        this.server = PEPeerServerFactory.create();
        if (this.server == null || this.server.getPort() == 0) {
            this.setFailed(MessageText.getString("DownloadManager.error.unabletostartserver"));
        }
    }

    public int getState() {
        if (this.state != 10) {
            return this.state;
        }
        if (this.diskManager == null) {
            return 10;
        }
        int diskManagerState = this.diskManager.getState();
        if (diskManagerState == 1) {
            return 10;
        }
        if (diskManagerState == 2) {
            return 20;
        }
        if (diskManagerState == 3) {
            return 30;
        }
        if (diskManagerState == 4) {
            return 40;
        }
        if (diskManagerState == 10) {
            return 100;
        }
        return 100;
    }

    public boolean getOnlySeeding() {
        return this.onlySeeding;
    }

    public void setOnlySeeding(boolean _onlySeeding) {
        if (this.onlySeeding != _onlySeeding) {
            this.onlySeeding = _onlySeeding;
            if (_onlySeeding && this.filesExist()) {
                this.stats.setDownloadCompleted(1000);
            }
            if (this.globalManager != null && this.position != -1) {
                DownloadManager[] dms = new DownloadManager[]{this};
                this.position = this.globalManager.getDownloadManagers().size() + 1;
                this.globalManager.moveTop(dms);
                this.globalManager.fixUpDownloadManagerPositions();
            }
            this.listeners.dispatch(3, new Boolean(_onlySeeding));
        }
    }

    public boolean filesExist() {
        return this.filesExistErrorMessage() == "";
    }

    private String filesExistErrorMessage() {
        String strErrMessage = "";
        if (this.diskManager == null) {
            DiskManager dm = DiskManagerFactory.createNoStart(this.torrent, this);
            if (dm.getState() == 10) {
                strErrMessage = dm.getErrorMessage();
            } else if (!dm.filesExist()) {
                strErrMessage = dm.getErrorMessage();
            }
            dm = null;
        } else if (!this.diskManager.filesExist()) {
            strErrMessage = this.diskManager.getErrorMessage();
        }
        if (!strErrMessage.equals("")) {
            this.setFailed(String.valueOf(MessageText.getString("DownloadManager.error.datamissing")) + " " + strErrMessage);
        }
        return strErrMessage;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public int getPrevState() {
        return this.prevState;
    }

    public void setPrevState(int prev_state) {
        this.prevState = prev_state;
    }

    public String getDisplayName() {
        return this.display_name;
    }

    public String getErrorDetails() {
        return this.errorDetail;
    }

    public long getSize() {
        if (this.diskManager != null) {
            return this.diskManager.getTotalLength();
        }
        if (this.torrent != null) {
            return this.torrent.getSize();
        }
        return 0L;
    }

    protected void setFailed() {
        this.setFailed((String)null);
    }

    protected void setFailed(Throwable e) {
        this.setFailed(Debug.getNestedExceptionMessage(e));
    }

    protected void setFailed(String reason) {
        if (reason != null) {
            this.errorDetail = reason;
        }
        this.stopIt(100, false, false);
    }

    public void stopIt(final int _stateAfterStopping, final boolean remove_torrent, final boolean remove_data) {
        if (this.state == 70 || this.state == 100) {
            if (remove_data) {
                this.deleteDataFiles();
            }
            if (remove_torrent) {
                this.deleteTorrentFile();
            }
            this.setState(_stateAfterStopping);
            return;
        }
        if (this.state == 65) {
            return;
        }
        this.setState(65);
        try {
            NonDaemonTaskRunner.run(new NonDaemonTask(){

                public Object run() {
                    block15: {
                        int stateAfterStopping = _stateAfterStopping;
                        try {
                            if (DownloadManagerImpl.this.peerManager != null) {
                                DownloadManagerImpl.this.stats.setSavedDownloadedUploaded(DownloadManagerImpl.this.stats.getSavedDownloaded() + DownloadManagerImpl.this.peerManager.getStats().getTotalReceived(), DownloadManagerImpl.this.stats.getSavedUploaded() + DownloadManagerImpl.this.peerManager.getStats().getTotalSent());
                                DownloadManagerImpl.this.stats.saveDiscarded(DownloadManagerImpl.this.stats.getDiscarded());
                                DownloadManagerImpl.this.stats.saveHashFails(DownloadManagerImpl.this.stats.getHashFails());
                                DownloadManagerImpl.this.stats.setSecondsDownloading(DownloadManagerImpl.this.stats.getSecondsDownloading());
                                DownloadManagerImpl.this.stats.setSecondsOnlySeeding(DownloadManagerImpl.this.stats.getSecondsOnlySeeding());
                                DownloadManagerImpl.this.peerManager.removeListener(DownloadManagerImpl.this.peer_manager_listener);
                                DownloadManagerImpl.this.peerManager.stopAll();
                                try {
                                    DownloadManagerImpl.this.peer_listeners_mon.enter();
                                    DownloadManagerImpl.this.peer_listeners.dispatch(6, DownloadManagerImpl.this.peerManager);
                                }
                                finally {
                                    DownloadManagerImpl.this.peer_listeners_mon.exit();
                                }
                                DownloadManagerImpl.this.peerManager = null;
                                DownloadManagerImpl.this.server = null;
                            }
                            if (DownloadManagerImpl.this.tracker_client != null) {
                                DownloadManagerImpl.this.tracker_client.removeListener(DownloadManagerImpl.this.tracker_client_listener);
                                DownloadManagerImpl.this.download_manager_state.setTrackerResponseCache(DownloadManagerImpl.this.tracker_client.getTrackerResponseCache());
                                DownloadManagerImpl.this.tracker_client.destroy();
                                DownloadManagerImpl.this.tracker_client = null;
                            }
                            if (DownloadManagerImpl.this.diskManager == null) break block15;
                            DownloadManagerImpl.this.stats.setCompleted(DownloadManagerImpl.this.stats.getCompleted());
                            DownloadManagerImpl.this.stats.setDownloadCompleted(DownloadManagerImpl.this.stats.getDownloadCompleted(true));
                            if (DownloadManagerImpl.this.diskManager.getState() == 4) {
                                try {
                                    DownloadManagerImpl.this.diskManager.dumpResumeDataToDisk(true, false);
                                }
                                catch (Exception e) {
                                    DownloadManagerImpl.this.errorDetail = "Resume data save fails: " + Debug.getNestedExceptionMessage(e);
                                    stateAfterStopping = 100;
                                }
                            }
                            if (!DownloadManagerImpl.this.onlySeeding) {
                                DownloadManagerImpl.this.download_manager_state.save();
                            }
                            DownloadManagerImpl.this.diskManager.storeFilePriorities();
                            DownloadManagerImpl.this.diskManager.stop();
                            DownloadManagerImpl.this.diskManager.removeListener(DownloadManagerImpl.this.disk_manager_listener);
                            DownloadManagerImpl.this.diskManager = null;
                        }
                        finally {
                            DownloadManagerImpl.this.forceStarted = false;
                            if (remove_data) {
                                DownloadManagerImpl.this.deleteDataFiles();
                            }
                            if (remove_torrent) {
                                DownloadManagerImpl.this.deleteTorrentFile();
                            }
                            DownloadManagerImpl.this.setState(stateAfterStopping);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void saveResumeData() {
        if (this.getState() == 50) {
            try {
                this.getDiskManager().dumpResumeDataToDisk(false, false);
            }
            catch (Exception e) {
                this.errorDetail = "Resume data save fails: " + Debug.getNestedExceptionMessage(e);
                this.setFailed(this.errorDetail);
            }
        }
        if (!this.onlySeeding) {
            this.download_manager_state.save();
        }
    }

    public void saveDownload() {
        DiskManager disk_manager = this.diskManager;
        if (disk_manager != null) {
            disk_manager.storeFilePriorities();
        }
        this.download_manager_state.save();
    }

    public void setState(int _state) {
        if (this.state != _state) {
            this.state = _state;
            if (this.state == 60) {
                this.setOnlySeeding(true);
            } else if (this.state == 75 && this.onlySeeding && !this.filesExist()) {
                return;
            }
            this.informStateChanged(this.state);
        }
    }

    public int getNbSeeds() {
        if (this.peerManager != null) {
            return this.peerManager.getNbSeeds();
        }
        return 0;
    }

    public int getNbPeers() {
        if (this.peerManager != null) {
            return this.peerManager.getNbPeers();
        }
        return 0;
    }

    public String getTrackerStatus() {
        TRTrackerScraperResponse response;
        if (this.tracker_client != null) {
            return this.tracker_client.getStatusString();
        }
        if (this.torrent != null && this.globalManager != null && (response = this.getTrackerScrapeResponse()) != null) {
            return response.getStatusString();
        }
        return "";
    }

    public void setTrackerScrapeResponse(TRTrackerScraperResponse response) {
        this.tracker_listeners.dispatch(2, response);
    }

    public TRTrackerClient getTrackerClient() {
        return this.tracker_client;
    }

    public int getNbPieces() {
        return this.nbPieces;
    }

    public int getTrackerTime() {
        TRTrackerScraperResponse response;
        if (this.tracker_client != null) {
            return this.tracker_client.getTimeUntilNextUpdate();
        }
        if (this.torrent != null && this.globalManager != null && (response = this.getTrackerScrapeResponse()) != null) {
            if (response.getStatus() == 3) {
                return -1;
            }
            return (int)((response.getNextScrapeStartTime() - SystemTime.getCurrentTime()) / 1000L);
        }
        return 60;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public String getTorrentSaveDirAndFile() {
        return String.valueOf(this.torrent_save_dir) + (this.torrent_save_file == null ? "" : String.valueOf(File.separator) + this.torrent_save_file);
    }

    public String getTorrentSaveDir() {
        return this.torrent_save_dir;
    }

    public String getTorrentSaveFile() {
        return this.torrent_save_file;
    }

    public void setTorrentSaveDir(String sPath) {
        this.torrent_save_dir = sPath;
    }

    public String getPieceLength() {
        if (this.torrent != null) {
            return DisplayFormatters.formatByteCountToKiBEtc(this.torrent.getPieceLength());
        }
        return "";
    }

    public String getTorrentFileName() {
        return this.torrentFileName;
    }

    public void setTorrentFileName(String string) {
        this.torrentFileName = string;
    }

    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        TRTrackerScraperResponse r = null;
        if (this.globalManager != null) {
            TRTrackerScraper scraper = this.globalManager.getTrackerScraper();
            if (this.tracker_client != null) {
                r = scraper.scrape(this.tracker_client);
            }
            if (r == null && this.torrent != null) {
                TRTrackerScraperResponse non_null_response = null;
                TOTorrentAnnounceURLSet[] sets = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
                if (sets.length == 0) {
                    r = scraper.scrape(this.torrent);
                } else {
                    Random scrape_random = new Random(this.scrape_random_seed);
                    int i = 0;
                    while (r == null && i < sets.length) {
                        TOTorrentAnnounceURLSet set = sets[i];
                        URL[] urls = set.getAnnounceURLs();
                        ArrayList<URL> rand_urls = new ArrayList<URL>();
                        int j = 0;
                        while (j < urls.length) {
                            URL url = urls[j];
                            int pos = (int)(scrape_random.nextDouble() * (double)(rand_urls.size() + 1));
                            rand_urls.add(pos, url);
                            ++j;
                        }
                        j = 0;
                        while (r == null && j < rand_urls.size()) {
                            r = scraper.scrape(this.torrent, (URL)rand_urls.get(j));
                            if (!(r == null || r.isValid() && r.getStatus() != 1)) {
                                if (non_null_response == null) {
                                    non_null_response = r;
                                }
                                r = null;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (r == null) {
                        r = non_null_response;
                    }
                }
            }
        }
        return r;
    }

    public void setErrorDetail(String string) {
        this.errorDetail = string;
    }

    public void restartDownload(boolean use_fast_resume) {
        try {
            if (!use_fast_resume) {
                this.diskManager.dumpResumeDataToDisk(false, true);
                this.readTorrent(this.torrent == null ? null : this.torrent.getHash(), false, false);
            }
            this.stopIt(70, false, false);
            try {
                while (this.state != 70) {
                    Thread.sleep(50L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initialize();
        }
        catch (Exception e) {
            this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
        }
    }

    public void startDownloadInitialized(boolean initStoppedDownloads) {
        if (this.getState() == 0 || initStoppedDownloads && this.getState() == 70) {
            this.initialize();
        }
        if (this.getState() == 40) {
            this.startDownload();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof DownloadManager) {
            DownloadManager other = (DownloadManager)obj;
            TOTorrent t1 = this.getTorrent();
            TOTorrent t2 = other.getTorrent();
            if (t1 == null || t2 == null) {
                return false;
            }
            try {
                return Arrays.equals(t1.getHash(), t2.getHash());
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    public void checkTracker() {
        this.checkTracker(false);
    }

    protected void checkTracker(boolean force) {
        if (this.tracker_client != null) {
            this.tracker_client.update(force);
        }
    }

    public String getTorrentComment() {
        return this.torrent_comment;
    }

    public String getTorrentCreatedBy() {
        return this.torrent_created_by;
    }

    public long getTorrentCreationDate() {
        if (this.torrent == null) {
            return 0L;
        }
        return this.torrent.getCreationDate();
    }

    public int getIndex() {
        if (this.globalManager != null) {
            return this.globalManager.getIndexOf(this);
        }
        return -1;
    }

    public boolean isMoveableUp() {
        if (this.globalManager != null) {
            return this.globalManager.isMoveableUp(this);
        }
        return false;
    }

    public boolean isMoveableDown() {
        if (this.globalManager != null) {
            return this.globalManager.isMoveableDown(this);
        }
        return false;
    }

    public void moveUp() {
        if (this.globalManager != null) {
            this.globalManager.moveUp(this);
        }
    }

    public void moveDown() {
        if (this.globalManager != null) {
            this.globalManager.moveDown(this);
        }
    }

    public GlobalManager getGlobalManager() {
        return this.globalManager;
    }

    public DiskManager getDiskManager() {
        return this.diskManager;
    }

    public PEPeerManager getPeerManager() {
        return this.peerManager;
    }

    public boolean isDownloadComplete() {
        return this.onlySeeding;
    }

    public void addListener(DownloadManagerListener listener) {
        this.listeners.addListener(listener);
        listener.stateChanged(this, this.state);
    }

    public void removeListener(DownloadManagerListener listener) {
        this.listeners.removeListener(listener);
    }

    protected void informStateChanged(int new_state) {
        this.listeners.dispatch(1, new Integer(new_state));
    }

    protected void informDownloadEnded() {
        this.listeners.dispatch(2, null);
    }

    protected void informPositionChanged(int iOldPosition) {
        this.listeners.dispatch(4, new Integer(iOldPosition));
    }

    public void addPeerListener(DownloadManagerPeerListener listener) {
        try {
            this.peer_listeners_mon.enter();
            this.peer_listeners.addListener(listener);
            int i = 0;
            while (i < this.current_peers.size()) {
                this.peer_listeners.dispatch(listener, 1, this.current_peers.get(i));
                ++i;
            }
            i = 0;
            while (i < this.current_pieces.size()) {
                this.peer_listeners.dispatch(listener, 3, this.current_pieces.get(i));
                ++i;
            }
            PEPeerManager temp = this.peerManager;
            if (temp != null) {
                this.peer_listeners.dispatch(listener, 5, temp);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public void removePeerListener(DownloadManagerPeerListener listener) {
        this.peer_listeners.removeListener(listener);
    }

    public void addPeer(PEPeer peer) {
        try {
            this.peer_listeners_mon.enter();
            this.current_peers.add(peer);
            this.peer_listeners.dispatch(1, peer);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public void removePeer(PEPeer peer) {
        try {
            this.peer_listeners_mon.enter();
            this.current_peers.remove(peer);
            this.peer_listeners.dispatch(2, peer);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public void addPiece(PEPiece piece) {
        try {
            this.peer_listeners_mon.enter();
            this.current_pieces.add(piece);
            this.peer_listeners.dispatch(3, piece);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public void removePiece(PEPiece piece) {
        try {
            this.peer_listeners_mon.enter();
            this.current_pieces.remove(piece);
            this.peer_listeners.dispatch(4, piece);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public DownloadManagerStats getStats() {
        return this.stats;
    }

    public boolean isForceStart() {
        return this.forceStarted;
    }

    public void setForceStart(boolean forceStart) {
        if (this.forceStarted != forceStart) {
            this.forceStarted = forceStart;
            if (this.forceStarted && (this.getState() == 70 || this.getState() == 75)) {
                this.setState(0);
            } else {
                this.informStateChanged(this.getState());
            }
        }
    }

    public void downloadEnded() {
        if (this.isForceStart()) {
            this.setForceStart(false);
        }
        this.setOnlySeeding(true);
        this.informDownloadEnded();
    }

    public DiskManager initializeDiskManager() {
        DiskManager res = this.diskManager;
        if (res == null) {
            res = this.diskManager = DiskManagerFactory.create(this.torrent, this);
            this.disk_manager_listener = new DiskManagerListener(){

                public void stateChanged(int oldDMState, int newDMState) {
                    int dl_state;
                    int completed;
                    if (newDMState == 10) {
                        DownloadManagerImpl.this.setFailed(DownloadManagerImpl.this.diskManager.getErrorMessage());
                    }
                    if (oldDMState == 3) {
                        DownloadManagerImpl.this.stats.setDownloadCompleted(DownloadManagerImpl.this.stats.getDownloadCompleted(true));
                        DownloadManagerImpl.this.setOnlySeeding(DownloadManagerImpl.this.diskManager.getRemaining() == 0L);
                    }
                    if (newDMState == 4 && DownloadManagerImpl.this.stats.getDownloaded() == 0L && DownloadManagerImpl.this.stats.getUploaded() == 0L && DownloadManagerImpl.this.stats.getSecondsDownloading() == 0L && (completed = DownloadManagerImpl.this.stats.getDownloadCompleted(false)) < 1000) {
                        long amount_downloaded = (long)completed * DownloadManagerImpl.this.diskManager.getTotalLength() / 1000L;
                        DownloadManagerImpl.this.stats.setSavedDownloadedUploaded(amount_downloaded, amount_downloaded);
                    }
                    if ((dl_state = DownloadManagerImpl.this.getState()) != DownloadManagerImpl.this.state) {
                        DownloadManagerImpl.this.informStateChanged(dl_state);
                    }
                }
            };
            this.diskManager.addListener(this.disk_manager_listener);
        }
        return res;
    }

    public boolean canForceRecheck() {
        if (this.torrent == null) {
            return false;
        }
        return this.state == 70 || this.state == 75 || this.state == 100 && this.diskManager == null;
    }

    public void forceRecheck() {
        if (this.diskManager != null) {
            LGLogger.log(0, 0, 3, "Trying to force recheck while diskmanager active");
            return;
        }
        if (this.torrent == null) {
            LGLogger.log(0, 0, 3, "Trying to force recheck with broken torrent");
            return;
        }
        AEThread recheck = new AEThread("forceRecheck"){

            public void runSupport() {
                block8: {
                    int start_state = DownloadManagerImpl.this.getState();
                    DownloadManagerImpl.this.setState(30);
                    DownloadManagerImpl.this.download_manager_state.clearResumeData();
                    boolean wasForceStarted = DownloadManagerImpl.this.forceStarted;
                    DownloadManagerImpl.this.forceStarted = true;
                    DownloadManagerImpl.this.setDataAlreadyAllocated(false);
                    DiskManager recheck_disk_manager = DownloadManagerImpl.this.initializeDiskManager();
                    while (recheck_disk_manager.getState() != 10 && recheck_disk_manager.getState() != 4) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    DownloadManagerImpl.this.forceStarted = wasForceStarted;
                    DownloadManagerImpl.this.stats.setDownloadCompleted(DownloadManagerImpl.this.stats.getDownloadCompleted(true));
                    if (recheck_disk_manager.getState() == 4) {
                        try {
                            recheck_disk_manager.dumpResumeDataToDisk(true, false);
                            recheck_disk_manager.stop();
                            DownloadManagerImpl.this.setOnlySeeding(recheck_disk_manager.getRemaining() == 0L);
                            DownloadManagerImpl.this.diskManager = null;
                            if (start_state == 100) {
                                DownloadManagerImpl.this.setState(70);
                                break block8;
                            }
                            DownloadManagerImpl.this.setState(start_state);
                        }
                        catch (Exception e) {
                            String string = "Resume data save fails: " + Debug.getNestedExceptionMessage(e);
                            DownloadManagerImpl.this.errorDetail = string;
                            DownloadManagerImpl.this.setFailed(string);
                        }
                    } else {
                        recheck_disk_manager.stop();
                        DownloadManagerImpl.this.setOnlySeeding(false);
                        DownloadManagerImpl.this.diskManager = null;
                        DownloadManagerImpl.this.setFailed(recheck_disk_manager.getErrorMessage());
                    }
                }
            }
        };
        recheck.setPriority(1);
        recheck.start();
    }

    public int getHealthStatus() {
        if (this.peerManager != null && (this.state == 50 || this.state == 60)) {
            boolean isSeed;
            int nbSeeds = this.getNbSeeds();
            int nbPeers = this.getNbPeers();
            int nbRemotes = this.peerManager.getNbRemoteConnections();
            int trackerStatus = this.tracker_client.getLastResponse().getStatus();
            boolean bl = isSeed = this.state == 60;
            if (nbSeeds + nbPeers == 0) {
                if (isSeed) {
                    return 2;
                }
                return 5;
            }
            if (trackerStatus == 0 || trackerStatus == 1) {
                return 2;
            }
            if (nbRemotes == 0) {
                return 3;
            }
            return 4;
        }
        return 1;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int newPosition) {
        if (newPosition != this.position) {
            int oldPosition = this.position;
            this.position = newPosition;
            this.informPositionChanged(oldPosition);
        }
    }

    public void addTrackerListener(DownloadManagerTrackerListener listener) {
        this.tracker_listeners.addListener(listener);
    }

    public void removeTrackerListener(DownloadManagerTrackerListener listener) {
        this.tracker_listeners.removeListener(listener);
    }

    private void deleteDataFiles() {
        DiskManagerFactory.deleteDataFiles(this.torrent, this.torrent_save_dir, this.torrent_save_file);
    }

    private void deleteTorrentFile() {
        if (this.torrentFileName != null) {
            TorrentUtils.delete(new File(this.torrentFileName));
        }
    }

    public DownloadManagerState getDownloadState() {
        return this.download_manager_state;
    }

    public Object getData(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public void setData(String key, Object value) {
        try {
            this.peer_listeners_mon.enter();
            if (this.data == null) {
                this.data = new HashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                }
            } else {
                this.data.put(key, value);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public boolean isDataAlreadyAllocated() {
        return this.data_already_allocated;
    }

    public void setDataAlreadyAllocated(boolean already_allocated) {
        this.data_already_allocated = already_allocated;
    }

    public long getCreationTime() {
        return this.creation_time;
    }

    public void setCreationTime(long t) {
        this.creation_time = t;
    }
}

