/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.config.impl.StringListImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class ConfigurationManager {
    private static ConfigurationManager config;
    private static AEMonitor class_mon;
    private Map propertiesMap;
    private List listeners = new ArrayList();
    private Hashtable parameterListeners = new Hashtable();
    private AEMonitor this_mon = new AEMonitor("ConfigMan");

    static {
        class_mon = new AEMonitor("ConfigMan:class");
    }

    public static ConfigurationManager getInstance() {
        try {
            class_mon.enter();
            if (config == null) {
                config = new ConfigurationManager();
                config.initialise();
            }
            ConfigurationManager configurationManager = config;
            class_mon.exit();
            return configurationManager;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public static ConfigurationManager getInstance(Map data) {
        try {
            class_mon.enter();
            if (config == null) {
                config = new ConfigurationManager(data);
            }
            ConfigurationManager configurationManager = config;
            class_mon.exit();
            return configurationManager;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    private ConfigurationManager() {
        this.load();
    }

    private ConfigurationManager(Map data) {
        this.propertiesMap = data;
    }

    private void initialise() {
        ConfigurationChecker.checkConfiguration();
        ConfigurationChecker.setSystemProperties();
    }

    public void load(String filename) {
        this.propertiesMap = FileUtil.readResilientConfigFile(filename);
    }

    public void load() {
        this.load("azureus.config");
    }

    public void save(String filename) {
        ArrayList listeners_copy;
        FileUtil.writeResilientConfigFile(filename, this.propertiesMap);
        try {
            this.this_mon.enter();
            listeners_copy = new ArrayList(this.listeners);
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < listeners_copy.size()) {
            COConfigurationListener l = (COConfigurationListener)listeners_copy.get(i);
            if (l != null) {
                try {
                    l.configurationSaved();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            } else {
                Debug.out("COConfigurationListener is null");
            }
            ++i;
        }
    }

    public void save() {
        this.save("azureus.config");
    }

    public boolean getBooleanParameter(String parameter, boolean defaultValue) {
        int defaultInt = defaultValue ? 1 : 0;
        int result = this.getIntParameter(parameter, defaultInt);
        return result != 0;
    }

    public boolean getBooleanParameter(String parameter) {
        int result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getIntParameter(parameter, def.getIntParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getIntParameter(parameter, def.def_boolean);
        }
        return result != 0;
    }

    public boolean setParameter(String parameter, boolean value) {
        return this.setParameter(parameter, value ? 1 : 0);
    }

    private Long getIntParameterRaw(String parameter) {
        try {
            return (Long)this.propertiesMap.get(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public int getIntParameter(String parameter, int defaultValue) {
        Long tempValue = this.getIntParameterRaw(parameter);
        return tempValue != null ? tempValue.intValue() : defaultValue;
    }

    public int getIntParameter(String parameter) {
        int result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getIntParameter(parameter, def.getIntParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getIntParameter(parameter, def.def_int);
        }
        return result;
    }

    private byte[] getByteParameterRaw(String parameter) {
        return (byte[])this.propertiesMap.get(parameter);
    }

    public byte[] getByteParameter(String parameter, byte[] defaultValue) {
        byte[] tempValue = this.getByteParameterRaw(parameter);
        return tempValue != null ? tempValue : defaultValue;
    }

    private String getStringParameter(String parameter, byte[] defaultValue) {
        try {
            return new String(this.getByteParameter(parameter, defaultValue));
        }
        catch (Exception e) {
            byte[] bytesReturn = this.getByteParameter(parameter, null);
            if (bytesReturn == null) {
                return null;
            }
            return new String(bytesReturn);
        }
    }

    public String getStringParameter(String parameter, String defaultValue) {
        String tempValue = this.getStringParameter(parameter, (byte[])null);
        return tempValue != null ? tempValue : defaultValue;
    }

    public String getStringParameter(String parameter) {
        String result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getStringParameter(parameter, def.getStringParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getStringParameter(parameter, def.def_String);
        }
        return result;
    }

    public StringList getStringListParameter(String parameter) {
        try {
            List rawList = (List)this.propertiesMap.get(parameter);
            if (rawList == null) {
                return new StringListImpl();
            }
            return new StringListImpl(rawList);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return new StringListImpl();
        }
    }

    public boolean setParameter(String parameter, StringList value) {
        try {
            this.propertiesMap.put(parameter, new ArrayList(((StringListImpl)value).getList()));
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public String getDirectoryParameter(String parameter) throws IOException {
        String dir = this.getStringParameter(parameter);
        if (dir.length() > 0) {
            File temp = new File(dir);
            if (!temp.exists()) {
                temp.mkdirs();
            } else if (!temp.isDirectory()) {
                throw new IOException("Configuration error. This is not a directory: " + dir);
            }
        }
        return dir;
    }

    public float getFloatParameter(String parameter) {
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            Object o = this.propertiesMap.get(parameter);
            if (o instanceof Number) {
                return ((Number)o).floatValue();
            }
            String s = this.getStringParameter(parameter);
            if (!s.equals(def.def_String)) {
                return Float.parseFloat(s);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        try {
            return def.getFloatParameter(parameter);
        }
        catch (Exception e2) {
            return def.def_float;
        }
    }

    public boolean setParameter(String parameter, float defaultValue) {
        String newValue = String.valueOf(defaultValue);
        return this.setParameter(parameter, newValue.getBytes());
    }

    public boolean setParameter(String parameter, int defaultValue) {
        Long newValue = new Long(defaultValue);
        Long oldValue = this.propertiesMap.put(parameter, newValue);
        return this.notifyParameterListenersIfChanged(parameter, newValue, oldValue);
    }

    public boolean setParameter(String parameter, byte[] defaultValue) {
        byte[] oldValue = this.propertiesMap.put(parameter, defaultValue);
        return this.notifyParameterListenersIfChanged(parameter, defaultValue, oldValue);
    }

    public boolean setParameter(String parameter, String defaultValue) {
        return this.setParameter(parameter, defaultValue.getBytes());
    }

    public boolean setRGBParameter(String parameter, int red, int green, int blue) {
        boolean bAnyChanged = false;
        bAnyChanged |= this.setParameter(String.valueOf(parameter) + ".red", red);
        bAnyChanged |= this.setParameter(String.valueOf(parameter) + ".green", green);
        if (bAnyChanged |= this.setParameter(String.valueOf(parameter) + ".blue", blue)) {
            this.notifyParameterListeners(parameter);
        }
        return bAnyChanged;
    }

    public boolean setParameter(String parameter) throws ConfigurationParameterNotFoundException {
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            return this.setParameter(parameter, def.getIntParameter(parameter));
        }
        catch (Exception e) {
            return this.setParameter(parameter, def.getStringParameter(parameter));
        }
    }

    public boolean removeParameter(String parameter) {
        return this.propertiesMap.remove(parameter) != null;
    }

    public boolean doesParameterNonDefaultExist(String parameter) {
        return this.propertiesMap.containsKey(parameter);
    }

    private boolean notifyParameterListenersIfChanged(String parameter, Long newValue, Long oldValue) {
        if (oldValue == null || newValue.compareTo(oldValue) != 0) {
            this.notifyParameterListeners(parameter);
            return true;
        }
        return false;
    }

    private boolean notifyParameterListenersIfChanged(String parameter, byte[] newValue, byte[] oldValue) {
        if (oldValue == null || !Arrays.equals(newValue, oldValue)) {
            this.notifyParameterListeners(parameter);
            return true;
        }
        return false;
    }

    private void notifyParameterListeners(String parameter) {
        Vector parameterListener = (Vector)this.parameterListeners.get(parameter);
        if (parameterListener != null) {
            try {
                int i = 0;
                while (i < parameterListener.size()) {
                    ParameterListener listener = (ParameterListener)parameterListener.get(i);
                    if (listener != null) {
                        listener.parameterChanged(parameter);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addParameterListener(String parameter, ParameterListener listener) {
        try {
            this.this_mon.enter();
            if (parameter == null || listener == null) {
                this.this_mon.exit();
                return;
            }
            Vector<ParameterListener> parameterListener = (Vector<ParameterListener>)this.parameterListeners.get(parameter);
            if (parameterListener == null) {
                parameterListener = new Vector<ParameterListener>();
                this.parameterListeners.put(parameter, parameterListener);
            }
            if (!parameterListener.contains(listener)) {
                parameterListener.add(listener);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeParameterListener(String parameter, ParameterListener listener) {
        try {
            this.this_mon.enter();
            if (parameter == null || listener == null) {
                this.this_mon.exit();
                return;
            }
            Vector parameterListener = (Vector)this.parameterListeners.get(parameter);
            if (parameterListener != null) {
                parameterListener.remove(listener);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addListener(COConfigurationListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeListener(COConfigurationListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }
}

