/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERObject;

public class IssuingDistributionPoint {
    private boolean onlyContainsUserCerts;
    private boolean onlyContainsCACerts;
    private boolean indirectCRL;
    private boolean onlyContainsAttributeCerts;
    private ASN1Sequence seq;

    public static IssuingDistributionPoint getInstance(ASN1TaggedObject obj, boolean explicit) {
        return IssuingDistributionPoint.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static IssuingDistributionPoint getInstance(Object obj) {
        if (obj == null || obj instanceof IssuingDistributionPoint) {
            return (IssuingDistributionPoint)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new IssuingDistributionPoint((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public IssuingDistributionPoint(ASN1Sequence seq) {
        this.seq = seq;
        int i = 0;
        while (i != seq.size()) {
            ASN1TaggedObject o = (ASN1TaggedObject)seq.getObjectAt(i);
            switch (o.getTagNo()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.onlyContainsUserCerts = DERBoolean.getInstance(o, false).isTrue();
                    break;
                }
                case 2: {
                    this.onlyContainsCACerts = DERBoolean.getInstance(o, false).isTrue();
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.indirectCRL = DERBoolean.getInstance(o, false).isTrue();
                }
                case 5: {
                    this.onlyContainsAttributeCerts = DERBoolean.getInstance(o, false).isTrue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag in IssuingDistributionPoint");
                }
            }
            ++i;
        }
    }

    public boolean onlyContainsUserCerts() {
        return this.onlyContainsUserCerts;
    }

    public boolean onlyContainsCACerts() {
        return this.onlyContainsCACerts;
    }

    public boolean isIndirectCRL() {
        return this.indirectCRL;
    }

    public boolean onlyContainsAttributeCerts() {
        return this.onlyContainsAttributeCerts;
    }

    public DERObject getDERObject() {
        return this.seq;
    }
}

