/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.device;

import com.aelitis.net.upnp.UPnPActionArgument;
import com.aelitis.net.upnp.UPnPActionInvocation;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.device.UPnPActionArgumentImpl;
import com.aelitis.net.upnp.impl.device.UPnPActionImpl;
import com.aelitis.net.upnp.impl.device.UPnPDeviceImpl;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class UPnPActionInvocationImpl
implements UPnPActionInvocation {
    protected UPnPActionImpl action;
    protected List arg_names = new ArrayList();
    protected List arg_values = new ArrayList();

    protected UPnPActionInvocationImpl(UPnPActionImpl _action) {
        this.action = _action;
    }

    public void addArgument(String name, String value) {
        this.arg_names.add(name);
        this.arg_values.add(value);
    }

    public UPnPActionArgument[] invoke() throws UPnPException {
        UPnPService service = this.action.getService();
        String soap_action = String.valueOf(service.getServiceType()) + "#" + this.action.getName();
        try {
            String request2 = "<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body>";
            request2 = String.valueOf(request2) + "<u:" + this.action.getName() + " xmlns:u=\"" + service.getServiceType() + "\">";
            int i = 0;
            while (i < this.arg_names.size()) {
                String name = (String)this.arg_names.get(i);
                String value = (String)this.arg_values.get(i);
                request2 = String.valueOf(request2) + "<" + name + ">" + value + "</" + name + ">";
                ++i;
            }
            request2 = String.valueOf(request2) + "</u:" + this.action.getName() + ">";
            request2 = String.valueOf(request2) + "</s:Body></s:Envelope>";
            SimpleXMLParserDocument resp_doc = ((UPnPDeviceImpl)this.action.getService().getDevice()).getUPnP().performSOAPRequest(service, soap_action, request2);
            SimpleXMLParserDocumentNode body = resp_doc.getChild("Body");
            SimpleXMLParserDocumentNode fault = body.getChild("Fault");
            if (fault != null) {
                throw new UPnPException("Invoke of '" + soap_action + "' fails - fault reported: " + fault.getValue());
            }
            SimpleXMLParserDocumentNode resp_node = body.getChild(String.valueOf(this.action.getName()) + "Response");
            if (resp_node == null) {
                throw new UPnPException("Invoke of '" + soap_action + "' fails - response missing: " + body.getValue());
            }
            SimpleXMLParserDocumentNode[] out_nodes = resp_node.getChildren();
            UPnPActionArgument[] resp = new UPnPActionArgument[out_nodes.length];
            int i2 = 0;
            while (i2 < out_nodes.length) {
                resp[i2] = new UPnPActionArgumentImpl(out_nodes[i2].getName(), out_nodes[i2].getValue());
                ++i2;
            }
            return resp;
        }
        catch (Throwable e) {
            if (e instanceof UPnPException) {
                throw (UPnPException)e;
            }
            throw new UPnPException("Invoke of '" + soap_action + "' fails: " + e.getMessage(), e);
        }
    }
}

