/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public abstract class LDAPSchemaElement {
    public static final int unknown = 0;
    public static final int cis = 1;
    public static final int binary = 2;
    public static final int telephone = 3;
    public static final int ces = 4;
    public static final int dn = 5;
    public static final int integer = 6;
    protected static final String cisString = "1.3.6.1.4.1.1466.115.121.1.15";
    protected static final String binaryString = "1.3.6.1.4.1.1466.115.121.1.5";
    protected static final String telephoneString = "1.3.6.1.4.1.1466.115.121.1.50";
    protected static final String cesString = "1.3.6.1.4.1.1466.115.121.1.26";
    protected static final String intString = "1.3.6.1.4.1.1466.115.121.1.27";
    protected static final String dnString = "1.3.6.1.4.1.1466.115.121.1.12";
    protected String oid = "";
    protected String name = "";
    protected String description = "";
    protected String attrName;

    protected LDAPSchemaElement() {
    }

    protected LDAPSchemaElement(String string, String string2, String string3) {
        this.name = string;
        this.oid = string2;
        this.description = string3;
    }

    public String getName() {
        return this.name;
    }

    public String getOID() {
        return this.oid;
    }

    public String getDescription() {
        return this.description;
    }

    protected void update(LDAPConnection lDAPConnection, int n, LDAPAttribute lDAPAttribute) throws LDAPException {
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[]{lDAPAttribute};
        this.update(lDAPConnection, n, lDAPAttributeArray);
    }

    protected void update(LDAPConnection lDAPConnection, int n, LDAPAttribute[] lDAPAttributeArray) throws LDAPException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        int n2 = 0;
        while (n2 < lDAPAttributeArray.length) {
            lDAPModificationSet.add(n, lDAPAttributeArray[n2]);
            ++n2;
        }
        lDAPConnection.modify("cn=schema", lDAPModificationSet);
    }

    protected void update(LDAPConnection lDAPConnection, int n, String string) throws LDAPException {
        LDAPAttribute lDAPAttribute = new LDAPAttribute(string, this.getValue());
        this.update(lDAPConnection, n, lDAPAttribute);
    }

    public void add(LDAPConnection lDAPConnection) throws LDAPException {
        this.update(lDAPConnection, 0, this.attrName);
    }

    public void remove(LDAPConnection lDAPConnection) throws LDAPException {
        this.update(lDAPConnection, 1, this.attrName);
    }

    public abstract String getValue();
}

