/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.OutputStream;
import netscape.util.IdHashtable;

public class CompactOutputStream
extends OutputStream {
    OutputStream out;
    int booleanCount;
    int booleanBuffer;
    IdHashtable stringTable = new IdHashtable(true);
    int stringCount = 2;

    public CompactOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    private final void flushBooleanBuffer() throws IOException {
        if (this.booleanCount > 0) {
            this.out.write(this.booleanBuffer);
            this.booleanCount = 0;
            this.booleanBuffer = 0;
        }
    }

    public void write(int n) throws IOException {
        this.flushBooleanBuffer();
        this.out.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.flushBooleanBuffer();
        this.out.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.flushBooleanBuffer();
        this.out.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.flushBooleanBuffer();
        this.out.flush();
    }

    public void close() throws IOException {
        this.flushBooleanBuffer();
        this.out.close();
    }

    public void writeCompactBoolean(boolean bl) throws IOException {
        int n = this.booleanCount;
        if (bl) {
            int n2 = this.booleanBuffer;
            n2 |= 1 << n;
            if (++n >= 8) {
                this.out.write(n2);
                this.booleanCount = 0;
                this.booleanBuffer = 0;
                return;
            }
            this.booleanCount = n;
            this.booleanBuffer = n2;
            return;
        }
        if (++n >= 8) {
            this.out.write(this.booleanBuffer);
            this.booleanCount = 0;
            this.booleanBuffer = 0;
            return;
        }
        this.booleanCount = n;
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.out.write(1);
            return;
        }
        this.out.write(0);
    }

    public void writeByte(int n) throws IOException {
        this.flushBooleanBuffer();
        this.out.write(n);
    }

    public void writeShort(int n) throws IOException {
        OutputStream outputStream = this.out;
        this.flushBooleanBuffer();
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    public void writeChar(int n) throws IOException {
        OutputStream outputStream = this.out;
        this.flushBooleanBuffer();
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    public void writeCompactInt(int n) throws IOException {
        OutputStream outputStream = this.out;
        this.flushBooleanBuffer();
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                outputStream.write(64);
                return;
            }
            if ((n = -n) < 64) {
                outputStream.write(n | 0x40);
                return;
            }
            outputStream.write(n & 0xFF | 0xC0);
        } else {
            if (n < 64) {
                outputStream.write(n);
                return;
            }
            outputStream.write(n & 0x3F | 0x80);
        }
        if ((n >>>= 6) < 128) {
            outputStream.write(n);
            return;
        }
        outputStream.write(n & 0xFF | 0x80);
        if ((n >>>= 7) < 128) {
            outputStream.write(n);
            return;
        }
        outputStream.write(n & 0xFF | 0x80);
        if ((n >>>= 7) < 128) {
            outputStream.write(n);
            return;
        }
        outputStream.write(n & 0xFF | 0x80);
        if ((n >>>= 7) > 0) {
            outputStream.write(n);
        }
    }

    public void writeInt(int n) throws IOException {
        OutputStream outputStream = this.out;
        this.flushBooleanBuffer();
        outputStream.write(n >>> 24 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        OutputStream outputStream = this.out;
        this.flushBooleanBuffer();
        outputStream.write((int)(l >>> 56) & 0xFF);
        outputStream.write((int)(l >>> 48) & 0xFF);
        outputStream.write((int)(l >>> 40) & 0xFF);
        outputStream.write((int)(l >>> 32) & 0xFF);
        outputStream.write((int)(l >>> 24) & 0xFF);
        outputStream.write((int)(l >>> 16) & 0xFF);
        outputStream.write((int)(l >>> 8) & 0xFF);
        outputStream.write((int)l & 0xFF);
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeBytes(String string) throws IOException {
        OutputStream outputStream = this.out;
        this.flushBooleanBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            outputStream.write((byte)string.charAt(n2));
            ++n2;
        }
    }

    public void writeChars(String string) throws IOException {
        OutputStream outputStream = this.out;
        this.flushBooleanBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            outputStream.write(c >>> 8 & 0xFF);
            outputStream.write(c & 0xFF);
            ++n2;
        }
    }

    public void writeCompactUTF(String string) throws IOException {
        if (string == null) {
            this.writeCompactInt(0);
            return;
        }
        if (string.length() == 0) {
            this.writeCompactInt(1);
            return;
        }
        int n = this.stringTable.get(string);
        if (n == 0) {
            n = this.stringCount++;
            this.stringTable.putKnownAbsent(string, n);
            int n2 = this.utfLength(string);
            this.writeCompactInt(-n2);
            this.writeUTFBytes(string);
            return;
        }
        this.writeCompactInt(n);
    }

    public void writeUTF(String string) throws IOException {
        OutputStream outputStream = this.out;
        this.flushBooleanBuffer();
        if (string == null) {
            outputStream.write(255);
            outputStream.write(255);
            return;
        }
        int n = this.utfLength(string);
        if (n >= 65535) {
            throw new IOException("string too long");
        }
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
        this.writeUTFBytes(string);
    }

    private final int utfLength(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        return n2;
    }

    private final void writeUTFBytes(String string) throws IOException {
        OutputStream outputStream = this.out;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '\u0001' && c <= '\u007f') {
                outputStream.write(c);
            } else if (c > '\u07ff') {
                outputStream.write(0xE0 | c >> 12 & 0xF);
                outputStream.write(0x80 | c >> 6 & 0x3F);
                outputStream.write(0x80 | c & 0x3F);
            } else {
                outputStream.write(0xC0 | c >> 6 & 0x1F);
                outputStream.write(0x80 | c & 0x3F);
            }
            ++n2;
        }
    }
}

