/*
 * Decompiled with CFR 0.152.
 */
package symantec.tools.debug;

import java.io.InputStream;
import symantec.tools.debug.NoSuchLineNumberException;
import symantec.tools.debug.RemoteAgent;
import symantec.tools.debug.RemoteField;
import symantec.tools.debug.RemoteObject;
import symantec.tools.debug.RemoteValue;

public class RemoteClass
extends RemoteObject {
    String name;
    String sourceName;
    boolean intf;
    RemoteClass superclass;
    RemoteObject loader;
    RemoteClass[] interfaces;
    private RemoteField[] methods;
    private RemoteField[] instanceFields;
    private RemoteField[] staticFields;

    RemoteClass(RemoteAgent remoteAgent, int n) {
        super(remoteAgent, 16, n, remoteAgent.classClass);
    }

    private void getClassInfo() throws Exception {
        if (this.interfaces == null) {
            this.agent.getClassInfo(this);
        }
    }

    private void loadFields() throws Exception {
        if (this.staticFields == null || this.instanceFields == null) {
            RemoteField[] remoteFieldArray = this.agent.getFields(this.id);
            int n = 0;
            int n2 = 0;
            while (n2 < remoteFieldArray.length) {
                if (remoteFieldArray[n2].isStatic()) {
                    ++n;
                }
                ++n2;
            }
            this.staticFields = new RemoteField[n];
            this.instanceFields = new RemoteField[remoteFieldArray.length - n];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < remoteFieldArray.length) {
                if (remoteFieldArray[n5].isStatic()) {
                    this.staticFields[n4++] = remoteFieldArray[n5];
                } else {
                    this.instanceFields[n3++] = remoteFieldArray[n5];
                }
                ++n5;
            }
        }
    }

    public String getName() throws Exception {
        this.getClassInfo();
        int n = this.name.indexOf(36);
        if (n >= 0) {
            return (String.valueOf(this.name.substring(0, n)) + ". " + this.name.substring(n + 1)).replace('$', '.');
        }
        return this.name;
    }

    public String typeName() throws Exception {
        this.getClassInfo();
        return this.getName();
    }

    public boolean isInterface() throws Exception {
        this.getClassInfo();
        return this.intf;
    }

    public RemoteClass getSuperclass() throws Exception {
        this.getClassInfo();
        return this.superclass;
    }

    public RemoteObject getClassLoader() throws Exception {
        this.getClassInfo();
        return this.loader;
    }

    public RemoteClass[] getInterfaces() throws Exception {
        this.getClassInfo();
        return this.interfaces;
    }

    public String getSourceFileName() throws Exception {
        this.getClassInfo();
        return this.sourceName;
    }

    public InputStream getSourceFile() throws Exception {
        this.getClassInfo();
        return this.agent.getSourceFile(this.name, this.sourceName);
    }

    public RemoteField[] getFields() throws Exception {
        return this.getStaticFields();
    }

    public RemoteField[] getStaticFields() throws Exception {
        this.loadFields();
        return this.staticFields;
    }

    public RemoteField[] getInstanceFields() throws Exception {
        this.loadFields();
        return this.instanceFields;
    }

    public RemoteField getField(int n) throws Exception {
        this.loadFields();
        if (n < 0 || n >= this.staticFields.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.staticFields[n];
    }

    public RemoteField getField(String string) throws NoSuchFieldException, Exception {
        this.loadFields();
        int n = 0;
        while (n < this.staticFields.length) {
            if (string.equals(this.staticFields[n].getName())) {
                return this.staticFields[n];
            }
            ++n;
        }
        throw new NoSuchFieldException();
    }

    public RemoteField getInstanceField(int n) throws Exception {
        this.loadFields();
        if (n < 0 || n >= this.instanceFields.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.instanceFields[n];
    }

    public RemoteValue getFieldValue(int n) throws Exception {
        return this.getField(n).getValue(this.id);
    }

    public RemoteValue getFieldValue(String string) throws NoSuchFieldException, Exception {
        this.loadFields();
        int n = 0;
        while (n < this.staticFields.length) {
            if (string.equals(this.staticFields[n].getName())) {
                return this.staticFields[n].getValue(this.id);
            }
            ++n;
        }
        throw new NoSuchFieldException();
    }

    public RemoteField getMethod(String string) throws NoSuchMethodException, Exception {
        if (this.methods == null) {
            this.methods = this.agent.getMethods(this.id);
        }
        int n = 0;
        while (n < this.methods.length) {
            if (string.equals(this.methods[n].getName())) {
                return this.methods[n];
            }
            ++n;
        }
        throw new NoSuchMethodException();
    }

    public RemoteField[] getMethods() throws Exception {
        if (this.methods == null) {
            this.methods = this.agent.getMethods(this.id);
        }
        return this.methods;
    }

    public String[] getMethodNames() throws Exception {
        if (this.methods == null) {
            this.methods = this.agent.getMethods(this.id);
        }
        String[] stringArray = new String[this.methods.length];
        int n = 0;
        while (n < this.methods.length) {
            stringArray[n] = this.methods[n].getName();
            ++n;
        }
        return stringArray;
    }

    public int getMethodLineNumber(String string) throws NoSuchMethodException, NoSuchLineNumberException, Exception {
        if (this.methods == null) {
            this.methods = this.agent.getMethods(this.id);
        }
        int n = 0;
        while (n < this.methods.length) {
            if (string.equals(this.methods[n].getName())) {
                int n2 = this.agent.getMethodLineNumber(this.id, n);
                if (n2 == -1) {
                    throw new NoSuchLineNumberException();
                }
                return n2;
            }
            ++n;
        }
        throw new NoSuchMethodException();
    }

    public int getMethodLineNumber(int n) throws IndexOutOfBoundsException, NoSuchLineNumberException, Exception {
        if (this.methods == null) {
            this.methods = this.agent.getMethods(this.id);
        }
        if (n < 0 || n >= this.methods.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.agent.getMethodLineNumber(this.id, n);
        if (n2 == -1) {
            throw new NoSuchLineNumberException();
        }
        return n2;
    }

    public String setBreakpointLine(int n) throws Exception {
        return this.agent.setBreakpointLine(this, n);
    }

    public String setCondBreakpointLine(int n, int n2, int n3) throws Exception {
        return this.agent.setCondBreakpointLine(this, n, n2, n3);
    }

    public int getCondBreakpointLimitCount(int n) throws Exception {
        return this.agent.getCondBreakpointLimitCount(this, n);
    }

    public String setBreakpointMethod(RemoteField remoteField) throws Exception {
        return this.agent.setBreakpointMethod(this, remoteField);
    }

    public String clearBreakpoint(int n) throws Exception {
        return this.agent.clearBreakpoint(this, n);
    }

    public String clearBreakpointLine(int n) throws Exception {
        return this.agent.clearBreakpointLine(this, n);
    }

    public String clearBreakpointMethod(RemoteField remoteField) throws Exception {
        return this.agent.clearBreakpointMethod(this, remoteField);
    }

    private boolean isExceptionClass() throws Exception {
        if (this.getName().equals("java.lang.Exception") || this.getName().equals("java.lang.Error")) {
            return true;
        }
        RemoteClass remoteClass = this.superclass;
        do {
            this.agent.message("isExceptionClass: superClass=" + remoteClass.getName());
            if (!remoteClass.getName().equals("java.lang.Exception") && !remoteClass.getName().equals("java.lang.Error")) continue;
            return true;
        } while (!(remoteClass = remoteClass.getSuperclass()).getName().equals("java.lang.Object"));
        return false;
    }

    public void catchExceptions() throws Exception {
        if (this.isExceptionClass()) {
            this.agent.catchExceptionClass(this);
            return;
        }
        throw new ClassCastException();
    }

    public void ignoreExceptions() throws Exception {
        if (this.isExceptionClass()) {
            this.agent.ignoreExceptionClass(this);
            return;
        }
        throw new ClassCastException();
    }

    public int[] getLineNumbers() throws Exception {
        this.getClassInfo();
        return this.agent.getLineNumbers(this);
    }

    public String description() {
        return this.toString();
    }

    public String toString() {
        try {
            this.getClassInfo();
            return String.valueOf(RemoteValue.toHex(this.id)) + ":" + (this.intf ? "interface" : "class") + "(" + this.getName() + ")";
        }
        catch (Exception exception) {
            return "<communications errors>";
        }
    }
}

