/*
 * Decompiled with CFR 0.152.
 */
package symantec.tools.debug;

import symantec.tools.debug.RemoteAgent;
import symantec.tools.debug.RemoteClass;
import symantec.tools.debug.RemoteObject;
import symantec.tools.debug.RemoteValue;

public class RemoteArray
extends RemoteObject {
    private int size;

    RemoteArray(RemoteAgent remoteAgent, int n, RemoteClass remoteClass, int n2) {
        super(remoteAgent, 9, n, remoteClass);
        this.size = n2;
    }

    public final int getSize() {
        return this.size;
    }

    public String typeName() {
        return new String("array");
    }

    public String arrayTypeName(int n) {
        switch (n) {
            case 0: {
                return new String("boolean");
            }
            case 1: {
                return new String("byte");
            }
            case 2: {
                return new String("char");
            }
            case 3: {
                return new String("short");
            }
            case 4: {
                return new String("int");
            }
            case 5: {
                return new String("long");
            }
            case 6: {
                return new String("float");
            }
            case 7: {
                return new String("double");
            }
            case 9: {
                return new String("array");
            }
            case 16: {
                return new String("Class");
            }
            case 10: 
            case 17: {
                return new String("Object");
            }
            case 18: {
                return new String("String");
            }
            case 19: {
                return new String("Thread");
            }
            case 11: {
                return new String("void");
            }
        }
        return new String("unknown type");
    }

    public final int getElementType() throws Exception {
        String string = this.getClazz().getName();
        switch (string.charAt(1)) {
            case 'C': {
                return 2;
            }
            case 'B': {
                return 1;
            }
            case 'L': {
                return 10;
            }
            case 'F': {
                return 6;
            }
            case 'D': {
                return 7;
            }
            case 'I': {
                return 4;
            }
            case 'J': {
                return 5;
            }
            case 'S': {
                return 3;
            }
            case 'V': {
                return 11;
            }
            case 'Z': {
                return 0;
            }
            case '[': {
                return 9;
            }
        }
        this.agent.error("Invalid array type: '" + new Character(string.charAt(1)).toString() + "'");
        return -1;
    }

    public final RemoteValue getElement(int n) throws Exception {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        RemoteValue[] remoteValueArray = this.agent.getElements(this.id, this.getElementType(), n, n);
        return remoteValueArray[0];
    }

    public final RemoteValue[] getElements() throws Exception {
        return this.agent.getElements(this.id, this.getElementType(), 0, this.size - 1);
    }

    public final RemoteValue[] getElements(int n, int n2) throws Exception {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 >= this.size || n > n2) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        return this.agent.getElements(this.id, this.getElementType(), n, n2);
    }

    public String description() {
        return this.toString();
    }

    public String toString() {
        try {
            String string = new String();
            if (this.size > 0) {
                if (this.getElementType() == 2) {
                    int n = this.size < 16 ? this.size : 16;
                    RemoteValue[] remoteValueArray = this.getElements(0, n - 1);
                    string = "{ ";
                    int n2 = 0;
                    while (n2 < n) {
                        string = string.concat(remoteValueArray[n2].toString());
                        string = string.concat(n2 < n - 1 ? ", " : (n < this.size ? ", ... }" : " }"));
                        ++n2;
                    }
                } else {
                    int n = this.size < 3 ? this.size : 3;
                    RemoteValue[] remoteValueArray = this.getElements(0, n - 1);
                    string = "{ ";
                    if (n > 0 && this.getElementType() == 9) {
                        string = string.concat(" { ... }, ...  }");
                        return string;
                    }
                    int n3 = 0;
                    while (n3 < n) {
                        string = string.concat(remoteValueArray[n3] == null ? "null" : remoteValueArray[n3].description());
                        string = string.concat(n3 < n - 1 ? ", " : (n < this.size ? ", ... }" : " }"));
                        ++n3;
                    }
                }
            }
            return string;
        }
        catch (Exception exception) {
            return "<communication error>";
        }
    }
}

