/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.util.Vector;
import sun.awt.image.ImageFetchable;

class ImageFetcher
extends Thread {
    static Thread[] fetchers = null;
    static int numfetchers;
    static int numwaiting;
    static final int HIGH_PRIORITY = 8;
    static final int LOW_PRIORITY = 3;
    static final int ANIM_PRIORITY = 2;
    static final int TIMEOUT = 5000;
    private static Vector waitList;
    private static ThreadGroup imageFetcherThreadGroup;

    private static ThreadGroup getImageFetcherThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    private ImageFetcher(int n) {
        super(imageFetcherThreadGroup, "Image Fetcher " + n);
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        this.setDaemon(true);
    }

    public static void add(ImageFetchable imageFetchable) {
        Vector vector = waitList;
        synchronized (vector) {
            if (!waitList.contains(imageFetchable)) {
                waitList.addElement(imageFetchable);
                if (numwaiting == 0 && numfetchers < fetchers.length) {
                    int n = 0;
                    while (n < fetchers.length) {
                        if (fetchers[n] == null) {
                            SecurityManager.enablePrivilege("UniversalThreadGroupAccess");
                            ImageFetcher.fetchers[n] = new ImageFetcher(n);
                            SecurityManager.revertPrivilege();
                            fetchers[n].start();
                            ++numfetchers;
                            break;
                        }
                        ++n;
                    }
                }
                waitList.notify();
            }
            return;
        }
    }

    public static boolean remove(ImageFetchable imageFetchable) {
        Vector vector = waitList;
        synchronized (vector) {
            if (waitList.contains(imageFetchable)) {
                waitList.removeElement(imageFetchable);
                boolean bl = true;
                Object var3_3 = null;
                return bl;
            }
        }
        return false;
    }

    public static boolean isFetcher(Thread thread) {
        Vector vector = waitList;
        synchronized (vector) {
            int n = 0;
            while (n < fetchers.length) {
                if (fetchers[n] == thread) {
                    boolean bl = true;
                    Object var3_4 = null;
                    return bl;
                }
                ++n;
            }
        }
        return false;
    }

    public static boolean amFetcher() {
        return ImageFetcher.isFetcher(Thread.currentThread());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ImageFetchable nextImage() {
        Vector vector = waitList;
        // MONITORENTER : vector
        ImageFetchable imageFetchable = null;
        long l = System.currentTimeMillis() + 5000L;
        block7: while (true) {
            if (imageFetchable != null) break;
            while (true) {
                Object var9_4;
                if (waitList.size() != 0) {
                    imageFetchable = (ImageFetchable)waitList.elementAt(0);
                    waitList.removeElement(imageFetchable);
                    continue block7;
                }
                long l2 = System.currentTimeMillis();
                if (l2 >= l) {
                    ImageFetchable imageFetchable2 = null;
                    Object var2_8 = null;
                    // MONITOREXIT : vector
                    return imageFetchable2;
                }
                try {
                    try {
                        ++numwaiting;
                        waitList.wait(l - l2);
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("Image Fetcher interrupted!");
                        ImageFetchable imageFetchable3 = null;
                        var9_4 = null;
                        --numwaiting;
                        Object var2_9 = null;
                        // MONITOREXIT : vector
                        return imageFetchable3;
                    }
                    var9_4 = null;
                    --numwaiting;
                }
                catch (Throwable throwable) {
                    var9_4 = null;
                    --numwaiting;
                    throw throwable;
                }
            }
            break;
        }
        ImageFetchable imageFetchable4 = imageFetchable;
        Object var2_10 = null;
        // MONITOREXIT : vector
        return imageFetchable4;
    }

    public void run() {
        Vector vector;
        Thread thread = Thread.currentThread();
        try {
            try {
                SecurityManager.enablePrivilege("UniversalConnectWithRedirect");
                this.fetchloop(thread);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Object var3_5 = null;
            vector = waitList;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            Vector vector2 = waitList;
            synchronized (vector2) {
                int n = 0;
                while (n < fetchers.length) {
                    if (fetchers[n] == thread) {
                        ImageFetcher.fetchers[n] = null;
                        --numfetchers;
                    }
                    ++n;
                }
            }
        }
        synchronized (vector) {
            int n = 0;
            while (n < fetchers.length) {
                if (fetchers[n] == thread) {
                    ImageFetcher.fetchers[n] = null;
                    --numfetchers;
                }
                ++n;
            }
        }
        return;
        throw throwable;
    }

    public void fetchloop(Thread thread) {
        while (ImageFetcher.isFetcher(thread)) {
            Thread.interrupted();
            SecurityManager.enablePrivilege("UniversalThreadAccess");
            thread.setPriority(8);
            SecurityManager.revertPrivilege();
            ImageFetchable imageFetchable = ImageFetcher.nextImage();
            if (imageFetchable == null) {
                return;
            }
            try {
                imageFetchable.doFetch();
            }
            catch (Exception exception) {
                System.err.println("Uncaught error fetching image:");
                exception.printStackTrace();
            }
            ImageFetcher.stoppingAnimation(thread);
        }
    }

    public static void startingAnimation() {
        Thread thread = Thread.currentThread();
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        Vector vector = waitList;
        synchronized (vector) {
            int n = 0;
            while (n < fetchers.length) {
                if (fetchers[n] == thread) {
                    ImageFetcher.fetchers[n] = null;
                    --numfetchers;
                    thread.setName("Image Animator " + n);
                    Object var2_3 = null;
                    return;
                }
                ++n;
            }
        }
        thread.setPriority(2);
        thread.setName("Image Animator");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void stoppingAnimation(Thread thread) {
        Vector vector = waitList;
        synchronized (vector) {
            int n = -1;
            int n2 = 0;
            while (true) {
                if (n2 >= fetchers.length) {
                    if (n < 0) {
                        return;
                    }
                    ImageFetcher.fetchers[n] = thread;
                    ++numfetchers;
                    SecurityManager.enablePrivilege("UniversalThreadAccess");
                    thread.setName("Image Fetcher " + n);
                    return;
                }
                if (fetchers[n2] == thread) {
                    return;
                }
                if (fetchers[n2] == null) {
                    n = n2;
                }
                ++n2;
            }
        }
    }

    static {
        waitList = new Vector();
        SecurityManager.enablePrivilege("UniversalPropertyRead");
        String string = System.getProperty("awt.imagefetchers", "4");
        SecurityManager.revertPrivilege();
        int n = Integer.parseInt(string);
        fetchers = new Thread[n];
        SecurityManager.enablePrivilege("UniversalThreadGroupAccess");
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        imageFetcherThreadGroup = new ThreadGroup(threadGroup, "ImageFetchers");
        imageFetcherThreadGroup.setDaemon(false);
        int n2 = 0;
        while (n2 < fetchers.length) {
            ImageFetcher.fetchers[n2] = new ImageFetcher(n2);
            ImageFetcher imageFetcher = ImageFetcher.fetchers[n2];
            imageFetcher.start();
            ++n2;
        }
        SecurityManager.revertPrivilege();
    }
}

