/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.InputStream;

public class StringBufferInputStream
extends InputStream {
    protected String buffer;
    protected int pos;
    protected int count;

    public StringBufferInputStream(String string) {
        this.buffer = string;
        this.count = string.length();
    }

    public synchronized int read() {
        if (this.pos < this.count) {
            return this.buffer.charAt(this.pos++) & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        String string = this.buffer;
        int n3 = n2;
        while (--n3 >= 0) {
            byArray[n++] = (byte)string.charAt(this.pos++);
        }
        return n2;
    }

    public synchronized long skip(long l) {
        if (l < 0L) {
            return 0L;
        }
        if (l > (long)(this.count - this.pos)) {
            l = this.count - this.pos;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public synchronized void reset() {
        this.pos = 0;
    }
}

