/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxMenuItemPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable {
    boolean state = false;
    transient ItemListener itemListener;
    private static final String base = "chkmenuitem";
    private static int nameCounter;
    private static final long serialVersionUID = 6190621106981774043L;
    private int checkboxMenuItemSerializedDataVersion = 1;

    public CheckboxMenuItem() {
        this("", false);
    }

    public CheckboxMenuItem(String string) {
        this(string, false);
    }

    public CheckboxMenuItem(String string, boolean bl) {
        super(string);
        this.name = base + nameCounter++;
        this.state = bl;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = Toolkit.getDefaultToolkit().createCheckboxMenuItem(this);
        }
        super.addNotify();
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean bl) {
        this.state = bl;
        CheckboxMenuItemPeer checkboxMenuItemPeer = (CheckboxMenuItemPeer)this.peer;
        if (checkboxMenuItemPeer != null) {
            checkboxMenuItemPeer.setState(bl);
        }
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.state) {
            Object[] objectArray = new Object[]{this.label};
            return objectArray;
        }
        return null;
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    public String paramString() {
        return String.valueOf(super.paramString()) + ",state=" + this.state;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "itemL") {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }
}

