/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

import netscape.security.ForbiddenTargetException;
import netscape.security.ParameterizedStringTarget;
import netscape.security.Principal;
import netscape.security.Privilege;
import netscape.security.PrivilegeManager;
import netscape.security.UserDialogHelper;
import netscape.security.UserTarget;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.Hashtable;

public class Target
implements Codable {
    static final int VERSION = 1;
    private String itsName;
    private Principal itsPrincipal;
    private int itsRisk;
    private String itsRiskColorStr;
    private String itsDescriptionStr;
    private String itsDetailDescriptionStr;
    private String itsUrlStr;
    private boolean isRegistered;
    private static Hashtable theTargetRegistry = new Hashtable();
    private static Hashtable theDescToTargetRegistry = new Hashtable();
    private Target[] itsTargetAry;
    private Target[] itsExpandedTargetAry;
    private boolean itsInited = false;

    private void init(String string, Principal principal, Target[] targetArray, int n, String string2, String string3, String string4, String string5) {
        if (string == null) {
            throw new NullPointerException("Invalid target name");
        }
        this.itsInited = true;
        this.itsName = string;
        this.itsPrincipal = principal;
        this.isRegistered = false;
        this.itsRisk = n;
        this.itsRiskColorStr = string2;
        this.itsDescriptionStr = string3 == null ? string : string3;
        this.itsDetailDescriptionStr = string4 == null ? this.itsDescriptionStr : string4;
        this.itsUrlStr = string5;
        this.itsTargetAry = null;
        if (targetArray == null) {
            return;
        }
        int n2 = targetArray.length;
        while (n2-- > 0) {
            if (targetArray[n2].itsPrincipal != principal) {
                throw new ForbiddenTargetException("Principals don't match for the target " + targetArray[n2]);
            }
            if (targetArray[n2].itsRisk <= this.itsRisk) continue;
            this.itsRisk = targetArray[n2].itsRisk;
        }
        try {
            this.itsTargetAry = (Target[])targetArray.clone();
            return;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ForbiddenTargetException("internal error: unable to clone Target");
        }
    }

    public Target() {
    }

    public Target(String string, Principal principal) {
        this.init(string, principal, null, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), null, null, null);
    }

    public Target(String string) {
        this.init(string, PrivilegeManager.getSystemPrincipal(), null, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), null, null, null);
    }

    public Target(String string, Principal principal, Target[] targetArray) {
        this.init(string, principal, targetArray, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), null, null, null);
    }

    public Target(String string, Principal principal, int n, String string2, String string3, String string4) {
        this.init(string, principal, null, n, string2, string3, null, string4);
    }

    public Target(String string, Principal principal, int n, String string2, String string3, String string4, Target[] targetArray) {
        this.init(string, principal, targetArray, n, string2, string3, null, string4);
    }

    public Target(String string, Principal principal, int n, String string2, String string3, String string4, String string5) {
        this.init(string, principal, null, n, string2, string3, string4, string5);
    }

    public Target(String string, Principal principal, int n, String string2, String string3, String string4, String string5, Target[] targetArray) {
        this.init(string, principal, targetArray, n, string2, string3, string4, string5);
    }

    public final Target registerTarget() {
        Hashtable hashtable = theTargetRegistry;
        synchronized (hashtable) {
            Target target = (Target)theTargetRegistry.get(this);
            if (target != null) {
                Target target2 = target;
                Object var4_5 = null;
                return target2;
            }
            PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
            if (privilegeManager != null && !privilegeManager.checkMatchPrincipal(this.itsPrincipal, 1)) {
                throw new ForbiddenTargetException("Target's principal " + this.itsPrincipal + " is different from caller's principal " + privilegeManager.getClassPrincipalsFromStack(1)[0]);
            }
            theTargetRegistry.put(this, this);
            theDescToTargetRegistry.put(this.getDescription(), this);
            this.isRegistered = true;
            Target target3 = this;
            Object var4_6 = null;
            return target3;
        }
    }

    public static Target findTarget(String string) {
        return Target.findTarget(string, PrivilegeManager.getSystemPrincipal());
    }

    public static Target findTarget(String string, Principal principal) {
        return Target.findTarget(new Target(string, principal));
    }

    public static Target findTarget(Target target) {
        return (Target)theTargetRegistry.get(target);
    }

    public Privilege checkPrivilegeEnabled(Principal[] principalArray, Object object) {
        return Privilege.findPrivilege(2, 1);
    }

    public Privilege checkPrivilegeEnabled(Principal[] principalArray) {
        return this.checkPrivilegeEnabled(principalArray, null);
    }

    public Privilege checkPrivilegeEnabled(Principal principal, Object object) {
        return Privilege.findPrivilege(2, 1);
    }

    public Privilege enablePrivilege(Principal principal, Object object) {
        if (this.itsPrincipal.equals(principal)) {
            return Privilege.findPrivilege(1, 1);
        }
        return Privilege.findPrivilege(2, 1);
    }

    Privilege getPrincipalPrivilege(Principal principal, Object object) {
        return Privilege.findPrivilege(2, 1);
    }

    public Target[] getFlattenedTargetAry() {
        Target[] targetArray = this.getFlattenedTargetAryUnsafe();
        try {
            return (Target[])targetArray.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ForbiddenTargetException("internal error: unable to clone Target");
        }
    }

    Target[] getFlattenedTargetAryUnsafe() {
        if (this.itsExpandedTargetAry != null) {
            return this.itsExpandedTargetAry;
        }
        int n = 0;
        Hashtable hashtable = new Hashtable();
        this.getFlattenedTargets(hashtable);
        Target[] targetArray = new Target[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            targetArray[n++] = target;
        }
        this.itsExpandedTargetAry = targetArray;
        return this.itsExpandedTargetAry;
    }

    private void getFlattenedTargets(Hashtable hashtable) {
        if (hashtable.get(this) != null) {
            return;
        }
        hashtable.put(this, this);
        if (this.itsTargetAry == null) {
            return;
        }
        int n = this.itsTargetAry.length;
        while (n-- > 0) {
            this.itsTargetAry[n].getFlattenedTargets(hashtable);
        }
    }

    public static Target[] getAllRegisteredTargets() {
        Target[] targetArray;
        int n = 0;
        Hashtable hashtable = theTargetRegistry;
        synchronized (hashtable) {
            targetArray = new Target[theTargetRegistry.size()];
            Enumeration enumeration = theTargetRegistry.keys();
            while (enumeration.hasMoreElements()) {
                Target target = (Target)enumeration.nextElement();
                targetArray[n++] = target;
            }
        }
        return targetArray;
    }

    public String getRisk() {
        return UserDialogHelper.targetRiskStr(this.itsRisk);
    }

    public String getRiskColor() {
        return this.itsRiskColorStr;
    }

    public String getDescription() {
        return this.itsDescriptionStr;
    }

    public String getDetailDescription() {
        return this.itsDetailDescriptionStr;
    }

    public static Target getTargetFromDescription(String string) {
        return (Target)theDescToTargetRegistry.get(string);
    }

    public String getHelpUrl() {
        return this.itsUrlStr;
    }

    public String getDetailedInfo(Object object) {
        return "";
    }

    public Principal getPrincipal() {
        return this.itsPrincipal;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Target)) {
            return false;
        }
        Target target = (Target)object;
        boolean bl = this.itsName.equals(target.itsName);
        boolean bl2 = this.itsPrincipal == null ? target.itsPrincipal == null : this.itsPrincipal.equals(target.itsPrincipal);
        return bl && bl2;
    }

    public int hashCode() {
        return this.itsName.hashCode() + (this.itsPrincipal != null ? this.itsPrincipal.hashCode() : 0);
    }

    public String toString() {
        String string = this.itsPrincipal != null ? this.itsPrincipal.toString() : "<none>";
        return "Target: " + this.itsName + " Prin: " + string;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("Target", 1);
        classInfo.addField("Name", (byte)16);
        classInfo.addField("Principal", (byte)18);
        classInfo.addField("TargetArray", (byte)19);
        classInfo.addField("Risk", (byte)8);
        classInfo.addField("RiskColorStr", (byte)16);
        classInfo.addField("DescriptionStr", (byte)16);
        classInfo.addField("DetailDescriptionStr", (byte)16);
        classInfo.addField("UrlStr", (byte)16);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeString("Name", this.itsName);
        encoder.encodeObject("Principal", (Object)this.itsPrincipal);
        encoder.encodeInt("Risk", this.itsRisk);
        encoder.encodeString("RiskColorStr", this.itsRiskColorStr);
        encoder.encodeString("DescriptionStr", this.itsDescriptionStr);
        encoder.encodeString("DetailDescriptionStr", this.itsDetailDescriptionStr);
        encoder.encodeString("UrlStr", this.itsUrlStr);
        encoder.encodeObjectArray("TargetArray", (Object[])this.itsTargetAry, 0, this.itsTargetAry == null ? 0 : this.itsTargetAry.length);
    }

    public void decode(Decoder decoder) throws CodingException {
        if (this.itsInited) {
            return;
        }
        this.itsInited = true;
        this.itsName = decoder.decodeString("Name");
        this.itsPrincipal = (Principal)decoder.decodeObject("Principal");
        this.itsRisk = decoder.decodeInt("Risk");
        this.itsRiskColorStr = decoder.decodeString("RiskColorStr");
        this.itsDescriptionStr = decoder.decodeString("DescriptionStr");
        this.itsDetailDescriptionStr = decoder.decodeString("DetailDescriptionStr");
        this.itsUrlStr = decoder.decodeString("UrlStr");
        Object[] objectArray = decoder.decodeObjectArray("TargetArray");
        if (objectArray != null) {
            this.itsTargetAry = new Target[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                Target target = (Target)objectArray[n];
                Target target2 = Target.findTarget(target);
                if (target2 == null) {
                    target2 = target.registerTarget();
                }
                this.itsTargetAry[n] = target2;
                ++n;
            }
        }
    }

    public void finishDecoding() throws CodingException {
    }

    public String getName() {
        return this.itsName;
    }

    static {
        Principal principal = PrivilegeManager.getSystemPrincipal();
        int n = 0;
        UserTarget userTarget = new UserTarget("UniversalThreadAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_ThreadAccess(), UserDialogHelper.targetDetailDesc_ThreadAccess(), UserDialogHelper.targetUrl_ThreadAccess());
        userTarget.registerTarget();
        UserTarget userTarget2 = new UserTarget("UniversalThreadGroupAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_ThreadGroupAccess(), UserDialogHelper.targetDetailDesc_ThreadGroupAccess(), UserDialogHelper.targetUrl_ThreadGroupAccess());
        userTarget2.registerTarget();
        UserTarget userTarget3 = new UserTarget("UniversalExecAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_ExecAccess(), UserDialogHelper.targetDetailDesc_ExecAccess(), UserDialogHelper.targetUrl_ExecAccess());
        userTarget3.registerTarget();
        UserTarget userTarget4 = new UserTarget("UniversalExitAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_ExitAccess(), UserDialogHelper.targetDetailDesc_ExitAccess(), UserDialogHelper.targetUrl_ExitAccess());
        userTarget4.registerTarget();
        UserTarget userTarget5 = new UserTarget("UniversalLinkAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_LinkAccess(), UserDialogHelper.targetDetailDesc_LinkAccess(), UserDialogHelper.targetUrl_LinkAccess());
        userTarget5.registerTarget();
        UserTarget userTarget6 = new UserTarget("UniversalPropertyWrite", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_PropertyWrite(), UserDialogHelper.targetDetailDesc_PropertyWrite(), UserDialogHelper.targetUrl_PropertyWrite());
        userTarget6.registerTarget();
        UserTarget userTarget7 = new UserTarget("UniversalPropertyRead", principal, UserDialogHelper.targetRiskLow(), UserDialogHelper.targetRiskColorLow(), UserDialogHelper.targetDesc_PropertyRead(), UserDialogHelper.targetDetailDesc_PropertyRead(), UserDialogHelper.targetUrl_PropertyRead());
        userTarget7.registerTarget();
        UserTarget userTarget8 = new UserTarget("UniversalFileRead", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_FileRead(), UserDialogHelper.targetDetailDesc_FileRead(), UserDialogHelper.targetUrl_FileRead());
        userTarget8.registerTarget();
        UserTarget userTarget9 = new UserTarget("UniversalFileWrite", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_FileWrite(), UserDialogHelper.targetDetailDesc_FileWrite(), UserDialogHelper.targetUrl_FileWrite());
        userTarget9.registerTarget();
        UserTarget userTarget10 = new UserTarget("UniversalFileDelete", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_FileDelete(), UserDialogHelper.targetDetailDesc_FileDelete(), UserDialogHelper.targetUrl_FileDelete());
        userTarget10.registerTarget();
        UserTarget userTarget11 = new UserTarget("UniversalFdRead", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_FdRead(), UserDialogHelper.targetDetailDesc_FdRead(), UserDialogHelper.targetUrl_FdRead());
        userTarget11.registerTarget();
        UserTarget userTarget12 = new UserTarget("UniversalFdWrite", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_FdWrite(), UserDialogHelper.targetDetailDesc_FdWrite(), UserDialogHelper.targetUrl_FdWrite());
        userTarget12.registerTarget();
        UserTarget userTarget13 = new UserTarget("UniversalListen", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_Listen(), UserDialogHelper.targetDetailDesc_Listen(), UserDialogHelper.targetUrl_Listen());
        userTarget13.registerTarget();
        UserTarget userTarget14 = new UserTarget("UniversalAccept", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_Accept(), UserDialogHelper.targetDetailDesc_Accept(), UserDialogHelper.targetUrl_Accept());
        userTarget14.registerTarget();
        UserTarget userTarget15 = new UserTarget("UniversalMulticast", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_Multicast(), UserDialogHelper.targetDetailDesc_Multicast(), UserDialogHelper.targetUrl_Multicast());
        userTarget15.registerTarget();
        UserTarget userTarget16 = new UserTarget("UniversalTopLevelWindow", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_TopLevelWindow(), UserDialogHelper.targetDetailDesc_TopLevelWindow(), UserDialogHelper.targetUrl_TopLevelWindow());
        userTarget16.registerTarget();
        UserTarget userTarget17 = new UserTarget("UniversalDialogModality", principal, UserDialogHelper.targetRiskMedium(), UserDialogHelper.targetRiskColorMedium(), UserDialogHelper.targetDesc_DialogModality(), UserDialogHelper.targetDetailDesc_DialogModality(), UserDialogHelper.targetUrl_DialogModality());
        userTarget17.registerTarget();
        Target target = new Target("UniversalPackageAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_PackageAccess(), UserDialogHelper.targetDetailDesc_PackageAccess(), UserDialogHelper.targetUrl_PackageAccess());
        target.registerTarget();
        Target target2 = new Target("UniversalPackageDefinition", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_PackageDefinition(), UserDialogHelper.targetDetailDesc_PackageDefinition(), UserDialogHelper.targetUrl_PackageDefinition());
        target2.registerTarget();
        UserTarget userTarget18 = new UserTarget("UniversalSetFactory", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_SetFactory(), UserDialogHelper.targetDetailDesc_SetFactory(), UserDialogHelper.targetUrl_SetFactory());
        userTarget18.registerTarget();
        Target target3 = new Target("UniversalMemberAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_MemberAccess(), UserDialogHelper.targetDetailDesc_MemberAccess(), UserDialogHelper.targetUrl_MemberAccess());
        target3.registerTarget();
        UserTarget userTarget19 = new UserTarget("UniversalPrintJobAccess", principal, UserDialogHelper.targetRiskLow(), UserDialogHelper.targetRiskColorLow(), UserDialogHelper.targetDesc_PrintJobAccess(), UserDialogHelper.targetDetailDesc_PrintJobAccess(), UserDialogHelper.targetUrl_PrintJobAccess());
        userTarget19.registerTarget();
        UserTarget userTarget20 = new UserTarget("UniversalSystemClipboardAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_SystemClipboardAccess(), UserDialogHelper.targetDetailDesc_SystemClipboardAccess(), UserDialogHelper.targetUrl_SystemClipboardAccess());
        userTarget20.registerTarget();
        UserTarget userTarget21 = new UserTarget("UniversalAwtEventQueueAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_AwtEventQueueAccess(), UserDialogHelper.targetDetailDesc_AwtEventQueueAccess(), UserDialogHelper.targetUrl_AwtEventQueueAccess());
        userTarget21.registerTarget();
        Target target4 = new Target("UniversalSecurityProvider", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_SecurityProvider(), UserDialogHelper.targetDetailDesc_SecurityProvider(), UserDialogHelper.targetUrl_SecurityProvider());
        target4.registerTarget();
        Target target5 = new Target("CreateSecurityManager", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_CreateSecurityManager(), UserDialogHelper.targetDetailDesc_CreateSecurityManager(), UserDialogHelper.targetUrl_CreateSecurityManager());
        target5.registerTarget();
        Target target6 = new Target("Impersonator", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_Impersonator(), UserDialogHelper.targetDetailDesc_Impersonator(), UserDialogHelper.targetUrl_Impersonator());
        target6.registerTarget();
        UserTarget userTarget22 = new UserTarget("UniversalBrowserRead", principal, UserDialogHelper.targetRiskMedium(), UserDialogHelper.targetRiskColorMedium(), UserDialogHelper.targetDesc_BrowserRead(), UserDialogHelper.targetDetailDesc_BrowserRead(), UserDialogHelper.targetUrl_BrowserRead());
        userTarget22.registerTarget();
        UserTarget userTarget23 = new UserTarget("UniversalBrowserWrite", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_BrowserWrite(), UserDialogHelper.targetDetailDesc_BrowserWrite(), UserDialogHelper.targetUrl_BrowserWrite());
        userTarget23.registerTarget();
        UserTarget userTarget24 = new UserTarget("UniversalPreferencesRead", principal, UserDialogHelper.targetRiskMedium(), UserDialogHelper.targetRiskColorMedium(), UserDialogHelper.targetDesc_PrefsRead(), UserDialogHelper.targetDetailDesc_PrefsRead(), UserDialogHelper.targetUrl_PrefsRead());
        userTarget24.registerTarget();
        UserTarget userTarget25 = new UserTarget("UniversalPreferencesWrite", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_PrefsWrite(), UserDialogHelper.targetDetailDesc_PrefsWrite(), UserDialogHelper.targetUrl_PrefsWrite());
        userTarget25.registerTarget();
        UserTarget userTarget26 = new UserTarget("UniversalSendMail", principal, UserDialogHelper.targetRiskMedium(), UserDialogHelper.targetRiskColorMedium(), UserDialogHelper.targetDesc_SendMail(), UserDialogHelper.targetDetailDesc_SendMail(), UserDialogHelper.targetUrl_SendMail());
        userTarget26.registerTarget();
        Target[] targetArray = new Target[1];
        UserTarget userTarget27 = new UserTarget("PrivateRegistryAccess", principal, UserDialogHelper.targetRiskLow(), UserDialogHelper.targetRiskColorLow(), UserDialogHelper.targetDesc_RegPrivate(), UserDialogHelper.targetDetailDesc_RegPrivate(), UserDialogHelper.targetUrl_RegPrivate());
        userTarget27.registerTarget();
        targetArray[0] = userTarget27;
        UserTarget userTarget28 = new UserTarget("StandardRegistryAccess", principal, UserDialogHelper.targetRiskMedium(), UserDialogHelper.targetRiskColorMedium(), UserDialogHelper.targetDesc_RegStandard(), UserDialogHelper.targetDetailDesc_RegStandard(), UserDialogHelper.targetUrl_RegStandard(), targetArray);
        userTarget28.registerTarget();
        targetArray[0] = userTarget28;
        UserTarget userTarget29 = new UserTarget("AdministratorRegistryAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_RegAdmin(), UserDialogHelper.targetDetailDesc_RegAdmin(), UserDialogHelper.targetUrl_RegAdmin(), targetArray);
        userTarget29.registerTarget();
        targetArray = new Target[2];
        n = 0;
        targetArray[n++] = userTarget11;
        targetArray[n++] = userTarget12;
        UserTarget userTarget30 = new UserTarget("UniversalConnect", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_Connect(), UserDialogHelper.targetDetailDesc_Connect(), UserDialogHelper.targetUrl_Connect(), targetArray);
        userTarget30.registerTarget();
        UserTarget userTarget31 = new UserTarget("ClientAuth", principal, UserDialogHelper.targetRiskMedium(), UserDialogHelper.targetRiskColorMedium(), UserDialogHelper.targetDesc_ClientAuth(), UserDialogHelper.targetDetailDesc_ClientAuth(), UserDialogHelper.targetUrl_ClientAuth());
        userTarget31.registerTarget();
        Target target7 = new Target("UniversalRedirect", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_Redirect(), UserDialogHelper.targetDetailDesc_Redirect(), UserDialogHelper.targetUrl_Redirect());
        target7.registerTarget();
        targetArray = new Target[2];
        n = 0;
        targetArray[n++] = userTarget30;
        targetArray[n++] = target7;
        UserTarget userTarget32 = new UserTarget("UniversalConnectWithRedirect", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_ConnectWithRedirect(), UserDialogHelper.targetDetailDesc_ConnectWithRedirect(), UserDialogHelper.targetUrl_ConnectWithRedirect(), targetArray);
        userTarget32.registerTarget();
        targetArray = new Target[2];
        n = 0;
        targetArray[n++] = userTarget11;
        targetArray[n++] = userTarget12;
        Target target8 = new Target("CodebaseEnvironment", principal, UserDialogHelper.targetRiskLow(), UserDialogHelper.targetRiskColorLow(), UserDialogHelper.targetDesc_CodebaseEnv(), UserDialogHelper.targetDetailDesc_CodebaseEnv(), UserDialogHelper.targetUrl_CodebaseEnv(), targetArray);
        target8.registerTarget();
        targetArray = new Target[31];
        n = 0;
        targetArray[n++] = userTarget;
        targetArray[n++] = userTarget2;
        targetArray[n++] = userTarget3;
        targetArray[n++] = userTarget4;
        targetArray[n++] = userTarget5;
        targetArray[n++] = userTarget6;
        targetArray[n++] = userTarget7;
        targetArray[n++] = userTarget8;
        targetArray[n++] = userTarget9;
        targetArray[n++] = userTarget10;
        targetArray[n++] = userTarget11;
        targetArray[n++] = userTarget12;
        targetArray[n++] = userTarget13;
        targetArray[n++] = userTarget14;
        targetArray[n++] = userTarget30;
        targetArray[n++] = userTarget15;
        targetArray[n++] = userTarget16;
        targetArray[n++] = target;
        targetArray[n++] = target2;
        targetArray[n++] = userTarget18;
        targetArray[n++] = target3;
        targetArray[n++] = userTarget19;
        targetArray[n++] = userTarget20;
        targetArray[n++] = userTarget21;
        targetArray[n++] = target4;
        targetArray[n++] = target5;
        targetArray[n++] = target6;
        targetArray[n++] = userTarget22;
        targetArray[n++] = userTarget23;
        targetArray[n++] = userTarget26;
        targetArray[n++] = target8;
        Target target9 = new Target("SuperUser", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_SuperUser(), UserDialogHelper.targetDetailDesc_SuperUser(), UserDialogHelper.targetUrl_SuperUser(), targetArray);
        target9.registerTarget();
        UserTarget userTarget33 = new UserTarget("SiteArchiveTarget", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_SAR(), UserDialogHelper.targetDetailDesc_SAR(), UserDialogHelper.targetUrl_SAR());
        userTarget33.registerTarget();
        targetArray = new Target[11];
        n = 0;
        targetArray[n++] = userTarget;
        targetArray[n++] = userTarget2;
        targetArray[n++] = userTarget5;
        targetArray[n++] = userTarget6;
        targetArray[n++] = userTarget7;
        targetArray[n++] = userTarget13;
        targetArray[n++] = userTarget14;
        targetArray[n++] = userTarget30;
        targetArray[n++] = userTarget16;
        targetArray[n++] = target;
        targetArray[n++] = target2;
        target9 = new UserTarget("30Capabilities", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_30Capabilities(), UserDialogHelper.targetDetailDesc_30Capabilities(), UserDialogHelper.targetUrl_30Capabilities(), targetArray);
        target9.registerTarget();
        targetArray = new Target[]{};
        Target target10 = new Target("MarimbaAppContextTarget", principal, UserDialogHelper.targetRiskMedium(), UserDialogHelper.targetRiskColorMedium(), UserDialogHelper.targetDesc_Marimba(), UserDialogHelper.targetDetailDesc_Marimba(), UserDialogHelper.targetUrl_Marimba(), targetArray);
        target10.registerTarget();
        targetArray = new Target[10];
        n = 0;
        targetArray[n++] = userTarget8;
        targetArray[n++] = userTarget9;
        targetArray[n++] = userTarget10;
        targetArray[n++] = userTarget7;
        targetArray[n++] = userTarget30;
        targetArray[n++] = userTarget16;
        targetArray[n++] = target;
        targetArray[n++] = userTarget;
        targetArray[n++] = userTarget2;
        targetArray[n++] = target10;
        target9 = new UserTarget("MarimbaInternalTarget", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_Marimba(), UserDialogHelper.targetDetailDesc_Marimba(), UserDialogHelper.targetUrl_Marimba(), targetArray);
        target9.registerTarget();
        targetArray = new Target[4];
        n = 0;
        targetArray[n++] = userTarget13;
        targetArray[n++] = userTarget14;
        targetArray[n++] = userTarget30;
        targetArray[n++] = target8;
        UserTarget userTarget34 = new UserTarget("IIOPRuntime", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_IIOP(), UserDialogHelper.targetDetailDesc_IIOP(), UserDialogHelper.targetUrl_IIOP());
        userTarget34.registerTarget();
        targetArray = new Target[10];
        n = 0;
        targetArray[n++] = userTarget3;
        targetArray[n++] = userTarget6;
        targetArray[n++] = userTarget7;
        targetArray[n++] = userTarget8;
        targetArray[n++] = userTarget13;
        targetArray[n++] = userTarget14;
        targetArray[n++] = userTarget30;
        targetArray[n++] = userTarget;
        targetArray[n++] = userTarget2;
        targetArray[n++] = userTarget18;
        UserTarget userTarget35 = new UserTarget("Debugger", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_Debugger(), UserDialogHelper.targetDetailDesc_Debugger(), UserDialogHelper.targetUrl_Debugger(), targetArray);
        userTarget35.registerTarget();
        targetArray = new Target[]{userTarget23};
        userTarget35 = new UserTarget("CanvasAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_CanvasAccess(), UserDialogHelper.targetDetailDesc_CanvasAccess(), UserDialogHelper.targetUrl_CanvasAccess(), targetArray);
        userTarget35.registerTarget();
        targetArray = new Target[5];
        n = 0;
        targetArray[n++] = userTarget5;
        targetArray[n++] = userTarget7;
        targetArray[n++] = userTarget8;
        targetArray[n++] = userTarget9;
        targetArray[n++] = userTarget10;
        UserTarget userTarget36 = new UserTarget("UniversalFileAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_FileAccess(), UserDialogHelper.targetDetailDesc_FileAccess(), UserDialogHelper.targetUrl_FileAccess(), targetArray);
        userTarget36.registerTarget();
        targetArray = new Target[2];
        n = 0;
        targetArray[n++] = userTarget22;
        targetArray[n++] = userTarget23;
        UserTarget userTarget37 = new UserTarget("UniversalBrowserAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_BrowserAccess(), UserDialogHelper.targetDetailDesc_BrowserAccess(), UserDialogHelper.targetUrl_BrowserAccess(), targetArray);
        userTarget37.registerTarget();
        UserTarget userTarget38 = new UserTarget("LimitedFileAccess", principal, UserDialogHelper.targetRiskLow(), UserDialogHelper.targetRiskColorLow(), UserDialogHelper.targetDesc_LimitedFileAccess(), UserDialogHelper.targetDetailDesc_LimitedFileAccess(), UserDialogHelper.targetUrl_LimitedFileAccess());
        userTarget38.registerTarget();
        UserTarget userTarget39 = new UserTarget("CookieAccess", principal, UserDialogHelper.targetRiskLow(), UserDialogHelper.targetRiskColorLow(), UserDialogHelper.targetDesc_CookieAccess(), UserDialogHelper.targetDetailDesc_CookieAccess(), UserDialogHelper.targetUrl_CookieAccess());
        userTarget39.registerTarget();
        UserTarget userTarget40 = new UserTarget("SignonAccess", principal, UserDialogHelper.targetRiskLow(), UserDialogHelper.targetRiskColorLow(), UserDialogHelper.targetDesc_SignonAccess(), UserDialogHelper.targetDetailDesc_SignonAccess(), UserDialogHelper.targetUrl_SignonAccess());
        userTarget40.registerTarget();
        targetArray = new Target[1];
        n = 0;
        targetArray[n++] = userTarget27;
        userTarget35 = new UserTarget("GamesAccess", principal, UserDialogHelper.targetRiskLow(), UserDialogHelper.targetRiskColorLow(), UserDialogHelper.targetDesc_GamesAccess(), UserDialogHelper.targetDetailDesc_GamesAccess(), UserDialogHelper.targetUrl_GamesAccess(), targetArray);
        userTarget35.registerTarget();
        targetArray = new Target[4];
        n = 0;
        targetArray[n++] = userTarget36;
        targetArray[n++] = userTarget27;
        targetArray[n++] = userTarget19;
        targetArray[n++] = userTarget20;
        userTarget35 = new UserTarget("WordProcessorAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_WordProcessorAccess(), UserDialogHelper.targetDetailDesc_WordProcessorAccess(), UserDialogHelper.targetUrl_WordProcessorAccess(), targetArray);
        userTarget35.registerTarget();
        targetArray = new Target[4];
        n = 0;
        targetArray[n++] = userTarget36;
        targetArray[n++] = userTarget27;
        targetArray[n++] = userTarget19;
        targetArray[n++] = userTarget20;
        userTarget35 = new UserTarget("SpreadsheetAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_SpreadsheetAccess(), UserDialogHelper.targetDetailDesc_SpreadsheetAccess(), UserDialogHelper.targetUrl_SpreadsheetAccess(), targetArray);
        userTarget35.registerTarget();
        targetArray = new Target[4];
        n = 0;
        targetArray[n++] = userTarget36;
        targetArray[n++] = userTarget27;
        targetArray[n++] = userTarget19;
        targetArray[n++] = userTarget20;
        userTarget35 = new UserTarget("PresentationAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_PresentationAccess(), UserDialogHelper.targetDetailDesc_PresentationAccess(), UserDialogHelper.targetUrl_PresentationAccess(), targetArray);
        userTarget35.registerTarget();
        targetArray = new Target[4];
        n = 0;
        targetArray[n++] = userTarget36;
        targetArray[n++] = userTarget27;
        targetArray[n++] = userTarget19;
        targetArray[n++] = userTarget20;
        userTarget35 = new UserTarget("DatabaseAccess", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_DatabaseAccess(), UserDialogHelper.targetDetailDesc_DatabaseAccess(), UserDialogHelper.targetUrl_DatabaseAccess(), targetArray);
        userTarget35.registerTarget();
        targetArray = new Target[7];
        n = 0;
        targetArray[n++] = userTarget5;
        targetArray[n++] = userTarget7;
        targetArray[n++] = userTarget13;
        targetArray[n++] = userTarget14;
        targetArray[n++] = userTarget30;
        targetArray[n++] = userTarget19;
        targetArray[n++] = userTarget20;
        userTarget35 = new UserTarget("TerminalEmulator", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_TerminalEmulator(), UserDialogHelper.targetDetailDesc_TerminalEmulator(), UserDialogHelper.targetUrl_TerminalEmulator(), targetArray);
        userTarget35.registerTarget();
        targetArray = new Target[3];
        n = 0;
        targetArray[n++] = userTarget36;
        targetArray[n++] = userTarget28;
        targetArray[n++] = userTarget16;
        userTarget35 = new UserTarget("JARPackager", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_JARPackager(), UserDialogHelper.targetDetailDesc_JARPackager(), UserDialogHelper.targetUrl_JARPackager(), targetArray);
        userTarget35.registerTarget();
        targetArray = new Target[7];
        n = 0;
        targetArray[n++] = userTarget22;
        targetArray[n++] = userTarget23;
        targetArray[n++] = userTarget24;
        targetArray[n++] = userTarget25;
        targetArray[n++] = userTarget16;
        targetArray[n++] = userTarget30;
        targetArray[n++] = userTarget36;
        userTarget35 = new UserTarget("AccountSetup", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_AccountSetup(), UserDialogHelper.targetDetailDesc_AccountSetup(), UserDialogHelper.targetUrl_AccountSetup(), targetArray);
        userTarget35.registerTarget();
        targetArray = new Target[12];
        n = 0;
        targetArray[n++] = userTarget22;
        targetArray[n++] = userTarget23;
        targetArray[n++] = userTarget8;
        targetArray[n++] = userTarget9;
        targetArray[n++] = userTarget33;
        targetArray[n++] = userTarget36;
        targetArray[n++] = userTarget24;
        targetArray[n++] = userTarget25;
        targetArray[n++] = userTarget32;
        targetArray[n++] = userTarget;
        targetArray[n++] = userTarget2;
        targetArray[n++] = userTarget5;
        target9 = new UserTarget("Netcaster", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_Constellation(), UserDialogHelper.targetDetailDesc_Constellation(), UserDialogHelper.targetUrl_Constellation(), targetArray);
        target9.registerTarget();
        userTarget35 = new ParameterizedStringTarget("FileRead", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_ParamFileRead(), UserDialogHelper.targetDetailDesc_ParamFileRead(), UserDialogHelper.targetUrl_ParamFileRead());
        userTarget35.registerTarget();
        userTarget35 = new ParameterizedStringTarget("FileWrite", principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), UserDialogHelper.targetDesc_ParamFileWrite(), UserDialogHelper.targetDetailDesc_ParamFileWrite(), UserDialogHelper.targetUrl_ParamFileWrite());
        userTarget35.registerTarget();
    }
}

