 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Thu Aug 14 1997                               */
 /* --------------------------------------------------------------------  */
 /* Fatal error calls.                                                    */
 /*                                                                       */
 /*************************************************************************/

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "EST_error.h"

const char * EST_error_where=NULL;
char EST_error_message_buf[MAX_ERROR_MESSAGE_LENGTH];
char *EST_error_message = EST_error_message_buf;

void EST_default_error_fn(const char *format, ...)
{
    va_list ap;

    if (EST_error_stream==NULL)
      EST_error_stream = stderr;

    fprintf(EST_error_stream, "-=-=-=-=-=- EST Error -=-=-=-=-=-\n");
    if (EST_error_where)
      fprintf(EST_error_stream,"    %s\n", EST_error_where);

    va_start(ap, format);
    vfprintf(EST_error_stream, format, ap);
    putc('\n', EST_error_stream);
    va_end(ap);
    fprintf(EST_error_stream, "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n");
    est_error_throw();
}

void EST_quiet_error_fn(const char *format, ...)
{
    va_list ap;
    char *p=EST_error_message;

    sprintf(p, "-=-=-=-=-=- EST Error -=-=-=-=-=-\n");

    if (EST_error_where)
      {
	while(*p)
	  p++;

	sprintf(p,"    %s\n", EST_error_where);
      }

    while(*p)
      p++;

    va_start(ap, format);
    vsprintf(p, format, ap);
    va_end(ap);

    while(*p)
      p++;

    *(p++) = '\n';

    sprintf(p, "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n");
    est_error_throw();
}

void EST_default_warning_fn(const char *format, ...)
{
    va_list ap;

    if (EST_warning_stream==NULL)
      EST_warning_stream = stderr;

    fprintf(EST_warning_stream, "-=-=-=-=-=- EST Warning -=-=-=-=-=-\n");
    if (EST_error_where)
      fprintf(EST_warning_stream,"    %s\n", EST_error_where);

    va_start(ap, format);
    vfprintf(EST_warning_stream, format, ap);
    putc('\n', EST_warning_stream);
    va_end(ap);
    fprintf(EST_warning_stream, "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n");
}

void EST_quiet_warning_fn(const char *format, ...)
{
    va_list ap;
    char *p=EST_error_message;

    sprintf(p, "-=-=-=-=-=- EST Warning -=-=-=-=-=-\n");

    if (EST_error_where)
      {
	while(*p)
	  p++;

	sprintf(p,"    %s\n", EST_error_where);
      }

    while(*p)
      p++;

    va_start(ap, format);
    vsprintf(p, format, ap);
    va_end(ap);

    while(*p)
      p++;

    *(p++) = '\n';

    sprintf(p, "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n");
    est_error_throw();
}

void EST_default_sys_error_fn(const char *format, ...)

{
    const char *msg = strerror(errno);
    va_list ap;

    if (EST_error_stream==NULL)
      EST_error_stream = stderr;

    fprintf(EST_error_stream, "-=-=-=-=-=- EST IO Error -=-=-=-=-\n");
    if (EST_error_where)
      fprintf(EST_error_stream,"    %s\n", EST_error_where);

    va_start(ap, format);
    vfprintf(EST_error_stream, format, ap);
    fprintf(EST_error_stream, " - %s\n", msg);
    va_end(ap);
    fprintf(EST_error_stream, "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n");
    est_error_throw();
}

void EST_quiet_sys_error_fn(const char *format, ...)
{
    const char *msg = strerror(errno);
    va_list ap;
    char *p=EST_error_message;

    sprintf(p, "-=-=-=-=-=- EST IO Error -=-=-=-=-=-\n");

    if (EST_error_where)
      {
	while(*p)
	  p++;

	sprintf(p,"    %s\n", EST_error_where);
      }

    while(*p)
      p++;

    va_start(ap, format);
    vsprintf(p, format, ap);
    va_end(ap);

    while(*p)
      p++;

    sprintf(p, " - %s\n", msg);

    while(*p)
      p++;

    *(p++) = '\n';

    sprintf(p, "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n");
    est_error_throw();
}

void EST_errors_default()
{
  EST_error_func = EST_default_error_fn;
  EST_sys_error_func = EST_default_sys_error_fn;
}

void EST_errors_quiet()
{
  EST_error_func = EST_quiet_error_fn;
  EST_sys_error_func = EST_quiet_sys_error_fn;
}

void (*EST_error_func)(const char *format, ...) = EST_default_error_fn;
void (*EST_sys_error_func)(const char *format, ...) = EST_default_sys_error_fn;
void (*EST_warning_func)(const char *format, ...) = EST_default_warning_fn;
FILE *EST_error_stream=NULL;
FILE *EST_warning_stream=NULL;
jmp_buf *est_errjmp = 0;
long errjmp_ok=0;





