/* Scheme In One Defun, but in C this time.
 
 *                    COPYRIGHT (c) 1988-1994 BY                            *
 *        PARADIGM ASSOCIATES INCORPORATED, CAMBRIDGE, MASSACHUSETTS.       *
 *        See the source file SLIB.C for more information.                  *

*/

/*

gjc@paradigm.com or gjc@mitech.com or gjc@world.std.com

Paradigm Associates Inc          Phone: 617-492-6079
29 Putnam Ave, Suite 6
Cambridge, MA 02138

  */

/***************************************************************/
/* This has been modified to act as an interface to siod as an */
/* embedded Lisp module.                                       */
/* Also a (large) number of other functions have been added    */
/*                                                             */
/*    Alan W Black (awb@cstr.ed.ac.uk) 8th April 1996          */
/***************************************************************/

/****************************************************************/
/*                                                              */
/* read-eval print loop functions separated from main functions */
/* so LISP functions may be used without require readline to be */
/* linked                                                       */
#include <stdio.h>
#include "EST_unix.h"
#include <stdlib.h>
#include <string.h>
#include "EST_String.h"
#include "EST_cutils.h"
#include "siod.h"
#include "siodp.h"
#include "siodline.h"

int siod_repl(int interactive)
{
    int retval;
    LISP histsize;

    siod_primary_prompt = "festival> ";
    siod_secondary_prompt = "> ";
    repl_prompt = siod_primary_prompt;
    
    /* Set history size (ignored if no readline included */
    histsize = siod_get_lval("readline_histsize",NULL);
    if (histsize != NIL)
	readline_histsize = get_c_int(histsize);

    siod_interactive = interactive;
    siod_rl_init();
    siod_fancy_getc = siod_rl_getc;
    siod_fancy_ungetc = siod_rl_ungetc;
    retval = repl_driver(1,0,NULL);
    if (interactive)
	cout << endl;

    return retval;
}

