
#include <stdio.h>
#include "jni_Utterance.h"
#include "ling_class/EST_Utterance.h"

static jobject utterance_class;
static jfieldID handle_field;

static inline short abs(short s) { return s>0?s:-s; }

JNIEXPORT jboolean JNICALL
Java_cstr_est_cpp_Utterance_initialise_1cpp (JNIEnv *env, jclass myclass)
{
  utterance_class = env->NewGlobalRef(myclass);
  handle_field = env->GetFieldID(myclass, "cpp_handle", "J");

  if (!handle_field)
    {
    printf("can't find cpp_handle!\n");
    return 0;
    }

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Utterance_finalise_1cpp (JNIEnv *env, jclass myclass)
{
  (void)env;
  (void)myclass;
  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Utterance_create_1cpp_1utterance(JNIEnv *env, jobject self)
{
  EST_Utterance *utterance = new EST_Utterance;

  // printf("create utterance %x\n", utterance);

  env->SetLongField(self, handle_field, (jlong)utterance);

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Utterance_destroy_1cpp_1utterance (JNIEnv *env, jobject self)
{
  EST_Utterance *utterance = (EST_Utterance *) env->GetLongField(self, handle_field);

  // printf("destroy utterance  %x\n", utterance);

  if (utterance)
    delete utterance;
  return 1;
}

JNIEXPORT jint JNICALL 
Java_cstr_est_cpp_Utterance_cpp_1num_1relations(JNIEnv *env, jobject self)
{
  EST_Utterance *utterance = (EST_Utterance *)env->GetLongField(self, handle_field);

  return utterance->num_relations();
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Utterance_cpp_1has_1relation(JNIEnv *env, 
					       jobject self,
					       jstring jname)
{
  EST_Utterance *utterance = (EST_Utterance *)env->GetLongField(self, handle_field);

  const char *name = env->GetStringUTFChars(jname, 0);

  bool has = utterance->has_relation(name);

  env->ReleaseStringUTFChars(jname, name);

  return has;
}

JNIEXPORT jlong JNICALL Java_cstr_est_cpp_Utterance_cpp_1relation_n(JNIEnv *env, 
					       jobject self,
					       jint n)
{
  EST_Utterance *utterance = (EST_Utterance *)env->GetLongField(self, handle_field);

  EST_Relation * rel = utterance->relation(n);

  return (long)rel;
}


JNIEXPORT jlong JNICALL 
Java_cstr_est_cpp_Utterance_cpp_1relation(JNIEnv *env, 
					  jobject self,
					  jstring jname)
{
  EST_Utterance *utterance = (EST_Utterance *)env->GetLongField(self, handle_field);

  const char *name = env->GetStringUTFChars(jname, 0);

  EST_Relation * rel = utterance->relation(name);

  env->ReleaseStringUTFChars(jname, name);
  return (long)rel;
}


JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Utterance_cpp_1load (JNIEnv *env, jobject self, jstring jfilename)
{
  fprintf(stderr, "ca\n");
  EST_Utterance *utterance = (EST_Utterance *) env->GetLongField(self, handle_field);
  fprintf(stderr, "u=0x%x\n", (int)utterance);

  const char *filename = env->GetStringUTFChars(jfilename, 0);
  fprintf(stderr, "cb %s\n", filename);
  const char *res = "";
  fprintf(stderr, "cc\n");

  EST_String fn(filename);

  fprintf(stderr, "cc1\n");
  EST_read_status stat = utterance->load(fn);
  fprintf(stderr, "cd\n");

  env->ReleaseStringUTFChars(jfilename, filename);
  fprintf(stderr, "ce\n");

  if (stat == read_format_error)
    res = "utterance format error";
  else if (stat != read_ok) 
    res = "utterance load error";
  
  return  env->NewStringUTF(res);
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Utterance_cpp_1save (JNIEnv *env, jobject self, jstring jfilename, jstring jformat)
{
  const EST_Utterance *utterance = (EST_Utterance *) env->GetLongField(self, handle_field);

  const char *filename = env->GetStringUTFChars(jfilename, 0);
  const char *format = env->GetStringUTFChars(jformat, 0);
  const char *res = "";

  EST_write_status stat = utterance->save(filename,format);

  env->ReleaseStringUTFChars(jfilename, filename);
  env->ReleaseStringUTFChars(jformat, format);

  if (stat == write_error) 
    res = "utterance save error";
  
  return  env->NewStringUTF(res);
}

