/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, and modify this software and its            */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor                              */
/*                    Date   :  February 1996                            */
/*-----------------------------------------------------------------------*/
/*              Intonational Event Include file                          */
/*                                                                       */
/*=======================================================================*/
#ifndef __RFC_H__
#define __RFC_H__

#include "ling_class/EST_Relation.h"
#include "EST_util_class.h"
#include "EST_speech_class.h"
#include "EST_Event.h"

void print_rfc3_events(EST_Relation &ev);
void default_rfc_params(EST_Option &op);

void rfc_analysis(EST_Track &fz, EST_Relation &event_list, EST_Option &op);

void tilt_analysis(EST_Track &fz, EST_Relation &event_list, EST_Option &op);

int rfc_synthesis(EST_Track &track, EST_Relation &ev_list,
		 float f_shift, int no_conn);

int tilt_synthesis(EST_Track &track, EST_Relation &ev_list,
		 float f_shift, int no_conn);


void tilt_to_rfc(EST_Relation &ev_tilt);
void rfc_to_tilt(EST_Relation &ev_rfc);

int validate_rfc_stream(EST_Relation &ev);
void fill_rfc_types(EST_Relation &ev);



#endif /* RFC */
