/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                      Author :  Alan W Black                           */
/*                      Date   :  May 1996                               */
/*-----------------------------------------------------------------------*/
/*           Class to represent ints, floats and strings                 */
/*                                                                       */
/*=======================================================================*/
#include <stdlib.h>
#include "EST_Val.h"
#include "EST_string_aux.h"

EST_Val::EST_Val(const EST_Val &c)
{
    if (c.t == val_ptr)
	v.pval = new EST_Contents;
	
    if (c.t == val_string) 
	sval = c.sval;
    else if (c.t == val_ptr) 
	(*(EST_Contents *)v.pval) = (*(EST_Contents *)c.v.pval);
    else if (c.t == val_func) 
	v.pval = c.v.pval;
    else 
	v=c.v;  // wonder if you can do that ??
    t=c.t; 
}

EST_Val::EST_Val(void *p, void (*f)(void *))
{
    t=val_ptr; 
    v.pval = new EST_Contents;
    ((EST_Contents *)v.pval)->set_contents(p,f);
}

EST_Val::EST_Val(EST_feature_function f)
{
    set_function(f);
}

EST_Val::~EST_Val(void)
{
    if (t == val_ptr)
	delete (EST_Contents *)v.pval;
}

const void *EST_Val::ptr(void) const
{
    if (t!=val_ptr) 
	return 0; 
    else
	return ((EST_Contents *)v.pval)->get_contents();
}

void EST_Val::set_ptr(void *p, void (*f)(void *))
{
    EST_Val t(p,f);
    *this = t;
}

void EST_Val::set_function(EST_feature_function f)
{
    t=val_func; 
    v.pval = (void *)f;
}

EST_Val &EST_Val::operator=(const EST_Val &c)
{
    // Have to be careful with the case where they are different types
    if ((t != val_ptr) && (c.t == val_ptr))
	v.pval = new EST_Contents;
	
    if (c.t == val_string) 
	sval = c.sval;
    else if (c.t == val_ptr) 
	(*(EST_Contents *)v.pval) = (*(EST_Contents *)c.v.pval);
    else if (c.t == val_func) 
	v.pval = c.v.pval;
    else 
	v=c.v;  // wonder if you can do that ??
    t=c.t; 
    return *this;
}

EST_Val &EST_Val::operator=(const EST_feature_function f)
{
    if (t == val_ptr)
	delete (EST_Contents *)v.pval;
    set_function(f);
    return *this;
}

const int EST_Val::to_int(void) const
{
    // coerce this to an int
    if (t==val_float)
	return (int)v.fval;
    else if (t==val_string)
	return atoi(sval);
    else
	return v.ival;  // just for completeness
}

const float EST_Val::to_flt(void) const
{
    // coerce this to a float
    if (t==val_int)
	return (float)v.ival;
    else if (t==val_string)
	return atof(sval);
    else
	return v.fval;  // just for completeness
}

const EST_String &EST_Val::to_str(void) const
{
    // coerce this to and save it for later
    // This requires the following casting, so we can still tell the
    // compiler this is a const function.  If this was properly declared
    // non-const vast amounts of the rest of this would also have to be
    // non-const.  So we do one nasty bit here for uniformity elsewhere.
    // Not saving the result is also a posibility but probably too
    // inefficient (maybe not with rjc's string class)
    EST_String *n = (EST_String *)((void *)&sval);
    if (t==val_int)
	*n = itoString(v.ival);
    else if (t==val_float)
	*n = ftoString(v.fval);
    else if (t==val_ptr)
	*n = "<contents>";
    else if (t==val_func)
	*n = "<function>";

    return sval;
}

