/* ***************************************************************** */
/* ******** Program to import hetro files from tabular format. ***** */
/* ***************************************************************** */

/* ***************************************************************** */
/* John ffitch 1995 Jul 14                                           */
/* ***************************************************************** */
     
#include <stdio.h>
#include <stdlib.h>

#define END  32767

void usage(void);

short getnum(FILE* inf, char *term)
{
    char buff[100];
    int  cc;
    int p = 0;
    while ((cc=getc(inf))!=',' && cc!='\n') {
	if (cc == EOF) {
	    *term = '\0';
	    return 0;
	}
	buff[p++] = cc;
    }
    buff[p]='\0';
    *term = cc;
    return (short)atoi(buff);
}

int main(int argc, char **argv)
{
    FILE *infd;
    FILE *outf;
    short x;
    char term;

    if (argc!= 3)
	usage();

    infd = fopen(argv[1], "r");
    if (infd == NULL) {
	fprintf(stderr, "Cannot open input comma file%s\n", argv[1]);
	exit(1);
    }
    outf = fopen(argv[2], "w");
    if (infd == NULL) {
	fprintf(stderr, "Cannot open output hetro file %s\n", argv[2]);
	exit(1);
    }
    x = getnum(infd, &term);    /* Read header */
    fwrite(&x, 1, sizeof(short), outf);
    for (;;) {
	short end = END;
	x = getnum(infd, &term);
	if (term == '\0') break;
	fwrite(&x, 1, sizeof(short), outf);
	if (term == '\n')  fwrite(&end, 1, sizeof(short), outf);
    }
    fclose(outf);
    fclose(infd);
}

void usage(void)
{
    fprintf(stderr, "Usage: het_import commafile hetfile\n");
    exit(1);
}

