#include "cs.h"			/*			UGENS1.C	*/
#include "ugens1.h"
#include <math.h>

#define FZERO (0.0f)
#define FONE  (1.0f)
extern float dvensmps;

void linset(LINE *p)
{
	float	dur;

	if ((dur = *p->idur) > FZERO) {
		p->incr = (*p->ib - *p->ia) / dur * onedkr;
		p->val = *p->ia;
	}
}

void kline(LINE *p)
{
	*p->xr = p->val;		/* rslt = val	*/
	p->val += p->incr;		/* val += incr	*/
}

void aline(LINE *p)
{
        float	val, inc, *ar;
        int	nsmps = ksmps;

	val = p->val;
	inc = p->incr;
	p->val += inc;		/* nxtval = val + inc */
	inc /= ensmps;
	ar = p->xr;
	do {	*ar++ = val;
		val += inc;	/* interp val for ksmps */
	}
	while (--nsmps);
}

void expset(EXPON *p)
{
        float	dur, a, b;

	if ((dur = *p->idur) > FZERO ) {
		a = *p->ia;
		b = *p->ib;
		if ((a * b) > FZERO) {
			p->mlt = (float) pow((double)(b / a),(onedkr/(double)dur));
			p->val = a;
		}
		else if (a == FZERO)
			initerror("arg1 is zero");
		else if (b == FZERO)
			initerror("arg2 is zero");
		else initerror("unlike signs");
	}
}

void kexpon(EXPON *p)
{
	*p->xr = p->val;		/* rslt = val	*/
	p->val *= p->mlt;		/* val *= mlt  */
}

void expon(EXPON *p)
{
        float	val, mlt, inc, *ar,nxtval;
        int	nsmps = ksmps;

	val = p->val;
	mlt = p->mlt;
	nxtval = val * mlt;
	inc = nxtval - val;
	inc /= ensmps;		/* increment per sample */
	ar = p->xr;
	do {
		*ar++ = val;
		val += inc;	/* interp val for ksmps */
	}
	while (--nsmps);
	p->val = nxtval;	/*store next value */
}

void lsgset(LINSEG *p)
{
        SEG	*segp;
        int	nsegs;
        float	**argp, val;

	nsegs = p->INOCOUNT >> 1;		/* count segs & alloc if nec */
	if ((segp = (SEG *) p->auxch.auxp) == NULL ||
            nsegs*sizeof(SEG) < (int)p->auxch.size) {
          auxalloc((long)nsegs*sizeof(SEG), &p->auxch);
          p->cursegp = segp = (SEG *) p->auxch.auxp;
          segp[nsegs-1].cnt = MAXPOS; /* set endcount for safety */
	}
	argp = p->argums;
	val = **argp++;
	if (**argp <= FZERO)  return;		/* if idur1 <= 0, skip init  */
	p->curval = val;
	p->curcnt = 0;
	p->cursegp = segp - 1;          /* else setup null seg0 */
	p->segsrem = nsegs + 1;
	do {		 	 	/* init each seg ..  */
	    float dur = **argp++;
	    segp->nxtpt = **argp++;
	    if ((segp->cnt = (long)(dur * ekr + 0.5f)) < 0)
		segp->cnt = 0;
            segp++;
	} while (--nsegs);
}

void klnseg(LINSEG *p)
{
    *p->rslt = p->curval;               /* put the cur value    */
    if (p->auxch.auxp==NULL) { /* RWD fix */
      die("\nError: linseg not initialized (krate)\n");
    }
    if (p->segsrem) {                   /* done if no more segs */
      while (--p->curcnt < 0            /* if done cur segment  */
             && p->segsrem) {
        SEG *segp = ++p->cursegp;       /*   find the next      */
        if (!(--p->segsrem))  return;
        if (!(p->curcnt = segp->cnt))   /*   nonlen = discontin */
          p->curval = segp->nxtpt;      /*   poslen = new slope */
        else p->curinc = (segp->nxtpt - p->curval) / segp->cnt;
      }
      p->curval += p->curinc;           /* advance the cur val  */
    }
}

void linseg(LINSEG *p)
{
    float  val, ainc, *rs = p->rslt;
    int		nsmps = ksmps;

    if (p->auxch.auxp==NULL) {  /* RWD fix */
      initerror("linseg: not initialized (arate)\n");
    }

    val = p->curval;                      /* sav the cur value    */
    if (p->segsrem) {                     /* if no more segs putk */
      if (--p->curcnt < 0) {              /*  if done cur segment */
        SEG *segp = p->cursegp;
      chk1:
        if (!--p->segsrem) {              /*   if none left       */
          val = p->curval = segp->nxtpt;
          goto putk;                      /*      put endval      */
        }
        p->cursegp = ++segp;              /*   else find the next */
        if (!(p->curcnt = segp->cnt)) {
          val = p->curval = segp->nxtpt;  /* nonlen = discontin */
          goto chk1;
        }                                 /*   poslen = new slope */
        p->curinc = (segp->nxtpt - val) / segp->cnt;
        p->curainc = p->curinc * dvensmps;
      }
      p->curval = val + p->curinc;        /* advance the cur val  */
      if ((ainc = p->curainc) == FZERO)
        goto putk;
      do {
        *rs++ = val;
        val += ainc;
      } while (--nsmps);
    }
    else {
putk:
      do *rs++ = val;
      while (--nsmps);
    }
}

void lsgrset(LINSEG *p)
{
    long relestim;
    lsgset(p);
    relestim = (p->cursegp + p->segsrem - 1)->cnt;
    if (relestim > p->h.insdshead->xtratim)
      p->h.insdshead->xtratim = (short)relestim;
}

void klnsegr(LINSEG *p)
{
    *p->rslt = p->curval;                   /* put the cur value    */
    if (p->segsrem) {                       /* done if no more segs */
      SEG *segp;
      if (p->h.insdshead->relesing && p->segsrem > 1) {
        while (p->segsrem > 1) {           /* reles flag new:      */
          segp = ++p->cursegp;             /*   go to last segment */
          p->segsrem--;
        }                                  /*   get univ relestim  */
        segp->cnt = p->h.insdshead->xtratim;
        goto newi;                         /*   and set new curinc */
      }
      if (--p->curcnt < 0) {               /* if done cur seg      */
      chk2:
        if (p->segsrem == 2) return;       /*   seg Y rpts lastval */
        if (!(--p->segsrem)) return;       /*   seg Z now done all */
        segp = ++p->cursegp;               /*   else find nextseg  */
      newi:
        if (!(p->curcnt = segp->cnt)) {    /*   nonlen = discontin */
          p->curval = segp->nxtpt;         /*     reload & rechk   */
          goto chk2;
        }                                  /*   else get new slope */
        p->curinc = (segp->nxtpt - p->curval) / segp->cnt;
      }
      p->curval += p->curinc;              /* advance the cur val  */
    }
}

void linsegr(LINSEG *p)
{
    float  val, ainc, *rs = p->rslt;
    int    nsmps = ksmps;

    val = p->curval;                        /* sav the cur value    */
    if (p->segsrem) {                       /* if no more segs putk */
      SEG *segp;
      if (p->h.insdshead->relesing && p->segsrem > 1) {
        while (p->segsrem > 1) {            /* reles flag new:      */
          segp = ++p->cursegp;              /*   go to last segment */
          p->segsrem--;
        }                                   /*   get univ relestim  */
        segp->cnt = p->h.insdshead->xtratim;
        goto newi;                          /*   and set new curinc */
      }
      if (--p->curcnt < 0) {                /* if done cur seg      */
      chk2:
        if (p->segsrem == 2) goto putk;     /*   seg Y rpts lastval */
        if (!(--p->segsrem)) goto putk;     /*   seg Z now done all */
        segp = ++p->cursegp;                /*   else find nextseg  */
      newi:
        if (!(p->curcnt = segp->cnt)) {     /*   nonlen = discontin */
          val = p->curval = segp->nxtpt;    /*   reload & rechk  */
          goto chk2;
        }                                   /*   else get new slope */
        p->curinc = (segp->nxtpt - val) / segp->cnt;
        p->curainc = p->curinc * dvensmps;
      }
      p->curval = val + p->curinc;          /* advance the cur val  */
      if ((ainc = p->curainc) == FZERO)
        goto putk;
      do {
        *rs++ = val;
        val += ainc;
      } while (--nsmps);
    }
    else {
    putk:
      do *rs++ = val;
      while (--nsmps);
    }
}

void xsgset(EXXPSEG *p)
{
    XSEG	*segp;
    int	nsegs;
    float	d, **argp, val, dur, nxtval;
    int    n;

    nsegs = p->INOCOUNT >> 1;			/* count segs & alloc if nec */
    if ((segp = (XSEG *) p->auxch.auxp) == NULL) {
      auxalloc((long)nsegs*sizeof(XSEG), &p->auxch);
      p->cursegp = segp = (XSEG *) p->auxch.auxp;
      (segp+nsegs-1)->cnt = MAXPOS;   /* set endcount for safety */
    }
    argp = p->argums;
    nxtval = **argp++;
    if (**argp <= FZERO)  return;		/* if idur1 <= 0, skip init  */
    p->cursegp = segp;                          /* else proceed from 1st seg */
    segp--;
    do {
      segp++; 	 	/* init each seg ..  */
      val = nxtval;
      dur = **argp++;
      nxtval = **argp++;
      if (dur > FZERO) {
        if (val * nxtval <= FZERO)
          goto experr;
        d = dur * ekr;
        segp->val = val;
        segp->mlt = (float) pow((double)(nxtval / val), (1.0/(double)d));
        segp->cnt = (long) (d + 0.5f);
      }
      else break;		/*  .. til 0 dur or done */
    } while (--nsegs);
    segp->cnt = MAXPOS;     	/* set last cntr to infin */
    return;

experr:
    n = segp - p->cursegp + 1;
    if (val == FZERO)
      sprintf(errmsg,"ival%d is zero", n);
    else if (nxtval == FZERO)
      sprintf(errmsg,"ival%d is zero", n+1);
    else sprintf(errmsg,"ival%d sign conflict", n+1);
    initerror(errmsg);
}

void kxpseg(EXXPSEG *p)
{
    XSEG	*segp;

    segp = p->cursegp;
    if (p->auxch.auxp==NULL) { /* RWD fix */
      initerror("expseg (krate): not initialized");
      return;
    }
    while (--segp->cnt < 0)
      p->cursegp = ++segp;
    *p->rslt = segp->val;
    segp->val *= segp->mlt;
}

void expseg(EXXPSEG *p)
{
    XSEG	*segp;
    int	nsmps = ksmps;
    float	li, val, *rs;
    float	nxtval;

    segp = p->cursegp;
    if (p->auxch.auxp==NULL) { /* RWD fix */
      initerror("expseg (krate): not initialized");
      return;
    }
    while (--segp->cnt < 0)
      p->cursegp = ++segp;
    val = segp->val;
    nxtval = val * segp->mlt;
    li = (nxtval - val) / ensmps;
    rs = p->rslt;
    do {
      *rs++ = val;
      val += li;
    } while (--nsmps);
    segp->val = nxtval ;
}

void xsgrset(EXPSEG *p)
{
    u_short relestim;
    SEG     *segp;
    int     nsegs, n;
    float   **argp, prvpt;

    nsegs = p->INOCOUNT >> 1;               /* count segs & alloc if nec */
    if ((segp = (SEG *) p->auxch.auxp) == NULL) {
      auxalloc((long)nsegs*sizeof(SEG), &p->auxch);
      p->cursegp = segp = (SEG *) p->auxch.auxp;
    }
    argp = p->argums;
    prvpt = **argp++;
    if (**argp < FZERO)  return;    /* if idur1 < 0, skip init      */
    p->curval = prvpt;
    p->curcnt = 0;                  /* else setup null seg0         */
    p->cursegp = segp - 1;         
    p->segsrem = nsegs + 1;
    do {                            /* init & chk each real seg ..  */
      float dur = **argp++;
      segp->nxtpt = **argp++;
      if ((segp->cnt = (long)(dur * ekr + 0.5f)) <= 0)
        segp->cnt = 0;
      else if (segp->nxtpt * prvpt <= FZERO)
        goto experr;
      prvpt = segp->nxtpt;
      segp++;
    } while (--nsegs);
    relestim = (u_short)(p->cursegp + p->segsrem - 1)->cnt;
    if (relestim > p->h.insdshead->xtratim)
      p->h.insdshead->xtratim = relestim;
    return;

experr:
    n = segp - p->cursegp + 2;
    if (prvpt == FZERO)
      sprintf(errmsg,"ival%d is zero", n);
    else if (segp->nxtpt == FZERO)
      sprintf(errmsg,"ival%d is zero", n+1);
    else sprintf(errmsg,"ival%d sign conflict", n+1);
    initerror(errmsg);
}

void kxpsegr(EXPSEG *p)
{
    *p->rslt = p->curval;       	/* put the cur value    */
    if (p->segsrem) {           	/* done if no more segs */
      SEG *segp;
      if (p->h.insdshead->relesing && p->segsrem > 1) {
        while (p->segsrem > 1) { 	/* reles flag new:      */
          segp = ++p->cursegp;  	/*   go to last segment */
          p->segsrem--;
        } 				/*   get univ relestim  */
        segp->cnt = p->h.insdshead->xtratim;
        goto newm;              	/*   and set new curmlt */
      }
      if (--p->curcnt < 0) {    	/* if done cur seg      */
      chk2:
        if (p->segsrem == 2) return;    /*   seg Y rpts lastval */
        if (!(--p->segsrem)) return;    /*   seg Z now done all */
        segp = ++p->cursegp;            /*   else find nextseg  */
      newm:
        if (!(p->curcnt = segp->cnt)) { /*   nonlen = discontin */
          p->curval = segp->nxtpt;      /*     reload & rechk   */
          goto chk2;
        }
        if (segp->nxtpt == p->curval)   /*   else get new mlt   */
          p->curmlt = FONE;
        else p->curmlt = (float) pow(segp->nxtpt/p->curval, 1./segp->cnt);
      }
      p->curval *= p->curmlt;           /* advance the cur val  */
    }
}

void expsegr(EXPSEG *p)
{
    float  val, amlt, *rs = p->rslt;
    int    nsmps = ksmps;

    val = p->curval;            	/* sav the cur value    */
    if (p->segsrem) {                   /* if no more segs putk */
      SEG *segp;
      if (p->h.insdshead->relesing && p->segsrem > 1) {
        while (p->segsrem > 1) {        /* if reles flag new    */
          segp = ++p->cursegp;          /*   go to last segment */
          p->segsrem--;
        }                               /*   get univ relestim  */
        segp->cnt = p->h.insdshead->xtratim;
        goto newm;                      /*   and set new curmlt */
      }
      if (--p->curcnt < 0) {            /* if done cur seg      */
      chk2:
        if (p->segsrem == 2) goto putk; /*   seg Y rpts lastval */
        if (!(--p->segsrem)) goto putk; /*   seg Z now done all */
        segp = ++p->cursegp;            /*   else find nextseg  */
      newm:
        if (!(p->curcnt = segp->cnt)) { /*   nonlen = discontin */
          val = p->curval = segp->nxtpt; /*   reload & rechk  */
          goto chk2;
        }                               /*   else get new mlts  */
        if (segp->nxtpt == val) {
          p->curmlt = p->curamlt = FONE;
          p->curval = val;
          goto putk;
        }
        else {
          p->curmlt = (float) pow((double)(segp->nxtpt/val), 1.0/(double)segp->cnt);
          p->curamlt = (float) pow(p->curmlt,  dvensmps);
        }
      }
      p->curval = val * p->curmlt;        /* advance the cur val  */
      if ((amlt = p->curamlt) == FONE)
        goto putk;
      do {
        *rs++ = val;
        val *= amlt;
      } while (--nsmps);
    } else {
    putk:
      do *rs++ = val;
      while (--nsmps);
    }
}

void lnnset(LINEN *p)
{
        float a,b,dur;

	if ((dur = *p->idur) > FZERO) {
		p->cnt1 = (long)(*p->iris * ekr + 0.5f);
		if (p->cnt1 > 0L) {
			p->inc1 = FONE / (float) p->cnt1;
			p->val = FZERO;
		}
		else p->inc1 = p->val = FONE;
		a = dur * ekr + 0.5f;
		b = *p->idec * ekr + 0.5f;
		if ((long) b > 0L) {
			p->cnt2 = (long) (a - b);
			p->inc2 = FONE /  b;
		}
		else {
			p->inc2 = FONE;
			p->cnt2 = (long) a;
		}
		p->lin1 = FZERO;
		p->lin2 = FONE;
	}
}

void klinen(LINEN *p)
{
        float fact = FONE;

	if (p->cnt1 > 0L) {
		fact = p->lin1;
		p->lin1 += p->inc1;
		p->cnt1--;
	}
	if (p->cnt2)
		p->cnt2--;
	else {
		fact *= p->lin2;
		p->lin2 -= p->inc2;
	}
	*p->rslt = *p->sig * fact;
}

void linen(LINEN *p)
{
        int flag=0, nsmps=ksmps;
        float *rs,*sg,li,val,nxtval=1.0f;

	val = p->val;
	rs = p->rslt;
	sg = p->sig;
	if (p->cnt1 > 0L) {
		flag = 1;
		p->lin1 += p->inc1;
		p->cnt1--;
		nxtval = p->lin1;
	}
	if (p->cnt2 <= 0L) {
		flag = 1;
		p->lin2 -= p->inc2;
		nxtval *= p->lin2;
	}
	else p->cnt2--;
	p->val = nxtval;
	if (flag) {
		li = (nxtval - val)/ensmps;
		if (p->XINCODE) {
			do {
				*rs++ = *sg++ * val;
				val += li;
			}
			while(--nsmps);
		}
		else {
			do {
				*rs++ = *sg * val;
				val += li;
			}
			while(--nsmps);
		}
	}
	else {
	        if (p->XINCODE) {
		  do *rs++ = *sg++;
		  while(--nsmps);
		}
		else {
		  do *rs++ = *sg;
		  while(--nsmps);
		}
	}
}

void lnrset(LINENR *p)
{
	p->cnt1 = (long)(*p->iris * ekr + 0.5f);
	if (p->cnt1 > 0L) {
	    p->inc1 = FONE / (float) p->cnt1;
	    p->val = FZERO;
	}
	else p->inc1 = p->val = FONE;
	if (*p->idec > FZERO) {
            u_short relestim = (u_short)(*p->idec * ekr + 0.5f);
	    if (relestim > p->h.insdshead->xtratim)
		p->h.insdshead->xtratim = relestim;
	    if (*p->iatdec <= FZERO)
		initerror("non-positive iatdec.");
	    else p->mlt2 = (float) pow((double)*p->iatdec, ((double)onedkr/ *p->idec));
	}
	else p->mlt2 = FONE;
	p->lin1 = FZERO;
	p->val2 = FONE;
}

void klinenr(LINENR *p)
{
        float fact = FONE;

	if (p->cnt1 > 0L) {
		fact = p->lin1;
		p->lin1 += p->inc1;
		p->cnt1--;
	}
	if (p->h.insdshead->relesing) {
		fact *= p->val2;
		p->val2 *= p->mlt2;
	}
	*p->rslt = *p->sig * fact;
}

void linenr(LINENR *p)
{
        int flag=0, nsmps=ksmps;
        float *rs,*sg,li,val,nxtval=FONE;

	val = p->val;
	rs = p->rslt;
	sg = p->sig;
	if (p->cnt1 > 0L) {
		flag = 1;
		p->lin1 += p->inc1;
		p->cnt1--;
		nxtval = p->lin1;
	}
	if (p->h.insdshead->relesing) {
		flag = 1;
		p->val2 *= p->mlt2;
		nxtval *= p->val2;
	}
	p->val = nxtval;
	if (flag) {
		li = (nxtval - val)/ensmps;
		if (p->XINCODE) {
			do {
				*rs++ = *sg++ * val;
				val += li;
			}
			while (--nsmps);
		}
		else {
			do {
				*rs++ = *sg * val;
				val += li;
			}
			while(--nsmps);
		}
	}
	else {
	        if (p->XINCODE) {
		  do *rs++ = *sg++;
		  while (--nsmps);
		}
		else {
		  do *rs++ = *sg;
		  while (--nsmps);
		}
	}
}

void evxset(ENVLPX *p)
{
        FUNC	*ftp;
        float	ixmod, iatss, idur, prod, diff, asym, nk, denom, irise;
	float	f100 = 100.0f;
	long	cnt1;

	if ((ftp = ftfind(p->ifn)) == NULL)
		return;
	p->ftp = ftp;
	if ((idur = *p->idur) > FZERO) {
		if ((iatss = (float)fabs(*p->iatss)) == FZERO) {
			initerror("iatss = 0");
			return;
		}
		if (iatss != FONE && (ixmod = *p->ixmod) != FZERO) {
			if (fabs(ixmod) > .95) {
				initerror("ixmod out of range.");
				return;
			}
			ixmod = -(float)sin(sin(ixmod));
			prod = ixmod * iatss;
			diff = ixmod - iatss;
			denom = diff + prod + 1.0f;
			if (denom == FZERO)
				asym = f100;
			else {
                          asym = 2 * prod / denom;
                          if (fabs(asym) > f100)
                            asym = f100;
			}
			iatss = (iatss - asym) / (1.0f - asym);
			asym = asym* *(ftp->ftable + ftp->flen); /* +1 */
		}
		else asym = FZERO;
		if ((irise = *p->irise) > FZERO) {
			p->phs = 0;
			p->ki = (long) (kicvt / irise);
			p->val = *ftp->ftable;
		}
		else {
			p->phs = -1;
			p->val = *(ftp->ftable + ftp->flen)-asym;
			irise = FZERO;	/* in case irise < 0 */
		}
		if (!(*(ftp->ftable + ftp->flen)))
			initerror("rise func ends with zero");
		cnt1 = (long) ((idur - irise - *p->idec) * ekr + 0.5f);
		if (cnt1 < 0L) {
			cnt1 = 0L;
			nk = ekr;
		}
		else {
			if (*p->iatss < FZERO || cnt1 <= 4L)
				nk = ekr;
			else nk = (float) cnt1;
		}
		p->mlt1 = (float) pow((double)iatss, (FONE/nk));
		if (*p->idec > FZERO) {
			if (*p->iatdec <= FZERO)
				initerror("non-positive iatdec.");
			else p->mlt2 = (float) pow((double)*p->iatdec,
						   ((double)onedkr / *p->idec));
		}
		p->cnt1 = cnt1;
		p->asym = asym;
	}
}

void knvlpx(ENVLPX *p)
{
        FUNC 	*ftp;
        long	phs;
        float 	fact, v1, fract, *ftab;

	ftp = p->ftp;
	if (ftp==NULL) {        /* RWD fix */
          initerror("envlpx(krate): not initialized");
          return;
	}

	if ((phs = p->phs) >= 0) {
		fract = (float) PFRAC(phs);
		ftab = ftp->ftable + (phs >> ftp->lobits);
		v1 = *ftab++;
		fact = (v1 + (*ftab - v1) * fract);
		phs += p->ki;
		if (phs >= MAXLEN) {  /* check that 2**N+1th pnt is good */
			p->val = *(ftp->ftable + ftp->flen );
			if (!p->val)
				perferror("envlpx rise func ends with zero");
			p->val -= p->asym;
			phs = -1L;
		}
		p->phs = phs;
	}
	else {
		fact = p->val;
		if (p->cnt1 > 0L) {
			p->val *= p->mlt1;
			fact += p->asym;
			p->cnt1--;
			if (p->cnt1 == 0L)
				p->val += p->asym;
		}
		else p->val *= p->mlt2;
	}
	*p->rslt = *p->xamp * fact;
}

void envlpx(ENVLPX *p)
{
        FUNC 	*ftp;
        long	phs;
        int	nsmps = ksmps;
        float 	*xamp, *rslt, val, nxtval, li, v1, fract, *ftab;

	xamp = p->xamp;
	rslt = p->rslt;
	val = p->val;
	if ((phs = p->phs) >= 0L) {
		ftp = p->ftp;
		if (ftp==NULL) { /* RWD fix */
                  initerror("envlpx(krate): not initialized");
                  return;
		}
		fract = (float) PFRAC(phs);
		ftab = ftp->ftable + (phs >> ftp->lobits);
		v1 = *ftab++;
		nxtval = (v1 + (*ftab - v1) * fract);
		phs += p->ki;
		if (phs >= MAXLEN) {  /* check that 2**N+1th pnt is good */
			nxtval = *(ftp->ftable + ftp->flen );
			if (!nxtval)
				perferror("envlpx rise func ends with zero");
			nxtval -= p->asym;
			phs = -1;
		}
		p->phs = phs;
	}
	else {
		nxtval = val;
		if (p->cnt1 > 0L) {
			nxtval *= p->mlt1;
			nxtval += p->asym;
			p->cnt1--;
		}
		else nxtval *= p->mlt2;
	}
	p->val = nxtval;
	li = (nxtval - val)/ensmps;	/* linear interpolation factor */
	if (p->XINCODE) {		/* for audio rate amplitude: */
		do {
			*rslt++ = *xamp++ * val;
			val += li;
		}
		while (--nsmps);
	}
	else {
		do {
			*rslt++ = *xamp * val;
			val += li;
		}
		while (--nsmps);
	}
}
