                        /*                              SOUNDIO.H       */

#ifdef WIN32
#define IOBUFSAMPS   16384      /* default sampframes in audio iobuf, -b settable */
#define IODACSAMPS   16384      /* default samps in hardware buffer,  -B settable */
#else
#define IOBUFSAMPS   1024   /* default sampframes in audio iobuf, -b settable */
#define IODACSAMPS   1024   /* default samps in hardware buffer,  -B settable */
#endif
#define SNDINBUFSIZ  4096   /* soundin bufsize;   must be > sizeof(SFHEADER), */
                            /*                 but small is kind to net rexec */
#define SNDOUTSMPS   (1024)
                                /* standard audio encoding types */
#define AE_CHAR   0x101         /* Signed 8 bit */
#define AE_ALAW   0x102
#define AE_ULAW   0x103
#define AE_SHORT  0x104
#define AE_LONG   0x105
#define AE_FLOAT  0x106
#define AE_UNCH   0x107         /* Unsigned 8 bit */
#define AE_LAST   AE_UNCH       /* current last audio encoding value */

#define TYP_IRCAM 0
#define TYP_AIFF  1
#define TYP_WAV   2
#define TYP_AIFC  3

#ifndef __cplusplus
typedef struct {         /* struct for passing data to/from sfheader routines */
        long  sr;
        long  nchnls;
        long  sampsize;
        long  format;
        long  hdrsize;
        int   filetyp;
        AIFFDAT *aiffdata;
        long  audsize;
        long  readlong;
        long  firstlong;
} HEADATA;

typedef struct {
        OPDS    h;
        float   *r1, *r2, *r3, *r4, *ifilno, *iskptim, *iformat, *kfrqratio;
        short   format, channel, nchnls, sampframsiz, filetyp;
        short   analonly, endfile;
        long    sr, audrem, framesrem, getframes;    /* bytes, frames, frames */
        AIFFDAT *aiffdata;
        void    (*bytrev)();
        FDCH    fdch;
        char    *inbufp, *bufend;
        char    inbuf[SNDINBUFSIZ+4];
                                /* work variables for soundin2 */
/*        double  phase_gab; */
/*         double  fl_buf; */
/*         int     base_sample_gab; */
/*         int     initflag_gab; */
} SOUNDIN;

typedef struct {        
        float   *ifilcod, *iformat;
        short   format, filetyp;
        AIFFDAT *aiffdata;
        void    (*swrtmethod)(int, float *, int);
        FDCH    fdch;
        float   *outbufp, *bufend;
        float   outbuf[SNDOUTSMPS];
} SNDCOM;

typedef struct {
        OPDS    h;
        float   *asig; 
        SNDCOM  c;
} SNDOUT;

typedef struct {
        OPDS    h;
        float   *asig1, *asig2; 
        SNDCOM  c;
} SNDOUTS;

int sreadin(int, char *, int, SOUNDIN *);

#ifdef SFSUN41
#include <multimedia/audio_hdr.h>
# ifdef sol
#  include <multimedia/audio_device.h>
# endif
#include <multimedia/libaudio.h>
#endif

#ifdef SFIRCAM

#define SF_MAXCHAN      4
#define SF_MINCOM       400

#define SF_END          0         /* SFCODE types */
#define SF_MAXAMP       1
#define SF_AUDIOENCOD   2
#define SF_PVDATA       3
#define SF_COMMENT      4
#define SF_CODMAX       4

typedef struct {                  /* this code written by sfheaders.c */
        float   value[SF_MAXCHAN];
} SFMAXAMP;

typedef struct {                  /*     ditto                    */
        short   encoding;
        short   grouping;
} SFAUDIOENCOD;

typedef struct {                  /* this code written by pvanal */
        short   frameSize;
        short   frameIncr;
} SFPVDATA;

typedef struct {                  /* this code not possible yet */
        char    comment[SF_MINCOM];
} SFCOMMENT;

#endif
#endif
