#include "cs.h"                 /*                      SOUNDIO.C       */
#include "soundio.h"
#ifdef __MWERKS__
#include "MacTransport.h"
#endif

static  char    *sfoutname;                         /* soundout filename    */
static  char    *inbuf;
        char    *outbuf;                            /* contin sndio buffers */
static  char    *chinbufp, *choutbufp;              /* char  pntr to above  */
static  short   *shinbufp, *shoutbufp;              /* short pntr           */
static  long    *llinbufp, *lloutbufp;              /* long  pntr           */
static  float   *flinbufp, *floutbufp;              /* float pntr           */
static  unsigned inbufrem,  outbufrem;              /* in monosamps (see openin,iotranset) */
static  unsigned inbufsiz,  outbufsiz;              /* alloc in sfopenin/out     */
static  int     isfd, isfopen = 0, infilend = 0;    /* (real set in sfopenin)    */
static  int     osfd, osfopen = 0;                  /* (real set in sfopenout)   */
static  int     pipdevin = 0, pipdevout = 0;        /* mod by sfopenin,sfopenout */
        long    nrecs = 0;
extern  float   *spin, *spout, maxamp[], *maxampend;
extern  long    rngcnt[];
extern  short   rngflg, multichan;
extern  int     nspin, nspout, nchnls, ksmps;
extern  HEADATA *readheader(int, char*, SOUNDIN*);
extern  short   ulaw_decode[];
extern  OPARMS  O;

static  SOUNDIN *p;    /* to be passed via sreadin() */
static  int     (*audrecv)(char *, int), audread(char *, int);
static  void    (*audtran)(char *, int), audwrite(char *, int), audwrtrev2(char *, int), audwrtrev4(char *, int);
extern  void    bytrev2(char *, int), bytrev4(char *, int), rewriteheader(int, long);
extern  int     openin(char *), openout(char *, int), bytrevhost(void), getsizformat(int);
extern  char    *getstrformat(int), *retfilnam;

#ifdef RTAUDIO
extern  int     rtrecord(char *, int);
extern  void    rtplay(char *, int);
extern  void    rtclose(void);
extern  void    recopen(int, int, float, int);
extern  void    playopen(int, int, float, int);
#define DEVAUDIO 0x7fff         /* unique fd for rtaudio  */
# ifdef sol
extern	int	audiofd;
# endif
#endif
#ifdef PIPES
FILE* pin=NULL, *pout=NULL;
#ifdef LINUX
#define _popen popen
#define _pclose pclose
#endif
#endif
void (*spinrecv)(void), (*spoutran)(void), (*nzerotran)(long);
static void byterecv(void), charrecv(void),  alawrecv(void), ulawrecv(void),
            shortrecv(void),longrecv(void), floatrecv(void);
static void bytetran(void), chartran(void),  alawtran(void), ulawtran(void),
            shortran(void), longtran(void), floatran(void);
static void bzerotran(long), czerotran(long), azerotran(long), uzerotran(long),
            szerotran(long), lzerotran(long), fzerotran(long);

void iotranset(void)
    /* direct recv & tran calls to the right audio formatter  */
{   /*                            & init its audio_io bufptr  */
        switch(O.informat) {
	case AE_UNCH:  spinrecv = byterecv;          /* J. Mohr  1995 Oct 17 */
	               chinbufp = inbuf;
	               break;
        case AE_CHAR:  spinrecv = charrecv;
                       chinbufp = inbuf;
                       break;
        case AE_ALAW:  spinrecv = alawrecv;
                       chinbufp = inbuf;
                       break;
        case AE_ULAW:  spinrecv = ulawrecv;
                       chinbufp = inbuf;
                       break;
        case AE_SHORT: spinrecv = shortrecv;
                       shinbufp = (short *)inbuf;
                       break;
        case AE_LONG:  spinrecv = longrecv;
                       llinbufp = (long  *)inbuf;
                       break;
        case AE_FLOAT: spinrecv = floatrecv;
                       flinbufp = (float *)inbuf;
                       break;
        default: die("unknown audio_in format");
        }

        switch(O.outformat) {
	case AE_UNCH:  spoutran = bytetran;        /* J. Mohr  1995 Oct 17 */
	               nzerotran = bzerotran;
	               choutbufp = outbuf;
	               break;
        case AE_CHAR:  spoutran = chartran;
                       nzerotran = czerotran;
                       choutbufp = outbuf;
		       break;
        case AE_ALAW:  spoutran = alawtran;
                       nzerotran = azerotran;
                       choutbufp = outbuf;
		       break;
        case AE_ULAW:  spoutran = ulawtran;
                       nzerotran = uzerotran;
                       choutbufp = outbuf;
		       break;
        case AE_SHORT: spoutran = shortran;
                       nzerotran = szerotran;
                       shoutbufp = (short *)outbuf;
		       break;
        case AE_LONG:  spoutran = longtran;
                       nzerotran = lzerotran;
                       lloutbufp = (long  *)outbuf;
		       break;
        case AE_FLOAT: spoutran = floatran;
                       nzerotran = fzerotran;
                       floutbufp = (float *)outbuf;
		       break;
        default: die("unknown audio_out format");
        }
}

void sndwrterr(unsigned nret, unsigned nput) /* report soundfile write(osfd) error      */
                                /* called after chk of write() bytecnt  */
{
        void sfcloseout(void);
        printf("soundfile write returned bytecount of %d, not %d\n",nret,nput);
        printf("closing the file ...\n");
        outbufrem = O.outbufsamps;       /* consider buf is flushed */
        sfcloseout();                    /* & try to close the file */
        die("\t... closed\n");
}

static int audread(char *inbuf, int nbytes)        /* diskfile read option for audrecv's */
                                /*     assigned during sfopenin()     */
{
        return(sreadin(isfd,inbuf,nbytes,p));
}

#if !defined SYMANTEC && !defined __MWERKS__
extern int write(int, const void*, unsigned int);
#endif
/* RWD.2.98 WAVE floats format must be NORMALIZED +- 1 */
static void audwrite_norm( char *outbuf,int nbytes)
{
#define NORMFACT 32768.0f
    int i,n;
    int cnt = nbytes / sizeof(float);
    float *fptr = (float *)outbuf;
    for(i=0;i<cnt;i++)
      *fptr++ /= NORMFACT;
    if ((n = write(osfd, outbuf, nbytes)) < nbytes)
      sndwrterr(n, nbytes);
    if (O.rewrt_hdr)
      rewriteheader(osfd, nbytes +(long)nrecs*outbufsiz);
    nrecs++;                /* JPff fix */
    if (O.heartbeat) {
      if (O.heartbeat==1) {
#ifdef SYMANTEC
	nextcurs();
#else
        putc("|/-\\"[nrecs&3], stderr); putc(8,stderr);
#endif
      }
      else if (O.heartbeat==2) putc('.', stderr);
      else if (O.heartbeat==3) {
	int n;
	err_printf( "%d(%.3f)%n", nrecs, nrecs/ekr, &n);
	while (n--) putc(8, stderr);
      }
      else putc(7, stderr);
    }
    POLL_EVENTS();
}



static void audwrite(char *outbuf, int nbytes)    /* diskfile write option for audtran's */
                                /*      assigned during sfopenout()    */
{
    int n;
    if ((n = write(osfd, outbuf, nbytes)) < nbytes)
      sndwrterr(n, nbytes);
    if (O.rewrt_hdr)
      rewriteheader(osfd, nbytes +(long)nrecs*outbufsiz);
    nrecs++;                /* JPff fix */
    if (O.heartbeat) {
      if (O.heartbeat==1) {
#ifdef SYMANTEC
	nextcurs();
#else
        putc("|/-\\"[nrecs&3], stderr); putc(8,stderr);
#endif
      }
      else if (O.heartbeat==2) putc('.', stderr);
      else if (O.heartbeat==3) {
	int n;
	err_printf( "%d(%.3f)%n", nrecs, nrecs/ekr, &n);
	while (n--) putc(8, stderr);
      }
      else putc(7, stderr);
    }
    POLL_EVENTS();
}

static void audwrtrev2(char *outbuf, int nbytes) /* diskfile write option for audtran's */
                                /*      assigned during sfopenout()    */
{
    bytrev2(outbuf, nbytes);    /* rev bytes in shorts  */
    audwrite(outbuf, nbytes);   /*   & send the data    */
}

static void audwrtrev4(char *outbuf, int nbytes) /* diskfile write option for audtran's */
                                /*      assigned during sfopenout()    */
{
    bytrev4(outbuf, nbytes);    /* rev bytes in longs   */
    audwrite(outbuf, nbytes);   /*   & send the data    */
}

void sfopenin(void)             /* init for continuous soundin */
{                               /*    called only if -i flag   */
    HEADATA *hdr;
    char    *sfname;
    long     n, readlong = 0;

    if (p == NULL)
      p = (SOUNDIN *) mcalloc((long)sizeof(SOUNDIN));
    if (O.infilename != NULL && strcmp(O.infilename,"stdin") == 0) {
      sfname = O.infilename;
      isfd = 0;		/* get sound from stdin if requested */
      pipdevin = 1;
    }
#ifdef PIPES
    else if (O.infilename != NULL && O.infilename[0]=='|') {
      FILE *_popen(const char *, const char *);
      pin = _popen(O.infilename+1, "rb");
      isfd = fileno(pin);
      pipdevin = 1;
    }
#endif
#ifdef RTAUDIO
    else if (O.infilename != NULL &&
             (strcmp(O.infilename,"devaudio") == 0
#ifdef WIN32
              || strncmp(O.infilename,"devaudio", 7) == 0
              || strncmp(O.infilename,"adc", 3) == 0
#endif
              || strcmp(O.infilename,"adc") == 0)) {
#ifdef WIN32
      extern int win_dev;
      win_dev = 0;
      if (strncmp(O.infilename,"devaudio", 7) == 0)
        sscanf(O.infilename+7, "%d", &win_dev);
      else if (strncmp(O.infilename,"adc", 3) == 0)
        sscanf(O.infilename+3, "%d", &win_dev);
#endif
      sfname = O.infilename;
      recopen(nchnls,O.insampsiz,esr,2);  /* open devaudio for input */
      audrecv = rtrecord;                 /*  & redirect audio gets  */
      isfd = DEVAUDIO;                    /* dummy file descriptor */
      pipdevin   = 1;                     /* no backward seeks !   */
      goto inset;                         /* no header processing  */
    }
#endif
    else {			/* else build filename and open that */
      if ((isfd = openin(O.infilename)) < 0)
        dies("isfinit: cannot open %s", retfilnam);
      sfname = retfilnam;
    }
    p->filetyp = 0;		/* initially non-typed for readheader */
    if ((hdr = readheader(isfd,sfname,p)) != NULL/* if headerblk returned */
        && !(readlong = hdr->readlong)) {          /* & hadn't readin audio */
      if (hdr->sr != (long)esr) {              /*    chk the hdr codes  */
        sprintf(errmsg,"audio_in %s has sr = %ld, orch sr = %ld",
                sfname, hdr->sr, (long)esr);
        warning(errmsg);
      }
      if (hdr->nchnls != nchnls) {
        sprintf(errmsg,"audio_in %s has %ld chnls, orch %d chnls",
                sfname, hdr->nchnls, nchnls);
        die(errmsg);
      }
      O.insampsiz = (int)hdr->sampsize; /*    & cpy header vals  */
      O.informat = (int) hdr->format;
      p->filetyp = hdr->filetyp;           
      p->audrem = hdr->audsize;
    }
    else {                                       /* no header:  defaults  */
      sprintf(errmsg,"%s has no soundfile header, assuming %s",
              sfname, getstrformat(O.outformat) );
      warning(errmsg);
      p->filetyp = 0;                          /*  (see also soundin.c) */
      p->audrem = -1;
    }
    if (p->filetyp == TYP_AIFF && bytrevhost() ||
        p->filetyp == TYP_AIFC && bytrevhost() ||
        p->filetyp == TYP_WAV && !bytrevhost()) {
      if (O.informat == AE_SHORT)        /* if audio_in needs byte rev */
        p->bytrev = bytrev2;           /*    set on sample size      */
      else if (O.informat == AE_LONG)
        p->bytrev = bytrev4;
      else if (O.informat == AE_FLOAT)
	p->bytrev = bytrev4;
      else p->bytrev = NULL;
      printf("opening %s infile %s, with%s bytrev\n",
             p->filetyp == TYP_AIFF ? "AIFF" :
             p->filetyp == TYP_AIFC ? "AIFC" : "WAV",
             sfname, p->bytrev == NULL ? " no" : "");
    }
    else p->bytrev = NULL;
    audrecv = audread;	/* will use standard audio gets  */

 inset:
    inbufsiz = (unsigned)O.inbufsamps * O.insampsiz;/* calc inbufsize reqd   */
    inbuf = mcalloc((long)inbufsiz); /* alloc inbuf space     */
    printf("reading %d-byte blks of %s from %s %s\n",
           inbufsiz, getstrformat(O.informat), sfname,
           p->filetyp == TYP_AIFF ? "(AIFF)" :
           p->filetyp == TYP_AIFC ? "(AIFC)" :
           p->filetyp == TYP_WAV ? "(WAV)" : "");
    isfopen = 1;
    if (readlong) {		/*     & fill it from    */
      *(long *)inbuf = hdr->firstlong;
      n = sreadin(isfd, inbuf+sizeof(long), inbufsiz-sizeof(long), p);
      n += sizeof(long);
    }
    else n = audrecv(inbuf, inbufsiz); /*     file or devaudio  */
    inbufrem = (unsigned int)(n / O.insampsiz); /* datasiz in monosamps  */
}

void sfopenout(void)                            /* init for sound out       */
{                                               /* (not called if nosound)  */
    extern  void    writeheader(int, char*);

    if (O.outfilename == NULL) O.outfilename = "test";
    if (strcmp(O.outfilename,"stdout") == 0) {
      sfoutname = O.outfilename;
      osfd = O.stdoutfd;              /* send sound to stdout if requested */
      pipdevout = 1;
    }    
#ifdef PIPES
    else if (O.outfilename != NULL && O.outfilename[0]=='|') {
      FILE *_popen(const char *, const char *);
      pout = _popen(O.infilename+1, "wb");
      osfd = fileno(pout);
      pipdevout = 1;
    }
#endif    
#ifdef RTAUDIO
    else if (strcmp(O.outfilename,"devaudio") == 0
             || strcmp(O.outfilename,"dac") == 0) {
      sfoutname = O.outfilename;
      playopen(nchnls, O.outsampsiz, esr, 2);  /* open devaudio for out */
      audtran = rtplay;                        /* & redirect audio puts */
      osfd = DEVAUDIO;                         /* dummy file descriptor */
      pipdevout = 1;                           /* no backward seeks !   */
#ifdef sol
      if (O.sfheader)
        writeheader(audiofd,"devaudio");
#endif
#if defined(__MWERKS__) || defined(SYMANTEC)
      O.outformat = AE_SHORT;
#endif
#ifdef __MWERKS__
      transport.state |= kGenRealtime;
#endif
      goto outset;                        /* no header needed      */
    }
#endif
    else {
      if ((osfd = openout(O.outfilename, 3)) < 0)   /* else open sfdir or cwd */
        dies("sfinit: cannot open %s", retfilnam);
      sfoutname = mmalloc((long)strlen(retfilnam)+1);
      strcpy(sfoutname, retfilnam);       /*   & preserve the name */
      if (strcmp(sfoutname, "/dev/audio") == 0) {
        /*      ioctl(   );   */
        pipdevout = 1;
      }
    }
#if defined(SYMANTEC)
    AddMacHeader(sfoutname,nchnls,esr,O.outsampsiz);  /* set Mac resource */
    SetMacCreator(sfoutname);               /*   set creator & file type */
#endif
    if (O.sfheader) {
      writeheader(osfd, sfoutname);       /* write header as required   */
#ifdef __MWERKS__
      transport.osfd = osfd;
      transport.eoheader = tell(osfd);
#endif
    }
    if (O.filetyp == TYP_AIFF && bytrevhost() ||
        O.filetyp == TYP_AIFC && bytrevhost() ||
        O.filetyp == TYP_WAV && !bytrevhost()) {
      if (O.outformat == AE_SHORT)        /* if audio out needs byte rev*/
        audtran = audwrtrev2;           /*   redirect the audio puts  */
      else if (O.outformat == AE_LONG)
        audtran = audwrtrev4;
      else audtran = audwrite;
    }
    /* RWD.2.98 normalize WAVE floats */
    else if (O.filetyp==TYP_WAV && O.outformat == AE_FLOAT)
      audtran = audwrite_norm;
    else audtran = audwrite; /* else use standard audio puts */
    
outset:
    outbufsiz = (unsigned)O.outbufsamps * O.outsampsiz;/* calc outbuf size */
    outbuf = mmalloc((long)outbufsiz); /*  & alloc bufspace */
    printf("writing %d-byte blks of %s to %s",
	   outbufsiz, getstrformat(O.outformat), sfoutname);
	if (strcmp(O.outfilename,"devaudio") == 0 	/* realtime output has no
header */
	    || strcmp(O.outfilename,"dac") == 0)  printf("\n");
	else if (O.sfheader == 0) printf(" (raw)\n");
	else
	    printf(" %s\n",
	           O.filetyp == TYP_AIFF ? "(AIFF)" :
	           O.filetyp == TYP_AIFC ? "(AIFC)" :
	           O.filetyp == TYP_WAV ? "(WAV)" : 
#ifdef __MWERKS__				
		                          "(SDII)");
#else
					  "(IRCAM)");
#endif
    osfopen = 1;
    outbufrem = O.outbufsamps;
}

void sfnopenout(void)
{
    printf("not writing to sound disk\n");
    outbufrem = O.outbufsamps;          /* init counter, though not writing */
}

extern int close(int);

void sfclosein(void)
{
    if (!isfopen) return;
#ifdef RTAUDIO
    if (isfd == DEVAUDIO) {
      if (!osfopen || osfd != DEVAUDIO)
        rtclose();     /* close only if not open for output too */
    }           
    else
#endif
#ifdef PIPES
      if (pin != NULL) {
	int _pclose(FILE*);
	_pclose(pin);
	pin = NULL;
      }
      else
#endif
	close(isfd);
    isfopen = 0;
}

void sfcloseout(void)
{
        int     nb;

        if (!osfopen) return;
        if ((nb = (O.outbufsamps-outbufrem) * O.outsampsiz) > 0)/* flush outbuffer */
                audtran(outbuf, nb);
#ifdef RTAUDIO
        if (osfd == DEVAUDIO) {
            if (!isfopen || isfd != DEVAUDIO)
                rtclose();     /* close only if not open for input too */
            goto report;
        }
#endif
        if (O.sfheader && !pipdevout) {	/* if header, & backward seeks ok */
            unsigned long datasize =
	      nb ? (nrecs-1)*outbufsiz + nb : nrecs*outbufsiz;
            rewriteheader(osfd, datasize); /*  rewrite  */
        }
#ifdef PIPES
	if (pout!=NULL) {
	  int _pclose(FILE*);
	  _pclose(pout);
	  pout = NULL;
	}
#endif
#ifndef SFSUN41
        if (!pipdevout)
#endif
                close(osfd);
report: printf("%ld %d-byte soundblks of %s written to %s",
               nrecs, outbufsiz, getstrformat(O.outformat), sfoutname);
	if (strcmp(O.outfilename,"devaudio") == 0 	/* realtime output has no
header */
	         || strcmp(O.outfilename,"dac") == 0) printf("\n");
	else if (O.sfheader == 0) printf(" (raw)\n");
	else
	    printf(" %s\n",
	           O.filetyp == TYP_AIFF ? "(AIFF)" :
	           O.filetyp == TYP_AIFC ? "(AIFC)" :
	           O.filetyp == TYP_WAV ? "(WAV)" : 
#ifdef __MWERKS__				
	                                  "(SDII)");
#else
	  	       			  "(IRCAM)");
#endif
        osfopen = 0;
}

static void bytetran()	                             /* J. Mohr  1995 Oct 17 */
                            /* same as above, but 8-bit unsigned char output */
{	      /*   sends HI-ORDER 8 bits of shortsamp, converted to unsigned */
    float	*sp, *maxampp;
    long   longsmp, *rngp;
    int	n, spoutrem;
    float	absamp;

    sp = spout;			/* adr spout	*/	
    spoutrem = nspout;		/* smps to go	*/
    maxampp = maxamp;

nchk:
    if ((n = spoutrem) > (int)outbufrem) /* if nspout remaining > buf rem, */
      n = outbufrem;		/*	prepare to send in parts  */
    spoutrem -= n;
    outbufrem -= n;
    do {
      if ((longsmp = (long)*sp) >= 0) {	/* +ive samp:	*/
        if (*sp > *maxampp) {		/*  maxamp this seg  */
          *maxampp = *sp;
          if (longsmp > 32767) {		/* out of range?     */
            longsmp = 32767;	/*   clip and report */
            rngp = rngcnt + (maxampp - maxamp);
            (*rngp)++;
            rngflg = 1;
          }
        }
      }
      else {					/* ditto -ive samp */
        if ((absamp = -*sp) > *maxampp)
          *maxampp = absamp;
        if (longsmp < -32768) {
          longsmp = -32768;
          rngp = rngcnt + (maxampp - maxamp);
          (*rngp)++;
          rngflg = 1;
        }
      }
      if (osfopen)
        *choutbufp++ = (unsigned char)(longsmp >> 8)^0x80;
      if (multichan && ++maxampp >= maxampend)
        maxampp = maxamp;
      sp++;
    } while (--n);
    if (!outbufrem) {
      if (osfopen) {
        audtran(outbuf,outbufsiz);
        choutbufp = outbuf;
      }
      outbufrem = O.outbufsamps;
      if (spoutrem) goto nchk;
    }
}

static void shortran(void)      /* fix spout vals and put in outbuf */
{                               /*      write buffer when full      */
    float  *sp, *maxampp;
    long   longsmp, *rngp;
    int    n, spoutrem;
    float   absamp;

    sp = spout;                     /* adr spout    */      
    spoutrem = nspout;              /* smps to go   */
    maxampp = maxamp;

 nchk:
    if ((n = spoutrem) > (int)outbufrem) /* if nspout remaining > buf rem, */
      n = outbufrem;          /*      prepare to send in parts  */
    spoutrem -= n;
    outbufrem -= n;
    do {
      if ((longsmp = (long)*sp) >= 0) { /* +ive samp:   */
        if (*sp > *maxampp)             /*  maxamp this seg  */
          *maxampp = *sp;
        if (longsmp > 32767) {          /* out of range?     */
          longsmp = 32767;        /*   clip and report */
          rngp = rngcnt + (maxampp - maxamp);
          (*rngp)++;
          rngflg = 1;
        }
      }
      else {                            /* ditto -ive samp */
        if ((absamp = -*sp) > *maxampp)
          *maxampp = absamp;
        if (longsmp < -32768) {
          longsmp = -32768;
          rngp = rngcnt + (maxampp - maxamp);
          (*rngp)++;
          rngflg = 1;
        }
      }
      if (osfopen)
        *shoutbufp++ = (short) longsmp;
      if (multichan && ++maxampp >= maxampend)
        maxampp = maxamp;
      sp++;
    } while (--n);
    if (!outbufrem) {
      if (osfopen) {
        audtran(outbuf,outbufsiz);
        shoutbufp = (short *) outbuf;
      }
      outbufrem = O.outbufsamps;
      if (spoutrem) goto nchk;
    }
}

static void chartran(void)      /* same as above, but 8-bit char output */
{                               /*   sends HI-ORDER 8 bits of shortsamp */
    float  *sp, *maxampp;
    long   longsmp, *rngp;
    int    n, spoutrem;
    float   absamp;

    sp = spout;                     /* adr spout    */      
    spoutrem = nspout;              /* smps to go   */
    maxampp = maxamp;

 nchk:
    if ((n = spoutrem) > (int)outbufrem) /* if nspout remaining > buf rem, */
      n = outbufrem;          /*      prepare to send in parts  */
    spoutrem -= n;
    outbufrem -= n;
    do {
      if ((longsmp = (long)*sp) >= 0) { /* +ive samp:   */
        if (*sp > *maxampp) {           /*  maxamp this seg  */
          *maxampp = *sp;
          if (longsmp > 32767) {          /* out of range?     */
            longsmp = 32767;        /*   clip and report */
            rngp = rngcnt + (maxampp - maxamp);
            (*rngp)++;
            rngflg = 1;
          }
        }
      }
      else {                                  /* ditto -ive samp */
        if ((absamp = (float)((long)(-(*sp)))) > *maxampp)
          *maxampp = absamp;
        if (longsmp < -32768) {
          longsmp = -32768;
          rngp = rngcnt + (maxampp - maxamp);
          (*rngp)++;
          rngflg = 1;
        }
      }
      if (osfopen)
        *choutbufp++ = (char)(longsmp >> 8);
      if (multichan && ++maxampp >= maxampend)
        maxampp = maxamp;
      sp++;
    } while (--n);
    if (!outbufrem) {
      if (osfopen) {
        audtran(outbuf,outbufsiz);
        choutbufp = outbuf;
      }
      outbufrem = O.outbufsamps;
      if (spoutrem) goto nchk;
    }
}

static void alawtran(void)
{
    die("alaw not yet implemented");
}

#define MUCLIP  32635
#define BIAS    0x84
#define MUZERO  0x02
#define ZEROTRAP 

static void ulawtran(void)              /* ulaw-encode spout vals & put in outbuf */
{                                       /*      write buffer when full      */
    float  *sp, *maxampp;
    long   longsmp, *rngp;
    int    n, spoutrem, sign;
    extern  char    exp_lut[];               /* mulaw encoding table */

    sp = spout;                     /* adr spout    */      
    spoutrem = nspout;              /* smps to go   */
    maxampp = maxamp;

 nchk:
    if ((n = spoutrem) > (int)outbufrem) /* if nspout remaining > buf rem, */
      n = outbufrem;          /*      prepare to send in parts  */
    spoutrem -= n;
    outbufrem -= n;
    do {
      if ((longsmp = (long)*sp) < 0L) {          /* if sample negative   */
        sign = 0x80;
        longsmp = - longsmp;        /*  make abs, save sign */
      }
      else sign = 0;
      if (longsmp > *maxampp)             /* save maxamp this seg  */
        *maxampp = (float)longsmp;
      if (longsmp > MUCLIP) {             /* out of range?     */
        longsmp = MUCLIP;           /*   clip and report */
        rngp = rngcnt + (maxampp - maxamp);
        (*rngp)++;
        rngflg = 1;
      }
      if (osfopen) {
        int sample, exponent, mantissa, ulawbyte;
        sample = (int)(longsmp + BIAS);
        exponent = exp_lut[( sample >> 8 ) & 0x7F];
        mantissa = ( sample >> (exponent+3) ) & 0x0F;
        ulawbyte = ~ (sign | (exponent << 4) | mantissa );
#ifdef ZEROTRAP
        if (ulawbyte == 0) ulawbyte = MUZERO;    /* optional CCITT trap */
#endif
        *choutbufp++ = ulawbyte;
      }
      if (multichan && ++maxampp >= maxampend)
        maxampp = maxamp;
      sp++;
    } while (--n);
    if (!outbufrem) {
      if (osfopen) {
        audtran(outbuf,outbufsiz);
        choutbufp = outbuf;
      }
      outbufrem = O.outbufsamps;
      if (spoutrem) goto nchk;
    }
}

static void longtran(void)              /* send long_int spout vals to outbuf */
{                                       /*      write buffer when full      */
    float  *sp, *maxampp;
    int    n, spoutrem;
    float  absamp;

    sp = spout;                     /* adr spout    */      
    spoutrem = nspout;              /* smps to go   */
    maxampp = maxamp;

 nchk:
    if ((n = spoutrem) > (int)outbufrem) /* if nspout remaining > buf rem, */
      n = outbufrem;          /*      prepare to send in parts  */
    spoutrem -= n;
    outbufrem -= n;
    do {
      if ((absamp = *sp) < 0.0f)
        absamp = -absamp;
      if (absamp > *maxampp)          /*  maxamp this seg  */
        *maxampp = absamp;
      if (osfopen)
        *lloutbufp++ = (long) *sp;
      if (multichan && ++maxampp >= maxampend)
        maxampp = maxamp;
      sp++;
    } while (--n);
    if (!outbufrem) {
      if (osfopen) {
        audtran(outbuf,outbufsiz);
        lloutbufp = (long *) outbuf;
      }
      outbufrem = O.outbufsamps;
      if (spoutrem) goto nchk;
    }
}

static void floatran(void)              /* send float spout vals to outbuf */
{                                       /*      write buffer when full      */
    float  *sp, *maxampp;
    int    n, spoutrem;
    float  absamp;

    sp = spout;                     /* adr spout    */      
    spoutrem = nspout;              /* smps to go   */
    maxampp = maxamp;

 nchk:
    if ((n = spoutrem) > (int)outbufrem) /* if nspout remaining > buf rem, */
      n = outbufrem;          /*      prepare to send in parts  */
    spoutrem -= n;
    outbufrem -= n;
    do {
      if ((absamp = *sp) < 0.0f)
        absamp = -absamp;
      if (absamp > *maxampp)          /*  maxamp this seg  */
        *maxampp = absamp;
      if (osfopen)
        *floutbufp++ = *sp;
      if (multichan && ++maxampp >= maxampend)
        maxampp = maxamp;
      sp++;
    } while (--n);
    if (!outbufrem) {
      if (osfopen) {
        audtran(outbuf,outbufsiz);
        floutbufp = (float *) outbuf;
      }
      outbufrem = O.outbufsamps;
      if (spoutrem) goto nchk;
    }
}

static void szerotran(long kcnt) /* copy kcnt zerospouts to short soundbuf, */
                                /*      sending buffer whenever full     */
{
    int   n, smpsrem, clearcnt = 0;

    if (!osfopen)  return;
    smpsrem = nspout * (int)kcnt;        /* calculate total smps to go   */
 nchk:
    if ((n = smpsrem) > (int)outbufrem)  /* if smps remaining > buf rem, */
      n = outbufrem;          /*      prepare to send in parts  */
    smpsrem -= n;
    outbufrem -= n;
    if (clearcnt < O.outbufsamps) {
      clearcnt += n;          /* clear buf only till clean */
      do *shoutbufp++ = (short) 0;
      while (--n);
    }
    else shoutbufp += n;
    if (!outbufrem) {
      audtran(outbuf,outbufsiz);
      shoutbufp = (short *) outbuf;
      outbufrem = O.outbufsamps;
      if (smpsrem) goto nchk;
    }
}

static void bzerotran(kcnt)	                    /* J. Mohr  1995 Oct 17 */
  /* copy kcnt zerospouts to (unsigned) char soundbuf, */
  long kcnt;			            /* sending buffer whenever full */
{
    int	n, smpsrem, clearcnt = 0;

    if (!osfopen)  return;
    smpsrem = nspout * (int)kcnt;	/* calculate total smps to go	*/
 nchk:
    if ((n = smpsrem) > (int)outbufrem)	/* if smps remaining > buf rem, */
      n = outbufrem;		/*	prepare to send in parts  */
    smpsrem -= n;
    outbufrem -= n;
    if (clearcnt < O.outbufsamps) {
      clearcnt += n;		/* clear buf only till clean */
      do *choutbufp++ = (const char)0x80;
      while (--n);
    }
    else choutbufp += n;
    if (!outbufrem) {
      audtran(outbuf,outbufsiz);
      choutbufp = outbuf;
      outbufrem = O.outbufsamps;
      if (smpsrem) goto nchk;
    }
}

static void czerotran(long kcnt)/* copy kcnt zerospouts to (signed) char soundbuf, */
                                /*      sending buffer whenever full     */
{
    int   n, smpsrem, clearcnt = 0;

    if (!osfopen)  return;
    smpsrem = nspout * (int)kcnt;        /* calculate total smps to go   */
 nchk:
    if ((n = smpsrem) > (int)outbufrem)  /* if smps remaining > buf rem, */
      n = outbufrem;          /*      prepare to send in parts  */
    smpsrem -= n;
    outbufrem -= n;
    if (clearcnt < O.outbufsamps) {
      clearcnt += n;          /* clear buf only till clean */
      do *choutbufp++ = 0x00;
      while (--n);
    }
    else choutbufp += n;
    if (!outbufrem) {
      audtran(outbuf,outbufsiz);
      choutbufp = outbuf;
      outbufrem = O.outbufsamps;
      if (smpsrem) goto nchk;
    }
}

static void azerotran(long kcnt) { die("alaw not yet implemented"); }

static void uzerotran(long kcnt)/* copy kcnt zerospouts to ulaw soundbuf, */
                                /*      sending buffer whenever full     */
{
    int   n, smpsrem, clearcnt = 0;

    if (!osfopen)  return;
    smpsrem = nspout * (int)kcnt;        /* calculate total smps to go   */
 nchk:
    if ((n = smpsrem) > (int)outbufrem)  /* if smps remaining > buf rem, */
      n = outbufrem;          /*      prepare to send in parts  */
    smpsrem -= n;
    outbufrem -= n;
    if (clearcnt < O.outbufsamps) {
      clearcnt += n;          /* clear buf only till clean */
      do *choutbufp++ = (const char) 0xFF; /* no signal is 0xFF in mulaw */
      while (--n);
    }
    else choutbufp += n;
    if (!outbufrem) {
      audtran(outbuf,outbufsiz);
      choutbufp = outbuf;
      outbufrem = O.outbufsamps;
      if (smpsrem) goto nchk;
    }
}

static void lzerotran(long kcnt)        /* copy kcnt zerospouts to long_int soundbuf, */
  /*      sending buffer whenever full     */
{
    int   n, smpsrem, clearcnt = 0;

    if (!osfopen)  return;
    smpsrem = nspout * (int)kcnt;        /* calculate total smps to go   */
 nchk:
    if ((n = smpsrem) > (int)outbufrem)  /* if smps remaining > buf rem, */
      n = outbufrem;          /*      prepare to send in parts  */
    smpsrem -= n;
    outbufrem -= n;
    if (clearcnt < O.outbufsamps) {
      clearcnt += n;          /* clear buf only till clean */
      do *lloutbufp++ = 0L;
      while (--n);
    }
    else lloutbufp += n;
    if (!outbufrem) {
      audtran(outbuf,outbufsiz);
      lloutbufp = (long *) outbuf;
      outbufrem = O.outbufsamps;
      if (smpsrem) goto nchk;
    }
}

static void fzerotran(long kcnt)        /* copy kcnt zerospouts to float soundbuf, */
                                        /*      sending buffer whenever full     */
{
    int   n, smpsrem, clearcnt = 0;

    if (!osfopen)  return;
    smpsrem = nspout * (int)kcnt;        /* calculate total smps to go   */
 nchk:
    if ((n = smpsrem) > (int)outbufrem)  /* if smps remaining > buf rem, */
      n = outbufrem;          /*      prepare to send in parts  */
    smpsrem -= n;
    outbufrem -= n;
    if (clearcnt < O.outbufsamps) {
      clearcnt += n;          /* clear buf only till clean */
      do *floutbufp++ = 0.0f;
      while (--n);
    }
    else floutbufp += n;
    if (!outbufrem) {
      audtran(outbuf,outbufsiz);
      floutbufp = (float *) outbuf;
      outbufrem = O.outbufsamps;
      if (smpsrem) goto nchk;
    }
}

static void clrspin1(float *r, int spinrem) /* clear remainder of spinbuf to zeros */
{                                	    /* called only once, at EOF   */
    infilend = 1;                        /* 1st filend pass:   */
    while (spinrem--)                    /*   clear spin rem   */
      *r++ = 0.0f;
}

static void clrspin2(void)      /* clear spinbuf to zeros   */
{                               /* called only once, at EOF */
    float *r = spin;
    int n = nspin;
    infilend = 2;                        /* at 2nd filend pass  */
    do *r++ = 0.0f;                       /*   clr whole spinbuf */
    while (--n);
    printf("end of audio_in file\n");
}

static void byterecv()                            /* J. Mohr  1995 Oct 17 */
  /* get spin values from byte inbuf */
{
    float *r = spin;
    int   n, spinrem = nspin;

    if (infilend == 2) return;
    if (!inbufrem)  goto echk;
 nchk:
    if ((n = spinrem) > (int)inbufrem)   /* if nspin remaining > buf rem,  */
      n = inbufrem;               /*       prepare to get in parts  */
    spinrem -= n;
    inbufrem -= n;
    do *r++ = (float) ( (short)((*(unsigned char*)chinbufp++)^0x80) << 8 );
    while (--n);
    if (!inbufrem) {
    echk:	    if (!infilend) {
      if ((n = audrecv(inbuf, inbufsiz)) != 0) {
        chinbufp = inbuf;
        inbufrem = n / sizeof(char);
        if (spinrem) goto nchk;
      } else clrspin1(r,spinrem);  /* 1st filend pass: partial clr  */
    } else clrspin2();           /* 2nd filend pass: zero the spinbuf */
    }
}
 
static void charrecv(void)              /* get spin values from char inbuf */
{
    float *r = spin;
    int   n, spinrem = nspin;

    if (infilend == 2) return;
    if (!inbufrem)  goto echk;
 nchk:
    if ((n = spinrem) > (int)inbufrem)   /* if nspin remaining > buf rem,  */
      n = inbufrem;               /*       prepare to get in parts  */
    spinrem -= n;
    inbufrem -= n;
    do *r++ = (float) ( (short)*(chinbufp++) << 8 );
    while (--n);
    if (!inbufrem) {
    echk:
      if (!infilend) {
        if ((n = audrecv(inbuf, inbufsiz)) != 0) {
          chinbufp = inbuf;
          inbufrem = n / sizeof(char);
          if (spinrem) goto nchk;
        } else clrspin1(r,spinrem);  /* 1st filend pass: partial clr  */
      } else clrspin2();           /* 2nd filend pass: zero the spinbuf */
    }
}

static void alawrecv(void)
{
    die("alaw audio_in not yet implemented");
}

static void ulawrecv(void)              /* get spin values from ulaw inbuf */
{
    float *r = spin;
    int   n, spinrem = nspin;

    if (infilend == 2) return;
    if (!inbufrem)  goto echk;
nchk:
    if ((n = spinrem) > (int)inbufrem)   /* if nspin remaining > buf rem,  */
      n = inbufrem;               /*       prepare to get in parts  */
    spinrem -= n;
    inbufrem -= n;
    do *r++ = (float) ulaw_decode[*(unsigned char *)chinbufp++];
    while (--n);
    if (!inbufrem) {
    echk:
      if (!infilend) {
        if ((n = audrecv(inbuf, inbufsiz)) != 0) {
          chinbufp = inbuf;
          inbufrem = n / sizeof(char);
          if (spinrem) goto nchk;
        } else clrspin1(r,spinrem);  /* 1st filend pass: partial clr  */
      } else clrspin2();           /* 2nd filend pass: zero the spinbuf */
    }
}

static void shortrecv(void)              /* get spin values from short_int inbuf */
{
    float *r = spin;
    int   n, spinrem = nspin;

    if (infilend == 2) return;
    if (!inbufrem)  goto echk;
 nchk:
    if ((n = spinrem) > (int)inbufrem)   /* if nspin remaining > buf rem,  */
      n = inbufrem;               /*       prepare to get in parts  */
    spinrem -= n;
    inbufrem -= n;
    do *r++ = (float) *shinbufp++;
    while (--n);
    if (!inbufrem) {
    echk:
      if (!infilend) {
        if ((n = audrecv(inbuf, inbufsiz)) != 0) {
          shinbufp = (short *) inbuf;
          inbufrem = n / sizeof(short);
          if (spinrem) goto nchk;
        } else clrspin1(r,spinrem);  /* 1st filend pass: partial clr  */
      } else clrspin2();           /* 2nd filend pass: zero the spinbuf */
    }
}

static void longrecv(void)              /* get spin values from long_int inbuf */
{
    float *r = spin;
    int   n, spinrem = nspin;

    if (infilend == 2) return;
    if (!inbufrem)  goto echk;
 nchk:
    if ((n = spinrem) > (int)inbufrem)   /* if nspin remaining > buf rem,  */
      n = inbufrem;               /*       prepare to get in parts  */
    spinrem -= n;
    inbufrem -= n;
    do *r++ = (float) *llinbufp++;
    while (--n);
    if (!inbufrem) {
    echk:
      if (!infilend) {
        if ((n = audrecv(inbuf, inbufsiz)) != 0) {
          llinbufp = (long *) inbuf;
          inbufrem = n / sizeof(long);
          if (spinrem) goto nchk;
        } else clrspin1(r,spinrem);  /* 1st filend pass: partial clr  */
      } else clrspin2();           /* 2nd filend pass: zero the spinbuf */
    }
}

static void floatrecv(void)              /* get spin values from float inbuf */
{
    float *r = spin;
    int   n, spinrem = nspin;
    
    if (infilend == 2) return;
    if (!inbufrem)  goto echk;
 nchk:
    if ((n = spinrem) > (int)inbufrem)   /* if nspin remaining > buf rem,  */
      n = inbufrem;               /*       prepare to get in parts  */
    spinrem -= n;
    inbufrem -= n;
    do *r++ = *flinbufp++;
    while (--n);
    if (!inbufrem) {
    echk:
      if (!infilend) {
        if ((n = audrecv(inbuf, inbufsiz)) != 0) {
          flinbufp = (float *) inbuf;
          inbufrem = n / sizeof(float);
          if (spinrem) goto nchk;
        } else clrspin1(r,spinrem);  /* 1st filend pass: partial clr  */
      } else clrspin2();           /* 2nd filend pass: zero the spinbuf */
    }
}

