#include "cs.h"                 /*                      SOUNDIN.C       */
#include "soundio.h"

static  float   fzero = 0.0f;
static  long	datpos= 0L;       /* Used in resetting only */
char    **strsets = NULL;

extern  int     ksmps;
extern  HEADATA *readheader(int, char *, SOUNDIN*);
extern  short   ulaw_decode[];
extern  int     bytrevhost(void), openin(char*);
extern  char    *retfilnam;
extern  OPARMS  O;
extern  void sndwrterr(int, int);

#ifdef RESET
void soundinreset(void)
{
      datpos = 0;
      fzero = 0.0f;             /* do not seem to need anything else... */
}
#endif

char *getstrformat(int format)  /* used here, and in sfheader.c */
{
    switch(format) {
    case AE_UNCH:  return("unsigned bytes");   /* J. Mohr 1995 Oct 17 */
    case AE_CHAR:  return("signed chars");
    case AE_ALAW:  return("alaw bytes");
    case AE_ULAW:  return("ulaw bytes");
    case AE_SHORT: return("shorts");
    case AE_LONG:  return("longs");
    case AE_FLOAT: return("floats");
    default:
      {
        char st[80];
        sprintf(st, "unknown sound format %d(0x%x)", format, format);
        die(st); return(NULL);
      }
    }
}

int getsizformat(int format)
{
 static int formatsiz[] = {0, sizeof(char), sizeof(char), sizeof(char),
                            sizeof(short), sizeof(long), sizeof(float),
                            sizeof(char)};
        if (format > AE_LAST)
                die("illegal input to getsizformat");
        return(formatsiz[format & 0xF]);
}

void bytrev2(char *buf, int nbytes)      /* reverse bytes in buf of shorts */
{
        char *p = buf, c1, c2;
        int n = nbytes/2;

        do {
            c1 = *p++;
            c2 = *p--;
            *p++ = c2;
            *p++ = c1;
        } while (--n);
}

void bytrev4(char *buf, int nbytes)     /* reverse bytes in buf of longs */
{
        char *p = buf, *q = buf;
        char c1, c2, c3, c4;
        int n = nbytes/4;

        do {
            c1 = *p++;
            c2 = *p++;
            c3 = *p++;
            c4 = *p++;
            *q++ = c4;
            *q++ = c3;
            *q++ = c2;
            *q++ = c1;
        } while (--n);
}

int sreadin(                    /* special handling of sound input       */
    int     infd,               /* to accomodate reads thru pipes & net  */
    char    *inbuf,             /* where nbytes rcvd can be < n requested*/
    int     nbytes,             /*  */
    SOUNDIN *p)                 /* extra arg passed for filetyp testing  */
{                               /* on POST-HEADER reads of audio samples */
        int    n, ntot=0;

        do if ((n = read(infd, inbuf+ntot, nbytes-ntot)) < 0)
                die("soundfile read error");
        while (n > 0 && (ntot += n) < nbytes);
        if (p->filetyp) {                           /* for AIFF and WAV samples */
            if (p->filetyp == TYP_AIFF) {
                if (p->audrem > 0) {                /* AIFF:                  */
                    if (ntot > p->audrem)           /*   chk haven't exceeded */
                        ntot = p->audrem;           /*   limit of audio data  */
                    p->audrem -= ntot;
                }
                else ntot = 0;
            }
            if (ntot && p->bytrev != NULL)          /* for post-header of both */
                p->bytrev(inbuf, ntot);             /*   bytrev 2 or 4 as reqd */
        }
 /* RWD.2.98: denormalize WAV float files: is it enough to do this here ?*/
        if (p->filetyp==TYP_WAV && p->format==AE_FLOAT) {
          int i;
          int cnt = ntot/sizeof(float);
          float *ptr = (float *) inbuf;
          for (i=0; i<cnt; i++)	*ptr++ *= 32768.0f;
        }
        return(ntot);
}

int sndgetset(SOUNDIN *p)       /* core of soundinset                */
                                /* called from sndinset, SAsndgetset, & gen01 */
				/* Return -1 on failure */
{
        int    n;
        HEADATA *hdr;
        long    hdrsize = 0, readlong = 0, framesinbuf, skipframes;
        char    *sfname, soundiname[128];
        int     sinfd;

        if ((n = p->OUTOCOUNT) && n != 1 && n != 2 && n != 4 &&
	    n != 6 && n!= 8) { /* if appl,chkchnls */
	  sprintf(errmsg,"soundin: illegal no of receiving channels");
	  goto errtn;
        }
        if (*p->ifilno == sstrcod)               /* if char string name given */
            strcpy(soundiname,unquote(p->STRARG));    /*     unquote it,  else use */
        else sprintf(soundiname,"soundin.%ld",(long)*p->ifilno);  /* soundin.filno */
        sfname = soundiname;
        if ((sinfd = openin(sfname)) < 0) {      /* open with full dir paths */
            if (isfullpath(sfname))
                sprintf(errmsg,"soundin cannot open %s", sfname);
            else sprintf(errmsg,"soundin can't find \"%s\" in its search paths",
                         sfname);
            goto errtn;
        }
        sfname = retfilnam;                      /* & record fullpath filnam */
        if ((p->format = (short)*p->iformat) > 0)       /* convert spec'd format code */
            p->format |= 0x100;
        p->endfile = 0;
        p->filetyp = 0;		/* initially non-typed for readheader */
        if ((hdr=readheader(sinfd,sfname,p)) != NULL /* if headerblk returned */
              && !(readlong = hdr->readlong)) {  /* & hadn't readin audio */
            if (hdr->filetyp == TYP_AIFF         /*    chk the hdr codes  */
              && hdr->aiffdata != NULL
              && hdr->aiffdata->loopmode1 != 0   /* looping aiff:         */
              && (p->analonly || p->OUTOCOUNT))  /*     ok for gen01 only */
                warning("aiff looping file, once through only");
            if (p->analonly) {                          /* anal: if sr param val */
                if (p->sr != 0 && p->sr != hdr->sr) {   /*          use it       */
                    sprintf(errmsg,"-s %ld overriding soundfile sr %ld",
                            p->sr, hdr->sr);
                    warning(errmsg);
                    hdr->sr = p->sr;
                }
            }
            else if (hdr->sr != esr) {                  /* non-anal:  cmp w. esr */
                sprintf(errmsg,"%s sr = %ld, orch sr = %7.1f",
                        sfname, hdr->sr, esr);
                warning(errmsg);
            }
            if (p->OUTOCOUNT) {                          /* for orch SOUNDIN: */
                if (hdr->nchnls != p->OUTOCOUNT) {       /*        chk nchnls */
                    sprintf(errmsg,"%s nchnls = %d, soundin reading as if nchnls = %d",
                            sfname, (int) hdr->nchnls, (int) p->OUTOCOUNT);
                    warning(errmsg);
                    hdr->nchnls = p->OUTOCOUNT;
                }
            }                                            /* else chk sufficient */
            else if (p->channel != ALLCHNLS && p->channel > hdr->nchnls) {
                sprintf(errmsg,"req chan %d, file %s has only %ld",
                        p->channel, sfname, hdr->nchnls);
                die(errmsg);
            }
            if (p->format && hdr->format != p->format) {
                sprintf(errmsg,"soundin %s superceded by %s header format %s",
                        getstrformat((int)p->format), sfname,
                        getstrformat((int)hdr->format));
                warning(errmsg);
            }
            switch ((p->format = (short)hdr->format)) {	/* & copy header data */
	    case AE_UNCH:   break;
            case AE_CHAR:   break;
            case AE_ULAW:   break;
            case AE_SHORT:  break;
            case AE_LONG:   break;
            case AE_FLOAT:  break;
            default: sprintf(errmsg,"%s format %s not yet supported",
                             sfname, getstrformat((int)p->format));
                     goto errcls;
            }
            p->sampframsiz = (short)(hdr->sampsize * hdr->nchnls);
            hdrsize = hdr->hdrsize;
            p->filetyp = hdr->filetyp;          /* copy type from headata       */
            p->aiffdata = hdr->aiffdata;
            p->sr = hdr->sr;
            p->nchnls = (short)hdr->nchnls;
        }
        else {                                  /* no hdr:  find info elsewhere */
            if (p->analonly) {
                if (!p->sr) {
                    p->sr = (long)DFLT_SR;
                    sprintf(errmsg,
                            "no -s and no soundheader, using sr default %ld",p->sr);
                    warning(errmsg);
                }
            }
            else {
                warning("no soundin header, presuming orchestra sr");
                p->sr = (long) esr;
            }
            if (p->OUTOCOUNT)
              p->channel = p->OUTOCOUNT;
            else if (p->channel == ALLCHNLS)
                p->channel = 1;
            if (!p->format) {                 /* no format:                  */
                if (p->analonly)              /*  analonly defaults to short */
                    p->format = AE_SHORT;
                else p->format = O.outformat; /*  orch defaults to outformat */
            }
            sprintf(errmsg,
		    "%s has no soundfile header, reading as %s, %d chnl%s",
                    sfname, getstrformat((int)p->format), (int)p->channel,
                    p->channel == 1 ? "" : "s");
            warning(errmsg);
            p->sampframsiz = getsizformat((int)p->format) * p->channel;
            p->filetyp = 0;                   /* in_type can't be AIFF or WAV */
            p->aiffdata = NULL;
            p->nchnls = p->channel;
        }
        printf("audio sr = %ld, ", p->sr);
        if (p->nchnls == 1)
            printf("monaural\n");
        else {
            printf("%s, reading ", p->nchnls == 2 ? "stereo" :
                                   p->nchnls == 4 ? "quad" :
				   p->nchnls == 6 ? "hex" : "oct" );
            if (p->channel == ALLCHNLS)
                printf("%s channels\n", p->nchnls == 2 ? "both" : "all");
            else printf("channel %d\n", p->channel);
        }

        if ( p->filetyp == TYP_AIFF && bytrevhost() ||
             p->filetyp == TYP_AIFC && bytrevhost() ||
             p->filetyp == TYP_WAV && !bytrevhost()) {
          if (p->format == AE_SHORT)          /* if audio_in needs byte rev */
            p->bytrev = bytrev2;            /*     set on sample size     */
          else if (p->format == AE_LONG)
            p->bytrev = bytrev4;
          else p->bytrev = NULL;
          printf("opening %s infile %s, with%s bytrev\n",
                 p->filetyp == TYP_AIFF ? "AIFF" : TYP_AIFC ? "AIFC" : "WAV",
                 sfname, p->bytrev == NULL ? " no" : "");
        }
        else p->bytrev = NULL;
        if (p->sampframsiz <= 0)                           /* must know framsiz */
            die("illegal sampframsiz");
        if (hdr != NULL && hdr->audsize > 0 ) {            /* given audiosize   */
            p->audrem = hdr->audsize;
            p->framesrem = hdr->audsize / p->sampframsiz;  /*   find frames rem */
        }
        else {
            p->audrem = -1;                                /* else mark unknown */
            p->framesrem = -1;
        }
        skipframes = (long)(*p->iskptim * p->sr);
        framesinbuf = SNDINBUFSIZ / p->sampframsiz;
        if (skipframes < framesinbuf) {              /* if sound within 1st buf */
            int nreq;
            if (readlong) {                             /*  fill by direct read */
                nreq = SNDINBUFSIZ - sizeof(long);
                *(long *)p->inbuf = hdr->firstlong;
                n = sreadin(sinfd, p->inbuf+sizeof(long), nreq, p);
                p->bufend = p->inbuf + sizeof(long) + n;
            }
            else {
                nreq = SNDINBUFSIZ;
                n = sreadin(sinfd, p->inbuf, nreq, p);
                p->bufend = p->inbuf + n;
            }
            p->inbufp = p->inbuf + skipframes * p->sampframsiz;
        }
        else {                                          /* for greater skiptime: */
            long nbytes = skipframes * p->sampframsiz;
            if (hdrsize < 0) {
                int nbufs = nbytes/SNDINBUFSIZ;         /* if headersize unknown, */
                int nrem = nbytes - (long)nbufs * SNDINBUFSIZ;
                while (--nbufs)                         /*  spinrd to req boundry */
                    sreadin(sinfd,p->inbuf,SNDINBUFSIZ,p);
                if (nrem)
                    sreadin(sinfd,p->inbuf,nrem,p);
            }
            else if (lseek(sinfd, nbytes+hdrsize, 0) < 0)  /* else seek to bndry */
                    die("soundin seek error");
            if ((n = sreadin(sinfd,p->inbuf,SNDINBUFSIZ,p)) == 0)/* now rd fulbuf */
                p->endfile = 1;
            p->inbufp = p->inbuf;
            p->bufend = p->inbuf + n;
        }
        if (p->inbufp >= p->bufend)   /* needed? */
                p->endfile = 1;
        if (p->framesrem != -1)
            p->framesrem -= skipframes;              /* sampleframes to EOF   */
        datpos = hdrsize;
        return(sinfd);                              /* return the active fd  */

 errcls: close(sinfd);               /* init error:  close any open file */
 errtn:  return(-1);                  /*              return empty handed */
}

int SAsndgetset(
     char    *infilnam,                          /* Stand-Alone sndgetset() */
     SOUNDIN **ap,                               /* used by SoundAnal progs */
     float   *abeg_time,
     float   *ainput_dur,
     float   *asr,
     int     channel)
{				/* Return -1 on failure */
        SOUNDIN  *p;
        char     quotname[80];
        int      infd;
static  ARGOFFS  argoffs = {0};     /* these for sndgetset */
static  OPTXT    optxt;

        sssfinit();                 /* stand-alone init of SFDIR etc. */
        esr = 0.0f;                 /* set esr 0. with no orchestra   */
        optxt.t.outoffs = &argoffs; /* point to dummy OUTOCOUNT       */
        *ap = p = (SOUNDIN *) mcalloc((long)sizeof(SOUNDIN));
        p->h.optext = &optxt;
        p->ifilno = &sstrcod;
        p->iskptim = abeg_time;
        p->iformat = &fzero;
        sprintf(quotname,"%c%s%c",'"',infilnam,'"');
        p->STRARG = quotname;
        p->sr = (long)*asr;
/* G. Sullivan This modification is not really complete - calling routines
   should now really be modified to check for channel count > 1, when they
   are not able to handle this case. I have been lazy, and have not yet
   bothered to do this. The reason I made this change was so that
   cvanal could handle stereo, or quad, soundfiles */
        if (channel < 1 || ((channel > 4) && (channel != ALLCHNLS))) {
/*        if (channel < 1 || channel > 4)  { */         /* SAsnd is chan 1,2,3 or 4 */
            printf("channel request %d illegal\n", channel);
            return(-1);
        }
        p->channel = channel;
        p->analonly = 1;
        if ((infd = sndgetset(p)) < 0)            /* open sndfil, do skiptime */
            return(-1);

        if (p->framesrem < 0 )
            warning("undetermined file length, will attempt requested duration");
        else {
            if (*ainput_dur == 0.0) {             /* 0 durtim, use to EOF */
                p->getframes = p->framesrem;
                *ainput_dur = (float) p->getframes / p->sr;
            }
                             /* else chk that input dur is within filetime rem */
            else if ((p->getframes = (long)(p->sr * *ainput_dur)) > p->framesrem) {
                    p->getframes = p->framesrem;
                    warning("full requested duration not available");
            }
            printf("analyzing %ld sample frames (%3.1f secs)",
                    p->getframes, *ainput_dur);
            if (*abeg_time != 0.0)
                printf(" from timepoint %3.1f\n", *abeg_time);
            else printf("\n");
        }
        return(infd);
}

long getsndin(int fd, float *fp, long nlocs, SOUNDIN *p)
        /* a simplified soundin */
{
        long  n, nread;
        float *fbeg = fp, *fend = fp + nlocs, gain;

        if (p->aiffdata != NULL)
            gain = p->aiffdata->gainfac;
        else gain = 1.0f;
        if (p->nchnls == 1 || p->channel == ALLCHNLS) {  /* MONO or ALLCHNLS */
          switch (p->format) {
	    case AE_UNCH: {
		unsigned char *inbufp, *bufend;
		inbufp = (unsigned char *) p->inbufp;
		bufend = (unsigned char *) p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (unsigned char *) p->inbuf;
			bufend = (unsigned char *) (p->inbuf + n);
		    }
		    /* convert unsigned char to signed by XOR 0x80 */
		    *fp++ = (float)( (short)((*inbufp++)^0x80) << 8 );
		}
		p->inbufp = (char *) inbufp;
		p->bufend = (char *) bufend;
	    } break;
            case AE_CHAR: {
                char *inbufp, *bufend;
                inbufp = p->inbufp;
                bufend = p->bufend;
                while (nlocs--) {
                    if (inbufp >= bufend) {
                        if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
                            break;
                        inbufp = p->inbuf;
                        bufend = p->inbuf + n;
                    }
                    *fp++ = (float)( (short)*inbufp++ << 8 ) * gain;
                }
                p->inbufp = inbufp;
                p->bufend = bufend;   /* must reinit after EOF this file */
            } break;
            case AE_ULAW: {
                unsigned char *inbufp, *bufend;
                inbufp = (unsigned char *) p->inbufp;
                bufend = (unsigned char *) p->bufend;
                while (nlocs--) {
                    if (inbufp >= bufend) {
                        if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
                            break;
                        inbufp = (unsigned char *) p->inbuf;
                        bufend = (unsigned char *) (p->inbuf + n);
                    }
                    *fp++ = (float)ulaw_decode[*inbufp++] * gain;
                }
                p->inbufp = (char *) inbufp;
                p->bufend = (char *) bufend;
            } break;
            case AE_SHORT: {
                short  *inbufp, *bufend;
                inbufp = (short *) p->inbufp;
                bufend = (short *) p->bufend;
                while (nlocs--) {
                    if (inbufp >= bufend) {
                        if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
                            break;
                        inbufp = (short *) p->inbuf;
                        bufend = (short *) (p->inbuf + n);
                    }
                    *fp++ = (float) *inbufp++ * gain;
                }
                p->inbufp = (char *) inbufp;
                p->bufend = (char *) bufend;
            } break;
            case AE_LONG: {
                long  *inbufp, *bufend;
                inbufp = (long *) p->inbufp;
                bufend = (long *) p->bufend;
                while (nlocs--) {
                    if (inbufp >= bufend) {
                        if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
                            break;
                        inbufp = (long *) p->inbuf;
                        bufend = (long *) (p->inbuf + n);
                    }
                    *fp++ = (float) *inbufp++ * gain;
                }
                p->inbufp = (char *) inbufp;
                p->bufend = (char *) bufend;
            } break;
            case AE_FLOAT: {
                float  *inbufp, *bufend;
                inbufp = (float *) p->inbufp;
                bufend = (float *) p->bufend;
                while (nlocs--) {
                    if (inbufp >= bufend) {
                        if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
                            break;
                        inbufp = (float *) p->inbuf;
                        bufend = (float *) (p->inbuf + n);
                    }
                    *fp++ = *inbufp++ * gain;
                }
                p->inbufp = (char *) inbufp;
                p->bufend = (char *) bufend;
            } break;
            default: goto getserr;
          }
        } else {                                /* MULTI-CHANNEL, SELECT ONE */
          int chcnt = 0, chreq = p->channel, nchnls = p->nchnls;
          nlocs *= nchnls;
          switch (p->format) {
	    case AE_UNCH: {
		unsigned char *inbufp, *bufend;
		inbufp = (unsigned char *) p->inbufp;
		bufend = (unsigned char *) p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (unsigned char *) p->inbuf;
			bufend = (unsigned char *) (p->inbuf + n);
		    }
		    if (++chcnt == chreq)
		        *fp++ = (float) ( (short)(*inbufp^0x80) << 8 );
		    inbufp++;
		    if (chcnt == nchnls) chcnt = 0;
		}
		p->inbufp = (char *) inbufp;
		p->bufend = (char *) bufend;
	    } break;
            case AE_CHAR: {
                char *inbufp, *bufend;
                inbufp = p->inbufp;
                bufend = p->bufend;
                while (nlocs--) {
                    if (inbufp >= bufend) {
                        if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
                            break;
                        inbufp = p->inbuf;
                        bufend = p->inbuf + n;
                    }
                    if (++chcnt == chreq)
                        *fp++ = (float) ( (short)*inbufp << 8 ) * gain;
                    inbufp++;
                    if (chcnt == nchnls) chcnt = 0;
                }
                p->inbufp = inbufp;
                p->bufend = bufend;
            } break;
            case AE_ULAW: {
                unsigned char *inbufp, *bufend;
                inbufp = (unsigned char *) p->inbufp;
                bufend = (unsigned char *) p->bufend;
                while (nlocs--) {
                    if (inbufp >= bufend) {
                        if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
                            break;
                        inbufp = (unsigned char *) p->inbuf;
                        bufend = (unsigned char *) (p->inbuf + n);
                    }
                    if (++chcnt == chreq)
                        *fp++ = (float) ulaw_decode[*inbufp] * gain;
                    inbufp++;
                    if (chcnt == nchnls) chcnt = 0;
                }
                p->inbufp = (char *) inbufp;
                p->bufend = (char *) bufend;
            } break;
            case AE_SHORT: {
                short  *inbufp, *bufend;
                inbufp = (short *) p->inbufp;
                bufend = (short *) p->bufend;
                while (nlocs--) {
                    if (inbufp >= bufend) {
                        if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
                            break;
                        inbufp = (short *) p->inbuf;
                        bufend = (short *) (p->inbuf + n);
                    }
                    if (++chcnt == chreq)
                        *fp++ = (float) *inbufp * gain;
                    inbufp++;
                    if (chcnt == nchnls) chcnt = 0;
                }
                p->inbufp = (char *) inbufp;
                p->bufend = (char *) bufend;
            } break;
            case AE_LONG: {
                long  *inbufp, *bufend;
                inbufp = (long *) p->inbufp;
                bufend = (long *) p->bufend;
                while (nlocs--) {
                    if (inbufp >= bufend) {
                        if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
                            break;
                        inbufp = (long *) p->inbuf;
                        bufend = (long *) (p->inbuf + n);
                    }
                    if (++chcnt == chreq)
                        *fp++ = (float) *inbufp * gain;
                    inbufp++;
                    if (chcnt == nchnls) chcnt = 0;
                }
                p->inbufp = (char *) inbufp;
                p->bufend = (char *) bufend;
            } break;
            case AE_FLOAT: {
                float  *inbufp, *bufend;
                inbufp = (float *) p->inbufp;
                bufend = (float *) p->bufend;
                while (nlocs--) {
                    if (inbufp >= bufend) {
                        if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
                            break;
                        inbufp = (float *) p->inbuf;
                        bufend = (float *) (p->inbuf + n);
                    }
                    if (++chcnt == chreq)
                        *fp++ = *inbufp * gain;
                    inbufp++;
                    if (chcnt == nchnls) chcnt = 0;
                }
                p->inbufp = (char *) inbufp;
                p->bufend = (char *) bufend;
            } break;
            default: goto getserr;
          }
        }
        nread = fp - fbeg;
        while (fp < fend)    /* if incomplete */
            *fp++ = 0.0f;   /*  pad with 0's */
        return(nread);

getserr: printf("cannot read sformat %s\n",getstrformat((int)p->format));
        return(-1L);
}

void sndinset(SOUNDIN *p)    /* init routine for instr soundin   */
                             /* shares above sndgetset with SAsndgetset, gen01*/
{
        int     sinfd;
        long	skipframes;

        if (p->fdch.fd != 0) {  /* if file already open, rtn */
          /* RWD: it is not safe to assume all compilers init this to 0 */
          /* RWD start of mods: for reinits, reset to init point of file */
          /* this is not actually RIGHT yet, but it is close... */
          skipframes = (long)(*p->iskptim * p->sr);
          /* UGH, want datpos to be in SOUNDIN struct somewhere, or add a */
          /* function to get hdrsize...? */
          lseek(p->fdch.fd,datpos+(skipframes* p->sampframsiz),SEEK_SET);
          return;
        }
        p->channel = ALLCHNLS;                   /* reading all channels      */
        p->analonly = 0;
        if ((sinfd = sndgetset(p)) >= 0) {       /* if soundinset successful  */
                p->fdch.fd = sinfd;              /*    store & log the fd     */
                fdrecord(&p->fdch);              /*    instr will close later */
        }
        else initerror(errmsg);                  /* else just print the errmsg*/
				/* The rest is only used in soundin2, but
				 * Does little harm so save code size */
/*         p->base_sample_gab = 0; */
/*         p->fl_buf = 0; */
/*         p->initflag_gab = 1; */
/*         p->phase_gab = (p->OUTOCOUNT == 1 ? 27 : 13) + *p->iskptim * p->sr; */
	/*        p->phase_gab = initphase + *p->iskptim * p->sr; */
}

void soundin(SOUNDIN *p)
{
    short       nsmps;
    float       *r1, *r2, *r3, *r4;
    int chnsout, n, ntogo;

    if ((!p->bufend) || (!p->inbufp) || (!p->sampframsiz)) {
      initerror("soundin: not initialised");
      return;
    }
    r1 = p->r1;
    r2 = p->r2;
    r3 = p->r3;
    r4 = p->r4;
    chnsout = p->OUTOCOUNT;
    ntogo = ksmps;
    if (p->endfile)
        goto filend;
    nsmps = (p->bufend - p->inbufp) / p->sampframsiz;
    if (nsmps > ksmps)
        nsmps = ksmps;
    ntogo -= nsmps;
    switch (p->format) {
	    case AE_UNCH: {
		unsigned char *inbufp = (unsigned char *)p->inbufp;
byte:		switch(chnsout) {
		case 1:	do { *r1++ = (float)((short)((*inbufp++)^0x80) << 8 );
			} while (--nsmps);
			break;
		case 2:	do { *r1++ = (float)((short)((*inbufp++)^0x80) << 8 );
			     *r2++ = (float)((short)((*inbufp++)^0x80) << 8 );
			} while (--nsmps);
			break;
		case 4:	do { *r1++ = (float)((short)((*inbufp++)^0x80) << 8 );
			     *r2++ = (float)((short)((*inbufp++)^0x80) << 8 );
			     *r3++ = (float)((short)((*inbufp++)^0x80) << 8 );
			     *r4++ = (float)((short)((*inbufp++)^0x80) << 8 );
			} while (--nsmps);
		}
		if (inbufp >= (unsigned char *)p->bufend) {
		    if ((n = sreadin(p->fdch.fd,p->inbuf,SNDINBUFSIZ,p)) == 0) {
		        p->endfile = 1;
			if (ntogo) goto filend;
			else return;
		    }
		    inbufp = (unsigned char *)p->inbuf;
		    p->bufend = p->inbuf + n;
		    if (ntogo > 0) {
		        if ((nsmps = n / p->sampframsiz) > ntogo)
			  nsmps = ntogo;
			ntogo -= nsmps;
			goto byte;
		    }
		}
		p->inbufp = (char *)inbufp;
		break;
	    }
    case AE_CHAR: {
        char *inbufp = p->inbufp;
chars:
        switch(chnsout) {
        case 1:
            do {
                *r1++ = (float) ( (short)*inbufp++ << 8 );
            } while (--nsmps);
            break;
        case 2:
            do {
                *r1++ = (float) ( (short)*inbufp++ << 8 );
                *r2++ = (float) ( (short)*inbufp++ << 8 );
            } while (--nsmps);
            break;
        case 4:
            do {
                *r1++ = (float) ( (short)*inbufp++ << 8 );
                *r2++ = (float) ( (short)*inbufp++ << 8 );
                *r3++ = (float) ( (short)*inbufp++ << 8 );
                *r4++ = (float) ( (short)*inbufp++ << 8 );
            } while (--nsmps);
        }
        if (inbufp >= p->bufend) {
            if ((n = sreadin(p->fdch.fd,p->inbuf,SNDINBUFSIZ,p)) == 0) {
                p->endfile = 1;
                if (ntogo) goto filend;
                else return;
            }
            inbufp = p->inbuf;
            p->bufend = p->inbuf + n;
            if (ntogo > 0) {
                if ((nsmps = n / p->sampframsiz) > ntogo)
                    nsmps = ntogo;
                ntogo -= nsmps;
                goto chars;
            }
        }
        p->inbufp = inbufp;
        break;
    }
    case AE_ULAW:
    {
        unsigned char *inbufp = (unsigned char *)p->inbufp;
ulaw:
        switch(chnsout) {
        case 1:
            do {
                *r1++ = (float) ulaw_decode[*inbufp++];
            } while (--nsmps);
            break;
        case 2:
            do {
                *r1++ = (float) ulaw_decode[*inbufp++];
                *r2++ = (float) ulaw_decode[*inbufp++];
            } while (--nsmps);
            break;
        case 4:
            do {
                *r1++ = (float) ulaw_decode[*inbufp++];
                *r2++ = (float) ulaw_decode[*inbufp++];
                *r3++ = (float) ulaw_decode[*inbufp++];
                *r4++ = (float) ulaw_decode[*inbufp++];
            } while (--nsmps);
        }
        if (inbufp >= (unsigned char *)p->bufend) {
            if ((n = sreadin(p->fdch.fd,p->inbuf,SNDINBUFSIZ,p)) == 0) {
                p->endfile = 1;
                if (ntogo) goto filend;
                else return;
            }
            inbufp = (unsigned char *)p->inbuf;
            p->bufend = p->inbuf + n;
            if (ntogo > 0) {
                if ((nsmps = n / p->sampframsiz) > ntogo)
                    nsmps = ntogo;
                ntogo -= nsmps;
                goto ulaw;
            }
        }
        p->inbufp = (char *)inbufp;
        break;
    }
    case AE_SHORT: {
        short *inbufp = (short *)p->inbufp;
shorts:
        switch(chnsout) {
        case 1:
            do {
                *r1++ = (float) *inbufp++;
            } while (--nsmps);
            break;
        case 2:
            do {
                *r1++ = (float) *inbufp++;
                *r2++ = (float) *inbufp++;
            } while (--nsmps);
            break;
        case 4:
            do {
                *r1++ = (float) *inbufp++;
                *r2++ = (float) *inbufp++;
                *r3++ = (float) *inbufp++;
                *r4++ = (float) *inbufp++;
            } while (--nsmps);
        }
        if (inbufp >= (short *)p->bufend) {
            if ((n = sreadin(p->fdch.fd,p->inbuf,SNDINBUFSIZ,p)) == 0) {
                p->endfile = 1;
                if (ntogo) goto filend;
                else return;
            }
            inbufp = (short *) p->inbuf;
            p->bufend = p->inbuf + n;
            if (ntogo > 0) {
                if ((nsmps = n / p->sampframsiz) > ntogo)
                    nsmps = ntogo;
                ntogo -= nsmps;
                goto shorts;
            }
        }
        p->inbufp = (char *) inbufp;
        break;
    }
    case AE_LONG: {
        long *inbufp = (long *)p->inbufp;
longs:
        switch(chnsout) {
        case 1:
            do {
                *r1++ = (float) *inbufp++;
            } while (--nsmps);
            break;
        case 2:
            do {
                *r1++ = (float) *inbufp++;
                *r2++ = (float) *inbufp++;
            } while (--nsmps);
            break;
        case 4:
            do {
                *r1++ = (float) *inbufp++;
                *r2++ = (float) *inbufp++;
                *r3++ = (float) *inbufp++;
                *r4++ = (float) *inbufp++;
            } while (--nsmps);
        }
        if (inbufp >= (long *)p->bufend) {
            if ((n = sreadin(p->fdch.fd,p->inbuf,SNDINBUFSIZ,p)) == 0) {
                p->endfile = 1;
                if (ntogo) goto filend;
                else return;
            }
            inbufp = (long *)p->inbuf;
            p->bufend = p->inbuf + n;
            if (ntogo > 0) {
                if ((nsmps = n / p->sampframsiz) > ntogo)
                    nsmps = ntogo;
                ntogo -= nsmps;
                goto longs;
            }
        }
        p->inbufp = (char *)inbufp;
        break;
    }
    case AE_FLOAT: {
        float *inbufp = (float *)p->inbufp;
floats:
        switch(chnsout) {
        case 1:
            do {
                *r1++ = *inbufp++;
            } while (--nsmps);
            break;
        case 2:
            do {
                *r1++ = *inbufp++;
                *r2++ = *inbufp++;
            } while (--nsmps);
            break;
        case 4:
            do {
                *r1++ = *inbufp++;
                *r2++ = *inbufp++;
                *r3++ = *inbufp++;
                *r4++ = *inbufp++;
            } while (--nsmps);
        }
        if ((char *)inbufp >= p->bufend) {
            if ((n = sreadin(p->fdch.fd,p->inbuf,SNDINBUFSIZ,p)) == 0) {
                p->endfile = 1;
                if (ntogo) goto filend;
                else return;
            }
            inbufp = (float *) p->inbuf;
            p->bufend = p->inbuf + n;
            if (ntogo > 0) {
                if ((nsmps = n / p->sampframsiz) > ntogo)
                    nsmps = ntogo;
                ntogo -= nsmps;
                goto floats;
            }
        }
        p->inbufp = (char *) inbufp;
        break;
    }
    default:
        dies("soundin of %s not implemented", getstrformat((int)p->format));
    }
    return;

filend:
    nsmps = ntogo;
    switch(chnsout) {                   /* if past end of file, */
    case 1:
        do *r1++ = 0.0f;               /*    move in zeros     */
        while (--nsmps);
        break;
    case 2:
        do {
            *r1++ = 0.0f;
            *r2++ = 0.0f;
        } while (--nsmps);
        break;
    case 4:
        do {
            *r1++ = 0.0f;
            *r2++ = 0.0f;
            *r3++ = 0.0f;
            *r4++ = 0.0f;
        } while (--nsmps);
    }
}

