#include "cs.h"         /*                                    PVADD.C        */
#include <math.h>
#include "dsputil.h"
#include "pvoc.h"
#include "pvadd.h"

/******************************************/
/* The applications in this file were     */
/* designed and coded by Richard Karpen   */
/* University of Washington, Seattle 1998 */
/******************************************/

extern  float   esr;
extern  int     ksmps;



void pvaddset(PVADD *p)
{
    int      i, ibins;
    char     pvfilnam[MAXNAME];
    PVSTRUCT *pvh;
    int     frInc, chans, size;
    MEMFIL   *mfp, *ldmemfile();
    FUNC *ftp;
    float *oscphase;

    if (*p->ifn > 0)
   	if ((ftp = ftfind(p->ifn)) == NULL)
	  return;
    p->ftp = ftp;

    if (p->auxch.auxp == NULL) {  /* if no buffers yet, alloc now */
        float *fltp;
        auxalloc((long)(MAXBINS+PVFFTSIZE) * sizeof(float), &p->auxch);
        fltp = (float *) p->auxch.auxp;
        p->oscphase = fltp;      fltp += MAXBINS;
        p->buf = fltp;
    }

    if (*p->ifilno == sstrcod) 
        strcpy(pvfilnam, p->STRARG); 
    else sprintf(pvfilnam,"pvoc.%d", (int)*p->ifilno);
    if ((mfp = p->mfp) == NULL
	|| strcmp(mfp->filename, pvfilnam) != 0) 
      if ( (mfp = ldmemfile(pvfilnam)) == NULL) {
	sprintf(errmsg,"PVADD cannot load %s", pvfilnam);
	goto pverr;
      }

    pvh = (PVSTRUCT *)mfp->beginp;
    if (pvh->magic != PVMAGIC) {
        sprintf(errmsg,"%s not a PVOC file (magic %ld)", 
                pvfilnam, pvh->magic );
        goto pverr;
    }

    p->frSiz = pvh->frameSize;
    frInc    = pvh->frameIncr;
    chans    = pvh->channels;
    if ((p->asr = pvh->samplingRate) != esr) { /* & chk the data */
        sprintf(errmsg,"%s''s srate = %8.0f, orch's srate = %8.0f",
                pvfilnam, p->asr, esr);
        warning(errmsg);
    }
    if (pvh->dataFormat != PVFLOAT) {
        sprintf(errmsg,"unsupported PV data format %ld in %s",
                pvh->dataFormat, pvfilnam);
        goto pverr;
    }
    if (p->frSiz > PVFRAMSIZE) {
        sprintf(errmsg,"PV frame %d bigger than %ld in %s",
                p->frSiz, PVFRAMSIZE, pvfilnam);
        goto pverr;
    }
    if (p->frSiz < PVFRAMSIZE/8) {
        sprintf(errmsg,"PV frame %ld seems too small in %s",
                p->frSiz, pvfilnam);
        goto pverr;
    }
    if (chans != 1) {
        sprintf(errmsg,"%d chans (not 1) in PVOC file %s",
                chans, pvfilnam);
        goto pverr;
    }
    p->frPtr = (float *) ((char *)pvh+pvh->headBsize);
    p->maxFr = -1 + ( pvh->dataBsize / (chans * (p->frSiz+2) * sizeof(float)));
       /* highest possible frame index */

    p->frPrtim = esr/((float)frInc);
       /* factor by which to mulitply 'real' time index to get frame index */

    size = pvfrsiz(p);
    p->prFlg = 1;    /* true */

    oscphase = p->oscphase;

    for (i=0; i < MAXBINS; i++)
	*oscphase++ = 0.0f;

    ibins = (*p->ibins==0 ? size/2 : (int)*p->ibins);
    p->maxbin = ibins + (int)*p->ibinoffset;
    p->maxbin = (p->maxbin > size/2 ? size/2 : p->maxbin);
    /*  printf("maxbin=%d\n", p->maxbin); fflush(stdout); */

     return;

pverr:  initerror(errmsg);
}

void pvadd(PVADD *p)
{
    float  *ar, *ftab;
    float frIndx;
    int    size = pvfrsiz(p);
    int i, binincr=(int)*p->ibinincr,  nsmps=ksmps;
    float amp, v1, fract, *oscphase;
    long phase, incr;
    FUNC *ftp;
    long lobits;

    if (p->auxch.auxp==NULL) {
      initerror("pvadd: not initialized");
      return;
    }

    ftp = p->ftp;
    if (ftp==NULL) {
          initerror("pvadd: not initialized");
          return;
    }

    if ((frIndx = *p->ktimpnt * p->frPrtim) < 0) {
        perferror("PVADD timpnt < 0");
        return;
    }
    if (frIndx > (float)p->maxFr) {  /* not past last one */
        frIndx = (float)p->maxFr;
        if (p->prFlg) {
            p->prFlg = 0;   /* false */
            warning("PVADD ktimpnt truncated to last frame");
	}
    }
    FetchIn(p->frPtr,p->buf,size,frIndx);
    p->buf[0] = 0.0f; p->buf[size] = 0.0f; /* kill spurious imag at dc & fs/2 */

    ar = p->rslt;
    for (i=0; i<nsmps; i++) *ar++ = 0.0f;
    oscphase = p->oscphase;
    for (i = (int)*p->ibinoffset; i < p->maxbin; i+=binincr) {
      lobits = ftp->lobits;  
      nsmps = ksmps;
      ar = p->rslt;
      phase = (long)*oscphase;
      incr=(long)(p->buf[i*2+1] * *p->kfmod * sicvt); 
      amp=p->buf[i*2];
      do {
	 fract = PFRAC(phase);
	 ftab = ftp->ftable + (phase >> lobits);
	 v1 = *ftab++;
	 *ar += (v1 + (*ftab - v1) * fract) * amp;
	 ar++;
	 phase += incr;
	 phase &= PMASK;
      } while (--nsmps);
      *oscphase = (float)phase;
      oscphase++;
   }
}
