#!/bin/sh 
#
# you may install Cecilia wherever suits you best, but 
# the recommended location is under the rootdir /usr/local, 
# as Cecilia automatically looks there for it's lib (as in
# /usr/lib) so nothing else is required for any user to run it.
#
# if your installation requires another location, you simply
# have to define a CEC_LIBRARY environment variable that points
# to where you have the cecilia library installed (for example: 
# setenv CEC_LIBRARY /home/joe/libs/Cecilia2.0_irix). Of 
# course, in a multi-user environment, make sure all your
# user's envs include the CEC_LIBRARY.
#
# on IRIX you may comment out the ftr flag if you don't want
# file type rules to be installed (the flag is harmless on
# other platforms)
#

### edit to taste ###
rootdir=/usr/local
ftrflag=1

### should not need to edit below ###

echo "You most likely need to be SuperUser to do this..." 

libdir=$rootdir/lib/cecilia
bindir=$rootdir/bin

echo "copying files in $rootdir" 

mkdir -p $libdir
cp -rp ./files   $libdir
cp -p  ./cecilia $bindir

# FTR on IRIX
if [ `uname` = "IRIX" -a -n "$ftrflag" ] 
then
    ./FTR/ftr_inst
fi

echo "done. cecilia is ready to run."

















