/********************************************************************************
 * Copyright (c) Erik Kunze 1995 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char rcsid[] = "$Id: loadsave.c,v 4.11 1998/02/01 13:25:11 erik Rel $";
#endif

#ifndef REGISTERED
#include <X11/keysym.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>
#include <assert.h>
#include "config.h"
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "util.h"
#include "dialog.h"
#include "tap.h"
#include "tzx.h"
#ifdef REGISTERED
#include "voc.h"
#include "vtp.h"
#endif
#include "loadsave.h"

#define PAGE_SIZE			17

static void tpRecordDestroy(void *);
#ifndef REGISTERED
static void tpDisplayPage(int);
#endif
static uns8 tpDummyGetNextBit(void);
static void tpCatchFault(int);


unsigned short TpState = TS_TRAPLOAD | TS_TRAPSAVE;


uns8 *TpInBegin;
uns8 *TpInEnd;
llist *TpInBlockList = NULL;
unsigned int TpInBlockCount = 0;
unsigned int TpInBlockCurrent = 0;
uns8 (*TpGetNextBit)(void) = tpDummyGetNextBit;

static char *tpInFn = NULL;
static char *tpOutFn = NULL;
static FILE *tpOutFp;
static jmp_buf tpEnv;

void
TpPatchRom(int model)
{
	uns16 loadAddr, saveAddr;
	int basicrom;
	switch (Machines[model].romType)
	{
		case ROM_STANDARD:
		case ROM_128:
		case ROM_PLUS2:
			loadAddr = 0x0556;
			saveAddr = 0x04C2;
			break;
#ifdef XZX_PLUS3
		case ROM_PLUS3:
			loadAddr = 0x0556;
			saveAddr = 0x04C6;
			break;
#endif
		default:
			return;
	}
	basicrom = Machines[model].basicRom;
	RealMemory[basicrom][loadAddr] = 0xed;
	RealMemory[basicrom][loadAddr + 1] = LOAD_BPT;
	RealMemory[basicrom][saveAddr] = 0xed;
	RealMemory[basicrom][saveAddr + 1] = SAVE_BPT;
}

void
TpLoadBlock(void)
{
	uns16 swap;
#ifdef DEBUG
	if (GETCFG(debug) & D_TAPE)
	{
		Msg(M_DEBUG, "%s request: id = %02x, addr = %04X, length = %5d",
			F & C_FLAG ? "load" : "verify", A, IX, DE);
	}
#endif

	if (!(TpState & (TS_TAPIN | TS_TZXIN | TS_VOCIN)))
	{
#ifdef REGISTERED
		(void)TpInsertTape("Load Tape", TO_READ | TO_TAP | TO_TZX | TO_VOC);
#else
		(void)TpInsertTape("Load Tape", TO_READ | TO_TAP | TO_TZX);
#endif
	}
	switch (TpState & (TS_TRAPLOAD | TS_TAPIN | TS_TZXIN | TS_VOCIN))
	{
		case TS_TRAPLOAD:

			PC = 0x0552;
			break;
		case TS_TRAPLOAD | TS_TAPIN:
			TapLoadBlock();
			break;
		default:


			D++;
			F = (F & C_FLAG) |
				(D & (S_FLAG | B5_FLAG | B3_FLAG)) |
				(D ? 0 : Z_FLAG) |
				(D & 0xf ? 0 : H_FLAG) |
				(D == 0x80 ? V_FLAG : 0);

			swap = AF; AF = AF1; AF1 = swap;
			break;
	}
}

void
TpSaveBlock(void)
{
#ifdef DEBUG
	if (GETCFG(debug) & D_TAPE)
	{
		Msg(M_DEBUG, "%stape saving: addr = %04X, length = %04X",
			A ? "headerless " : "",	IX, DE);
	}
#endif

	if (!(TpState & TS_TAPOUT))
	{
		(void)TpInsertTape("Save Tape", TO_WRITE | TO_TAP);
	}
	switch (TpState & (TS_TRAPSAVE | TS_TAPOUT))
	{
		case TS_TRAPSAVE:

			PC = 0x0552;
			break;
		case TS_TRAPSAVE | TS_TAPOUT:
			TapSaveBlock(tpOutFp);
			break;
		default:


		  Tstates += 2;
		  R = (R & 0x80) | (--R & 0x7f);
		  HL = 0x053f;
		  PC++;
		  break;
	}
}

int
TpInsertTape(char *title, int operation)
{
	char *fname;
	char *ext[3] = { NULL, NULL, NULL };
	int readonly;
	size_t size;
	struct sigaction newact, oldact;
	int i = 0, ret = -1;
	if (operation & TO_TAP)
	{
		ext[i++] = "tap";
	}
	if (operation & TO_TZX)
	{
		ext[i++] = "tzx";
	}
#ifdef REGISTERED
	if (operation & TO_VOC)
	{
		assert(operation & TO_READ);
		ext[i++] = "voc";
	}
#endif
	if (operation & TO_READ)
	{
		if (!(fname = FileSelector(title, 1, ext[0], ext[1], ext[2])))
		{
			return -1;
		}

		TpEjectTape(TO_READ);
		readonly = 1;
		TpInBegin = (uns8 *)Mmap(fname, 1, &readonly, &size);
		if (TpInBegin != (uns8 *)-1)
		{
			TpInEnd = TpInBegin + size;
			tpInFn = fname;

			newact.sa_handler = tpCatchFault;
			(void)sigemptyset(&newact.sa_mask);
#ifdef SA_RESTART
			newact.sa_flags = SA_RESTART;
#else
			newact.sa_flags = 0;
#endif
			(void)sigaction(SIGSEGV, &newact, &oldact);
			if (!setjmp(tpEnv))
			{
				switch (GetFileType(fname))
				{
					case FT_TAP:
						TpState |= TS_TAPIN;
						ret = TapNewFile();
						break;
					case FT_TZX:
						TpState |= TS_TZXIN;
						ret = TzxNewFile();
						break;
#ifdef REGISTERED
					case FT_VOC:
						TpState |= TS_VOCIN;
						ret = VocNewFile();
						break;
#endif
				}
			}
			else
			{

				Msg(M_ERR, "corrupted input file");
				ret = -1;
			}

			(void)sigaction(SIGSEGV, &oldact, NULL);
			if (ret != 0)
			{
				TpState &= ~(TS_TAPIN | TS_TZXIN | TS_VOCIN);
				Munmap((void *)TpInBegin, size);
				free(tpInFn);
				tpInFn = NULL;
				DestroyList(TpInBlockList, tpRecordDestroy);
				TpInBlockList = NULL;
				TpInBlockCount = 0;
				TpInBlockCurrent = 0;
			}
		}
		else
		{
			free(fname);
		}
	}
	else
	{
		if ((fname = FileSelector(title, 0, ext[0], ext[1], ext[2])))
		{

			TpEjectTape(TO_WRITE);

			if (!(tpOutFp = Fopen(fname, "wb")))
			{
				Msg(M_PERR, "couldn't open <%s> for writing", fname);
				free(fname);
			}
			else
			{
				TpState |= TS_TAPOUT;
				tpOutFn = fname;
				ret = 0;
			}
		}
	}
	return ret;
}

void
TpEjectTape(int operation)
{
	if (operation & TO_READ)
	{
		if (TpState & (TS_TAPIN | TS_TZXIN | TS_VOCIN))
		{

			TpGetNextBit = tpDummyGetNextBit;
			TpState &= ~(TS_TAPIN | TS_TZXIN | TS_VOCIN | TS_PLAY | TS_ERRIN |
						 TS_ENDIN);
			Munmap((void *)TpInBegin, (size_t)(TpInEnd - TpInBegin));
			free(tpInFn);
			tpInFn = NULL;
			DestroyList(TpInBlockList, tpRecordDestroy);
			TpInBlockList = NULL;
			TpInBlockCount = 0;
			TpInBlockCurrent = 0;
		}
	}
	else
	{
		if (TpState & TS_TAPOUT)
		{
			TpState &= ~(TS_TAPOUT | TS_ERROUT | TS_ENDOUT);
			(void)fclose(tpOutFp);
			free(tpOutFn);
			tpOutFn = NULL;
		}
	}
}

static void
tpRecordDestroy(void *entry)
{
	if (((tapeRecord *)entry)->str)
	{
		free(((tapeRecord *)entry)->str);
	}
}

char *
TpTapeName(int operation)
{
	return (operation == TO_READ ? tpInFn : tpOutFn);
}

void
TpStartPlayback(void)
{
	assert (TpState & (TS_TZXIN | TS_VOCIN)
			&& !(TpState & (TS_PLAY | TS_ERRIN | TS_ENDIN)));
	TpState |= TS_PLAY;
	switch (TpState & (TS_TZXIN | TS_VOCIN))
	{
		case TS_TZXIN:
			TpGetNextBit = TzxGetNextBit;
			TzxStartPlaying();
			break;
#ifdef REGISTERED
		case TS_VOCIN:
			TpGetNextBit = VocGetNextBit;
			VocStartPlaying();
			break;
#endif
	}
#ifdef REGISTERED
	VtpUpdate();
#endif
}

void
TpStopPlayback(void)
{
	assert(TpState & TS_PLAY);
	TpState &= ~TS_PLAY;
	TpGetNextBit = tpDummyGetNextBit;
#ifdef REGISTERED
	VtpUpdate();
#endif
}

#ifndef REGISTERED
void
TpBrowser(void)
{
	int item;
	int oldInDialog;
	assert(TpState & (TS_TAPIN | TS_TZXIN));

	oldInDialog = EnterOSD();

	{
		char *selectorText[PAGE_SIZE + 2];
		int i;
		selectorText[0] = "Browse Inputfile";
		for (i = 1; i <= NOPTS(selectorText); i++)
		{
			selectorText[i] = " ";
		}
		selectorText[i] = NULL;
		DisplayMenu(selectorText);
	}

	item = TpInBlockCurrent;
	tpDisplayPage(item / PAGE_SIZE);
	for (;;)
	{
		switch (BrowseList(&item, TpInBlockCount, PAGE_SIZE, tpDisplayPage))
		{

			case XK_Return:

				TpInBlockCurrent = item;
				if (item == TpInBlockCount - 1)
				{
					TpState |= TS_ENDIN;
				}
				else
				{
					TpState &= ~TS_ENDIN;
				}

			case XK_Escape:
				goto quit;
		}
	}
  quit:
	LeaveOSD(oldInDialog);
}
#endif

#ifndef REGISTERED
static void
tpDisplayPage(int page)
{
	int cnt;
	uns8 cursor_y = MENU_CURSOR_Y;
	tapeRecord *tr;
	uns8 attr = GetAttr();
	SetAttr(MENU_SELECT_ATTR);
	SetCursor(MENU_CURSOR_X + 1, cursor_y);
	DrawBox(COLS - 2 * (MENU_CURSOR_X + 1), PAGE_SIZE);

	for (cnt = page * PAGE_SIZE;
		 cnt < (page + 1) * PAGE_SIZE && cnt < TpInBlockCount;
		 cnt++)
	{
		tr = (tapeRecord *)RetrieveElemList(TpInBlockList, cnt);
		assert(tr !=  NULL);
		if (cnt == TpInBlockCurrent)
		{
			SetAttr(MENU_DISABLED_ATTR);
			PrintString(tr->str);
			SetAttr(MENU_SELECT_ATTR);
		}
		else
		{
			PrintString(tr->str);
		}
		SetCursor(MENU_CURSOR_X + 1, ++cursor_y);
	}

	SetAttr(attr);
}
#endif

static uns8
tpDummyGetNextBit(void)
{
	return 0;
}

static void
tpCatchFault(int signo)
{
	longjmp(tpEnv, -1);
}

