//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef VCSSCRIPT_HXX
#define VCSSCRIPT_HXX

class Properties;

#include "machine.hxx"

/**
  Objects of this class are VCS-Script interpreters.  They can read
  in a VCS-Script file, parse it, and evalute it.

  The parser has been hacked together pretty quickly and I'm sure it
  has several problems, however, it seems to behave pretty good
  on "correct" input.

  @author  Bradford W. Mott
  @version $Id: VCSScrpt.hxx,v 1.1 1997/05/17 19:04:13 bwmott Exp $
*/
class VCSScript
{
  public:
    /// Construct VCSScript object
    VCSScript();

    /// Destructor
    ~VCSScript();

  public:
    /// Evaluate the specified script using the supplied environment
    void evaluate(istream& stream, Properties& env);

  private:
    // Get the next token but don't discard it.  Answer true iff a valid
    // token was read.
    bool peekToken(char* token);

    // Set token to the next token and remove the token.
    // Answer true iff everything is okay.
    bool nextToken(char* token);

    // Skip the next list and any sub-lists within that list
    void skip(int level = 0);

    // Evalute the boolean expression that follows
    bool evaluateBooleanExpression(Properties& env);

    // Run the next statement
    void run(Properties& env);

  private:
    // File stream used to read script file with
    istream* myStream;

    // Buffer for a single token
    char myToken[256];

    // Indicates if the string in myToken is a valid token
    bool myTokenValid;

    // Indicates the current line number in the script file being processed
    uLong myLineNumber;
};
#endif

