
/*
 * LIB/ACTIVE.C	- dactive.kp active file support
 *
 */

#include "defs.h"

Prototype void InitDActive(const char *fileName);
Prototype void GenerateXRef(Buffer *b, const char *nglist, const char *npName);

KPDB *DActiveDB;

void 
InitDActive(const char *fileName)
{
    DActiveDB = KPDBOpen(fileName, O_RDWR);
    if (DActiveDB == NULL) {
	syslog(LOG_CRIT, "InitDActive, open failed: %s", fileName);
	exit(1);
    }
}

void 
GenerateXRef(Buffer *b, const char *nglist, const char *npName)
{
    const char *p = nglist;
    char group[MAXGNAME];

    bwrite(b, "Xref: ", 6);
    bwrite(b, npName, strlen(npName));
    while (*p) {
	int i;
	for (i = 0; p[i] && p[i] != ',' && p[i] != ' ' && p[i] != '\t'; ++i)
	    ;
	if (i == 0)
	    break;
	if (i < sizeof(group)) {
	    const char *rec;
	    int recLen;

	    bcopy(p, group, i);
	    group[i] = 0;
	    rec = KPDBReadRecord(DActiveDB, group, KP_LOCK, &recLen);
	    if (rec != NULL) {
		int flen;
		const char *f = KPDBGetField(rec, recLen, "NE", &flen, NULL);

		if (f) {
		    int n = (strtol(f, NULL, 10) + 1) & 0x7FFFFFFF;
		    char buf[16];

		    sprintf(buf, "%010d", n);
		    KPDBWrite(DActiveDB, group, "NE", buf, KP_UNLOCK);
		    bwrite(b, " ", 1);
		    bwrite(b, group, i);
		    bwrite(b, ":", 1);
		    sprintf(buf, "%d", n);
		    bwrite(b, buf, strlen(buf));
		} else {
		    KPDBUnlock(DActiveDB, rec);
		}
	    }
	}
	p += i;
	if (*p != ',')
	    break;
	++p;
    }
    bwrite(b, "\n", 1);
}

