
#include <lib/defs.h>
#include <sys/uio.h>

/*
 * MSG_ flags that may not be implemented on a particular OS
 */

#ifndef MSG_WAITALL
#define MSG_WAITALL	0
#endif
#ifndef MSG_EOR
#define MSG_EOR		0
#endif

/*
 *
 */

#define logit	syslog

struct ServReq;

#define THREAD_LISTEN	1	/* listening thread		*/
#define THREAD_DNS	2	/* dns resolver thread		*/
#define THREAD_READER	3	/* reader thread		*/
#define THREAD_SDNS	4	/* server dns resolver thread	*/

#define THREAD_NNTP	5	/* nntp connection		*/
#define THREAD_SPOOL	6	/* spool connection		*/
#define THREAD_POST	7	/* outgoing post		*/

#define OVERVIEW_FMT	"Subject:\r\nFrom:\r\nDate:\r\nMessage-ID:\r\nReferences:\r\nBytes:\r\nLines:\r\nXref:full\r\n"
#define MAXARTSINGROUP	3000
#define DEFARTSINGROUP	1024
#define OV_CACHE_MAX			8	/* open fd's for N groups */
#define MAX_OVERVIEW_CACHE_REGIONS      2       /* 256x2 = 512 articles   */

/*
 * ForkDesc - structure used to manage descriptors for select() threads
 */

typedef struct ForkDesc {
    char	*d_Id;		/* host name 		*/
    pid_t	d_Pid;
    int		d_Slot;		/* status reporting slot*/
    int		d_Fd;
    int		d_Type;
    int		d_FdPend;	/* save pending fd	*/
    int		d_Count;	/* active subthreads	*/
    void	*d_Data;
    struct sockaddr_in d_SaveRSin;
} ForkDesc;

/*
 * DnsReq/DnsRes - structures used to manage DNS lookups
 */

typedef struct DnsReq {
    struct sockaddr_in dr_LSin;
    struct sockaddr_in dr_RSin;
    char dr_AuthUser[16];
    char dr_AuthPass[16];
} DnsReq;

typedef struct DnsRes {
    int dr_Code;
    int dr_Flags;
    int dr_FetchPri;
    int dr_PushPri;
    int dr_GroupId;
    int dr_Reserved;
    struct in_addr dr_Addr;
    char dr_User[16];
    char dr_Host[64];
} DnsRes;

#define DF_FEED		0x00000001	/* f		*/
#define DF_READ		0x00000002	/* r		*/
#define DF_POST		0x00000004	/* p/w		*/
#define DF_FETCHSERVER	0x00000008	/* s#		*/
#define DF_PUSHSERVER	0x00000010	/* o#		*/
#define DF_GROUPID	0x00000020	/* g#		*/
#define DF_AUTHREQUIRED	0x00000040	/* a user=user pass=pass */
#define DF_VALID	0x40000000

/*
 * MBuf - structure used to manage read and write buffers
 */

typedef struct MBuf {
    struct MBuf *mb_Next;
    char	*mb_Buf;
    int		mb_Index;	/* finished index		*/
    int		mb_NLScan;	/* newline scan index 		*/
    int		mb_Size;
    int		mb_Max;
} MBuf;

typedef struct MBufHead {
    MBuf	*mh_MBuf;
    MemPool	**mh_MemPool;
    MemPool	**mh_BufPool;
    int		mh_Bytes;
    int		mh_Wait;
    int		mh_Fd;
    char	mh_REof;
    char	mh_WEof;
    char	mh_RError;
    char	mh_WError;
} MBufHead;

/*
 * Control - control.ctl 
 */

typedef struct Control {
    char	*ct_Msg;
    char	*ct_From;
    char	*ct_Groups;
    FILE	*ct_LogFo;
    long	ct_LogSeekPos;
    char	*ct_Verify;
    char	*ct_TmpFileName;
    int		ct_Flags;
} Control;

#define CTF_VERIFY	0x0001
#define CTF_EXECUTE	0x0002
#define CTF_DROP	0x0004
#define CTF_LOG		0x0008
#define CTF_MAIL	0x0010

/*
 * Connection - structure used to manage an NNTP connection
 *
 * note(1): Server requests are attached in two places:  The co_SReq in a 
 *	    THREAD_NNTP connection and the co_SReq in a THREAD_SPOOL or
 *	    THREAD_POST connection.
 */

typedef struct Connection {
    ForkDesc	*co_Desc;
    void	(*co_Func)(struct Connection *conn);
    int		(*co_ArtFuncHead)(struct Connection *conn, char *buf, int len);
    int		(*co_ArtFuncBody)(struct Connection *conn, char *buf, int len);
    const char	*co_State;
    MemPool	*co_MemPool;
    MemPool	*co_BufPool;
    MBufHead	co_TMBuf;
    MBufHead	co_RMBuf;
    int		co_FCounter;
    int		co_Flags;
    DnsRes	co_Auth;
    char	*co_AuthInfoUser;
    char	*co_AuthInfoPass;
    char	*co_GroupName;	/* current group or NULL	*/
    char	*co_IHaveMsgId;
    Control	*co_Ctl;	/* control lookup cache		*/
    struct ServReq *co_SReq;	/* see note(1)			*/
    const char *co_ListRec;
    int		co_ListRecLen;
    char	*co_ListPat;
    char	*co_ListHdrs;
    int		co_ListBegNo;
    int		co_ListEndNo;
    int		co_ArtMode;	/* current article mode		*/
    int		co_ArtNo;	/* current article number	*/
    int		co_ArtBeg;
    int		co_ArtEnd;

    MBufHead	co_ArtBuf;	/* article buffer		*/
} Connection;

#define COF_SERVER	0x00000001
#define COF_HEADFEED	0x00000002
#define COF_STREAM	0x00000004
#define COF_IHAVE	0x00000008	/* temporary ihave->takethis */
#define COF_POST	0x00000010	/* post command, else feed   */
#define COF_INHEADER	0x00000020	/* post/feed, reading headers*/
#define COF_DORANGE	0x00000040	/* do article range, else msgid */
#define COF_WASCONTROL	0x00000080
#define COF_CLOSESERVER 0x00010000	/* close server ASAP	     	*/
#define COF_PATISWILD	0x00020000	/* list pattern is wildcard	*/

#define MBUF_SIZE	1024

#define COM_ARTICLE	0
#define COM_BODY	1
#define COM_HEAD	2
#define COM_STAT	3
#define COM_BODYNOSTAT	4
#define COM_FUNC	5

#define COM_ACTIVE	6		/* list active			*/
#define COM_GROUPDESC	7		/* list newsgroups grouppat	*/

#define COM_XHDR	8
#define COM_XOVER	9
#define COM_XPAT	10

typedef struct ServReq {
    struct ServReq *sr_Next;	/* linked list of requests	*/
    Connection *sr_CConn;	/* client making request	*/
    Connection *sr_SConn;	/* server handling request	*/
    char	*sr_Group;	/* request related to group	*/
    char	*sr_MsgId;	/* request related to messageid	*/
    time_t	sr_Time;	/* time of request for timeout calc	*/
    FILE	*sr_Cache;	/* cache write (locked for duration)	*/
} ServReq;

#define SREQ_RETRIEVE	1
#define SREQ_POST	2


/*
 * Overview record.	over.groupname	(overview information - headers)
 *			numa.groupname	(article number assignment file)
 */

typedef struct OverArt {
    int         oa_ArtNo;       /* article number                       */
    int         oa_SeekPos;     /* seek in over.groupname file          */
    int		oa_Bytes;
    int		oa_Reserved2;
} OverArt;

typedef struct OverData {
    struct OverData *od_Next;
    int		od_HFd;
    int		od_ArtBase;
    int		od_HMapPos;
    int		od_HMapBytes;
    const char *od_HMapBase;
} OverData;

typedef struct OverInfo {
    struct OverInfo *ov_Next;
    int		ov_Refs;
    char        *ov_Group;
    int         ov_MaxArts;     /* maximum number of articles in group  */
    int		ov_Size;
    OverData	*ov_HData;	/* hdata file reference linked list	*/
    OverData	*ov_HCache;	/* last accessed file reference		*/
    int         ov_OFd;
    int		ov_OMapPos;
    int		ov_OMapBytes;
    const char *ov_OMapBase;
} OverInfo;

typedef struct ArtNumAss {
    struct ArtNumAss *an_Next;
    const char	     *an_GroupName;	/* NOT TERMINATED	*/
    int	 	     an_GroupLen;
    int		     an_ArtNo;
} ArtNumAss;

#include "protos.h"


