/*
 *	FILE:    repair.h
 *	PROGRAM: RAT
 *	AUTHOR:  Orion Hodson
 *
 * 	$Revision: 1.8 $
 * 	$Date: 1997/05/09 14:11:22 $
 *
 * Copyright (c) 1995,1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted, for non-commercial use only, provided
 * that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * Use of this software for commercial purposes is explicitly forbidden
 * unless prior written permission is obtained from the authors.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _REPAIR_H_
#define _REPAIR_H_

/* Fades by 0.2 in 160 linear steps */

#define FADE_SIZE          0.2
#define FADE_STEP          0.00125

#define NO_FADE            0
#define FADE_TO_LEFT       1
#define FADE_TO_RIGHT      2

#define REPAIR_NONE        0
#define REPAIR_REPEAT      1
#define REPAIR_WAVEFORM_PM 2

#define UNBOUND            0
#define BOUND              1

#define FORWARD           +1
#define BACKWARD          -1

typedef struct s_rep_seg {
        short start;
        short end;
} rep_seg;

void patch_dummy(int                      repair,
                 rx_interval_struct      *ip,
                 rx_queue_element_struct *up);
char *get_repair_name(int id);
int  get_previous_participant_audio(rx_interval_struct      *ip,
                                    rx_queue_element_struct *up,
                                    rx_queue_struct         *op); 
int  count_dummies_back(rx_interval_struct      *ip,
                        rx_queue_element_struct *up);
int  count_dummies_ahead(rx_interval_struct      *ip,
                        rx_queue_element_struct *up);
void repeat_previous(rx_queue_element_struct *pp,
                     rx_queue_element_struct *up);

#endif /* _REPAIR_H_ */

