/************************************************************************/
/* File   : callback.h				                        */
/* Purpose: callback module header		                        */
/* By     : Keith R. Davis				                */
/* Date   : 12/27/95				                        */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software			*/
/************************************************************************/

#ifndef _CALLBACK_H
#define _CALLBACK_H

#define NONE  0
#define TAB   1
#define SPACE 2
#define COMMA 3

void DeleteWindowCallback(Widget w, XtPointer clientdata, XtPointer callData);

void ConnectCallback(Widget w, XtPointer clientdata, XtPointer callData);
void ConnectCheckPassword(Widget text_w, XtPointer client_data, XtPointer call_data);
void ConnectOKCallback(Widget w, XtPointer clientData, XtPointer callData);
void ConnectCancelCallback(Widget w, XtPointer clientData, XtPointer callData);

void NewCallback(Widget w, XtPointer clientdata, XtPointer callData);

void OpenCallback(Widget w, XtPointer clientdata, XtPointer callData);
void OpenOKCallback(Widget w, XtPointer clientdata, XtPointer callData);
void OpenCancelCallback(Widget w, XtPointer clientdata, XtPointer callData);

void SaveCallback(Widget w, XtPointer clientdata, XtPointer callData);

void SaveAsCallback(Widget w, XtPointer clientdata, XtPointer callData);
void SaveAsOKCallback(Widget w, XtPointer clientdata, XtPointer callData);
void SaveAsCancelCallback(Widget w, XtPointer clientdata, XtPointer callData);

void CloseCallback(Widget w, XtPointer clientdata, XtPointer callData);
void ReallyQuitCallback(Widget w, XtPointer clientData, XtPointer callData);

void CutCallback(Widget w, XtPointer clientdata, XtPointer callData);
void CopyCallback(Widget w, XtPointer clientdata, XtPointer callData);
void PasteCallback(Widget w, XtPointer clientdata, XtPointer callData);
void ClearResultCallback(Widget w, XtPointer clientdata, XtPointer callData);


void SpoolCallback(Widget w, XtPointer clientdata, XtPointer callData);
void SpoolOKCallback(Widget w, XtPointer clientdata, XtPointer callData);

void SaveOptCallback(Widget w, XtPointer clientdata, XtPointer callData);

void AboutCallback(Widget w, XtPointer clientdata, XtPointer callData);

void PrintCallback(Widget w, XtPointer clientdata, XtPointer callData);
void PrintOKCallback(Widget w, XtPointer clientdata, XtPointer callData);

void ExecSQLCallback(Widget w, XtPointer clientdata, XtPointer callData);

void CascadeCallback(Widget w, XtPointer clientdata, XtPointer callData);
void BufferCallback(Widget w, XtPointer clientdata, XtPointer callData);

void TextModifiedCallback(int pos, int nInserted, int nDeleted, int nRestyled,
        char *deletedText, void *cbArg);

void DeleteBufferCallback(Widget w, XtPointer clientdata, XtPointer callData);
void DeleteBufferOKCallback(Widget w, XtPointer clientdata, XtPointer callData);

void HighlightToggleCallback(Widget w, XtPointer clientdata, XtPointer callData);

char GetColSeparator(void);
int  GetColSeparatorId(void);
void SetColSeparator(int sep_value);
int  GetAlignment(void);
void SetAlignment(int align_value);
int  GetType(void);
void SetType(int out_value);
int  GetHighlight(void);
void Sethighlight(int highlight_value);
	
#endif	
