.TH zpch2 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
zpch2 - Chebyshev analog filter
.SH CALLING SEQUENCE
.nf
[zeros,poles,gain]=zpch2(n,A,omegar)
.fi
.SH PARAMETERS
.TP 10
n
: integer : filter order
.TP
A
: real : attenuation in stop band (\fVA>1\fR)
.TP
omegar
: real : cut-off frequency in Hertz
.TP
zeros
: resulting filter zeros
.TP
poles
: resulting filter poles
.TP
gain
: Resulting filter gain
.SH DESCRIPTION
Poles and zeros of a type 2 Chebyshev analog filter
gain is the gain of the filter
.nf
H(s)=gain*poly(zeros,'s')/poly(poles,'s')
.fi
.SH AUTHOR
F.D.
