/* --------------------------------------------------------------------------
 * STG syntax, translation to STG code and STG code generator.
 *
 * This is experimental code that is disabled in normal releases.
 * This version is a crude prototype that I'm using to figure out
 * all the problems I have to solve.  Once I have the complete 
 * picture, I'll rewrite it more carefully - maybe even document it!
 * -- ADR
 *
 * Copyright (c) The University of Nottingham and Yale University, 1994-1997.
 * All rights reserved. See NOTICE for details and conditions of use etc...
 * Hugs version 1.4, December 1997
 *
 * $RCSfile: stg.c,v $
 * $Revision: 1.10 $
 * $Date: 1997/12/12 15:09:05 $
 * ------------------------------------------------------------------------*/

/* Temporary hack */
#define reverse(xs) xs
#define pmFail mkStgAltVar(NIL,NIL)

/* ----------------------------------------------------------------
 * ToDo: 
 *
 * Fix pmFail - or treat unbound altvar specially in codegen
 *
 * Representation
 * ~~~~~~~~~~~~~~
 * Replace STGVAR(Rhs,info) with AP(Rhs,info)?
 *
 * Freevar analysis
 * ~~~~~~~~~~~~~~~~
 *
 * Don't treat top level vars as free vars
 *
 * Translator
 * ~~~~~~~~~~
 * o Insert translation earlier - case of case translation is terrible
 *   - though it seems to be involved in deciding scope of Fatbar.
 * 
 * o Translate literal constant patterns such as Chars
 *
 * o Beta reduce uses of primops and constructors as we insert them
 *   so that optimisation pass isn't necessary for good code.
 *
 * o Kinds
 *   o Must tag variables with their kinds for benefit of code generator.
 *
 * o Primops
 *   o Support many more primops
 *   o Use argument and result kinds instead of assuming Int# in makeStgPrim
 *   o Note that some primops (eg error) don't need to be primCased - in
 *     fact, we could probably write them in Haskell!
 *   o Reduce need for an optimisation pass by always 
 *     reducing the resulting redex as we build it.  Ditto for constructors
 *
 * o Add TREX support back in
 *
 * o Consider modifying pmc to generate stg code directly.  Use the 
 *   time savings to pay for a single census-inline optimisation pass
 *   that cleans up trivial inefficiencies in the translator.
 *   
 * PrettyPrinter
 * ~~~~~~~~~~~~~
 * o Find a way to share code with output.c
 * o Figure out a plan for when to take a new line
 * 
 * Optimiser
 * ~~~~~~~~~
 * 
 * o float dictionary selection outwards in the hope of coalescing with
 *   other selections.  This would normally require strictness analysis
 *   but thats unnecessary for dictionaries.  Cost: closures may
 *   gain extra freevars
 * 
 * o implement Appel+Jim's constant time contract phase and Appel's
 *   cost/benefit analysis to trigger inlining of shared lambda bindings
 * 
 * o specialisation of overloaded functions to specific dictionaries.
 *   Just generate values like:
 * 
 *     foo_Int = foo {dict_Eq_Int}
 * 
 *   and replace occurences of foo {dict_Eq_Int} with foo_Int.  The 
 *   optimiser will do the rest.
 * 
 *   (This doesnt do quite as good a job as MPJs specialiser for
 *   examples covered by the monomorphism restriction.)
 *
 * o Float constants out to top level if they're in NF (not WHNF!)
 *   (eg "I# 1#" and "\ x y -> x" but not "id (I# 1#)")
 *   common up with identical constants
 *
 * o Float functions out as far as freevars allow
 *
 * 
 * Code generator
 * ~~~~~~~~~~~~~~
 * 
 * o Instructions for pushing info-ptrs should be flexible enough to
 *   allow efficient implementation of fromEnum/toEnum.
 * o Use hash-consing of generated code to reduce code size.
 * o Build info tables for constructors
 * o Optimisations:
 *   o let f = \ x -> e in e'  ==>  e'[f/cgRhs(f)] if fvs(f) = {}
 *     Alternatively lift out all supercombinators to top level during
 *     optimisation and treat specially there.
 *   o let x = f{a,b,c} in e   ==>  alloc x 4; push* [c,b,a,f]; mkAP x 4; e
 *     That is, we don't generate a BCO for the application.
 *     Note that this changes the size of the object so it's not just a
 *     peephole optimisation
 *   o let x = y in e  =>   e[y/x]
 *     Beware when x=y!  Best done in optimisation prepass
 *   o push m+1; push a_1; ... push a_m; slide m+1 m+1
 *     ===>
 *     push a_1; ... push a_m; slide m m
 * 
 * ---------------------------------------------------------------- */


/* This is the main entry point */
static Void local stgDefn Args((Name, Int, Cell));

/* ---------------------------------------------------------------- */

#if DEBUG_PRINTER
Void print Args((Cell, Int));
#endif

/* Start of code copied from output.c */

/* --------------------------------------------------------------------------
 * Basic output routines:
 * ------------------------------------------------------------------------*/

static FILE *outputStream;             /* current output stream        	   */
static Int  outColumn = 0;             /* current output column number 	   */
				       				       
#define OPEN(b)    if (b) putChr('('); 				       
#define CLOSE(b)   if (b) putChr(')'); 				       
				       				       
static Void local putChr(c)            /* print single character       	   */
Int c; {			       				       
    Putc(c,outputStream);	       				       
    outColumn++;		       				       
}				       				       
				       				       
static Void local putStr(s)            /* print string                 	   */
String s; {			       				       
    for (; *s; s++) {		       				       
        Putc(*s,outputStream);	       				       
        outColumn++;		       				       
    }				       				       
}				       				       
				       				       
static Void local putInt(n)            /* print integer                	   */
Int n; {
    static char intBuf[16];
    sprintf(intBuf,"%d",n);
    putStr(intBuf);
}

/* --------------------------------------------------------------------------
 * Precedence values (See Haskell 1.3 report, p.12):
 * ------------------------------------------------------------------------*/

#define ALWAYS      FUN_PREC           /* Always use parens (unless atomic)*/
                                       /* User defined operators have prec */
                                       /* in the range MIN_PREC..MAX_PREC  */
#define ARROW_PREC  MAX_PREC           /* for printing -> in type exprs    */
#define COCO_PREC   (MIN_PREC-1)       /* :: is left assoc, low precedence */
#define COND_PREC   (MIN_PREC-2)       /* conditional expressions          */
#define WHERE_PREC  (MIN_PREC-3)       /* where expressions                */
#define LAM_PREC    (MIN_PREC-4)       /* lambda abstraction               */
#define NEVER       LAM_PREC           /* Never use parentheses            */

/* --------------------------------------------------------------------------
 * Indentation and showing names/constants
 * ------------------------------------------------------------------------*/

static Void local pIndent        Args((Int));
static Void local unlexVar       Args((Text));
static Void local unlexCharConst Args((Cell));
static Void local unlexStrConst  Args((Text));

static Void local pIndent(n)           /* indent to particular position    */
Int n; {
    outColumn = n;
    while (0<n--) {
        Putc(' ',outputStream);
    }
}

static Void local unlexVar(t)          /* print text as a variable name    */
Text t; {                              /* operator symbols must be enclosed*/
    String s = textToStr(t);           /* in parentheses... except [] ...  */

    if ((isascii(s[0]) && isalpha(s[0])) || s[0]=='_' || s[0]=='[' || s[0]=='(')
        putStr(s);
    else {
        putChr('(');
        putStr(s);
        putChr(')');
    }
}

static Void local unlexCharConst(c)
Cell c; {
    putChr('\'');
    putStr(unlexChar(c,'\''));
    putChr('\'');
}

static Void local unlexStrConst(t)
Text t; {
    String s            = textToStr(t);
    static Char SO      = 14;          /* ASCII code for '\SO'             */
    Bool   lastWasSO    = FALSE;
    Bool   lastWasDigit = FALSE;
    Bool   lastWasEsc   = FALSE;

    putChr('\"');
    for (; *s; s++) {
        String ch = unlexChar(*s,'\"');
        Char   c  = ' ';

        if ((lastWasSO && *ch=='H') ||
                (lastWasEsc && lastWasDigit && isascii(*ch) && isdigit(*ch)))
            putStr("\\&");

        lastWasEsc   = (*ch=='\\');
        lastWasSO    = (*s==SO);
        for (; *ch; c = *ch++)
            putChr(*ch);
        lastWasDigit = (isascii(c) && isdigit(c));
    }
    putChr('\"');
}


/* --------------------------------------------------------------------------
 * End of code copied from output.c
 * ------------------------------------------------------------------------*/


/* STG Syntax:
 * 
 *   Rhs  -> STGCON   (Con, [Atom])
 *         | LAMBDA   ([Var],Expr)     -- all vars bound to NIL
 *   	   | Expr
 *   	  
 *   Expr -> LETREC   ([Var],Expr)     -- Vars contain their bound value
 *         | LETALT   (AltVar,Expr)
 *         | AltVar                    -- must not escape into a binding!
 *   	   | CASE     (Expr,[Alt],Default)
 *         | PRIMCASE (Expr,[Var],Expr)
 *         | STGPRIM  (Prim,[Atom])
 *   	   | STGAPP   (Var, [Atom]) 
 *         | Var                       -- Abbreviation for STGAPP(Var,[])
 *   
 *   Atom -> Var
 *   	   | CHAR                      -- unboxed
 *         | INT                       -- unboxed
 *         | BIGNUM                    -- unboxed
 *         | FLOAT                     -- unboxed
 *         | STRING                    -- boxed? unboxed?
 *   
 *   Var    -> STGVAR    (Rhs,info)    -- Use pointer equality to distinguish
 *   AltVar -> STGALTVAR (Expr,info)   -- Use pointer equality to distinguish
 *
 *   Alt     -> (Discr,[Var],Expr)     -- all vars bound to NIL
 *   Default -> (Var,Expr)
 *            | NIL
 * 
 * The info field of a Var is used as follows in various phases:
 * 
 * Translation: unused
 * Free variable analysis: 
 *   unused before
 *   let bindings contains freevar lists after
 *   freevar lists may be shared between several vars
 * Code generation: 
 *   freevar lists before
 *
 * letAlt corresponds to SLPJs let-no-escape.  It should be generalised
 * to allow a lambda (but not a constructor) on the rhs.
 */

typedef Cell   StgRhs;
typedef Cell   StgExpr;
typedef Cell   StgAtom;
typedef Cell   StgVar;
typedef Cell   StgAltVar;
typedef Triple StgCaseAlt;
typedef Pair   StgDefault;
typedef Cell   StgDiscr;

#define mkStgLet(binds,body) ap(LETREC,pair(binds,body))
#define stgLetBinds(e)       fst(snd(e))
#define stgLetBody(e)        snd(snd(e))

#define mkStgVar(e,info) ap(STGVAR,pair(e,info))
#define stgVarBody(e)    fst(snd(e))
#define stgVarInfo(e)    snd(snd(e))

#define mkStgLetAlt(bind,body) ap(LETALT,pair(bind,body))
#define stgLetAltBind(e)       fst(snd(e))
#define stgLetAltBody(e)       snd(snd(e))

#define mkStgAltVar(e,info) ap(STGALTVAR,pair(e,info))
#define stgAltVarBody(e)    fst(snd(e))
#define stgAltVarInfo(e)    snd(snd(e))

#define mkStgCase(scrut,alts,defalt) ap(CASE,triple(scrut,alts,defalt))
#define stgCaseScrut(e)       fst3(snd(e))
#define stgCaseAlts(e)        snd3(snd(e))
#define stgCaseDefault(e)     thd3(snd(e))

#define mkStgCaseAlt(discr,vs,e) triple(discr,vs,e)
#define stgCaseAltDiscr(alt)     fst3(alt)
#define stgCaseAltVars(alt)      snd3(alt)
#define stgCaseAltBody(alt)      thd3(alt)

#define mkStgDefault(v,e)   pair(v,e)
#define stgDefaultVar(def)  fst(def)
#define stgDefaultBody(def) snd(def)

#define mkStgPrimCase(scrut,vs,body) ap(PRIMCASE,triple(scrut,vs,body))
#define stgPrimCaseScrut(e) fst3(snd(e))
#define stgPrimCaseVars(e)  snd3(snd(e))
#define stgPrimCaseBody(e)  thd3(snd(e))

/* NB: We occasionally rely on the fact that STGAPP, STGPRIM and STGCON
 * all have the same structure.
 */
#define mkStgApp(fun,args) ap(STGAPP,pair(fun,args))
#define stgAppFun(e)       fst(snd(e))
#define stgAppArgs(e)      snd(snd(e))

#define mkStgPrim(op,args) ap(STGPRIM,pair(op,args))
#define stgPrimOp(e)       fst(snd(e))
#define stgPrimArgs(e)     snd(snd(e))

#define mkStgCon(con,args) ap(STGCON,pair(con,args))
#define stgConCon(e)       fst(snd(e))
#define stgConArgs(e)      snd(snd(e))

#define mkStgLambda(args,body) ap(LAMBDA,pair(args,body))
#define stgLambdaArgs(e)       fst(snd(e))
#define stgLambdaBody(e)       snd(snd(e))

/* ---------------------------------------------------------------- */

typedef struct {
    String  name;
    String  args;
    String  results;
} StgPrim;

StgPrim StgPrims[] = {
    { "primPlusInt", "II", "I" },
    { 0,0,0 }
};

static StgPrim* local findPrimitive Args((Name));

static StgPrim* local findPrimitive(n)
Name n; {
    Text t = name(n).text;
    Int i;
    for(i=0; StgPrims[i].name; ++i) {
        if (findText(StgPrims[i].name) == t) {
            return &StgPrims[i];
        }
    }
    return 0;
}


/* --------------------------------------------------------------------------
 * Utility functions for manipulating STG syntax trees.
 * ------------------------------------------------------------------------*/

static List    local makeArgs    Args((Int));
static Bool    local isStgVar    Args((StgRhs));
static Bool    local isAtomic    Args((StgRhs));
static StgRhs  local makeStgPrim Args((Name,String,String));

static List local makeArgs( Int n )
{
    List args = NIL;
    for(; n>0; --n) {
        args = cons(mkStgVar(NIL,NIL),args);
    }
    return args;
}

static Bool local isStgVar(e)
StgRhs e; {
    switch (whatIs(e)) {
    case STGVAR:
            return TRUE;
    default:
            return FALSE;
    }
}

static Bool local isAtomic(e) 
StgRhs e; {
    switch (whatIs(e)) {
    case STGVAR:
    case CHARCELL:
    case INTCELL:
    case POSNUM:
    case ZERONUM:
    case NEGNUM:
    case FLOATCELL:
    case STRCELL:
            return TRUE;
    default:
            return FALSE;
    }
}

/* Generate wrapper for primop based on list of arg types and result types:
 *
 * makeStgPrim op# "II" "II" =
 *   \ x y -> "case x of { I# x# -> 
 *             case y of { I# y# -> 
 *             case op#{x#,y#} of { r1# r2# ->
 *             let r1 = I# r1#; r2 = I# r2# in
 *             (r1, r2)
 *             }}}"
 */
static StgRhs local makeStgPrim(op,a_kinds,r_kinds)
Name op;
String a_kinds;
String r_kinds; {
    StgExpr e = NIL;
    List as   = NIL;
    List vs   = NIL;
    List args = NIL;
    List rs   = NIL;
    List bs   = NIL;

    /* box results */
    for(; *r_kinds; ++r_kinds) {
        Cell v = mkStgVar(NIL,NIL); /* unboxed result */
        Cell bv = mkStgVar(mkStgCon(nameMkI,singleton(v)),NIL); /* boxed */
        rs = cons(v,rs);
        bs = cons(bv,bs);
    }
    /* Construct tuple of results */
    if (length(bs) == 0) {
        e = nameUnit;
    } else if (length(bs) == 1) {
        e = mkStgLet(bs,hd(bs));
    } else {
        StgVar r = mkStgVar(mkStgCon(mkTuple(length(bs)),bs),NIL); /* result tuple */
        e = mkStgLet(cons(r,bs),r);
    }
    
    /* make vars into which we'll unbox arguments */
    for(; *a_kinds; ++a_kinds) {
        Cell bv = mkStgVar(NIL,NIL); /* boxed arg */
        Cell nv = mkStgVar(NIL,NIL); /* unboxed arg */
        args = cons(bv,args);
        as   = cons(nv,as);
        vs   = cons(nv,vs);
    }

    /* generate the call */
    e = mkStgPrimCase(mkStgPrim(op,revOnto(as,NIL)),revOnto(rs,NIL),e);
        
    /* unbox the args */
    for(as=args; nonNull(as); as=tl(as),vs=tl(vs)) {
        StgVar arg = hd(as);
        StgVar v   = hd(vs); /* unboxed var */
        StgCaseAlt alt = mkStgCaseAlt(nameMkI, singleton(v), e);
        e = mkStgCase(arg,singleton(alt),NIL);
    }

    /* abstract out the args */
    return mkStgLambda(args,e);
}    

/* --------------------------------------------------------------------------
 * Free variable analysis
 * ------------------------------------------------------------------------*/

static List local freeVarsBind    Args((List, StgVar));
static List local freeVarsAlt     Args((List, StgCaseAlt));
static List local freeVarsExpr    Args((List, StgExpr));
static List local freeVarsAtom    Args((List, StgAtom));
static List local freeVarsVar     Args((List, StgVar));

static List local freeVarsBind( List acc, StgVar v )
{
    StgRhs rhs = stgVarBody(v);
    List fvs = NIL;
    switch (whatIs(rhs)) {
    case STGCON:
            mapAccum(freeVarsAtom,fvs,stgConArgs(rhs));
            break;
    case LAMBDA:
            fvs = diffList(freeVarsExpr(fvs,stgLambdaBody(rhs)),stgLambdaArgs(rhs));
            break;
    default:
            fvs = freeVarsExpr(fvs,rhs);
            break;
    }
    stgVarInfo(v) = fvs;
    mapAccum(freeVarsVar,acc,fvs); /* copy onto acc */
    return acc;
}

static List local freeVarsAlt( List acc, StgCaseAlt alt )
{
    return diffList(freeVarsExpr(acc,stgCaseAltBody(alt)),
                    stgCaseAltVars(alt));
}

static List local freeVarsExpr( List acc, StgExpr e )
{
    switch (whatIs(e)) {
    case LETREC:
            mapAccum(freeVarsBind,acc,stgLetBinds(e));
            return diffList(freeVarsExpr(acc,stgLetBody(e)),stgLetBinds(e));
    case LETALT:
            return freeVarsExpr(freeVarsBind(acc,stgLetAltBind(e)),
                                stgLetAltBody(e));
    case STGALTVAR:
            return acc;  // ToDo: is this right?
    case CASE:
            mapAccum(freeVarsAlt,acc,stgCaseAlts(e));
            if (nonNull(stgCaseDefault(e))) {
                StgDefault d = stgCaseDefault(e);
                acc=deleteCell(freeVarsExpr(acc,stgDefaultBody(d)),
                               stgDefaultVar(d));
            }
            return freeVarsExpr(acc,stgCaseScrut(e));
    case PRIMCASE:
            return freeVarsExpr(diffList(freeVarsExpr(acc,stgPrimCaseBody(e)),
                                         stgPrimCaseVars(e)),
                                stgPrimCaseScrut(e));
    case STGPRIM:
            mapAccum(freeVarsAtom,acc,stgPrimArgs(e));
            /* primop is not a var */
            return acc;
    case STGAPP:
            mapAccum(freeVarsAtom,acc,stgAppArgs(e));
            return freeVarsExpr(acc,stgAppFun(e));
    case STGVAR:
            return freeVarsVar(acc, e);
    default:
            internal("freeVarsExpr");
    }
}

static List local freeVarsAtom( List acc, StgAtom a)
{
    switch (whatIs(a)) {
    case STGVAR:
            return freeVarsVar(acc,a);
    default:
            return acc;
    }
}

static List local freeVarsVar( List acc, StgVar v)
{
    if (cellIsMember(v,acc)) {
        return acc;
    } else {
        return cons(v,acc);
    }
}

/* --------------------------------------------------------------------------
 * Pretty printer for stg code:
 * ------------------------------------------------------------------------*/

static Void local printStg( FILE *fp, StgVar b);

static Void local putStgAltVar    Args((StgAltVar));
static Void local putStgVar       Args((StgVar));
static Void local putStgVars      Args((List));
static Void local putStgBinds     Args((List));
static Void local putStgExpr      Args((Int,Cell));
static Void local putStgRhs       Args((Cell));
static Void local putStgDiscr     Args((Cell,List));

static Void local putStgAltVar( StgAltVar v ) 
{
    putStr("alt");
    putInt(-v);
}

static Void local putStgVar(StgVar v) 
{
    putStr("id");
    putInt(-v);
}

static Void local putStgVars( List vs )
{
    for(; nonNull(vs); vs=tl(vs)) {
        putStgVar(hd(vs));
        putChr(' ');
    }
}

static Void local putStgAtom( StgAtom a )
{
    switch (whatIs(a)) {
    case STGVAR: 
            putStgVar(a);
            break;
    case CHARCELL: 
            unlexCharConst(charOf(a));
            putChr('#');
            break;
    case INTCELL: 
            putInt(intOf(a));
            putChr('#');
            break;
#if BIGNUMS
    case NEGNUM:
    case ZERONUM:
    case POSNUM: 
        {   
            List xs = bigOut(a,NIL,FALSE);
            for (; nonNull(xs); xs=tl(xs))
                putChr(charOf(arg(hd(xs))));
        }
    putChr('#');
    break;
#endif
    case FLOATCELL: 
            putStr(floatToString(floatOf(a)));
            putChr('#');
            break;
    case STRCELL: 
            unlexStrConst(textOf(a));
            break;
    default: 
            fprintf(stderr,"\nYoiks: "); printExp(stderr,a);
            internal("putStgAtom");
    }
}

static Void local putStgAtoms( List as )
{
    putChr('{');
    while (nonNull(as)) {
        putStgAtom(hd(as));
        as=tl(as);
        if (nonNull(as)) {
            putChr(',');
        }
    }
    putChr('}');
}

static Void local putStgDiscr(d,vs)        /* pretty print discriminator    */
Cell d; 
List vs; {
    switch (whatIs(d)) {
#if NPLUSK
    case ADDPAT:
            putStgVar(hd(vs));
            putChr('+');
            putInt(intValOf(d));
            break;
#endif
    case NAME:
        { 
            unlexVar(name(d).text);
            for (; nonNull(vs); vs=tl(vs)) {
                putChr(' ');
                putStgVar(hd(vs));
            }
            break;
        }
    case TUPLE: 
        { 
            putChr('(');
            putStgVar(hd(vs));
            vs=tl(vs);
            while (nonNull(vs)) {
                putChr(',');
                putStgVar(hd(vs));
                vs=tl(vs);
            }
            putChr(')');
            break;
        }
    case STGVAR: 
            putStgVar(d);
            break;
    case CHARCELL: 
            unlexCharConst(charOf(d));
            break;
    default: 
            fprintf(stderr,"\nYoiks: "); printExp(stderr,d);
            internal("putStgDiscr");
    }
}

static Void local putStgBinds(binds)        /* pretty print locals           */
List binds; {
    Int left = outColumn;

    putStr("let { ");
    while (nonNull(binds)) {
        Cell bind = hd(binds);
        putStgVar(bind);
        putStr(" = ");
#if 0 /* Only if freevar info is valid */
        putStr("{");
        putStgVars(stgVarInfo(bind));
        putStr("}");
#endif
        putStgRhs(stgVarBody(bind));
        binds = tl(binds);
        if (nonNull(binds))
            pIndent(left+6);
    }
    putStr("\n");
    pIndent(left);
    putStr("} in  ");
}

static Void local putStgExpr(d,e)          /* pretty print expr in context of  */
Int  d;                                /* operator of precedence d         */
Cell e; {
    switch (whatIs(e)) {
    case LETREC: 
            OPEN(d>WHERE_PREC);
            putStgBinds(stgLetBinds(e));
            putStgExpr(WHERE_PREC+1, stgLetBody(e));
            CLOSE(d>WHERE_PREC);
            break;
    case LETALT: 
        { 
            Int left;
            OPEN(d>WHERE_PREC);
            left = outColumn;
            putStr("letalt ");
            putStgAltVar(stgLetAltBind(e));
            putStr(" = ");
            putStgRhs(stgAltVarBody(stgLetAltBind(e)));
            putStr(" in\n");
            pIndent(left);
            putStgExpr(WHERE_PREC+1, stgLetAltBody(e));
            CLOSE(d>WHERE_PREC);
            break;
        }
    case STGALTVAR:
            putStgAltVar(e);
            break;
    case CASE: 
        {  
            Int  left = outColumn;
            List alts = stgCaseAlts(e);
            putStr("case ");
            putStgExpr(NEVER,stgCaseScrut(e));
            if (length(alts) == 1 && isNull(stgCaseDefault(e))) {
                StgCaseAlt alt = hd(alts);
                putStr(" of { ");
                putStgDiscr(stgCaseAltDiscr(alt),stgCaseAltVars(alt));
                putStr(" ->\n");
                pIndent(left);
                putStgExpr(NEVER,stgCaseAltBody(alt));
                putStr("\n");
                pIndent(left);
                putStr("}\n");
            } else {
                putStr(" of {\n");
                for (; nonNull(alts); alts=tl(alts)) {
                    StgCaseAlt alt = hd(alts);
                    pIndent(left+2);
                    putStgDiscr(stgCaseAltDiscr(alt),stgCaseAltVars(alt));
                    putStr(" -> ");
                    putStgExpr(NEVER,stgCaseAltBody(alt));
                    putStr("\n");
                }
                if (nonNull(stgCaseDefault(e))) {
                    StgDefault d = stgCaseDefault(e);
                    pIndent(left+2);
                    putStgVar(stgDefaultVar(d));
                    putStr(" -> ");
                    putStgExpr(NEVER,stgDefaultBody(d));
                    putStr("\n");
                }
                pIndent(left);
                putStr("}\n");
            }
            break;
        }
    case PRIMCASE:
        { 
            Int  left = outColumn;
            putStr("case# ");
            putStgExpr(NEVER,stgPrimCaseScrut(e));
            putStr(" of { ");
            putStgVars(stgPrimCaseVars(e));
            putStr("->\n");
            pIndent(left);
            putStgExpr(NEVER,stgPrimCaseBody(e));
            pIndent(left);
            putStr("}\n");
            break;
        }
    case STGPRIM: 
        {
            Cell op = stgPrimOp(e);
            if (isSelect(op)) {
                putStr("#");
                putInt(selectOf(op));
            } else {
                unlexVar(name(op).text);
            }
            putStgAtoms(stgPrimArgs(e));
            break;
        }
    case STGAPP: 
            putStgVar(stgAppFun(e));
            putStgAtoms(stgAppArgs(e));
            break;
    case STGVAR: 
            putStgVar(e);
            break;
    default: 
            fprintf(stderr,"\nYoiks: "); printExp(stderr,e);
            internal("putStgExpr");
    }
}

static Void local putStgRhs(e)            /* print lifted definition         */
Cell   e; {
    switch (whatIs(e)) {
    case STGCON:
        {
            Name   con  = stgConCon(e);
            List   args = stgConArgs(e);
            if (isTuple(con)) {
                putStr("Tuple");
                putInt(tupleOf(con));
            } else {
                unlexVar(name(con).text);
            }
            putChr('{');
            while (nonNull(args)) {
                putStgAtom(hd(args));
                args=tl(args);
                if (nonNull(args)) {
                    putChr(',');
                }
            }
            putChr('}');
            break;
        }
    case LAMBDA:
        {   
            Int left = outColumn;
            putStr("\\ ");
            putStgVars(stgLambdaArgs(e));
            putStr("->\n");
            pIndent(left+2);
            putStgRhs(stgLambdaBody(e));
            break;
        }
    default: 
            putStgExpr(NEVER,e);
            putStr(";\n");
            break;
    }
}

Void printStg(fp,b)              /* Pretty print sc defn on fp      */
FILE  *fp;
StgVar b; {
    outputStream = fp;
    putChr('\n');
    outColumn = 0;
    putStgVar(b);
    putStr(" = ");
    putStgRhs(stgVarBody(b));
}

#if DEBUG_PRINTER
Void ppStg( StgVar v )
{
    printStg(stdout,v);
}
#endif

/* --------------------------------------------------------------------------
 * Translator: generates stg code from output of pattern matching
 * compiler.
 * ------------------------------------------------------------------------*/

static StgVar  local stgOffset       Args((Offset,List));
static StgVar  local stgText         Args((Text,List));
static StgRhs  local stgRhs          Args((Cell,Int,List));
static StgExpr local stgExpr         Args((Cell,Int,List,StgExpr));

/* ---------------------------------------------------------------- */

/* Association list storing globals assigned to dictionaries, tuples, etc */
static List stgGlobals = NIL;

static StgVar local getSTGTupleVar  Args((Cell));
static StgVar local getSTGDictVar   Args((Cell));
static StgVar local getSTGSelectVar Args((Cell));
static StgVar local getSTGMemberVar Args((Name));
static StgVar local getSTGConVar    Args((Name));
static StgVar local getSTGPrimVar   Args((Name));

static StgVar local getSTGTupleVar(t)
Cell t; {
    Pair p = cellAssoc(t,stgGlobals);
    if (isNull(p)) {
        List    args = makeArgs(tupleOf(t));
        StgVar  tv   = mkStgVar(mkStgCon(t,args),NIL);
        StgExpr e    = mkStgLet(singleton(tv),tv);
        StgRhs  rhs  = mkStgLambda(args,e);
        StgVar  v    = mkStgVar(rhs,NIL);
        p = pair(t,v);
        stgGlobals = cons(p,stgGlobals);
    }
    return snd(p);
}

static StgVar local getSTGDictVar(d)
Cell d; {
    Pair p = cellAssoc(d,stgGlobals);
    if (isNull(p)) {
        StgVar v = mkStgVar(NIL,NIL);  /* ToDo: bind to something */
        p = pair(d,v);
        stgGlobals = cons(p,stgGlobals);
    }
    return snd(p);
}

static StgVar local getSTGSelectVar(sel) /* Used to get dictionary fields */
Cell sel; {
    Pair p = cellAssoc(sel,stgGlobals);
    if (isNull(p)) {
        StgVar  arg = mkStgVar(NIL,NIL);
        StgVar  nv  = mkStgVar(NIL,NIL);
        StgExpr e   = mkStgPrimCase(mkStgPrim(sel,singleton(arg)),singleton(nv),nv);
        StgRhs  rhs = mkStgLambda(singleton(arg),e);
        StgVar  v   = mkStgVar(rhs,NIL);
        p = pair(sel,v);
        stgGlobals = cons(p,stgGlobals);
    }
    return snd(p);
}

static StgVar local getSTGMemberVar(n)
Name n; {
    StgVar  arg = mkStgVar(NIL,NIL);
    StgVar  nv  = mkStgVar(NIL,NIL);
    StgExpr e   = mkStgPrimCase(mkStgPrim(mkSelect(mfunOf(n)),singleton(arg)),singleton(nv),nv);
    StgRhs  rhs = mkStgLambda(singleton(arg),e);
    StgVar  v   = mkStgVar(rhs,NIL);
    stgGlobals = cons(pair(n,v),stgGlobals); /* hack to make it print out */
    name(n).stgVar = v;
    return v;
}

static StgVar local getSTGConVar(n)
Name n; {
    if (name(n).arity > 0) {
        List    args = makeArgs(name(n).arity);
        StgVar  con  = mkStgVar(mkStgCon(n,args),NIL);
        StgExpr e    = mkStgLet(singleton(con),con);
        StgRhs  rhs  = mkStgLambda(args,e);
        StgVar  v    = mkStgVar(rhs,NIL);
        name(n).stgVar = v;
        return v;
    } else {
        StgVar v = mkStgVar(mkStgCon(n,NIL),NIL);
        name(n).stgVar = v;
        return v;
    }
}

static StgVar local getSTGPrimVar( n )
Name n; {
    StgPrim* p = findPrimitive(n);
    StgVar   v   = NIL;
    if (p) {
        StgRhs rhs = makeStgPrim(n,p->args,p->results);
        v = mkStgVar(rhs,NIL);
        stgGlobals=cons(pair(n,v),stgGlobals);  /* so it will get codegened */
    } else {
        v = mkStgVar(NIL,NIL);
    }
    name(n).stgVar = v;
    return v;
}

/* ---------------------------------------------------------------- */

static Cell local stgOffset(Offset o, List sc)
{
    Cell r = cellAssoc(o,sc);
    if (nonNull(r)) {
        return snd(r);
    }
#if DEBUG_PRINTER
    Printf("\nSTGOffset failed: ");
    print(sc,20);
#endif
    internal("stgOffset");
}

static Cell local stgText(Text t,List sc)
{
    List xs = sc;
    for (; nonNull(xs); xs=tl(xs)) {
        Cell x = hd(xs);
        Cell v = fst(x);
        if (!isOffset(v) && t == textOf(v)) {
            return snd(x);
        }
    }
#if DEBUG_PRINTER
    Printf("\nSTGText failed: ");
    print(sc,20);
#endif
    internal("stgText");
}

/* ---------------------------------------------------------------- */

static StgRhs local stgRhs(e,co,sc)
Cell e; 
Int  co; 
List sc; {
    switch (whatIs(e)) {

    /* Identifiers */
    case OFFSET:
            return stgOffset(e,sc);
    case VARIDCELL:
    case VAROPCELL:
            return stgText(textOf(e),sc);
    case DICTCELL:
            return getSTGDictVar(e);
    case TUPLE: 
            return getSTGTupleVar(e);
    case SELECT: 
            return getSTGSelectVar(e);
    case NAME:
            if (nonNull(name(e).stgVar)) {
                return name(e).stgVar;
            } else if (isMfun(e)) { /* member */
                return getSTGMemberVar(e);
            } else if (isCfun(e)) { /* constructor */
                return getSTGConVar(e);
            } else if (name(e).primDef) { /* primop */
                return getSTGPrimVar(e);
            } else {
                internal("stgRhs1");
            }

    /* Literals */
    case CHARCELL:
            return mkStgCon(nameMkC,singleton(e));
    case INTCELL:
            return mkStgCon(nameMkI,singleton(e));
#if BIGNUMS
    case POSNUM:
    case ZERONUM:
    case NEGNUM:
            return mkStgCon(nameMkJ,singleton(e));
#endif
    case FLOATCELL:
            return mkStgCon(nameMkF,singleton(e));
    case STRCELL:
            return e;

    case AP:
            if (fun(e) == mkSelect(0)) {
                return stgRhs(arg(e),co,sc);
            } else {
                return stgExpr(e,co,sc,pmFail);
            }
    default:
            return stgExpr(e,co,sc,pmFail);
    }
}

static StgExpr local stgExpr(e,co,sc,failExpr)
Cell e; 
Int  co; 
List sc; 
StgExpr failExpr; 
{
    switch (whatIs(e)) {
    case COND:
        {
            StgCaseAlt then_alt = mkStgCaseAlt(nameTrue,NIL,stgExpr(snd3(snd(e)),co,sc,failExpr));
            StgCaseAlt else_alt = mkStgCaseAlt(nameFalse,NIL,stgExpr(thd3(snd(e)),co,sc,failExpr));
            return mkStgCase(stgExpr(fst3(snd(e)),co,sc,pmFail),
                             cons(then_alt,cons(else_alt,NIL)),
                             NIL);
        }
    case GUARDED:
        {   
            List guards = reverse(snd(e));
            e = failExpr;
            for(; nonNull(guards); guards=tl(guards)) {
                Cell g   = hd(guards);
                Cell c   = stgExpr(fst(g),co,sc,pmFail);
                Cell rhs = stgExpr(snd(g),co,sc,failExpr);
                e = c == nameTrue  /* ToDo: I don't think this ever succeeds */
		  ? rhs   /* deletes dead code */
		  : mkStgCase(c,doubleton(mkStgCaseAlt(nameTrue,NIL,rhs),
					  mkStgCaseAlt(nameFalse,NIL,e)),
			      NIL);
            }
            return e;
        }
    case FATBAR:
        {
            StgExpr e2 = stgExpr(snd(snd(e)),co,sc,failExpr);
            StgAltVar alt = mkStgAltVar(e2,NIL);
            return mkStgLetAlt(alt,stgExpr(fst(snd(e)),co,sc,alt));
        }
    case CASE:
        {   
            List alts  = snd(snd(e));
            Cell scrut = stgExpr(fst(snd(e)),co,sc,pmFail);
            List as    = NIL;
            for(; nonNull(alts); alts=tl(alts)) {
                StgCaseAlt alt = hd(alts);
                StgDiscr   d   = fst(alt);
                Int  da  = discrArity(d);
                Cell altsc = sc;
                Cell vs  = NIL;
                Int  i;
                for(i=1; i<=da; ++i) {
                    StgVar nv = mkStgVar(NIL,NIL);
                    vs    = cons(nv,vs);
                    altsc = cons(pair(mkOffset(co+i),nv),altsc);
                }
                alt = mkStgCaseAlt(d, vs, stgExpr(snd(alt),co+da,altsc,failExpr));
                as = cons(alt,as);
            }
            return mkStgCase(scrut, revOnto(as,NIL), mkStgDefault(mkStgVar(NIL,NIL),failExpr));
        }
    case NUMCASE:
        {
            Triple nc    = snd(e);
            Offset o     = fst3(nc);
            Cell   discr = snd3(nc);
            Cell   r     = thd3(nc);
            Cell   scrut = stgOffset(o,sc);
            Cell   h     = getHead(discr);
            Int    da    = discrArity(discr);
                
            if (!isName(h) || argCount != 2) {
                internal("stgExpr: n+k pattern");
            } else {
                Cell   n     = arg(discr);
                Cell   dict  = arg(fun(discr));
                StgExpr d    = NIL;
                List   binds = NIL;
                Cell   test   
                    = h == nameFromInt     ? namePmInt
                    : h == nameFromInteger ? namePmInteger
                    :                        namePmFlt;
                Name   box
                    = h == nameFromInt     ? nameMkI
                    : h == nameFromInteger ? nameMkJ 
                    :                        nameMkF;
                StgCaseAlt alt   = NIL;
                Cell   altsc = sc;
                Cell   vs    = NIL;
                Int    i;

                for(i=1; i<=da; ++i) {
                    Cell nv = mkStgVar(NIL,NIL);
                    vs    = cons(nv,vs);
                    altsc = cons(pair(mkOffset(co+i),nv),altsc);
                }
                alt = mkStgCaseAlt(nameTrue,NIL,stgExpr(r,co+da,altsc,failExpr));
                test = name(test).stgVar;

                /* bind dictionary */
                d = stgRhs(dict,co,sc);
                if (!isAtomic(d)) { /* wasn't atomic */
                    d = mkStgVar(d,NIL);
                    binds = cons(d,binds);
                }
                /* bind number */
                n = mkStgVar(mkStgCon(box,singleton(n)),NIL);
                binds = cons(n,binds);

                test = mkStgLet(binds,
                                mkStgApp(test, cons(d,cons(n,cons(scrut,NIL)))));
                return mkStgCase(test,singleton(alt),mkStgDefault(mkStgVar(NIL,NIL),failExpr));
            }
        }
    case LETREC:
        {
            List binds = NIL;
            List vs = NIL;
            List bs;
            /* allocate variables, extend scope */
            for(bs = snd(fst(snd(e))); nonNull(bs); bs=tl(bs)) {
                Cell nv  = mkStgVar(NIL,NIL);
                sc = cons(pair(fst3(hd(bs)),nv),sc);
                binds = cons(nv,binds);
                vs = cons(nv,vs);
            }
            vs = revOnto(vs,NIL);
            for(bs = fst(fst(snd(e))); nonNull(bs); bs=tl(bs)) {
                Cell nv  = mkStgVar(NIL,NIL);
                sc = cons(pair(mkOffset(++co),nv),sc);
                binds = cons(nv,binds);
                vs = cons(nv,vs);
            }
            /* transform expressions */
            for(bs = fst(fst(snd(e))); nonNull(bs); bs=tl(bs), vs=tl(vs)) {
                Cell rhs = hd(bs);
                Cell nv  = hd(vs);
                stgVarBody(nv) = stgRhs(rhs,co,sc);
            }
            /* transform functions */
            for(bs = snd(fst(snd(e))); nonNull(bs); bs=tl(bs), vs=tl(vs)) {
                Cell fun = hd(bs);
                Cell nv  = hd(vs);
                List as = NIL;
                List funsc = sc;
                Int  arity = intOf(snd3(fun));
                Int  i;
                for(i=1; i<=arity; ++i) {
                    Cell nv = mkStgVar(NIL,NIL);
                    as = cons(nv,as);
                    funsc = cons(pair(mkOffset(co+i),nv),funsc);
                }
                stgVarBody(nv) = mkStgLambda(as,stgExpr(thd3(thd3(fun)),co+arity,funsc,pmFail));
            }
            return mkStgLet(binds,stgRhs(snd(snd(e)),co,sc));
        }
    default: /* convert to an StgApp or StgVar plus some bindings */
        {   
            List args  = NIL;
            List binds = NIL;
            List as    = NIL;

            /* Unwind args */
            while (isAp(e)) {
                Cell arg = arg(e);
                e        = fun(e);
                if (mkSelect(0) == e) { /* Trivial short circuit */
                    e = arg;
                } else {
                    args = cons(arg,args);
                }
            }

            /* Special cases */
            if (e == nameSel && length(args) == 3) {
                Cell   con   = hd(args);
                StgVar var   = stgOffset(hd(tl(args)),sc);
                Int    index = intOf(hd(hd(tl(args))));
                Int    da    = discrArity(con);
                List   vs    = NIL;
                Int    i;
                for(i=1; i<=da; ++i) {
                    Cell nv = mkStgVar(NIL,NIL);
                    vs=cons(nv,vs);
                }
                return mkStgCase(var,
                                 singleton(mkStgCaseAlt(con,vs,nth(index-1,vs))),
                                 pmFail);
            }
            
            /* Arguments must be StgAtoms */
            for(as=args; nonNull(as); as=tl(as)) {
                StgRhs a = stgRhs(hd(as),co,sc);
                if (!isAtomic(a)) {
                    a     = mkStgVar(a,NIL);
                    binds = cons(a,binds);
                }
                hd(as) = a;
            }

            /* Function must be StgVar */
            e = stgRhs(e,co,sc);
            if (!isStgVar(e)) {
                e = mkStgVar(e,NIL);
                binds = cons(e,binds);
            }

            if nonNull(args) {
                e = mkStgApp(e,args);
            }
            if nonNull(binds) {
                e = mkStgLet(binds,e);
            }
            return e;
        }
    }
}

static Void local stgDefn(n,arity,e)
Name n;
Int  arity;
Cell e; {
    List vs = NIL;
    List sc = NIL;
    Int i;
    if (debugCode) {
        printf("%s", textToStr(name(n).text)); 
        for (i = arity; i > 0; i--) {
            printf(" o%d", i);
        }
        printf(" = ");
        printExp(stdout,e); 
        printf("\n");
    }
    for (i = 1; i <= arity; ++i) {
        Cell nv = mkStgVar(NIL,NIL);
        vs = cons(nv,vs);
        sc = cons(pair(mkOffset(i),nv),sc);
    }
    e = stgExpr(e,arity,sc,pmFail);
    if (nonNull(vs)) {
        if (whatIs(e) == LAMBDA) {
            stgLambdaArgs(e) = appendOnto(vs,stgLambdaArgs(e));
        } else {
            e = mkStgLambda(vs,e);
        }
    }
    stgVarBody(name(n).stgVar) = e;
}

/* --------------------------------------------------------------------------
 * Optimiser for stg code:
 * This code has suffered massive bit-rot!
 * ------------------------------------------------------------------------*/

#if 0
static Cell local stgOptimise   Args((Cell));

static Cell local stgOptimise(e)
Cell e; {
redo:
    switch (whatIs(e)) {
#if 0
    case AP: 
        {   
            Cell f = stgOptimise(fun(e));
            Cell a = stgOptimise(arg(e));
            if (isSelect(f) && whatIs(a) == DICTCELL) {
                Cell m = selectOf(f) == 0 ? a : dictGet(a,selectOf(f));
                if (getHead(m) != nameMakeMem) {
                    e = m;
                    goto redo; /* danger of inf loop! */
                }
            } else if (isName(f) && isMfun(f) && whatIs(a) == DICTCELL) {
                Cell m = dictGet(a,mfunOf(f));
                if (getHead(m) != nameMakeMem) {
                    e = m;
                    goto redo;
                }
            }
            fun(e) = f;
            arg(e) = a;
            break;
        }
#endif
    case STGAPP:
            break;
    case STGVAR:
        {
            Cell x = stgVarBody(e);
            switch (whatIs(x)) {
            case NAME:   /* atomic expressions */
            case STGVAR: 
                    e = x;
                    break;
            default     : 
                    break;
            }
            break;
        }
    case NAME:
        {
            if (nonNull(name(e).stgVar)) {
                e = name(e).stgVar;
                goto redo;
            }
            break;
        }
    case CASE: 
        {
            Cell scrut = stgOptimise(stgCaseScrut(e));
            List alts  = stgCaseAlts(e);
            for(; nonNull(alts); alts=tl(alts)) {
                StgCaseAlt alt = hd(alts);
                stgCaseAltBody(alt) = stgOptimise(stgCaseAltBody(alt));
            }
            stgCaseScrut(e) = scrut;
            break;
        }
    case LETREC: 
        {   
            List binds = stgLetBinds(e);
            for(; nonNull(binds); binds=tl(binds)) {
                Cell bind = hd(binds);
                stgVarBody(bind) = stgOptimise(stgVarBody(bind));
            }
            stgLetBody(e) = stgOptimise(stgLetBody(e));
            break;
        }
    case LAMBDA: 
        {
            stgLambdaBody(e) = stgOptimise(stgLambdaBody(e));
            break;
        }
    default :
            break;
    }
    return e;
}

#endif

#if 1
/* --------------------------------------------------------------------------
 * Code generator
 * ------------------------------------------------------------------------*/

static Void local enter( Void );
static Void local primop( Name op );
static Void local primReturn( Void );
static Void local pushVar( StgVar v );
static Void local cgChar( Char c );
static Void local cgInt( Int i );
static Void local cgFloat( Float f );
#if 0
static Void local cgDouble( Double f );
#endif
static Void local cgString( String s );
static Void local cgAlloc( Int size );
static Void local pushCon( Name con );
static Void local buildCon( Int size );
static Void local buildPAP( Int size );
static Void local buildAP( Int size );
static Void local cgArgCheck( List args );
static Void local pushAlts( List alts );

/* --------------------------------------------------------------------------
 * 
 * ------------------------------------------------------------------------*/

#define OUT(s) printf("\t%s\n", #s)

static Void local enter( )
{
  OUT(slide);
  OUT(enter);
}

static Void local primop( Name op )
{
  OUT(primop);
}

static Void local primReturn( )
{
  OUT(primReturn);
}

static Void local pushVar( StgVar v )
{
    switch (whatIs(v)) {
    case STGVAR:
            OUT(pushVar);
            break;
    default:
            print(v,10);
            internal("pushVar");
            break;
    }
}

static Void local cgChar( Char c )
{
  OUT(cgChar);
}

static Void local cgInt( Int i )
{
  OUT(cgInt);
}

static Void local cgFloat( Float f )
{
  OUT(cgFloat);
}

#if 0
static Void local cgDouble( double d )
{}
#endif

static Void local cgString( String s )
{
  OUT(cgString);
}

static Void local cgAlloc( Int size )
{
  OUT(cgAlloc);
}

static Void local pushCon( Name con )
{
  OUT(pushCon);
}

static Void local buildCon( Int size )
{
  OUT(buildCon);
}

static Void local buildPAP( Int size )
{
  OUT(buildPAP);
}

static Void local buildAP( Int size )
{
  OUT(buildAP);
}

static Void local cgArgCheck( List args )
{
  OUT(cgArgCheck);
}

static Void local pushAlts( List alts )
{
  OUT(pushAlts);
}
    
/* --------------------------------------------------------------------------
 * 
 * ------------------------------------------------------------------------*/

static Void local pushAtom( StgAtom atom );
static Void local alloc( StgRhs rhs );
static Void local build( StgRhs rhs );
static Void local cgRhs( StgRhs rhs );
static Void local cgAlts( List alts, StgDefault d );
static Void local cgPrimAlt( List vs, StgExpr e );
static Void local cg( StgExpr e );

/* --------------------------------------------------------------------------
 * 
 * ------------------------------------------------------------------------*/

static Void local pushAtom( StgAtom e )
{
    switch (whatIs(e)) {
    case STGVAR: 
            pushVar(e);
            break;
    case CHARCELL: 
            cgChar(charOf(e));
            break;
    case INTCELL: 
            cgInt(intOf(e));
            break;
    case FLOATCELL: 
            cgFloat(floatOf(e));
            break;
#if 0
    case DOUBLECELL: 
            cgDouble(doubleOf(e));
            break;
#endif
    case STRCELL: 
            cgString(textToStr(textOf(e)));
            break;
#if BIGNUMS
    case NEGNUM:
    case ZERONUM:
    case POSNUM: 
            internal("Nae bignums yet, Jimmy!");
            break;
#endif
    case SELECT:
            OUT(cgSelect); /* only here to cope with stgApp(#7,dict) */
            break;
    case TUPLE:
            OUT(cgTuple); /* only here to cope with tuples */
            break;
    default: 
            fprintf(stderr,"\nYoiks: "); printExp(stderr,e);
            internal("pushAtom");
    }
}

static Void local alloc( StgVar v )
{
    StgRhs rhs = stgVarBody(v);
    List   fvs = stgVarInfo(v);
    switch (whatIs(rhs)) {
    case STGCON:
            cgAlloc(length(stgConArgs(rhs)));
            break;
    case LAMBDA:
            cgAlloc(length(fvs));
            break;
    default:
            cgAlloc(length(fvs));
            break;
    }
}

static Void local build( StgVar v )
{
    StgRhs rhs = stgVarBody(v);
    List   fvs = stgVarInfo(v);
    switch (whatIs(rhs)) {
    case STGCON:
            mapProc(pushAtom,reverse(stgConArgs(rhs)));
            pushCon(stgConCon(rhs));
            buildCon(length(stgConArgs(rhs)));
            break;
    case LAMBDA:
            mapProc(pushVar,fvs);
            cgRhs(rhs);
            buildPAP(length(fvs));
            break;
    default:
            mapProc(pushVar,fvs);
            cgRhs(rhs);
            buildAP(length(fvs));
            break;
    }
}

static Void local cgRhs( StgRhs rhs )
{
    OUT(BeginBCO);
    switch (whatIs(rhs)) {
    case LAMBDA:
            cgArgCheck(stgLambdaArgs(rhs));
            cg(stgLambdaBody(rhs));
            break;
    default:
            cg(rhs);
            break;
    }
    OUT(EndBCO);
}

static Void local cgAlts( List alts, StgDefault d )
{
    OUT(BeginAlts);
    for(; nonNull(alts); alts=tl(alts)) {
        StgCaseAlt alt = hd(alts);
        OUT(TEST);
        cg( stgCaseAltBody(alt) );
    }
    if (nonNull(d)) {
        cg( stgDefaultBody(d) );
    }        
    OUT(EndAlts);
}

static Void local cgPrimAlt( List vs, StgExpr e )
{
    OUT(BeginPrimAlt);
    cg(e);
    OUT(EndPrimAlt);
}

static Void local cg( StgExpr e )
{
    switch (whatIs(e)) {
    case LETREC:
            mapProc(alloc,stgLetBinds(e));
            mapProc(build,stgLetBinds(e));
            cg(stgLetBody(e));
            break;
    case LETALT:
            cgRhs(stgAltVarBody(stgLetAltBind(e)));
            cg(stgLetAltBody(e));
            break;
    case STGALTVAR:
            OUT(JUMP);
            break;
    case CASE:
            cgAlts(stgCaseAlts(e),stgCaseDefault(e));  /* should push alts */
            cg( stgCaseScrut(e) );
            break;
    case PRIMCASE:
        {
            StgExpr scrut = stgPrimCaseScrut(e);
            if (whatIs(scrut) == STGPRIM) {
                mapProc(pushAtom,reverse(stgPrimArgs(scrut)));
                primop(stgPrimOp(scrut));
                /* ToDo: bind stgPrimCaseVars(e) to results */
                cg( stgPrimCaseBody(e) );
            } else {
                /* ToDo: push ret addr */
                cgPrimAlt( stgPrimCaseVars(e), stgPrimCaseBody(e) );
                cg( scrut );
            }
            break;
        }
    case STGAPP: /* Tail call */
            mapProc(pushAtom,reverse(stgAppArgs(e)));
            pushVar(stgAppFun(e));
            enter();
            break;
    case STGVAR: /* Tail call - special case with no args */
            pushVar(e);
            enter();
            break;
    case STGPRIM: /* Tail call again */
            mapProc(pushAtom,reverse(stgPrimArgs(e)));
            primop(stgPrimOp(e));
            primReturn();
            break;
    default:
            fprintf(stderr,"\nYoiks: "); printExp(stderr,e);
            internal("cg");
    }
}

#endif

/* --------------------------------------------------------------------------
 * 
 * ------------------------------------------------------------------------*/

static Void local stgCGBinds(binds)
List binds; {
    for(; nonNull(binds); binds=tl(binds)) {
        StgVar bind = hd(binds);
#if 0
        stgVarBody(bind) = stgOptimise(stgVarBody(bind));
#endif
	    printStg(stdout,bind);
        freeVarsBind(NIL,bind);   /* fill in free var info */
	    cgRhs(stgVarBody(bind));
    }
}

/*-------------------------------------------------------------------------*/
