----------------------------------------------------------------
-- A minimal Prelude - not much use but it's got all the things
-- the compiler expects too see.
-- Note that the compiler also derives instances for tuples
-- so expect to see that code come through the codegen too.
----------------------------------------------------------------

module Prelude where

infixr 9  .
infixl 7  *, /, `quot`, `rem`, `div`, `mod`, :%
infixl 6  +, -
infixr 5  :, ++
infix  4  ==, /=, <, <=, >=, >
infixr 3  &&
infixr 2  ||
infixl 1  >>, >>=
infixr 0  `seq`

----------------------------------------------------------------
-- Temporary additions go here - these are compiled first so
-- it's a good place to put the current experiment
----------------------------------------------------------------

{-
x1 = x1

x2 = let x = x in x
x3 = let f x = x in f
x4 = let x = [] in x


f [x] = 'a'
f []  = 'b'

g = 'a'

primitive primPlusInt :: Int -> Int -> Int

f3 = primPlusInt 1 2

plus x y = x + y == x

f4 = []

f5 = ('a','b')

foo x y z = x (y z)

bar :: Int -> Bool
bar x = case x of { 0 -> True; 1 -> False }

-- fatbar test
baz p x | p x = True
baz p 0 = False

-- nested case test
f1 x = case x of 
       (y:ys) -> case ys of 
                 (z:zs) -> z
       [] -> 'a'

f2 x = case x of
       (y:z:zs) -> z
       [] -> 'b'
-}

----------------------------------------------------------------
-- Wired in functions
----------------------------------------------------------------

(&&) :: Bool -> Bool -> Bool
False && x   = False
True  && x   = x

(||) :: Bool -> Bool -> Bool
False || x   = x
True  || x   = True

lex :: ReadS String
lex = lex

(.) :: (b -> c) -> (a -> b) -> (a -> c)
(f . g) x = f (g x)

id :: a -> a
id x = x

flip           :: (a -> b -> c) -> b -> a -> c
flip f x y      = f y x

fst            :: (a,b) -> a
fst (x,_)       = x

snd            :: (a,b) -> b
snd (_,y)       = y

otherwise :: Bool
otherwise = True

primitive error  :: String -> a

undefined        :: a
undefined | False = undefined

showField    :: Show a => String -> a -> ShowS
showField m v s = s

showParen    :: Bool -> ShowS -> ShowS
showParen b p s = s

readParen    :: Bool -> ReadS a -> ReadS a
readParen b g r = []

readField    :: Read a => String -> ReadS a
readField m s0 = []

rationalToFloat  :: Rational -> Float
floatToRational  :: Float  -> Rational
doubleToRational :: Double -> Rational
intToRatio :: Integral a => Int -> Ratio a
doubleToRatio :: Integral a => Double -> Ratio a

rationalToFloat = undefined
floatToRational  = undefined 
doubleToRational = undefined
intToRatio       = undefined
doubleToRatio    = undefined




----------------------------------------------------------------
-- Wired in classes
----------------------------------------------------------------

class Eq a where
    (==), (/=) :: a -> a -> Bool

class (Eq a) => Ord a where
    compare                :: a -> a -> Ordering
    (<), (<=), (>=), (>)   :: a -> a -> Bool
    max, min               :: a -> a -> a

class Ord a => Bounded a where
    minBound, maxBound :: a

class (Eq a, Show a, Eval a) => Num a where
    (+), (-), (*)  :: a -> a -> a
    negate         :: a -> a
    abs, signum    :: a -> a
    fromInteger    :: Integer -> a
    fromInt        :: Int -> a

class (Num a, Ord a) => Real a where
    toRational     :: a -> Rational

class (Real a, Enum a) => Integral a where
    quot, rem, div, mod :: a -> a -> a
    quotRem, divMod     :: a -> a -> (a,a)
    even, odd           :: a -> Bool
    toInteger           :: a -> Integer
    toInt               :: a -> Int

class (Num a) => Fractional a where
    (/)          :: a -> a -> a
    recip        :: a -> a
    fromRational :: Rational -> a
    fromDouble   :: Double -> a

class (Fractional a) => Floating a where
    pi                  :: a
    exp, log, sqrt      :: a -> a
    (**), logBase       :: a -> a -> a
    sin, cos, tan       :: a -> a
    asin, acos, atan    :: a -> a
    sinh, cosh, tanh    :: a -> a
    asinh, acosh, atanh :: a -> a

class (Real a, Fractional a) => RealFrac a where
    properFraction   :: (Integral b) => a -> (b,a)
    truncate, round  :: (Integral b) => a -> b
    ceiling, floor   :: (Integral b) => a -> b

class (RealFrac a, Floating a) => RealFloat a where
    floatRadix       :: a -> Integer
    floatDigits      :: a -> Int
    floatRange       :: a -> (Int,Int)
    decodeFloat      :: a -> (Integer,Int)
    encodeFloat      :: Integer -> Int -> a
    exponent         :: a -> Int
    significand      :: a -> a
    scaleFloat       :: Int -> a -> a
    isNaN, isInfinite, isDenormalized, isNegativeZero, isIEEE
		     :: a -> Bool

class (Ord a) => Ix a where
    range                :: (a,a) -> [a]
    index                :: (a,a) -> a -> Int
    inRange              :: (a,a) -> a -> Bool
    rangeSize            :: (a,a) -> Int

    rangeSize r@(l,u)
             | l > u      = 0
             | otherwise  = index r u + 1

class Enum a where
    toEnum               :: Int -> a
    fromEnum             :: a -> Int
    enumFrom             :: a -> [a]              -- [n..]
    enumFromThen         :: a -> a -> [a]         -- [n,m..]
    enumFromTo           :: a -> a -> [a]         -- [n..m]
    enumFromThenTo       :: a -> a -> a -> [a]    -- [n,n'..m]

    enumFromTo x y        = map toEnum [ fromEnum x .. fromEnum y ]
    enumFromThenTo x y z  = map toEnum [ fromEnum x, fromEnum y .. fromEnum z ]



type ReadS a = String -> [(a,String)]
type ShowS   = String -> String

class Read a where
    readsPrec :: Int -> ReadS a
    readList  :: ReadS [a]

class Show a where
    showsPrec :: Int -> a -> ShowS
    showList  :: [a] -> ShowS

class Functor f where
    map :: (a -> b) -> (f a -> f b)

class Monad m where
    (>>=)  :: m a -> (a -> m b) -> m b
    return :: a -> m a
    (>>)   :: m a -> m b -> m b

class Monad m => MonadZero m where
    zero   :: m a

class MonadZero m => MonadPlus m where
    (++)   :: m a -> m a -> m a

class Eval a where
    strict :: (a -> b) -> a -> b
    seq    :: a -> b -> b

----------------------------------------------------------------
-- Wired in types and instances
----------------------------------------------------------------

data Void      -- Void type has only one element, namely bottom.

-- data () = () deriving (Eq, Ord, Ix, Enum, Read, Show, Bounded)

instance Eq ()
instance Ord ()
instance Ix ()
instance Enum ()
instance Read ()
instance Show ()
instance Bounded ()

data Bool    = False | True

data Char               -- builtin datatype of ISO Latin characters
type String = [Char]    -- strings are lists of characters

instance Eq      Char  
instance Ord     Char 
instance Enum    Char
instance Ix      Char 
instance Read    Char
instance Show    Char
instance Bounded Char

data Maybe a = Nothing | Just a

instance Functor   Maybe 
instance Monad     Maybe 
instance MonadZero Maybe
instance MonadPlus Maybe 

data Either a b = Left a | Right b

data Ordering = LT | EQ | GT

-- data [a] = [] | a : [a] 

instance Eq a  => Eq [a]
instance Ord a => Ord [a]
instance Functor   [] 
instance Monad     []
instance MonadZero []
instance MonadPlus []
instance Read a => Read [a]
instance Show a => Show [a]

-- data (a,b) = (a,b) deriving (Eq, Ord, Ix, Read, Show)
-- etc..

instance Show (a -> b)
instance Functor ((->) a)

data Int

instance Eq       Int     
instance Ord      Int     
instance Num      Int 
instance Bounded  Int
instance Real     Int
instance Integral Int 
instance Ix       Int
instance Enum     Int
instance Read     Int
instance Show     Int

data Integer

instance Eq       Integer 
instance Ord      Integer 
instance Num      Integer
instance Real     Integer 
instance Integral Integer
instance Ix       Integer
instance Enum     Integer 
instance Read     Integer
instance Show     Integer

data Float

instance Eq         Float  
instance Ord        Float  
instance Num        Float 
instance Real       Float
instance Fractional Float 
instance Floating   Float 
instance RealFrac   Float 
instance RealFloat  Float
instance Enum       Float  
instance Read       Float  
instance Show       Float  

data Double    -- builtin datatype of double precision floating point numbers

instance Eq    	    Double 
instance Ord   	    Double 
instance Num   	    Double
instance Real  	    Double
instance Fractional Double
instance Floating   Double
instance RealFrac   Double
instance RealFloat  Double
instance Enum       Double 
instance Read       Double 
instance Show       Double 

-- Standard functions on rational numbers {PreludeRatio} --------------------

data Integral a => Ratio a = a :% a
type Rational              = Ratio Integer

instance Integral a => Eq   (Ratio a) 
instance Integral a => Ord  (Ratio a) 
instance Integral a => Num  (Ratio a)
instance Integral a => Real (Ratio a)
instance Integral a => Fractional (Ratio a) 
instance Integral a => RealFrac (Ratio a)
instance Integral a => Enum (Ratio a) 
instance (Read a, Integral a) => Read (Ratio a)
instance Integral a => Show (Ratio a)

-- Monadic I/O: --------------------------------------------------------------

--data IO a             -- builtin datatype of IO actions
data IOError            -- builtin datatype of IO error codes

instance Show (IO a)
instance Functor IO 
instance Monad IO

-- Hooks for primitives: -----------------------------------------------------
-- Do not mess with these!

newtype IO a = IO ((IOError -> IOResult a) -> (a -> IOResult a) -> IOResult a)
data IOResult a 
  = Hugs_ExitWith Int
  | Hugs_SuspendThread
  | Hugs_Error    IOError
  | Hugs_Return   a

primitive primbindIO   "rbindIO" :: IO a -> (a -> IO b) -> IO b
primitive primretIO    "runitIO" :: a -> IO a
primitive catch        "lbindIO" :: IO a -> (IOError -> IO a) -> IO a
primitive fail         "lunitIO" :: IOError -> IO a
primitive putChar		 :: Char -> IO ()
primitive putStr		 :: String -> IO ()
primitive getChar   		 :: IO Char
primitive userError    		 :: String -> IOError

hugsPutStr :: String -> IO ()
hugsPutStr  = putStr

hugsIORun  :: IO a -> Either Int a
hugsIORun m = performIO (runAndShowError m)
 where
  performIO       :: IO a -> Either Int a
  performIO (IO m) = case m Hugs_Error Hugs_Return of
	             Hugs_Return a   -> Right a
		     Hugs_ExitWith e -> Left  e
		     _               -> Left  1

  runAndShowError :: IO a -> IO a
  runAndShowError m =
    m `catch` \err -> do 
	putChar '\n'
	putStr (ioeGetErrorString err)
	primExitWith 1 -- alternatively: (IO (\f s -> Hugs_SuspendThread))

primExitWith     :: Int -> IO a
primExitWith c    = IO (\ f s -> Hugs_ExitWith c)

primitive ioeGetErrorString "primShowIOError" :: IOError -> String

instance Show IOError

primCompAux      :: Ord a => a -> a -> Ordering -> Ordering
primCompAux x y o = case compare x y of EQ -> o; LT -> LT; GT -> GT

primPmInt        :: Num a => Int -> a -> Bool
primPmInt n x     = fromInt n == x

primPmInteger    :: Num a => Integer -> a -> Bool
primPmInteger n x = fromInteger n == x

primPmFlt        :: Fractional a => Double -> a -> Bool
primPmFlt n x     = fromDouble n == x

-- The following primitives are only needed if (n+k) patterns are enabled:
primPmNpk        :: Integral a => Int -> a -> Maybe a
primPmNpk n x     = if n'<=x then Just (x-n') else Nothing
		    where n' = fromInt n

primPmSub        :: Integral a => Int -> a -> a
primPmSub n x     = x - fromInt n

-- End of Hugs standard prelude ----------------------------------------------
