module Input where

import Graphics
--import GraphicsColor
import IOExts
import Output
import Board

import Board (Board, MoveInfo, Piece, Coord, UserAction(..), playMove)

getUserAction :: Board -> Window -> IO (Board, MoveInfo)
getUserAction b win = do
                        coord <- getLBP win
                        ua <- getHitButton coord
                        if(ua /= UA_Nothing)
                          then return (b,(-1,ua))
                          else
                            do
                              (x,y) <- convToBoardCoord coord
                              p <- pieceAtCoord b (x,y)
                              if(p >= 0)
                               then
                                   userPieceMove p b win (x,y)
                               else
                                   return (b,(-1, UA_Nothing));

userPieceMove :: Int -> Board -> Window -> Coord -> IO (Board, MoveInfo)
userPieceMove p b win (x,y) = loop
             where
               playAllMoves i b ua = do
                                       case i of
                                        0 -> do
                                               display b win
                                               return b
                                        _ -> do
                                               (f',b') <- playMove b (p, ua)
                                               if(f')
                                                 then playAllMoves (i-1) b' ua
                                                 else return b
               loop = do
                        e <- getEvent win
                        case e of
                          MouseMove {pt = coord} 
                                   -> do
                                        (x2,y2) <- convToBoardCoord coord
                                        if ((abs (x-x2)) > (abs (y-y2)))
                                          then
                                            if(x2 > x)
                                            then do b'@(Board (w,h) piecelist bm) <- playAllMoves (x2-x) b UA_Right
                                                    if (p < length piecelist)
                                                      then do userPieceMove p b' win (x2,y2)
                                                      else do return(b', (p, UA_Nothing))
                                            else do b'@(Board (w,h) piecelist bm) <- playAllMoves (x-x2) b UA_Left
                                                    if (p < length piecelist)
                                                      then do userPieceMove p b' win (x2,y2)
                                                      else do return(b', (p, UA_Nothing))
                                          else if ((abs (x-x2)) < (abs (y-y2)))
                                                 then
                                                    if(y2 > y)
                                                    then do
                                                           b'@(Board (w,h) piecelist bm) <- playAllMoves (y2-y) b UA_Down
                                                           if (p < length piecelist)
                                                             then do userPieceMove p b' win (x2,y2)
                                                             else do return(b', (p, UA_Nothing))
                                                    else do
                                                           b'@(Board (w,h) piecelist bm) <- playAllMoves (y-y2) b UA_Up
                                                           if (p < length piecelist)
                                                             then do userPieceMove p b' win (x2,y2)
                                                             else do return(b', (p, UA_Nothing))
                                                  else loop


                          Button { pt= coord, isLeft=True, isDown=False } -> return(b, (p, UA_Nothing))
                          _ ->loop
                
