module Demos where

{-
A few simple demos (last modified: Friday, March 07, 1997)

Erik Meijer (erik@cs.ruu.nl)
-}

import Common
import Mime
import HTML
import HTMLWizard
import PrettyHTML
import CgiOut
import Wrapper
import UrlEncoded

helloWorldText :: [(Name,Value)] -> TextPlain
helloWorldText env
 = TextPlain "Hello World!"

helloWorldHTML :: [(Name,Value)] -> HTML
helloWorldHTML env
 = page "Hello World" [] [h1 "Hello World!"]

envPassed :: [(Name,Value)] -> HTML
envPassed env
  = page "Environment Variables" []
     [ h1 "Environment variables"
     , dl [ (dt,[prose dd]) | (dt , dd) <- env ]
     ]

test f
 = wrapper (\env -> do{ return (Content{mime = f env}) })
