/*
    CTHUGHA-L 							options.h
	
    Functions make it easy to change to new flame, wave & co. functions,
    and all the stuff needed to accept command-line-options and to
    read the ini-files.
	
*/

#ifndef __OPTIONS_H__
#define __OPTIONS_H__

#include "feature.h"
#include <stdio.h>
#include <getopt.h>

/* maybe we don't have getopt_long,
 check this by checking, if 'no_argument' is defined 
 */
#ifndef no_argument
struct option {
    char * name;
    int has_arg;
    int * flag;
    int val;
};
#endif


extern int options_save;		/* save options (and buffer) at end */

extern int double_load;				/* allow double loading */

int val_change(int to, int min, int max, int old);

extern char extra_lib_path[256];		/* extra path to search for
						   pcx, tab, map and ini */
int load(char * search_path[], char * extra_path, char * extension, 
	 feature_entry* (* load_function)(FILE *, char *, char *),
	 feature * feat);

int get_params(int argc, char * argv[]);
int get_pre_params(int argc, char * argv[]);
int do_param(int c, int value, char * str);

int options_information();

extern struct option long_options[];

/*
 * Stuff about ini-files
 */
int read_ini();				/* read settings from ini-files */
int read_ini_usage();
int write_ini();

int open_ini_start();
int open_ini_file();
char * ini_file_name(int ini_nr);
int getini_int(const char * entry, int * value);
int getini_yesno(const char * entry, int * value);
int getini_use(feature * in, int pos);
extern FILE * ini_file;
int open_ini_sys();
int get_ini_str_sys(const char * name, char * value);

/*
 * options dialog
 */
int options_dialog();

#endif

