/*
 * some important parts written by:
 *  Mark Vojkovich (mvojkovi@ucsd.edu) 
 * and
 *  modified to allow status to change without reseting the counter...  clp 
 */

#include "cthugha.h"
#include "display.h"
#include "disp-sys.h"

#include <string.h>
#include <stdlib.h>

int display_text_time = 300;
int display_text_color[][3] = {
    {0, 255, 255},		/* normal */
    {255, 0, 0},		/* error */
    {255, 255, 255}		/* highlight */
};
int display_text_colors = 3;

static text_t* text_to_show[10];	/* texts currently on screen */
int display_text_on_screen = 0;		/* number of texts currently on screen */

/* 
 * Display a text on the screen 
 *
 * The text is not displayed immediately, only with the next
 * refresh of the screen.
 */

int lines(const char * text) {
    int n;

    text --;		/* a "virtual" '\n' before the text */
    for(n = 1; (text = strchr(text+1, '\n')) != NULL; n ++);

    return n;
}

int copyline(text_line * l, const char * text) {
    char * ntext = strchr(text, '\n');

    l->len = (ntext != NULL) ? ntext - text : strlen(text);
    l->text = cth_memory(l->text, (l->len+1) * sizeof(char), "Text line");
    strncpy(l->text, text, l->len);
    l->text[l->len] = '\0';

    return 0;
}
	

text_t * display_print(const char * text,	/* what text to display (handles \n) */
		       int line,		/* line number (in lines!) */
		       int justification,	/* 'l', 'c', 'r' */
		       int remove,		/* remove after some time, or keep */
		       int color) {		/* colorindex to use 255, 254, .. */
    int i;

    text_t * t = cth_memory(NULL, sizeof(text_t), "Text");

    /* put at a random line number */
    if(line == -1)	
	line = rand() % (disp_size.y - 8)/8;

    if(line == -2)
	line = (disp_size.y - 8)/8;

    t->remove = remove;	

    /* get number of lines, counte number of \n */
    t->n = lines(text);


    /* create the text to display, line by line */
    for(i = 0; i < t->n; i ++) {
	t->lines[i].text = NULL;
	copyline(&(t->lines[i]), text);

	t->lines[i].justification = justification;
	t->lines[i].time = gettime();
	t->lines[i].line = (line+i) * 8;
	t->lines[i].color = color;

	text = strchr(text, '\n') + 1;
    }
    text_to_show[display_text_on_screen] = t;
    display_text_on_screen ++;			/* text is on screen */

    display_clear = 1;				/* need a full redraw now */

    return t;
}

text_t * display_reprint(text_t * t,
		    const char * text,	/* what text to display (handles \n) */
		    int line,		/* line number (in lines!) */
		    int justification,	/* 'l', 'c', 'r' */
		    int remove,		/* remove after some time, or keep */
		    int color) {	/* colorindex to use 255, 254, .. */
    
    if(t)
	display_remove_text(t);
    return display_print(text, line, justification, remove, color);
}

int showing(text_t * t) {
    int i;
    for(i=0; i < display_text_on_screen; i++)
	if(text_to_show[i] == t)
	    return 1;
    return 0;
}
    
text_t * display_add_text(text_t * t, const char * text,
			  int line,		/* line number (in lines!) */
			  int justification,	/* 'l', 'c', 'r' */
			  int remove,		/* remove after some time, or keep */
			  int color) {		/* colorindex to use 255, 254, .. */

    int i; 
    int n = lines(text);


    /* create a new text if necessary */
    if( ! showing(t) )
	t = display_print("", line, justification, remove, color);

    /* start one line below last line of text */
    line = t->lines[t->n-1].line + 8; 
    
    /* create the text to display, line by line */
    for(i = 0; i < n; i ++) {
	
	t->lines[t->n + i].text = NULL;
	copyline(&(t->lines[t->n + i]), text);

	t->lines[t->n + i].justification = justification;
	t->lines[t->n + i].time = gettime();
	t->lines[t->n + i].line = line + i * 8;
	t->lines[t->n + i].color = color;

	text = strchr(text, '\n') + 1;
    }
    t->n += n;
    
    return t;
}

int display_scroll_text(text_t * t, int by) {
    int i,j;
    
    for(i=0; i < t->n; i++) {
	t->lines[i].line -= by;
	if(t->lines[i].line < 0) {		/* delete lines scrolled away */
	    for(j=0; j < (t->n-1); j++)
		t->lines[j] = t->lines[j+1];
	    t->n --;
	    i --;
	}
    }
	

    return 0;
}

int display_remove_text(text_t * t) {		/* clear this text */
    int i,j;

    if(t == NULL)
	return 0;

    for(i=0; i < display_text_on_screen; i++) {	/* remove from texts to display */
	if(text_to_show[i] == t) {		/* found text in list */

	    for(j = i; j < (display_text_on_screen-1); j++)	/* remove from list */
		text_to_show[j] = text_to_show[j+1];

	    display_text_on_screen --;		/* one less to display */

	    for(i=0; i < t->n; i++)		/* free all the memory for this text */
		free(t->lines[i].text);
	    free(t);
	    return 0;
	}
    }
    return 0;
}


/*
 * clear the text display completely
 */
int display_print_clear() {

    while(display_text_on_screen) {		/* there is something on the screen */
	display_remove_text(text_to_show[0]);
	display_clear = 1;			/* need a full redraw now */
    }
    return 0;
}



/*
 * bring the current active text to the screen
 */
int show_text() {
    int line;
    int i,j;

    for(i=0; i < display_text_on_screen; i++) {			/* all the text blocks */
	
	/* write text to screen/buffer line by line */
	for(line = 0; line < text_to_show[i]->n; line++) {

	    text_line * l = &(text_to_show[i]->lines[line]);	/* current line */

	    int len = min( l->len, disp_size.x/8); 
	    int x;
	    
	    /* check if it is time to remove this line */
	    if( text_to_show[i]->remove ) {
		if( (gettime() - l->time) > display_text_time) {	/* remove line */
		    free(l->text);

		    for(j=line; j < (text_to_show[i]->n-1); j++)
			text_to_show[i]->lines[j] = text_to_show[i]->lines[j+1];
		    line--;
		    text_to_show[i]->n --;

		    if(text_to_show[i]->n == 0) {		/* nothing left */
			display_remove_text( text_to_show[i]);
		    }
		    i--;
		    break;
		}			
	    }

	    if(len == 0)
		continue;

	    switch( l->justification) {
	    case 'l':
		x = 0;
		break;
	    case 'c':
		x = 8 * (disp_size.x/8 - len) / 2;
		break;
	    case 'r':
		x = 8 * (disp_size.x/8 - len);
		break;
	    default:
		x = 0;
	    }
	    display_print_string_sys(x, l->line, l->text, l->color);
	}
    }
    return 0;
}


