/* 
    CHUGHA-L							cd_player.h
*/

#ifndef __CD_PLAYER_H__
#define __CD_PLAYER_H__

#if USE_CDROM == 1

#include <sys/ioctl.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/cdrom.h>

int init_cd();					/* init CD-Player */
int exit_cd();					/* close CD-Player */

int cd_eject();
int cd_track(int track);			/* start playing at track */
int cd_pause();					/* pause the CD */
int cd_stop();					/* stops playing the CD */
int cd_next(int skip);				/* skip by skip  tracks */
int cd_fast(int skip);
int cd_subchnl();
int cd_check();

extern int cd_first_track;			/* start with track nr */
extern int cd_stop_on_exit;				
extern int cd_randomplay;
extern int cd_loop;
extern int cd_eject_on_end;

extern struct cdrom_subchnl  subchnl; 
extern int first, last;
extern int ejected;
extern int no_disk;
extern int *random_played;

#endif /* USE_CDROM */
#endif
