/***************************************************************************

  vidhrdw.c

  Functions to emulate the video hardware of the machine.

***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"



unsigned char *warpwarp_bulletsram;



/***************************************************************************

  Convert the color PROMs into a more useable format.

  Warp Warp doesn't use PROMs - the 8-bit code is directly converted into a
  color.

  The color RAM is connected to the RGB output this way (I think - schematics
  are fuzzy):

  bit 7 -- 300 ohm resistor  -- BLUE
        -- 820 ohm resistor  -- BLUE
        -- 300 ohm resistor  -- GREEN
        -- 820 ohm resistor  -- GREEN
        -- 1.6kohm resistor  -- GREEN
        -- 300 ohm resistor  -- RED
        -- 820 ohm resistor  -- RED
  bit 0 -- 1.6kohm resistor  -- RED

  Moreover, the bullet is pure white, obtained with three 220 ohm resistors.

***************************************************************************/
void warpwarp_vh_convert_color_prom(unsigned char *palette, unsigned short *colortable,const unsigned char *color_prom)
{
	int i;
	#define TOTAL_COLORS(gfxn) (Machine->gfx[gfxn]->total_colors * Machine->gfx[gfxn]->color_granularity)
	#define COLOR(gfxn,offs) (colortable[Machine->drv->gfxdecodeinfo[gfxn].color_codes_start + offs])


	for (i = 0;i < Machine->drv->total_colors;i++)
	{
		int bit0,bit1,bit2;


		/* red component */
		bit0 = (i >> 0) & 0x01;
		bit1 = (i >> 1) & 0x01;
		bit2 = (i >> 2) & 0x01;
		*(palette++) = 0x1f * bit0 + 0x3c * bit1 + 0xa4 * bit2;
		/* green component */
		bit0 = (i >> 3) & 0x01;
		bit1 = (i >> 4) & 0x01;
		bit2 = (i >> 5) & 0x01;
		*(palette++) = 0x1f * bit0 + 0x3c * bit1 + 0xa4 * bit2;
		/* blue component */
		bit0 = 0;
		bit1 = (i >> 6) & 0x01;
		bit2 = (i >> 7) & 0x01;
		*(palette++) = 0x1f * bit0 + 0x3c * bit1 + 0xa4 * bit2;
	}

	for (i = 0;i < TOTAL_COLORS(0);i += 2)
	{
		COLOR(0,i) = 0;			/* black background */
		COLOR(0,i + 1) = i / 2;	/* colored foreground */
	}
}



/***************************************************************************

  Draw the game screen in the given osd_bitmap.
  Do NOT call osd_update_display() from this function, it will be called by
  the main emulation engine.

***************************************************************************/
void warpwarp_vh_screenrefresh(struct osd_bitmap *bitmap,int full_refresh)
{
	int offs;


	/* for every character in the Video RAM, check if it has been modified */
	/* since last time and update it accordingly. */
	for (offs = videoram_size - 1;offs >= 0;offs--)
	{
		if (dirtybuffer[offs])
		{
			int mx,my,sx,sy;

			mx = offs % 32;
			my = offs / 32;

			if (my == 0)
			{
				sx = 33;
				sy = mx;
			}
			else if (my == 1)
			{
				sx = 0;
				sy = mx;
			}
			else
			{
				sx = mx + 1;
				sy = my;
			}

			drawgfx(tmpbitmap,Machine->gfx[0],
					videoram[offs],
					colorram[offs],
					0,0,
					8*sx,8*sy,
					&Machine->drv->visible_area,TRANSPARENCY_NONE,0);

			dirtybuffer[offs] = 0;
		}
	}


	/* copy the character mapped graphics */
	copybitmap(bitmap,tmpbitmap,0,0,0,0,&Machine->drv->visible_area,TRANSPARENCY_NONE,0);


	if (warpwarp_bulletsram[0] > 1)
	{
		int x,y;


		x = 260 - warpwarp_bulletsram[0];
		y = 252 - warpwarp_bulletsram[1];
		if (x >= Machine->drv->visible_area.min_x && x+3 <= Machine->drv->visible_area.max_x &&
				y >= Machine->drv->visible_area.min_y && y+3 <= Machine->drv->visible_area.max_y)
		{
			int colour;
			int i,j;


			colour = Machine->pens[0xf6];	/* white */

			if (Machine->orientation & ORIENTATION_SWAP_XY)
			{
				int temp;


				temp = x;
				x = y;
				y = temp;
			}
			if (Machine->orientation & ORIENTATION_FLIP_X)
				x = bitmap->width-4 - x;
			if (Machine->orientation & ORIENTATION_FLIP_Y)
				y = bitmap->height-4 - y;

			osd_mark_dirty(x,y,x+3,y+3,0);

			for (i = 0;i < 4;i++)
			{
				for (j = 0;j < 4;j++)
				{
					bitmap->line[y+i][x+j] = colour;
				}
			}
		}
	}
}
