/*
* NetBSD/i386 dependent code by entropy@zippy.bernstein.com
*
* Joystick code is based on the linux driver.
* Audio code is based on the solaris driver, by jantonio@dit.upm.es
*/

#ifdef netbsd_i386

#include "xmame.h"
#include "sound.h"

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#if defined(USE_JOYSTICK) && defined(I386_JOYSTICK)
#include <machine/joystick.h>
struct joystick joy_data, joy_orig;
int joy_fd;
#endif

#ifdef USE_AUDIO
#include <sys/types.h>
#include <sys/audioio.h>
int audio_fd;
audio_info_t a_info;
audio_device_t a_dev;
#endif

int sysdep_init(void)
{
#if defined(USE_JOYSTICK) && defined(I386_JOYSTICK)
  if (use_joystick) {
    fprintf(stderr_file, "NetBSD/i386 joystick interface initialization...\n");
    if ((joy_fd = open ("/dev/joy0", O_RDONLY | O_NONBLOCK)) < 0) {
      fprintf(stderr_file, "Couldn't open joystick device /dev/joy0\n");
      fprintf(stderr_file, "Be sure joystick is configured into kernel\n");
      use_joystick = FALSE;
    } else {
      if (read(joy_fd, &joy_orig, sizeof(struct joystick)) < 0) {
	fprintf(stderr_file, "Cannot read joystick device.  Sorry.\n");
	use_joystick = FALSE;
      } else {
	/* mask x e y pos to skip "flickering" */
	if (swapjoyaxis)
	{
	    int a      = joy_orig.y;
	    joy_orig.y = joy_orig.x;
	    joy_orig.x = a;
	}
      }
    }
  }
#endif

#ifdef USE_AUDIO
  if (play_sound) {
    fprintf(stderr_file, "NetBSD/i386 sound device initialization...\n");
    /* try to open audio device */
    if ((audio_fd = open("/dev/audio", O_WRONLY /* | O_NDELAY*/)) < 0) {
      perror("Cannot open audio device");
      play_sound = FALSE;
    } else {
      /* empty buffers before change config */
      ioctl(audio_fd, AUDIO_FLUSH, 0);        /* flush everything */
      
      /* identify audio device. */
      if(ioctl(audio_fd, AUDIO_GETDEV, &a_dev) < 0) {
	perror("Cannot get sound device type");
	close(audio_fd);
	play_sound = FALSE;
      } else {
	fprintf(stderr_file, "Sound device is a %s %s version %s\n",
	       a_dev.config, a_dev.name, a_dev.version);
	    
	/* initialize audio parameters. */ 
	AUDIO_INITINFO(&a_info);
	    
	a_info.play.sample_rate = (uint) options.samplerate = AUDIO_SAMPLE_FREQ;
	a_info.play.encoding = (uint) AUDIO_ENCODING_LINEAR;
	a_info.play.precision = (uint) AUDIO_SAMPLE_BITS;
	a_info.play.channels = (uint) 1;
	a_info.blocksize = AUDIO_SAMPLE_FREQ / AUDIO_TIMER_FREQ;
	a_info.play.buffer_size = AUDIO_BUFF_SIZE;
	a_info.mode = AUMODE_PLAY | AUMODE_PLAY_ALL;

	if (ioctl(audio_fd, AUDIO_SETINFO, &a_info) < 0) {
	  perror("cannot set audio device parameters");
	  close(audio_fd);
	  play_sound = FALSE;
	}
      }
    }
  }
#endif
  return (TRUE);
}

void sysdep_exit(void) {
#if defined(USE_JOYSTICK) && defined(I386_JOYSTICK)
  if (use_joystick) close(joy_fd);
#endif
#ifdef USE_AUDIO
  if (play_sound) { close(audio_fd);
  }
#endif  
}

int sysdep_play_audio(byte *buf, int bufsize) {
#ifdef USE_AUDIO
  return write(audio_fd, buf, bufsize);
#endif
}

#endif
