/*** TMS34010: Portable TMS34010 emulator ***********************************

	Copyright (C) Alex Pasadyn/Zsolt Vasvari 1998
	 originally based on code by Aaron Giles

	This is a private include file. Drivers should NOT include it, but
	use TMS34010.h instead.
	
	System dependencies:	long must be at least 32 bits
	                        word must be 16 bit UINT32
							byte must be 8 bit UINT32
							arrays up to 65536 bytes must be supported
							machine must be twos complement

*****************************************************************************/

#ifndef _34010OPS_H
#define _34010OPS_H

#include "osd_cpu.h"
#include "memory.h"

/****************************************************************************/
/* sizeof(char)=1, sizeof(short)=2, sizeof(long)>=4                         */
/****************************************************************************/

#define INVALID_PIX_ADDRESS  0xffffffe0  /* This is the reset vector, this should be ok */

#ifndef INLINE
#define INLINE static inline
#endif

/* Interrupts that are generated by the processor internally */
#define TMS34010_NMI         0x0100    /* NMI Interrupt */
#define TMS34010_HI          0x0200    /* Host Interrupt */
#define TMS34010_DI          0x0400    /* Display Interrupt */
#define TMS34010_WV          0x0800    /* Window Violation Interrupt */

/* Size of the memory buffer allocated for the shiftr register */
#define SHIFTREG_SIZE		 (2*512*sizeof(UINT16))

/****************************************************************************/
/* Read a byte from given memory location                                   */
/****************************************************************************/
#define TMS34010_RDMEM(A) ((unsigned)cpu_readmem29(A))
#define TMS34010_RDMEM_WORD(A) ((unsigned)cpu_readmem29_word(A))
#define TMS34010_RDMEM_DWORD(A) ((unsigned)cpu_readmem29_dword(A))

/****************************************************************************/
/* Write a byte to given memory location                                    */
/****************************************************************************/
#define TMS34010_WRMEM(A,V) (cpu_writemem29(A,(V)&0xff))
#define TMS34010_WRMEM_WORD(A,V) (cpu_writemem29_word(A,(V)&0xffff))
#define TMS34010_WRMEM_DWORD(A,V) (cpu_writemem29_dword(A,V))

/****************************************************************************/
/* I/O constants and function prototypes 									*/
/****************************************************************************/
#define REG_HESYNC		0
#define REG_HEBLNK		1
#define REG_HSBLNK		2
#define REG_HTOTAL		3
#define REG_VESYNC		4
#define REG_VEBLNK		5
#define REG_VSBLNK		6
#define REG_VTOTAL		7
#define REG_DPYCTL		8
#define REG_DPYSTRT		9
#define REG_DPYINT		10
#define REG_CONTROL		11
#define REG_HSTDATA		12
#define REG_HSTADRL		13
#define REG_HSTADRH		14
#define REG_HSTCTLL		15
#define REG_HSTCTLH		16
#define REG_INTENB		17
#define REG_INTPEND		18
#define REG_CONVSP		19
#define REG_CONVDP		20
#define REG_PSIZE		21
#define REG_PMASK		22
#define REG_DPYTAP		27
#define REG_HCOUNT		28
#define REG_VCOUNT		29
#define REG_DPYADR		30
#define REG_REFCNT		31

/* IO registers accessor */
#define IOREG(reg)	     (state.IOregs[reg])
#define SLAVE_IOREG(reg) (slavecontext->IOregs[reg])
#define PBH (IOREG(REG_CONTROL) & 0x0100)
#define PBV (IOREG(REG_CONTROL) & 0x0200)

#define COPY_ASP   (BREG(15) = AREG(15))
#define COPY_BSP   (AREG(15) = BREG(15))

void WFIELD_01(UINT32 bitaddr, UINT32 data);
void WFIELD_02(UINT32 bitaddr, UINT32 data);
void WFIELD_03(UINT32 bitaddr, UINT32 data);
void WFIELD_04(UINT32 bitaddr, UINT32 data);
void WFIELD_05(UINT32 bitaddr, UINT32 data);
void WFIELD_06(UINT32 bitaddr, UINT32 data);
void WFIELD_07(UINT32 bitaddr, UINT32 data);
void WFIELD_08(UINT32 bitaddr, UINT32 data);
void WFIELD_09(UINT32 bitaddr, UINT32 data);
void WFIELD_10(UINT32 bitaddr, UINT32 data);
void WFIELD_11(UINT32 bitaddr, UINT32 data);
void WFIELD_12(UINT32 bitaddr, UINT32 data);
void WFIELD_13(UINT32 bitaddr, UINT32 data);
void WFIELD_14(UINT32 bitaddr, UINT32 data);
void WFIELD_15(UINT32 bitaddr, UINT32 data);
void WFIELD_16(UINT32 bitaddr, UINT32 data);
void WFIELD_17(UINT32 bitaddr, UINT32 data);
void WFIELD_18(UINT32 bitaddr, UINT32 data);
void WFIELD_19(UINT32 bitaddr, UINT32 data);
void WFIELD_20(UINT32 bitaddr, UINT32 data);
void WFIELD_21(UINT32 bitaddr, UINT32 data);
void WFIELD_22(UINT32 bitaddr, UINT32 data);
void WFIELD_23(UINT32 bitaddr, UINT32 data);
void WFIELD_24(UINT32 bitaddr, UINT32 data);
void WFIELD_25(UINT32 bitaddr, UINT32 data);
void WFIELD_26(UINT32 bitaddr, UINT32 data);
void WFIELD_27(UINT32 bitaddr, UINT32 data);
void WFIELD_28(UINT32 bitaddr, UINT32 data);
void WFIELD_29(UINT32 bitaddr, UINT32 data);
void WFIELD_30(UINT32 bitaddr, UINT32 data);
void WFIELD_31(UINT32 bitaddr, UINT32 data);
void WFIELD_32(UINT32 bitaddr, UINT32 data);

int RFIELD_01(UINT32 bitaddr);
int RFIELD_02(UINT32 bitaddr);
int RFIELD_03(UINT32 bitaddr);
int RFIELD_04(UINT32 bitaddr);
int RFIELD_05(UINT32 bitaddr);
int RFIELD_06(UINT32 bitaddr);
int RFIELD_07(UINT32 bitaddr);
int RFIELD_08(UINT32 bitaddr);
int RFIELD_09(UINT32 bitaddr);
int RFIELD_10(UINT32 bitaddr);
int RFIELD_11(UINT32 bitaddr);
int RFIELD_12(UINT32 bitaddr);
int RFIELD_13(UINT32 bitaddr);
int RFIELD_14(UINT32 bitaddr);
int RFIELD_15(UINT32 bitaddr);
int RFIELD_16(UINT32 bitaddr);
int RFIELD_17(UINT32 bitaddr);
int RFIELD_18(UINT32 bitaddr);
int RFIELD_19(UINT32 bitaddr);
int RFIELD_20(UINT32 bitaddr);
int RFIELD_21(UINT32 bitaddr);
int RFIELD_22(UINT32 bitaddr);
int RFIELD_23(UINT32 bitaddr);
int RFIELD_24(UINT32 bitaddr);
int RFIELD_25(UINT32 bitaddr);
int RFIELD_26(UINT32 bitaddr);
int RFIELD_27(UINT32 bitaddr);
int RFIELD_28(UINT32 bitaddr);
int RFIELD_29(UINT32 bitaddr);
int RFIELD_30(UINT32 bitaddr);
int RFIELD_31(UINT32 bitaddr);
int RFIELD_32(UINT32 bitaddr);

#endif /* _34010OPS_H */
