/*
 * Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 *
 * (c) Copyright 1996, 1997, 1998 Gary Henderson (gary@daniver.demon.co.uk) and
 *                                Jerremy Koot (jkoot@snes9x.com)
 *
 * Super FX C emulator code 
 * (c) Copyright 1997, 1998 Ivar (Ivar@snes9x.com) and
 *                          Gary Henderson.
 * Super FX assembler emulator code (c) Copyright 1998 zsKnight and _Demo_.
 *
 * DSP1 emulator code (c) Copyright 1998 Ivar, _Demo_ and Gary Henderson.
 * DOS port code contains the works of other authors. See headers in
 * individual files.
 *
 * Snes9x homepage: www.snes9x.com
 *
 * Permission to use, copy, modify and distribute Snes9x in both binary and
 * source form, for non-commercial purposes, is hereby granted without fee,
 * providing that this license information and copyright notice appear with
 * all copies and any derived work.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event shall the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Snes9x is freeware for PERSONAL USE only. Commercial users should
 * seek permission of the copyright holders first. Commercial use includes
 * charging money for Snes9x or software derived from Snes9x.
 *
 * The copyright holders request that bug fixes and improvements to the code
 * should be forwarded to them so everyone can benefit from the modifications
 * in future versions.
 *
 * Super NES and Super Nintendo Entertainment System are trademarks of
 * Nintendo Co., Limited and its subsidiary companies.
 */

#include "snes9x.h"

#include "memmap.h"
#include "ppu.h"
#include "display.h"
#include "gfx.h"
#include "tile.h"

extern uint32 HeadMask [4];
extern uint32 TailMask [5];

void ConvertTile (uint8 *pCache, uint32 TileAddr)
{
    register uint8 *tp = &Memory.VRAM[TileAddr];
    uint32 *p = (uint32 *) pCache;
    uint8 line;
    switch (BG.BitShift)
    {
    case 8:
	for (line = 8; line != 0; line--, tp += 2)
	{
	    uint32 p1 = 0;
	    uint32 p2 = 0;
	    register uint8 pix;

	    if (pix = *(tp + 0))
	    {
		p1 |= odd_high[0][pix >> 4];
		p2 |= odd_low[0][pix & 0xf];
	    }
	    if (pix = *(tp + 1))
	    {
		p1 |= even_high[0][pix >> 4];
		p2 |= even_low[0][pix & 0xf];
	    }
	    if (pix = *(tp + 16))
	    {
		p1 |= odd_high[1][pix >> 4];
		p2 |= odd_low[1][pix & 0xf];
	    }
	    if (pix = *(tp + 17))
	    {
		p1 |= even_high[1][pix >> 4];
		p2 |= even_low[1][pix & 0xf];
	    }
	    if (pix = *(tp + 32))
	    {
		p1 |= odd_high[2][pix >> 4];
		p2 |= odd_low[2][pix & 0xf];
	    }
	    if (pix = *(tp + 33))
	    {
		p1 |= even_high[2][pix >> 4];
		p2 |= even_low[2][pix & 0xf];
	    }
	    if (pix = *(tp + 48))
	    {
		p1 |= odd_high[3][pix >> 4];
		p2 |= odd_low[3][pix & 0xf];
	    }
	    if (pix = *(tp + 49))
	    {
		p1 |= even_high[3][pix >> 4];
		p2 |= even_low[3][pix & 0xf];
	    }
	    *p++ = p1;
	    *p++ = p2;
	}
	break;

    case 4:
	for (line = 8; line != 0; line--, tp += 2)
	{
	    uint32 p1 = 0;
	    uint32 p2 = 0;
	    register uint8 pix;
	    if (pix = *(tp + 0))
	    {
		p1 |= odd_high[0][pix >> 4];
		p2 |= odd_low[0][pix & 0xf];
	    }
	    if (pix = *(tp + 1))
	    {
		p1 |= even_high[0][pix >> 4];
		p2 |= even_low[0][pix & 0xf];
	    }
	    if (pix = *(tp + 16))
	    {
		p1 |= odd_high[1][pix >> 4];
		p2 |= odd_low[1][pix & 0xf];
	    }
	    if (pix = *(tp + 17))
	    {
		p1 |= even_high[1][pix >> 4];
		p2 |= even_low[1][pix & 0xf];
	    }
	    *p++ = p1;
	    *p++ = p2;
	}
	break;

    case 2:
	for (line = 8; line != 0; line--, tp += 2)
	{
	    uint32 p1 = 0;
	    uint32 p2 = 0;
	    register uint8 pix;
	    if (pix = *(tp + 0))
	    {
		p1 |= odd_high[0][pix >> 4];
		p2 |= odd_low[0][pix & 0xf];
	    }
	    if (pix = *(tp + 1))
	    {
		p1 |= even_high[0][pix >> 4];
		p2 |= even_low[0][pix & 0xf];
	    }
	    *p++ = p1;
	    *p++ = p2;
	}
	break;
    }
}

inline void WRITE_4PIXELS (uint32 Offset, uint8 *Pixels, uint32 Palette,
			   uint8 Z)
{
    uint32 Pixel;
    uint8 *Screen = GFX.S + Offset;

    if (Pixel = Pixels[0])
	Screen [0] = Pixel + Palette;
    if (Pixel = Pixels [1])
	Screen [1] = Pixel + Palette;
    if (Pixel = Pixels [2])
	Screen [2] = Pixel + Palette;
    if (Pixel = Pixels [3])
	Screen [3] = Pixel + Palette;
}

inline void WRITE_4PIXELS_FLIPPED (uint32 Offset, uint8 *Pixels, uint32 Palette,
				   uint8 Z)
{
    uint8 Pixel;
    uint8 *Screen = GFX.S + Offset;

    if (Pixel = Pixels[3])
	Screen [0] = Pixel + Palette;
    if (Pixel = Pixels [2])
	Screen [1] = Pixel + Palette;
    if (Pixel = Pixels [1])
	Screen [2] = Pixel + Palette;
    if (Pixel = Pixels [0])
	Screen [3] = Pixel + Palette;
}

inline void WRITE_4PIXELSx2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
			     uint8 Z)
{
    uint8 Pixel;
    uint8 *Screen = GFX.S + Offset;

    if (Pixel = Pixels[0])
	Screen [0] = Screen [1] = Pixel + Palette;
    if (Pixel = Pixels [1])
	Screen [2] = Screen [3] = Pixel + Palette;
    if (Pixel = Pixels [2])
	Screen [4] = Screen [5] = Pixel + Palette;
    if (Pixel = Pixels [3])
	Screen [6] = Screen [7] = Pixel + Palette;
}

inline void WRITE_4PIXELS_FLIPPEDx2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
				     uint8 Z)
{
    uint8 Pixel;
    uint8 *Screen = GFX.S + Offset;

    if (Pixel = Pixels[3])
	Screen [0] = Screen [1] = Pixel + Palette;
    if (Pixel = Pixels [2])
	Screen [2] = Screen [3] = Pixel + Palette;
    if (Pixel = Pixels [1])
	Screen [4] = Screen [5] = Pixel + Palette;
    if (Pixel = Pixels [0])
	Screen [6] = Screen [7] = Pixel + Palette;
}

inline void WRITE_4PIXELSx2x2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
			       uint8 Z)
{
    uint8 Pixel;
    uint8 *Screen = GFX.S + Offset;

    if (Pixel = Pixels[0])
	Screen [0] = Screen [1] = Screen [GFX.RealPitch + 0] = 
	    Screen [GFX.RealPitch + 1] = Pixel + Palette;
    if (Pixel = Pixels [1])
	Screen [2] = Screen [3] = Screen [GFX.RealPitch + 2] = 
	    Screen [GFX.RealPitch + 3] = Pixel + Palette;
    if (Pixel = Pixels [2])
	Screen [4] = Screen [5] = Screen [GFX.RealPitch + 4] = 
	    Screen [GFX.RealPitch + 5] = Pixel + Palette;
    if (Pixel = Pixels [3])
	Screen [6] = Screen [7] = Screen [GFX.RealPitch + 6] = 
	    Screen [GFX.RealPitch + 7] = Pixel + Palette;
}

inline void WRITE_4PIXELS_FLIPPEDx2x2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
				       uint8 Z)
{
    uint8 Pixel;
    uint8 *Screen = GFX.S + Offset;

    if (Pixel = Pixels[3])
	Screen [0] = Screen [1] = Screen [GFX.RealPitch + 0] = 
	    Screen [GFX.RealPitch + 1] = Pixel + Palette;
    if (Pixel = Pixels [3])
	Screen [2] = Screen [3] = Screen [GFX.RealPitch + 2] = 
	    Screen [GFX.RealPitch + 3] = Pixel + Palette;
    if (Pixel = Pixels [1])
	Screen [4] = Screen [5] = Screen [GFX.RealPitch + 4] = 
	    Screen [GFX.RealPitch + 5] = Pixel + Palette;
    if (Pixel = Pixels [0])
	Screen [6] = Screen [7] = Screen [GFX.RealPitch + 6] = 
	    Screen [GFX.RealPitch + 7] = Pixel + Palette;
}

void DrawTile (uint32 Tile, uint32 Offset, uint32 StartLine,
	       uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE

    register uint8 *bp;

    RENDER_TILE(WRITE_4PIXELS, WRITE_4PIXELS_FLIPPED, 4)
}

void DrawClippedTile (uint32 Tile, uint32 Offset,
		      uint32 StartPixel, uint32 Width,
		      uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    TILE_CLIP_PREAMBLE
    RENDER_CLIPPED_TILE(WRITE_4PIXELS, WRITE_4PIXELS_FLIPPED, 4)
}

void DrawTilex2 (uint32 Tile, uint32 Offset, uint32 StartLine,
		 uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE

    register uint8 *bp;

    RENDER_TILE(WRITE_4PIXELSx2, WRITE_4PIXELS_FLIPPEDx2, 8)
}

void DrawClippedTilex2 (uint32 Tile, uint32 Offset,
			uint32 StartPixel, uint32 Width,
			uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    TILE_CLIP_PREAMBLE
    RENDER_CLIPPED_TILE(WRITE_4PIXELSx2, WRITE_4PIXELS_FLIPPEDx2, 8)
}

void DrawTilex2x2 (uint32 Tile, uint32 Offset, uint32 StartLine,
		   uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE

    register uint8 *bp;

    RENDER_TILE(WRITE_4PIXELSx2x2, WRITE_4PIXELS_FLIPPEDx2x2, 8)
}

void DrawClippedTilex2x2 (uint32 Tile, uint32 Offset,
			  uint32 StartPixel, uint32 Width,
			  uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    TILE_CLIP_PREAMBLE
    RENDER_CLIPPED_TILE(WRITE_4PIXELSx2x2, WRITE_4PIXELS_FLIPPEDx2x2, 8)
}

void DrawLargePixel (uint32 Tile, uint32 Offset,
		     uint32 StartPixel, uint32 Pixels,
		     uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE

    register uint8 *sp = GFX.S + Offset;
    uint8 pixel;
#define PLOT_PIXEL(screen, pixel) (pixel)

    RENDER_TILE_LARGE (pixel + tt, PLOT_PIXEL)
}

inline void WRITE_4PIXELS16 (uint32 Offset, uint8 *Pixels, uint32 Palette,
			     uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if ((Pixel = Pixels[0]))
	Screen [0] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [1]))
	Screen [1] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [2]))
	Screen [2] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [3]))
	Screen [3] = IPPU.ScreenColors [Pixel + Palette];
}

inline void WRITE_4PIXELS16_FLIPPED (uint32 Offset, uint8 *Pixels, uint32 Palette,
				     uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if ((Pixel = Pixels[3]))
	Screen [0] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [2]))
	Screen [1] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [1]))
	Screen [2] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [0]))
	Screen [3] = IPPU.ScreenColors [Pixel + Palette];
}

inline void WRITE_4PIXELS16x2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
			       uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if ((Pixel = Pixels[0]))
	Screen [0] = Screen [1] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [1]))
	Screen [2] = Screen [3] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [2]))
	Screen [4] = Screen [5] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [3]))
	Screen [6] = Screen [7] = IPPU.ScreenColors [Pixel + Palette];
}

inline void WRITE_4PIXELS16_FLIPPEDx2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
				       uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if ((Pixel = Pixels[3]))
	Screen [0] = Screen [1] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [2]))
	Screen [2] = Screen [3] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [1]))
	Screen [4] = Screen [5] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [0]))
	Screen [6] = Screen [7] = IPPU.ScreenColors [Pixel + Palette];
}

inline void WRITE_4PIXELS16x2x2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
				 uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if ((Pixel = Pixels[0]))
	Screen [0] = Screen [1] = Screen [(GFX.RealPitch >> 1) + 0] = 
	    Screen [(GFX.RealPitch >> 1) + 1] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [1]))
	Screen [2] = Screen [3] = Screen [(GFX.RealPitch >> 1) + 2] = 
	    Screen [(GFX.RealPitch >> 1) + 3] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [2]))
	Screen [4] = Screen [5] = Screen [(GFX.RealPitch >> 1) + 4] = 
	    Screen [(GFX.RealPitch >> 1) + 5] = IPPU.ScreenColors [Pixel + Palette];
    if ((Pixel = Pixels [3]))
	Screen [6] = Screen [7] = Screen [(GFX.RealPitch >> 1) + 6] = 
	    Screen [(GFX.RealPitch >> 1) + 7] = IPPU.ScreenColors [Pixel + Palette];
}

inline void WRITE_4PIXELS16_FLIPPEDx2x2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
					 uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if (Pixel = Pixels[3])
	Screen [0] = Screen [1] = Screen [(GFX.RealPitch >> 1) + 0] = 
	    Screen [(GFX.RealPitch >> 1) + 1] = IPPU.ScreenColors [Pixel + Palette];
    if (Pixel = Pixels [2])
	Screen [2] = Screen [3] = Screen [(GFX.RealPitch >> 1) + 2] = 
	    Screen [(GFX.RealPitch >> 1) + 3] = IPPU.ScreenColors [Pixel + Palette];
    if (Pixel = Pixels [1])
	Screen [4] = Screen [5] = Screen [(GFX.RealPitch >> 1) + 4] = 
	    Screen [(GFX.RealPitch >> 1) + 5] = IPPU.ScreenColors [Pixel + Palette];
    if (Pixel = Pixels [0])
	Screen [6] = Screen [7] = Screen [(GFX.RealPitch >> 1) + 6] = 
	    Screen [(GFX.RealPitch >> 1) + 7] = IPPU.ScreenColors [Pixel + Palette];
}

void DrawTile16 (uint32 Tile, uint32 Offset, uint32 StartLine,
	         uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    RENDER_TILE(WRITE_4PIXELS16, WRITE_4PIXELS16_FLIPPED, 4)
}

void DrawClippedTile16 (uint32 Tile, uint32 Offset,
			uint32 StartPixel, uint32 Width,
			uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    TILE_CLIP_PREAMBLE
    RENDER_CLIPPED_TILE(WRITE_4PIXELS16, WRITE_4PIXELS16_FLIPPED, 4)
}

void DrawTile16x2 (uint32 Tile, uint32 Offset, uint32 StartLine,
		   uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    RENDER_TILE(WRITE_4PIXELS16x2, WRITE_4PIXELS16_FLIPPEDx2, 8)
}

void DrawClippedTile16x2 (uint32 Tile, uint32 Offset,
			  uint32 StartPixel, uint32 Width,
			  uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    TILE_CLIP_PREAMBLE
    RENDER_CLIPPED_TILE(WRITE_4PIXELS16x2, WRITE_4PIXELS16_FLIPPEDx2, 8)
}

void DrawTile16x2x2 (uint32 Tile, uint32 Offset, uint32 StartLine,
		     uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    RENDER_TILE(WRITE_4PIXELS16x2x2, WRITE_4PIXELS16_FLIPPEDx2x2, 8)
}

void DrawClippedTile16x2x2 (uint32 Tile, uint32 Offset,
			    uint32 StartPixel, uint32 Width,
			    uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    TILE_CLIP_PREAMBLE
    RENDER_CLIPPED_TILE(WRITE_4PIXELS16x2x2, WRITE_4PIXELS16_FLIPPEDx2x2, 8)
}

void DrawLargePixel16 (uint32 Tile, uint32 Offset,
		       uint32 StartPixel, uint32 Pixels,
		       uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE

    register uint16 *sp = (uint16 *) GFX.S + Offset;
    uint16 pixel;

    RENDER_TILE_LARGE (IPPU.ScreenColors [pixel + tt], PLOT_PIXEL)
}

inline void WRITE_4PIXELS16_ADD (uint32 Offset, uint8 *Pixels, uint32 Palette,
				 uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if (Pixel = Pixels[0])
	Screen [0] = COLOR_ADD (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 0]);
    if (Pixel = Pixels [1])
	Screen [1] = COLOR_ADD (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 1]);
    if (Pixel = Pixels [2])
	Screen [2] = COLOR_ADD (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 2]);
    if (Pixel = Pixels [3])
	Screen [3] = COLOR_ADD (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 3]);
}

inline void WRITE_4PIXELS16_FLIPPED_ADD (uint32 Offset, uint8 *Pixels, uint32 Palette,
					 uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if (Pixel = Pixels[3])
	Screen [0] = COLOR_ADD (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 0]);
    if (Pixel = Pixels [2])
	Screen [1] = COLOR_ADD (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 1]);
    if (Pixel = Pixels [1])
	Screen [2] = COLOR_ADD (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 2]);
    if (Pixel = Pixels [0])
	Screen [3] = COLOR_ADD (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 3]);
}

inline void WRITE_4PIXELS16_ADD1_2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
				    uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if (Pixel = Pixels[0])
	Screen [0] = COLOR_ADD1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 0]);
    if (Pixel = Pixels [1])
	Screen [1] = COLOR_ADD1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 1]);
    if (Pixel = Pixels [2])
	Screen [2] = COLOR_ADD1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 2]);
    if (Pixel = Pixels [3])
	Screen [3] = COLOR_ADD1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 3]);
}

inline void WRITE_4PIXELS16_FLIPPED_ADD1_2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
					    uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if (Pixel = Pixels[3])
	Screen [0] = COLOR_ADD1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 0]);
    if (Pixel = Pixels [2])
	Screen [1] = COLOR_ADD1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 1]);
    if (Pixel = Pixels [1])
	Screen [2] = COLOR_ADD1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 2]);
    if (Pixel = Pixels [0])
	Screen [3] = COLOR_ADD1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 3]);
}

inline void WRITE_4PIXELS16_SUB (uint32 Offset, uint8 *Pixels, uint32 Palette,
				 uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if (Pixel = Pixels[0])
	Screen [0] = COLOR_SUB (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 0]);
    if (Pixel = Pixels [1])
	Screen [1] = COLOR_SUB (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 1]);
    if (Pixel = Pixels [2])
	Screen [2] = COLOR_SUB (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 2]);
    if (Pixel = Pixels [3])
	Screen [3] = COLOR_SUB (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 3]);
}

inline void WRITE_4PIXELS16_FLIPPED_SUB (uint32 Offset, uint8 *Pixels, uint32 Palette,
					 uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if (Pixel = Pixels[3])
	Screen [0] = COLOR_SUB (IPPU.ScreenColors [Pixel + Palette],
			  Screen [GFX.Delta + 0]);
    if (Pixel = Pixels [2])
	Screen [1] = COLOR_SUB (IPPU.ScreenColors [Pixel + Palette],
			  Screen [GFX.Delta + 1]);
    if (Pixel = Pixels [1])
	Screen [2] = COLOR_SUB (IPPU.ScreenColors [Pixel + Palette],
			  Screen [GFX.Delta + 2]);
    if (Pixel = Pixels [0])
	Screen [3] = COLOR_SUB (IPPU.ScreenColors [Pixel + Palette],
			  Screen [GFX.Delta + 3]);
}

inline void WRITE_4PIXELS16_SUB1_2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
				    uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if (Pixel = Pixels[0])
	Screen [0] = COLOR_SUB1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 0]);
    if (Pixel = Pixels [1])
	Screen [1] = COLOR_SUB1_2 (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 1]);
    if (Pixel = Pixels [2])
	Screen [2] = COLOR_SUB1_2 (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 2]);
    if (Pixel = Pixels [3])
	Screen [3] = COLOR_SUB1_2 (IPPU.ScreenColors [Pixel + Palette],
				Screen [GFX.Delta + 3]);
}

inline void WRITE_4PIXELS16_FLIPPED_SUB1_2 (uint32 Offset, uint8 *Pixels, uint32 Palette,
					    uint8 Z)
{
    uint32 Pixel;
    uint16 *Screen = (uint16 *) GFX.S + Offset;

    if (Pixel = Pixels[3])
	Screen [0] = COLOR_SUB1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 0]);
    if (Pixel = Pixels [2])
	Screen [1] = COLOR_SUB1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 1]);
    if (Pixel = Pixels [1])
	Screen [2] = COLOR_SUB1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 2]);
    if (Pixel = Pixels [0])
	Screen [3] = COLOR_SUB1_2 (IPPU.ScreenColors [Pixel + Palette],
				   Screen [GFX.Delta + 3]);
}

void DrawTile16Add (uint32 Tile, uint32 Offset, uint32 StartLine,
		    uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    RENDER_TILE(WRITE_4PIXELS16_ADD, WRITE_4PIXELS16_FLIPPED_ADD, 4)
}

void DrawClippedTile16Add (uint32 Tile, uint32 Offset,
			   uint32 StartPixel, uint32 Width,
			   uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    TILE_CLIP_PREAMBLE
    RENDER_CLIPPED_TILE(WRITE_4PIXELS16_ADD, WRITE_4PIXELS16_FLIPPED_ADD, 4)
}

void DrawTile16Add1_2 (uint32 Tile, uint32 Offset, uint32 StartLine,
		       uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    RENDER_TILE(WRITE_4PIXELS16_ADD1_2, WRITE_4PIXELS16_FLIPPED_ADD1_2, 4)
}

void DrawClippedTile16Add1_2 (uint32 Tile, uint32 Offset,
			      uint32 StartPixel, uint32 Width,
			      uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    TILE_CLIP_PREAMBLE
    RENDER_CLIPPED_TILE(WRITE_4PIXELS16_ADD1_2, WRITE_4PIXELS16_FLIPPED_ADD1_2, 4)
}

void DrawTile16Sub (uint32 Tile, uint32 Offset, uint32 StartLine,
		    uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    RENDER_TILE(WRITE_4PIXELS16_SUB, WRITE_4PIXELS16_FLIPPED_SUB, 4)
}

void DrawClippedTile16Sub (uint32 Tile, uint32 Offset,
			   uint32 StartPixel, uint32 Width,
			   uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    TILE_CLIP_PREAMBLE
    RENDER_CLIPPED_TILE(WRITE_4PIXELS16_SUB, WRITE_4PIXELS16_FLIPPED_SUB, 4)
}

void DrawTile16Sub1_2 (uint32 Tile, uint32 Offset, uint32 StartLine,
		       uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    RENDER_TILE(WRITE_4PIXELS16_SUB1_2, WRITE_4PIXELS16_FLIPPED_SUB1_2, 4)
}

void DrawClippedTile16Sub1_2 (uint32 Tile, uint32 Offset,
			      uint32 StartPixel, uint32 Width,
			      uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE
    register uint8 *bp;

    TILE_CLIP_PREAMBLE
    RENDER_CLIPPED_TILE(WRITE_4PIXELS16_SUB1_2, WRITE_4PIXELS16_FLIPPED_SUB1_2, 4)
}

inline uint16 LARGE_ADD_PIXEL (uint16 *Screen, uint32 P)
{
    return (COLOR_ADD (P, Screen [GFX.Delta]));
}

void DrawLargePixel16Add (uint32 Tile, uint32 Offset,
			  uint32 StartPixel, uint32 Pixels,
			  uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE

    register uint16 *sp = (uint16 *) GFX.S + Offset;
    uint16 pixel;

    RENDER_TILE_LARGE (IPPU.ScreenColors [pixel + tt], LARGE_ADD_PIXEL)
}

inline uint16 LARGE_ADD_PIXEL1_2 (uint16 *Screen, uint32 P)
{
    return (COLOR_ADD1_2 (P, Screen [GFX.Delta]));
}

void DrawLargePixel16Add1_2 (uint32 Tile, uint32 Offset,
			     uint32 StartPixel, uint32 Pixels,
			     uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE

    register uint16 *sp = (uint16 *) GFX.S + Offset;
    uint16 pixel;

    RENDER_TILE_LARGE (IPPU.ScreenColors [pixel + tt], LARGE_ADD_PIXEL1_2)
}

inline uint16 LARGE_SUB_PIXEL (uint16 *Screen, uint32 P)
{
    return (COLOR_SUB (P, Screen [GFX.Delta]));
}

void DrawLargePixel16Sub (uint32 Tile, uint32 Offset,
			  uint32 StartPixel, uint32 Pixels,
			  uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE

    register uint16 *sp = (uint16 *) GFX.S + Offset;
    uint16 pixel;

    RENDER_TILE_LARGE (IPPU.ScreenColors [pixel + tt], LARGE_SUB_PIXEL)
}

inline uint16 LARGE_SUB_PIXEL1_2 (uint16 *Screen, uint32 P)
{
    return (COLOR_SUB1_2 (P, Screen [GFX.Delta]));
}

void DrawLargePixel16Sub1_2 (uint32 Tile, uint32 Offset,
			     uint32 StartPixel, uint32 Pixels,
			     uint32 StartLine, uint32 LineCount, uint8 Z)
{
    TILE_PREAMBLE

    register uint16 *sp = (uint16 *) GFX.S + Offset;
    uint16 pixel;

    RENDER_TILE_LARGE (IPPU.ScreenColors [pixel + tt], LARGE_SUB_PIXEL1_2)
}
