/*
 * Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 *
 * (c) Copyright 1996, 1997, 1998 Gary Henderson (gary@daniver.demon.co.uk) and
 *                                Jerremy Koot (jkoot@snes9x.com)
 *
 * Super FX C emulator code 
 * (c) Copyright 1997, 1998 Ivar (Ivar@snes9x.com) and
 *                          Gary Henderson.
 * Super FX assembler emulator code (c) Copyright 1998 zsKnight and _Demo_.
 *
 * DSP1 emulator code (c) Copyright 1998 Ivar, _Demo_ and Gary Henderson.
 * DOS port code contains the works of other authors. See headers in
 * individual files.
 *
 * Snes9x homepage: www.snes9x.com
 *
 * Permission to use, copy, modify and distribute Snes9x in both binary and
 * source form, for non-commercial purposes, is hereby granted without fee,
 * providing that this license information and copyright notice appear with
 * all copies and any derived work.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event shall the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Snes9x is freeware for PERSONAL USE only. Commercial users should
 * seek permission of the copyright holders first. Commercial use includes
 * charging money for Snes9x or software derived from Snes9x.
 *
 * The copyright holders request that bug fixes and improvements to the code
 * should be forwarded to them so everyone can benefit from the modifications
 * in future versions.
 *
 * Super NES and Super Nintendo Entertainment System are trademarks of
 * Nintendo Co., Limited and its subsidiary companies.
 */

#include "snes9x.h"
#include "memmap.h"
#include "ppu.h"
#include "dsp1.h"
#include "cpuexec.h"
#include "debug.h"
#include "apu.h"
#include "dma.h"

void S9xResetSA1 ()
{
    SA1.PB = 0;
    SA1.PC = S9xGetWord (0xFFFC);
    SA1.D.W = 0;
    SA1.DB = 0;
    SA1.SH = 1;
    SA1.SL = 0xFF;
    SA1.XH = 0;
    SA1.YH = 0;
    SA1.P.W = 0;

    SA1.ShiftedPB = 0;
    SA1.ShiftedDB = 0;
    SA1SetFlags (MemoryFlag | IndexFlag | IRQ | Emulation);
    SA1ClearFlags (Decimal);

    SA1.Flags = 0;
    SA1.Cycles = 0;
    SA1.NextEvent = Settings.HBlankStart;
    SA1.V_Counter = 0;
    SA1.BranchSkip = FALSE;
    SA1.NMIActive = FALSE;
    SA1.IRQActive = FALSE;
    SA1.WaitingForInterrupt = FALSE;
    SA1.InDMA = FALSE;
    SA1.WhichEvent = HBLANK_START_EVENT;
    SA1.PC = NULL;
    SA1.PCBase = NULL;
    SA1.MemSpeed = 8;
    SA1.MemSpeedx2 = 16;
    SA1.FastROMSpeed = 8;
    SA1.PCAtOpcodeStart = NULL;
    SA1.WaitAddress = NULL;
    SA1.WaitCounter = 0;
    S9xSA1SetPCBase (Registers.PC);

    SA1.Speed = S9xE1M1X1;
    SA1.S9xOpcodes = S9xOpcodesM1X1;
    SA1.CPUExecuting = TRUE;

    S9xSA1UnpackStatus();
}
