.\" kdrill.1 94/07/5
.TH KDRILL 1 "August 2nd, 1994" "Phil\'s Software"
.SH NAME
kdrill v4.0 \- drill program for kanji chars under Xwindows (X11R5 or
better)


Yikes.. this man-page is getting huge. But I am a great believer in
having proper documentation. Hopefully, this new format will help instead
of hinder.

REMEMBER:  "/WORD" usually takes you to the next occurence of "WORD",
using a "man" program.

.SH SECTIONS
 RUNTIME OPTIONS
 RESOURCES
 DESCRIPTION
 PLAYING
 PLAYING OPTIONS
 SEARCH
 KEYBOARD ACCELERATORS
 USEFILES
 CONFIGURATION DETAILS
 LOGFILES AND MISSED KANJI
 KANJIDIC

.SH RUNTIME OPTIONS

.TP
.B \-usefile \fINewUsefileName\fR
Change name of usefile, which lets you drill on specific characters.
.TP
.B \-nousefile
Still read in usefile if it exists, but ignore it at startup.
.TP
.B \-dictfile \fIOtherKanjidicFile\fR
Use a different dictionary file name.
.TP
.B \-englishfont \fIFontName\fR
Changes only english display of english-guess buttons.
.TP
.B \-kanjifont \fIKanjiFontName\fR
Change large kanji font.
.TP
.B \-smallkanji \fIKanjiFontName\fR
Change small kanji/kana font for kana-guess buttons.
.TP
.B \-noBell 
Turns off beep on wrong answer.
.TP
.B \-guessmeaning 
 Start with one meaning and five kanji to guess from.
.TP
.B \-showinorder
Start in ordered mode. Go through desired kanji in order of #.
.TP
.B \-gradelevel \fI<level #s>\fR
Start with different grade levels enabled. [123456+]
.TP
.B \-showkana
Start with kana meanings instead of english.
.TP
.B \-lowfrequency #, \-highfrequency #
Set lowest and/or highest frequency kanji you want to see.
.TP
.B \-logfile \fIfilename\fR
Change filename to log current errors to (with "Log" button)
.TP
.B \-notallT
Don't insist that all dictionary entries have kana AND English.
\fBWARNING!\fR Normal operation is to ignore incomplete entries, and
thereby enable switching from kana to english without changing the quiz
kanji. Using this option will make kdrill move to another kanji if you
switch kana to English or vica versa.
 \[: default behaviour currently loses 300 kanji, with the kanjidic
file I have currently. All characters with Frequency ratings have full
translations. \]

.SH RESOURCES
All the above options can be set in a resource file, with the same names
as the flags. Addition resources, like fonts, and window placement, can
also be set. See the sample "KDrill" file for more detail, which is
often installed in /usr/lib/X11/app-defaults. 
You do not have to be able to change that file. You can usually put your
own customizations in a file called "~/.Xresources".

.SH Colors
You may change the background of the windows using the above resource file.

.SH DESCRIPTION

.B kdrill
is a program to drill users on meanings of kanji characters. Various
formats of drills are available:

.RS 5
   kanji to English
   kanji to kana
   English to kanji
   kana to kanji
.RE

.SH PLAYING
kdrill will present you with either five kanji and one meaning, or one
kanji and five meanings [depending on how you configure it].

Either way, there is a "current kanji" that you are being quizzed on.
Any grade level or frequency rating the current kanji has will be
displayed in the top right hand side of the window, next to the "G:" and
"F:" letters. The kanji index number will be displayed after the "#:" sign. 

Click with your primary mouse button (usually the left one) on one of the multiple-choice
answered to see how well you know the lone kanji or meaning.  You may
also use the number keys to make your choice.
[1,2,3,4,5]

If you guess correctly, you will move on to another character. If you
guess incorrectly, you will have to guess again. Furthermore, kdrill will
make a note that you didn't know either the character displayed, or the
character for the incorrect meaning you clicked on.

If you are playing in random order, kdrill will randomly repeat the ones
you have missed. You will have to get a missed character right twice for
kdrill to think you know it. If you miss a character more than once, you
will have to repeat the character two times the number of times you
missed it. If you are playing in order, kdrill will keep to the
order, and not go back. It will still remember ones you have missed,
however, and will go back to them if you later switch to random order.

There are two ways of "cheating", if you are learning new characters, and
don't want to have an incorrect guess recorded. One way is to press the
"cheat" button, and the correct answer will be highlighted. The other way
is to make a guess with button 2 on your mouse. The character
of the one you clicked on will appear in the search window.
If the search window was not already open, it will appear when you do
this.

.SH PLAYING OPTIONS
If you want to change the way the game works while playing, you can bring
up the options window by pressing the options button. If you know how you
want the game to play before starting it, you can most likely do what you
want with a command-line option, described at the top of this
man-page. If you want to permenantly change an option, see the
"RESOURCES" header, above.

.TP
Grades

You may specify which grade levels you wish to study, by clicking on the
buttons labeled: "1", "2", "3", "4", "5", "6", "+", or "All", in the
"Grade Select" window. You may also select/unselect a grade by holding
down shift, followed by "1", "2", "3", "4", "5", "6", "+", or "a", in the
main window.

The "All" feature will select all grades. but it will not unselect them.

The default is to have all the grades enabled.

.TP 
 Frequency

Some kanji have frequency ratings. That means that, in real life, some
kanji are used more frequently than others. Frequency rating 1 means that
this is \fBthe\fR most frequently used character.  
The frequency of the true answer you are guessing will be displayed in
the top right of the main window, next to the "F:" sign, if a frequency
rating exists. 

The frequency range area in the options window allows you to limit the
kanji you see based on their frequency rating. The frequency range area
consists of two smaller input areas; "High", and "Low". 
.I High
means a kanji that is high frequency. That is to say, something that is
used often. According to the definitions of the dictionary, "1" means the
kanji that is used the \fImost\fR often. A frequency rating of "2" means
that the character has a \fIlower\fR frequency than "1". The most
frequently used kanji is the character for "day", which is "F: 1".

Setting a number in the "High" window limits high frequency kanji.
If there is a number in the "High" window, that means that you will see no
kanji that is of higher frequency than that number. Similarly, setting a
number in the "Low" window means that you will see no kanji of frequency
lower than that number. 2000 is a "Low" frequency kanji. If you put 2000
in the "Low" area, you would see nothing of lower frequency than the
character rated at 2000 (which happens to be "hazy")
that you would see nothing

A blank in the "High" or "Low" fields indicates no limit in the field. If
you try to set either window to "0", it will automatically set itself
blank for you. 

.TP
Order

It is possible to be drilled on kanji in order, without repetition, until
"all" kanji have been covered. Any restrictions on grade level or
frequency will still apply. To enable or disable ordering, click on the
"Showing randomly" (or "Showing in order") button in the options window.

\fINote that "in order" does not mean in order of frequency.\fR It means
in the order represented by the dictionary, denoted by the '#' number
shown at top right. This happens to be the JIS-encoding of the Kanji,
which we also call the kanji index.

.SH SEARCH
With kdrill version 4.0, it is now possible to search for a character.
First, bring up the search window by pressing the search button. Then,
enter an English word (or fragment) in the bottom-most section of the
window, and press return or enter. The window will then display the first
kanji it finds that has that word in its definition, along with its
index number, grade, and other information available, if any.

If you press return again, kdrill will look for the next character that
has the word in its definition. Eventually, it will loop back to the
first one it found. If no matches are found, all fields will be blank.

Unfortunately, it is not easily possible to search for a kanji through
kana description, because the Athena widget set "Xaw" does not seem to
like handling 16=bit characters for input.

.TP
What are all those letters?

The top row; "G, F, #", all refer to the basic indexes that are shown in
the mail kdrill window. They stand for "Grade, Frequency, and Index #",
respectively.

\fBH\fR denotes the index in the "Halperin" dictionary

\fBN\fR denotes the index in the "Nelson" dictionary

\fBUx\fR denotes the "Unicode" of the kanji. It is U\fBx\fR to make it
stand out as the only one that expects input in Hexadecimal. This is
because that is the way the dictionary has it.

For all windows with the little ^ in them, you can change the values.
When you press return or enter in them, kdrill will attempt to find a
match for what you just entered. If it can find no match, it will blank
out all fields displayed.

You can use this jump-to-index feature in the main window too. However,
the main window will keep any restrictions you might have while doing the
search (limits by usefile, grade, or frequency limit).

The search window ignores any restrictions on the main window, and
searches the entire on-line dictionary.

.SH KEYBOARD ACCELERATORS
Almost everything has a keyboard shortcut in kdrill.

    Key                               Action
  1,2,3,4,5                  Make a guess
  Shift+(123456+)            Change grade levels used
  c                          (C)hear
  e                          Toggle (E)nglish/kana 
  k                          Guess which (K)anji fits
  l                          Make a (l)og of errors
  m                          Guess which (m)eaning fits
  o                          Toggle in-(o)rder drill
  O                          Bring up (O)ptions window
  p                          Go back to (p)revious
  Control+q                  (Q)uit kdrill
  u                          Toggle (u)sefile usage.
  s                          (S)earch for a Kanji
  
  

.SH CONFIGURATION DETAILS
kdrill checks for a file by the name of
.B ".kanjiusefile"
in the current directory, although this name can be changed either with
the '-usefile' option, or in a resource file.

kdrill also checks for a logfile, named
.B kdrill.log
by default, in the current directory. This can be changed with the
-logfile option, or in a resource file. See "LOGFILES AND MISSED KANJI",
below.

kdrill uses a file called "kanjidic" (which does not come in the source
package) to interpret many of the various 16-bit kanji chars in the
.I kanji24
font supplied with the X11R5 distribution. This file should be in a place
accessible to all users. Normally it would be in /usr/local/lib or
somewhere similar.

.I kanjidic
subdivides its entries into grade levels, and frequency ratings. Grade
levels are similar to school grade levels, but more compressed. For
kdrill's purposes, grade levels start at 1, and increase to 6. There are
many kanji that do not have a grade level, due to their infrequency of
use, or other reasons. These are denoted by the "+" character in the
grade select window. 

The user can restrict the range of kanji to drill on in different, yet
compatible, ways. The first way is to make a ".kanjiusefile" 
with a an explicit list of desired kanji. 
(described below in "USEFILES"),

Changes you make to the "Grade Select" window or the "Frequency Range"
section will not do anything until you supply the correct match to the
current drill-question (or press the english/kana toggle button).

Keep in mind that the xfd font tool and other applications may refer to
kanji characters by a \fIhexadecimal\fR number. You may enter a
hexadecimal number by starting it with "0x". For example, "0x315c".
To maintain compatibitily with the dictionary, the kdrill "usefile"
expects hexadecimal input, not decimal input. Similarly, the logfile
also stores kanji in hexadecimal format. This makes it easy to use a log
file of kanji you have missed as a usefile, for repeated drilling.

.SH USEFILES

A usefile consists of a list of hex numbers; one per line, no initial
spaces allowed. A usefile lets the program know you are interested in
certain kanji, over the thousands listed in the dictionary.

It is possible to add comment lines by having the very first character
of a line be "#". It is also possible to add english reminders after the
number on each line, so you remember what each number is.  Hex numbers
can be checked or found by using the "xfd" util on the "kanji24" font. 
Alternatively, you could use the search window or main kdrill window.
In on of the "#" input boxes, type in "0x", and then the hex number.
It is best to do this in the search window, since the main window may
have range restrictions on it.

Grade and Frequency restrictions will apply, even if you have a
usefile. Thus, if all your usefile-defined kanji are of grade 4 or
higher, and you have only selected grades 3 and lower, kdrill will
complain that there are not enough kanji available, and attempt to
add viewable grade levels.

If you wish kdrill to ignore your usefile at first, you may use the
\-nousefile option. You can also change whether the program uses your usefile
interactively while the program is running, by toggling the "No Usefile"
button on the options window.

.SH LOGFILES AND MISSED KANJI
Every time you guess incorrectly, kdrill makes a note. It later will give
you extra practice on ones you missed, if you are playing in random order.
It will repeat a character until you get it right a certain number
of times. kdrill will then think you "know" that character (until you
miss it again!)

You can store a list of your incorrect answers by pressing the "Log"
button. kdrill will then write out all the kanji characters it thinks you
do not know into the logfile. This will erase any information previously
in that logfile. The next time you start up kdrill, it will automatically
read in the standardlogfile, if it exists.

The logfile is named "kdrill.log", by default. You may change the name
of the logfile with the -logfile option. 

It is  a good idea to press "Log" just before quitting kdrill.
That way, it will remember which characters you are weak on, for the next
time you play. It will then go back to those characters from time to
time, if you play in "random" order. If you do not press "Log", kdrill
will not save a record of what you have missed.

Alternatively, you can use the logfile as a usefile. kdrill will then
only quiz you on those kanji you missed. If you choose to do this, it is
a good idea to copy the log file over to a different file. That way, you
can make a logfile for your new usefile. For example, in UNIX;

cp kdrill.log kdrill.usefile
kdrill -usefile kdrill.usefile


.SH KANJIDIC
The dictionary for kdrill, kanjidic, is currently available where it
originated, via ftp from
.I monu6.cc.monash.edu.au,
or from a mirror in the U.S. at ftp.uwtc.washington.edu

At the monu6 site, both the dictionary and this program can currently be
found in
.I /pub/nihongo
This program's primary ftp site is now ftp.x.org:/contrib/games.

.SH BUGS
"kanjidic" isn't perfect. There are "incomplete" entries, missing either
English or kana translations. There are also entries consisting of "See
Nxxxx", which isn't really an improvement.  A new version (Aug. 3rd,
1993) is supposed to have filled in most of the gaps. Note that you can
now use the search window to follow those "See Nxxxx" references!

.SH AUTHOR
Philip P. Brown

(Who does not speak Japanese or Chinese, but hopes to one day)

.SH COPYRIGHT
This program was originally created while I was a student at the
University of California. However, this program was developed entirely by
myself, on my own computer, not related to any classwork. I retain sole
right to this program. 

I, Philip Brown, hereby give permission to use, and/or modify this code, so
long as it it not sold for profit, and I am given credit somewhere in
the code. Unrelated works originally derived from this code are not
covered by this restriction (although it would be nice to mention me!)

.SH NOTICE
Nope.. still no donations, no postcards, no 'nuffin. :-(

Bug reports always "welcome". However, please ensure that you can
reproduce it, and let me know your machine type, and version of kdrill.

I hope that this latest version will impress someone enough to actually
send me something tangible in appreciation of this program. (A JOB would
be nice!) As far as I know, nothing else like it exists for UNIX or the X
window system.

Philip Brown
Aug 2nd, 1994

philb@soda.csua.berkeley.edu

