#--------------------------------------------------
#
# manShowMan -- given various formats of names,
#	 search for that man page.  if successful, call manShowManFound
#
# don't use `man' to show because may want to *always*
#	 format with my own macros
#
#--------------------------------------------------

proc manShowMan {fname {goodnum ""} {w .man}} {
	global man manx mani env stat
DEBUG {puts stdout "manShowMan: $fname $goodnum $w"}

	if $manx(shift) { set manx(shift) 0; set w [manInstantiate] }

	set wi $w.info; set t $w.show

	# establish valid variable values
	if {[string trim $fname]==""} return

	# dispatch to pipe, straight text, Texinfo
	# `|command' for shell command, whose text is sucked into search box,
	#    to use with lman, say
	# `< file' syntax for file to suck up raw text
	# for more sophisticated file reading, use NBT

	if {[llength [set filelist [glob -nocomplain -- $fname]]]>1} {
		# show list to choose from => dups!
		manNewMode $w picklist
		manTextOpen $w
		# bolg?
		$w.show insert end [join $filelist "\n"] manref
		manTextClose $w
		return
# need protocol for adding suffix handlers.  generalize manShowXXX
	} elseif {[string match "*/rfc*.txt" $fname]} {
		# just like text file except credit to different account
		incr stat(rfc); incr stat(txt) -1
		manShowRfc $fname $w; return
	} elseif {[regexp {^[|<]} $fname] || [string match "*.txt" $fname]} {manShowText $fname $w; return
	} elseif {[regexp {.*\.texi(nfo)?$} $fname]} {manShowTexi $fname $w; return
#	} elseif {[string match "*.tcl" $fname]} {manShowTcl $fname $w; return
#	} elseif {[string match "*.java" $fname]} {manShowJava $fname $w; return
	}

	# given full path?  if so, don't need to search
	if {[regexp {^(\.\./|\./|[~/$])} $fname]} {
#puts "full path match on $fname"
		return [manShowManFound [fileexp [lfirst $fname]] 0 $w]
	}

	### need to search for name

	# protect backslashes
	regsub "\\\\" $fname "\a" fname

	# goodnum comes from double clicks from sections or previously parsed section number
	if {[lsearch $manx(specialvols) $goodnum]!=-1} {set goodnum ""}

	# construct stem, section, extension
	set oname [string trimright [string trim [lfirst $fname] { ,?!;"'-}] .]
	if {$goodnum!=""} {set tmp "($goodnum)"} {set tmp ""}
	manWinstdout $w "Searching for \"$oname$tmp\" ..." 1
	set fname [string tolower $oname]; # lc w/  () for regexp
	set sname [string trim $fname ()]; # lc w/o ()
	set oname [string trim $oname ()]; # original case w/o ()

	set name $sname; set num ""; set ext ""
# set sect {\..};

	# extract section number in `man(sect)' format
	if {[regexp -nocase {([a-z0-9_.+-:]+)([\t ]*)\(([^)]?)(.*)\)} $fname \
		 all pname spc pnum pext]} {
		set name $pname; set num $pnum; set ext $pext
#		set sect "\\\..$ext"
DEBUG {puts "(num) = $num"}

	# if you have a dot, assume it's the section number
	} elseif {[regexp {(.+)\.(.)([^.]*)$} $oname all namex sectx extx]
# bad sections fixed up later--just check for mandots here
		&& [lsearch -exact $manx(manList) $sectx]!=-1
		&& [lsearch -exact $manx(mandot) $oname]==-1} {
#		set sect {\.}
		set name $namex; set num $sectx; set ext $extx
#		set num [string trimleft [file extension $oname] .]
#		set name [file rootname $oname]
DEBUG {puts ".num = $num"}

	# given section number
	} elseif {$goodnum!=""} {
#		set sect "\\\.$goodnum"
#		set sect {\.}
		set num $goodnum
	}

	# check for multicharacter section "letters"
	if {[lsearch -exact $manx(manList) "$num$ext"]!=-1} {
		set num "$num$ext"; set ext ""
	}

# get section number in `man.sect' format
# no .z's here

	set ext [string tolower $ext]
	if $man(shortnames) {set name [string range $name 0 10].*}
	if [catch {regexp $name validregexpcheck}] { set name [stringregexpesc $name] }
	# restore backslashes
	foreach v {fname sname oname name} { regsub "\a" [set $v] "\\" $v }

	# special case
	if {$name=="tkman"} {manHelp $w; return}

	# search!
	cursorBusy
DEBUG {puts stdout "$name : $num : $ext"}
	set manx(searchtime) [lfirst [time {
	set foundList [manShowManSearch $name $num $ext]
	}]]
	cursorUnset
DEBUG {puts stdout "search time: $manx(searchtime)"}

	# if no matches with extension, look for one without
	set found [llength $foundList]
	if {!$found} {
DEBUG {puts stdout "$name not found: $ext, $num, [file rootname $name], [stringregexpesc $name]"}
		if {$ext!=""} {
			manShowMan $name $num $w; return
		} elseif {$num!="" || [file rootname $name]!=$name} {
			manShowMan [file rootname $name] {} $w
			return
		} elseif {$name!=[stringregexpesc $name] && ![string match {*\\*} $name]} {
			# case when name has embedded regexp meta characters which are part of valid regexp
			manShowMan [stringregexpesc $name] {} $w
			return
		}
	}

	# act on results of search
	if {!$found} {
		# assume got first letter right, but then be leinient
		# letter insert, delete, quasi-transpose, new all ok; later sort by length
		regsub -all {(.)} [string range $name 1 end] {(|\1.?)} fuzzyname
		set fuzzyname "[string index $name 0]$fuzzyname"

		# see if match in disabled Paths
		if [llength [set hiddenList [manShowManSearch $name "" "" 1]]] {
			manNewMode $w picklist
			manTextOpen $w
			$t insert end "However, found in [plural [llength $hiddenList] {disabled path}]:\n\n"
			foreach path $hiddenList {$t insert end "[file dirname [file dirname $path]]" b "/[file tail [file dirname $path]]/[file tail $path]\n"}
			$t insert end "\nPaths can be enabled with the Paths menu, under the man menu."
			manTextClose $w
			#after 2000 $w.paths flash -- can't flash menubuttons, alas
			after 500 $w.man configure -foreground $man(buttbg) -background $man(buttfg)
			after 2500 $w.man configure -foreground $man(buttfg) -background $man(buttbg)

		# see if can find it in master list of man hierarchies
		} elseif [llength [set masterList [manShowManSearch $name MASTER]]] {
			manNewMode $w picklist
			manTextOpen $w
			$t insert end "However, it was found in the master list of manual page directory hierarchies.  You use the [plural [llength $masterList] hyperlink] now, but to find this page and others clustered with it in the usual search, add the corresponding directory (named ..." "" "/man" tt ", not ..." "" "/man" tt "n" i ") to your " "" "MANPATH" sc " in a shell.\n\n"
			# don't show the following if can somehow tell user is an expert... but how?
			#set hyper [lfirst $masterList] -- use as example below... but always get weird ones
			$t insert end "For instance, if the page hyperlink shows " "" "/opt/SUNWrtvc/man/man1/mpeg_rc.1" tt " and your " "" "MANPATH" sc " is " "" "/usr/man:/usr/local/man" tt ", add " "" "/opt/SUNWrtvc/man" tt " to make it " "" "/usr/man:/usr/local/man:/opt/SUNWrtvc/man" tt ".  Then restart TkMan by typing " ""  "retkman" tt ".\n\n"
			foreach path $masterList {$t insert end "$path\n" manref}
			manTextClose $w

		# try a fuzzy match
		} elseif [llength [set fuzzyList [manShowManSearch $fuzzyname]]] {
			set minlen [max 4 [expr [string length $name]-1]]
			set priorityList {}; foreach page $fuzzyList {set fuzlen [string length [file rootname [file tail $page]]]; if {$fuzlen>=$minlen} {lappend priorityList [list $page $fuzlen]}}
			if {[llength $priorityList]} {
				set foundList {}; foreach pagepri [lsort -decreasing -integer -index 1 $priorityList] {lappend foundList [lfirst $pagepri]}
				return [manShowManFound $foundList 0 $w]
			}
		}

		manWinstderr $w "$sname not found"; incr stat(man-no)

	} else {
		set orname [file rootname $oname]
#puts "sorting $foundList"
		set priorityList {}; foreach page $foundList {lappend priorityList [list $page [manShowManPriority $page $num $ext $orname $manx(cursect$w)]]}
		set foundList {}; foreach pagepri [lsort -decreasing -integer -index 1 $priorityList] {lappend foundList [lfirst $pagepri]}
		return [manShowManFound $foundList 0 $w]
	}
}


proc manShowManPriority {m num ext orname onum} {
	global man manx mani

	# locals: d=directory, t=tail, n=number, e=extention
	set d [file dirname $m]; set t [file tail $m]
	set r [file rootname $t]; set n [file extension $t]
	set e [string range $n 2 end]; set n [string range $n 1 1]

	# determine priority value
	# levels: name, lc names, num, ext, num==onum
	set pri 0
# I think $n==$num is true for all or none
	set isGNU [expr {[string index $r 0]=="g" || [regexp -nocase {/gnu} $d]}]
	if {$man(preferGNU)!=""} {
		if {$isGNU} {incr pri 32}
	} elseif {!$isGNU} {incr pri 32}
	if {$n==$num} {incr pri 16} elseif {$n==$onum} {incr pri 1}
	if {$r==$orname} {incr pri 8} elseif {[string tolower $r]==[string tolower $orname]} {incr pri 4}
	if {$e==$ext} {incr pri 2}
	set pri [expr $pri<<7]

	# tie breaker #1: MANPATH order
	set p -1; set l [llength $manx(paths)]
	while {$d!="/" && [set p [lsearch -glob $manx(paths) $d*]]==-1} {
		set d [file dirname $d]
	}

	# should manDescAdd directories be first or last?
	if {$p==-1} {set p $l}
	incr pri [expr $l-$p]
	set pri [expr $pri<<7]

	# tie breaker #2: section number order
	set l [llength $mani(manList)]
	set p [lsearch -exact $mani(manList) $n]; if {$p==-1} {set p $l}
	incr pri [expr $l-$p]

	### use time last seen as another tie breaker (later the better)?

	return $pri
}


# given name, number and extension of manual page,
# return a list of matches as full pathnames
# (should do some memoizing here)
proc manSearchArray {{sectpat ""} {inactive 0}} {
	global man manx mani
# manc

	if {[string match "*MASTER*" $sectpat]} {
		set sects "MASTER"
	} else {
		if {$sectpat=="" || [lsearch $manx(manList) $sectpat]==-1} {set sectpat "*"}
		set sects $manx(manList)
	}

	set vars {}
	foreach s $sects {
		if {![string match $sectpat $s] || ![info exists mani($s,dirs)]} continue
		foreach d $mani($s,dirs) {
			set sup [file dirname $d]
			if {([info exists man($sup)] && !$man($sup)) ^ $inactive} continue
			lappend vars "$s,$d"
		}
	}
	return $vars
}


proc manManComplete {w} {
	global manx

	set t $w.show; set wi $w.info
	
	set typelen [string length $manx(typein$w)]
	if {$typelen<=1} return

	set candidates {}
	foreach c [string tolower [manShowManSearch "$manx(typein$w).*"]] {
		lappend candidates [file tail $c]
	}
	set cnt [llength $candidates]
	if {!$cnt} {
		manWinstderr $w "no matches"
		return
	} elseif {$cnt>=2} {
		if {[string length $candidates]<50} {
			manWinstderr $w $candidates
		} else {
			manTextOpen $w
			$t insert end $candidates
			manTextClose $w
		}
	}

	# compute longest common prefix
	set typeend [expr $typelen-1]
	set pfx [lfirst $candidates]; set end [expr [string length $pfx]-1]
	foreach c $candidates {
		set cend [expr [string length $c]-1]
		if {$end>$cend} {set end $cend; set pfx [string range $pfx 0 $end]}
		while {[string range $c 0 $end]!=$pfx} {incr end -1; set pfx [string range $pfx 0 $end]}
		if {$end==$typeend} break
	}

	set manx(typein$w) $pfx
	$w.mantypein icursor end
}


proc manShowManSearch {name {sect ""} {ext ""} {inactive 0}} {
	global man manx mani manc

	set foundList {}
#	set e "^$man(preferGNU)$name\$"
#	set e "^(g|n)?"; # include GNU and "new" too, whether preferred or not
#	if {[string length $name]>=5} {append e ".[string range $name 1 end]"} else {append e $name}
#	append e "\$"
	set e "^(g|n)?$name\$"; # include GNU and "new" too, whether preferred or not

#puts "manSearchArray $sect$ext* $inactive => [llength [manSearchArray $sect$ext* $inactive]]"
	foreach subvar [manSearchArray "$sect$ext*" $inactive] {
		set d [lsecond [split $subvar ","]]
		set var manc($subvar)
#puts "$var for $sect"

		# need an lsearch that can return all matches or at least search from a starting index
		if {[info exists manc($subvar)]} {
# && [set match [lsearch -regexp $manc($subvar) $e]]!=-1} {
			# if at least one match, find them all
			foreach p $manc($subvar) {
				if {[regexp -nocase $e $p]} {

					set f "$d/$p"
#					puts "found $f"

					if {[set actual [glob -nocomplain "$f.?*"]]==""} {
						# could have been stray cat that was normalized
						if {[regsub {/man([^/]+)$} [file dirname $f] {/cat\1} d2]} {
							set actual [glob -nocomplain "$d2/[file tail $f].?*"]
						}
					}
#puts "actual = $actual"
					foreach i $actual {
						zapZ! i
						if {[regexp "$manx(bkupregexp)\$" $i]} continue
						if {[lsearch $foundList $i]==-1} {lappend foundList $i}
					}
				}
			}
		}
	}
	return $foundList
}



#--------------------------------------------------
#
# manShowManFound -- display man page and update gui with parse info
#
# invariants:
#	 manx(catfull$w)!="" iff loaded from .../cat. directory
#--------------------------------------------------

proc manShowManFound {f {keep 0} {w .man}} {
	global man manx stat pagecnt

	set t $w.show; set wi $w.info

	if {$man(maxpage)} {pack forget $w.kind $w.search}

#	if {$manx(effcols)!=""} { -- can have long lines enabled but set to 65 columns
		set fid [open $manx(longtmp) "w"]; puts $fid ".ll $man(columns)\n.hym 20"; close $fid
# doesn't work, macros are overridden	set fid [open $manx(longtmp) "w"]; puts $fid ".ll $man(columns)\n.de VS\n..\n.de VE\n"; close $fid
#	}

	# update dups arrow
	set flen [llength $f]
	if {$flen>1} {
		set manx(manhits) $f

		# multiple matches
		pack $w.dups -after $w.mantypein -side left -anchor e -padx 10; $w.dups configure -state active
		after 2000 raise $w.dups
		set m $w.dups.m
		$m delete 0 last
		foreach i [lrange $f 0 100] {$m add command -label $i -command "incr stat(man-dups); manShowManFound $i 1 \$manx(out$w)"}
		manMenuFit $m

		set f [lfirst $f]
	} elseif {!$keep} {pack forget $w.dups; set manx(manhits) {}}

	# usually get name from database which doesn't have .z's, but just in case (and for transition time)
	set f [zapZ [string trim $f]]

	manNewMode $w man; incr stat(man)


	# only redirect text of man pages
#puts "show me $f$manx(zoptglob)"
	# passed filename may or may not have (i.e., need) compression suffix
#	if {[set fg [lfirst [glob -nocomplain $f*$manx(zoptglob)]]]!=""} {

	set frcs "[file dirname $f]/[zapZ [file tail $f]]"
	set isrcs 0
	if {[regexp {([^/]+):([0-9\.]+)$} $f all rcstail rcsrev] 
		&& [file readable [set frcs "[file dirname $frcs]/$rcstail"]]} {

#puts "rcstail=$rcstail, frcs=$frcs, rcsrev=$rcsrev"
		set isrcs 1
#		set f [file dirname $frcs]/$rcstail
#		set f $frcs
		set fid [open "|$man(co) -p$rcsrev"]

	} elseif {[set fg [lfirst [glob -nocomplain $f$manx(zoptglob)]]]!=""} {
		set f $fg

		if [file isdirectory $f] {
			manWinstderr $w "$f is a directory"
			return
		} elseif ![file readable $f] {
			manWinstderr $w "$f not readable"
			return
		}

		set fid [open "|[manManPipe $f]"]

	} else {manWinstderr $w "$f doesn't exist"; return}

	set f0 $f

	# for relative names w/. and ..
	set tmpdir [file dirname $f]
#	set f [stringesc $f $manx(regexpmetachars)]
#puts "$f => $f"

	# on first line, check for single-line .so file pointing to a compressed destination
	# on second line, check for "  Purpose" as sign of IBM AIX manual page
	set so 0
#	catch {
	set line1 [set line2 ""]
#	if {[file readable $f]} {
#		set fid [open "|[manManPipe $f]"] -- moved up
		while {([string trim $line1]=="" || [regexp {^[.']\\"} $line1]) && ![eof $fid]} {gets $fid line1}
		while {[string trim $line2]=="" && ![eof $fid]} {gets $fid line2}
		catch {close $fid}
#puts stderr "***$line1***\n***$line2***"
		# don't be fooled by simple inclusion of macro file
		if {[regexp {^\.so (man.+/.+)} $line1 all newman]} {
DEBUG {puts stderr "*** single-line .so => $manx(manfull$w): $line1"}
			# glob here as redirected file may be compressed
			# (catch in case destination of .so doesn't exist)
			if [catch {set f [lfirst [glob [file dirname $tmpdir]/$newman*$manx(zoptglob)]]}] return
			set tmpdir [file dirname $f]
			set so 1
DEBUG {puts stderr "*** new f => $f"}
		}
#	}
#	}

	# set up variables
	set manx(manfull$w) $f
	set manx(man$w) [zapZ [file tail $f]]
	# used to rootname so can do easy apropos or glimpse if don't find a match
	if $isrcs {set manx(name$w) $f} else {set manx(name$w) [string trimright [file rootname $manx(man$w)] "\\"].[manSetSect $w $f]}
#	set manx(name$w) [string trimright $manx(man$w) "\\"]

	set fdir [zapZ [file dirname $manx(manfull$w)]]
	set topdir [file dirname $fdir]
	# strip trailing Zs
	set manx(num$w) [string range [file tail $fdir] $manx(dirnameindex) end]
	if {[lsearch $man(manList) $manx(num$w)]==-1} {set manx(num$w) [string index $manx(num$w) 0]}
#puts "manx(num\$w) = $manx(num$w)"
#	set manx(num$w) [string range [file extension $manx(man$w)] 1 1]
#	if {[file extension $manx(man$w)]==".man"} {set manx(num$w) [string range [file dirname $f] 1 1]}
	set cat "$topdir/cat$manx(num$w)$manx(effcols)"


	# set FSSTND for finding and saving
	# Linux FSSTND: /usr/<blah/>man/manN/<name> => /var/catman/<blah>/catN/<name>
	set fsstnd ""
	if {[regexp {^(/usr)?/(.*)man/man(.*)$} [file dirname $manx(manfull$w)] all junk prefix suffix]} {
		set fsstnd "$man(fsstnddir)/${prefix}cat$suffix$manx(effcols)/$manx(man$w)$manx(zoptglob)"
DEBUG {puts "*** fsstnd = $fsstnd"}
	}

# if get good translation from [tn]roff source, use it
#	if {$manx(rman-source) && $man(prefersource)} {
#		set manx(catfull$w) $manx(manfull$w)
#		set pipe [manManPipe $manx(catfull$w)]

	set gotcat 0
	# if cat-only, then manfull is cat already
	if {$isrcs || [string match "*ignore*" $man(nroffsave)]} {
# || $flonglines))} {
		# ignoring cache -- keep gotcat==0
	} elseif {[regexp $man(catsig) $fdir]} {
#[string match */cat?*/* $f]} {
# $tmpdir] || [string match */cat?* [file dirname $tmpdir]]} {
		set manx(catfull$w) $manx(manfull$w)

		if {$line2=="  Purpose"} {
			manShowText $f $w 1
			set manx(typein$w) [set manx(name$w) [file rootname [set manx(man$w) [file tail $f]]]]
			return
		}
		set gotcat 1
	} else {
DEBUG {puts "regexp on $topdir"}
		# bizarro cases:
		# Linux FSSTND set above
		# BSDI suffixes formatted pages with .0 rather than .<section>
		set bsdi "$cat/[file rootname $manx(man$w)].0$manx(zoptglob)"
#puts "bsdi = $bsdi"
		# stupid, stupid IRIX
		set irix "$cat/[file rootname $manx(man$w)].z"
#puts "irix = $irix"
#		set manx(catfull$w) "$cat*/$manx(man$w)$manx(zoptglob)"
		set manx(catfull$w) "$cat{,.Z}/$manx(man$w)$manx(zoptglob)"
DEBUG {puts "manx(man\$w) = $manx(man$w), catfull = $manx(catfull$w)"}


		# check for already-formatted man page that's up to date vis-a-vis source code
	    # for case of source a link to nowhere but formatted version OK (yeesh)
		if [catch {set manfullmtime [file mtime $manx(manfull$w)]}] {set manfullmtime 0}

#puts "list is  [list $manx(catfull$w) $fsstnd $bsdi $irix]"
		foreach catme [list $manx(catfull$w) $fsstnd $bsdi $irix] {
			if {$catme==""} continue
#puts "trying $catme"
			if {[set path [lfirst [lsort [glob -nocomplain $catme]]]]!=""
				&& [file readable $path] && [file mtime $path]>=$manfullmtime} {
					set manx(catfull$w) $path
					set gotcat 1
#puts "got it: $path"
					break
			}
#puts "catme now $catme"
		}
	}


	# need to format from roff source
	if {$isrcs} {
		# man(format) until/if source interpretation
		set pipe "$man(co) -p$rcsrev $frcs | $man(format)"
	} elseif {$gotcat} {
		set pipe [manManPipe $manx(catfull$w)]
	} elseif {[file exists $manx(manfull$w)]} {
		# cd into top of man hierarchy in case get .so's
		if {[string match */man?* $tmpdir]} {
			set topdir [file dirname $tmpdir]
		} else {set topdir $tmpdir}
		if [catch {cd $topdir}] {
			manWinstderr $w "Can't cd into $topdir.  This is bad.  Change permissions."
			return
		}
#puts stdout "\n\n\tcurrend dir [pwd]"
#puts stdout "manShowManFound\n\tcatfull = $cat, manfull = $manx(manfull$w)"
		# try to save a nroff-formatted version?
		# check for H-P save directory
		if {[string match "*compress" $man(nroffsave)] && [file writable "$cat.Z"]} {
			append cat ".Z"
		}
		if {[string match "on*" $man(nroffsave)]} {
			set saveerr ""

			# if .../catN unavailable, check Linux /var/catman alternative
			if {([file exists $cat]? ![file writable $cat] : ![file writable [file dirname $cat]])
				&& [file writable $man(fsstnddir)] && $fsstnd!=""} {
				set cat [file dirname $fsstnd]
			}

			# may need to create intermediate directories
			set idir ""
#puts "cat = $cat"
			foreach dir [file split [string range $cat 1 end]] {
#puts "idir = $idir, dir = $dir"
				if {![file exists $idir/$dir]} {
DEBUG {puts "\tmaking $idir/$dir"}
#					if {![file writable $idir]} {
#						manWinstderr $w "$idir not writable when trying to mkdir $dir"
#						break
#					}
					if [catch "file mkdir $idir/$dir" info] {
DEBUG {puts "\t  ERROR: $info"}
#						manWinstderr $w $info 1
						set saveerr $info
						break
					} else {
						# permissions: if dir=.../catN and exists .../manN, make same as .../manN
						# otherwise make same a parent directory (assume never have to create /)
						catch {
							if {"$idir/$dir"!=$cat || ![string match cat* $dir] ||
							![file isdirectory [set permme "$idir/man[string range $dir 3 end]"]]} {
								set permme $idir
							}
							file stat $permme dirstat
							set perm [format "0%o" [expr $dirstat(mode)&0777]]
DEBUG { puts "\tsetting permission of directory $idir/$dir to $perm, from $permme" }
							file attributes "$idir/$dir" -permissions $perm
						}
					}
				}
				append idir "/$dir"
			}

			if {$saveerr!=""} {
				# nothing
			} elseif {![file writable $cat]} {
				set saveerr "CAN'T SAVE: $cat not writable"
			} else {
				# same name as source file, different directory
				set path [set manx(catfull$w) $cat/$manx(man$w)]
				if $manx(fBSDI) {[set path [set manx(catfull$w) "$cat/[file rootname $manx(man$w)].0"]]}

				manWinstdout $w "Saving copy formatted by nroff ..." 1
				# zap any existing out of date or compressed
				foreach zapme [glob -nocomplain $path$manx(zoptglob)] {file delete -force $zapme}
				if {$man(columns)!=65} {set redirect "2>/dev/null"} {set redirect ""}
				if [catch {eval "exec [manManPipe $manx(manfull$w)] | $man(format) > $path $redirect"} info] {
					set saveerr "CAN'T SAVE: $info"
				} else {
					catch {
						file stat [file dirname $manx(manfull$w)] dirstat
						set perm [format "0%o" [expr $dirstat(mode)&0666]]
DEBUG { puts "\tsetting permission of $path to $perm, from $manx(manfull$w)" }
						file attributes $path -permissions $perm
 					}

					# if successfully saved formatted version, check on compressing it
					if {[string match "*compress" $man(nroffsave)]} {
						manWinstdout $w "Compressing ..." 1
						if [catch "exec $man(compress) $manx(catfull$w)" info] {
							set saveerr "CAN'T COMPRESS:  $info"
							# set path -- keep same path
							# return -- ok to fall through
						} elseif {[file extension $cat]==".Z"} {	# H-P
							file rename [glob $manx(catfull$w).$manx(zglob)] $manx(catfull$w)
							set path $manx(catfull$w)
						} else {
							set path [set manx(catfull$w) [lfirst [glob $manx(catfull$w).$manx(zglob)]]]
						}
					}
					set pipe [manManPipe $path]
				}
			}

			# if problem making nroff version, fall back
			if {$saveerr!=""} {
				after 20 manWinstdout $w "{$saveerr}"
				set path $manx(manfull$w)
				set manx(catfull$w) ""
				set pipe "[manManPipe $path] | $man(format)"
			}

		# don't save formatted version
		} else {
			set path $manx(manfull$w)
			set manx(catfull$w) ""
			set pipe "[manManPipe $path] | $man(format)"
		}

	} elseif [catch {[file readlink $manx(manfull$w)]}] {
		manWinstderr $w "$manx(manfull$w) is a symbolic link that points nowhere"
		return
	} else {
		manWinstderr $w "$manx(manfull$w) not found"
		return
	}


	# got full file name, now show it
	set errflag 0
	set msg [expr [string match "*/*roff*" $pipe]?"Formatting and filtering":"Filtering"]
	manWinstdout $w "$msg $manx(name$w) ..." 1


# can't really have -p here
	append pipe " | $manx(rman) -f TkMan $manx(normalize) $man(subsect) $man(headfoot)"
	if $man(rebus) {append pipe " -R $manx(rebus)"}
# $man(zaphy)
DEBUG {puts stderr "pipe = $pipe"}

	# source should take a pipe argument: "source |$pipe"
	if [catch {set fid [open "|$pipe"]} info] {
#		manWinstderr $w "Deep weirdness with $path.  Tell your sys admin."
		manWinstderr $w "ERROR: $info"
DEBUG {puts "can't open pipe: $info"}
		return
	}

	manTextOpen $w
	# want line at a time so can see first n lines quickly
	set loadtime [lfirst [time {
# plan A -- significately slower than plan B
#	while {[gets $fid line]!=-1} {eval $line}
# plan B -- shows first page quickly, but slower overall (text, canvas 0.79 sec) than plan C
 	while {![eof $fid]} {eval [gets $fid]}
# plan C - doesn't show first page quickly
#	eval [read $fid]
# plan D - quicker, but Perl 4 page uses 200K more memory! => so decided not quick enough!
#	set ctr 0
#	while {![eof $fid] && [incr ctr]<100} {eval [gets $fid]}
	# ... gobble rest as fast as possible
#	if {![eof $fid]} {eval [read $fid]}
# plan E - no that compiler insists on compiling lines, avoid it on test insertion lines - takes ~1.00
#	while {[gets $fid line]!=-1} {
#		if {[set ch [string index $line 0]]!="\"" && $ch!="\{"} {
#			eval $line
#		} else {
#			foreach {txt tag} $line {$t insert end $txt $tag}
#		}
#	}
# plan F - slower than B
#	while {![eof $fid]} {
#		if {[set ch [read $fid 1]]!=" "} {
#			# this case doesn't happen often
#			eval "$ch[gets $fid]"
#		} else {
#			# avoid compilation
#			foreach {txt tag} [gets $fid] {$t insert end $txt $tag}
#			$t insert end [gets $fid]
#		}
#	}
	}]]
DEBUG {puts "formatting time: $loadtime"}
	while {[$t get 1.0]=="\n"} {$t delete 1.0}

	# add tags from "raw" RosettaMan, before start zapping text
	$t tag add man 1.0 end-1c; # handles single tab lines and leftovers
	set cnt 1
	foreach tabcnt $manx(tabcnts) {
		if {$tabcnt>=2 && $tabcnt<=6} {$t tag add tab$tabcnt $cnt.0 "$cnt.0 lineend"}
		incr cnt
	}
	foreach clo $manx(clo) {$t tag add clo $clo.0}
	foreach para $manx(para) {$t tag add para1 $para.0}
	foreach reb $manx(reb) {$t tag add reb $reb.0}

#	$t mark set endcontent end
#	$t mark gravity endcontent left

	# pseudo-section for Revision History
	set rcsfile "[file dirname $frcs]/RCS/[file tail $frcs],v"
	set rcscache "[file dirname $frcs]/RCSdiff/[file tail $frcs]"
	if [file readable $rcsfile] {
		catch {
		set rlog [exec $man(rlog) $frcs]
		set index [expr {$man(headfoot)==""? "end-1l" : "[lindex [$t tag ranges h2] end] linestart-1l"}]
		$t insert $index "\n" "" "Revision History\n" h2 "\n[string trim $rlog]" "" "\n\n"
		# hyperlinks of revision x.y
		set revregexp {^revision ([0-9\.]+)}
		while {[set index [$t search -regexp $revregexp $index+1l end]]!=""} {
			regexp $revregexp [$t get $index "$index lineend"] all rev
			$t insert "$index lineend" "\t$frcs:$rev" {manref hyper}
		}
		}
	}

	if {!$isrcs && $man(headfoot)!=""} {
		set f $manx(manfull$w)

		if [catch {set og "[file attributes $f -owner]/[file attributes $f -group]"}] {set og "(unknown)"}

		$t insert end "[bolg $f ~], installed [recently [file mtime $f]] by $og\n"
		# report corresponding binaries, if any, automatically listing first one that would be executed
		set binpre "binary: "; set binpost ""; set bincnt 0
		set bin [file rootname $manx(name$w)]; # strip suffix
		foreach bindir $manx(bin-paths) {
			foreach path [glob -nocomplain $bindir/$bin $bindir/$bin-*] {
				if [catch {set binog "[file attributes $path -owner]/[file attributes $path -group]"}] {set binog "(unknown)"}
				set binvers ""
# too dangerous
#				foreach flag {"--version" "-V" "-v"} {
#					if {[catch {set versdump [exec $path $flag < /dev/null]} errinfo]} {set versdump $errinfo}
#					if {[regexp $manx(bin-versregexp) $versdump vers]} {
#						set binvers " (v$vers)"
#						break
#					}
#				}
				$t insert end "$binpre[bolg $path ~]$binvers, installed [recently [file mtime $path]]"
				if {$binog!=$og} {$t insert end " by $binog"}
				$t insert end "$binpost\n"; incr bincnt
				# break -- to prevent alternatives
				set binpre "   also:  "; set binpost ""
			}
		}
		set actvol [string index [file extension [zapZ $f]] 1]
		if {$bincnt==0 && ($actvol==1 || $actvol==6 || $actvol==8)
			&& ![string match "Intro*" $f] && ![string match "List*" $f]} {
			$t insert end "No corresponding binary in PATH!" bi
			set binalts ""
			foreach bindir [concat $manx(aux-binpaths) "[file dirname [file dirname $f]]/bin" "[file dirname [file dirname [file dirname $f]]]/bin"] {
				if {[llength [glob -nocomplain $bindir/$bin $bindir/$bin-*]]} {
					append binalts ":$bindir"
				}
			}
			if {$binalts==""} {
				$t insert end "  This may be fine, but it is unusual for volume $actvol"
				catch {$t insert end ", [lindex $manx(manTitleList) [lsearch $manx(manList) $actvol]]"}
			} else {
				$t insert end "  However, try appending \"" "" $binalts tt "\" to your " "" "PATH" sc
			}
			$t insert end ".\n"
		}
		$t insert end "\n"

		# canonical name.  can have name conflicts, but rare
		# continue to verify any conflict would be harmless for read cnt, last read time, cksum
		set fc [zapZ [file tail $f]]
		set fpagecnt [info exists pagecnt($fc)]
		if !$fpagecnt {set pagecnt($fc) [list 0 [clock seconds] 0 0 [clock seconds]]}
		foreach {times lasttime cksum nlines firsttime} $pagecnt($fc) break
		set fnewdate [expr [file mtime $f]>$lasttime]
		if {!$fpagecnt || [llength $pagecnt($fc)]<=2 || $fnewdate} {
			set curcksum 0
			catch {set curcksum [lfirst [eval exec [manManPipe $manx(manfull$w)] | $man(cksum)]]}
#puts "set curcksum \[lfirst \[exec [manManPipe $manx(manfull$w)] | $man(cksum)]] => $curcksum"
		} else {set curcksum $cksum}
		if !$fpagecnt {
			$t insert end "Reading $fc for " "" "first time" b "\n"
		} else {
#			foreach {times lasttime cksum nlines} $pagecnt($fc) {}
			$t insert end "Read $fc  " "" $times b " [plural $times time], last time " "" [recently $lasttime] b "\n"

			if {$fnewdate} {
				if {$cksum!=$curcksum && (![file readable $rcscache] || [file size $rcscache]>1)} {
					# highlights are robust enough to handle the following insertion at 1.0
					set txt "This manual page has changed since you last looked at it.  "
					# if versioning files, can see exactly how it's changed
					if {![file readable $rcsfile]} {
						append txt "If you had an old version in RCS, I could SHOW you exactly how it has changed."
					} elseif {!$man(versiondiff)} {
						append txt "If you turn on Occasionals/Show version differences, version difference information will be incorporated into the page for your examination."
					} else {
						append txt "You can see exactly how by scrolling through the page or by choosing \"version changes\" from the arrow next to \"n lines\" at the bottom of the screen and clicking Search."
					}
					#after 1000 -- screws up NoteMark cacheing now (used to preserve it)
					manTextPlug $t 1.0 "$txt\n\n" b
				}
			}
		}
		# could use destructive list mutation operator
		set pagecnt($fc) [concat [lrange $pagecnt($fc) 0 1] $curcksum [lrange $pagecnt($fc) 3 end]]

		if $manx(mondostats) {
			$t insert end "\n"
			scan [$t index end] "%d" numlines

			$t insert end "search time: "
			$t insert end [format %.2f [expr $manx(searchtime)/1000000.0]] [expr {$manx(searchtime)>600000? "b":""}]
			$t insert end " sec in $manx(db-pagecnt) pages, load time: "
			$t insert end [format %.2f [expr $loadtime/1000000.0]] [expr {$loadtime>1000000? "b":""}]
#			$t insert end " sec for $numlines lines\n"
			$t insert end " sec for [string length [$t get 1.0 end]] chars\n"
#[file size $f] -- file may be compressed

			set manx(searchtime) 0; # in case load from dups or history

			set sum 0; set csum 0
			foreach tag [lsort [$t tag names]] {
				set ranges [$t tag ranges $tag]
				set eol [llength $ranges]
				if {$eol==0} continue
				if {$tag=="h2"} {incr eol -2} elseif {$tag=="sc"} {incr eol -2}
				set ranges [lrange $ranges 0 [expr $eol-1]]
				# doesn't take that long to compute this, on an UltraSPARC anyhow
				foreach {start end} [$t tag ranges $tag] {
					# ok to diff chars as RosettaMan never crosses lines
					scan $start "%d.%d" junk s; scan $end "%d.%d" junk e
					incr csum [expr $e-$s]
				}
				set cnt [expr $eol/2]; incr sum $cnt
				$t insert end "$cnt $tag, "
			}
			$t delete end-3c end-1c
			$t insert end ".   total=$sum tags, covering $csum characters\n"
			$t insert end "averages: [format %.2f [expr $csum/($sum+0.0)]] characters/tag, "
			set tpl [expr $sum/($numlines+0.0)]
			$t insert end [format %.2f $tpl] [expr {$tpl>1.0? "b":""}]
			$t insert end " tags/line"
		}
	}

	manTextClose $w
	manWinstdout $w ""

	# co -p spits to stderr and co -q dumps core
	if {[catch {close $fid} info] && !$isrcs} {
#		manWinstderr $w "Man page not installed properly, probably."
		manWinstderr $w "ERROR: $info"
DEBUG {puts "can't close pipe: $info"}
		return
	}

#	if $manx(mondostats) {
#		# flash stats for 2 seconds
#		$t yview end; update idletasks; after 2000
#	}

	# if followed a .so link, restore initial man page name for history and shortcuts, but not highlights
	# (is this the right policy decision?)
	if {$so} {
		set manx(manfull$w) $f0
		set manx(man$w) [zapZ [file tail $f0]]
		set manx(name$w) [file rootname $manx(man$w)]
#puts stderr "new status: $manx(manfull$w), $manx(man$w), $manx(name$w)"
	}

	# collect js*.* from tags: h2=>jsX, h3=>jsX.Y
	set sect 1
	foreach {s e} [$t tag ranges h2] {$t mark set js$sect $s; incr sect}
	if {$man(headfoot)!=""} {
		$t mark set endcontent js[incr sect -1]-1l; $t mark unset js$sect
		$t tag add sc "endcontent+3l" "end"
	}
	set maxsect [expr $sect-1]
	set lastsect 1; set subsect 0
	foreach {s e} [$t tag ranges h3] {
		# find corresponding section.  since iterating in order, search from last matched section
		set sect $lastsect; while {$sect<=$maxsect && [$t compare js$sect < $s]} {incr sect}
		incr sect -1
		if {$sect!=$lastsect} {set subsect 1} else {incr subsect}; set lastsect $sect
		$t mark set js$sect.$subsect $s
	}

	manShowManFoundSetText $w $t [bolg [zapZ $manx(manfull$w)] ~]

	if {$manx(tryoutline$w) && [set tag $man(manref-show)]!="never"} {
		foreach {s e} [$t tag ranges manref] {nb $t $tag $s $e}
	}


	# do this before go adding and deleting lines!
	# but after figure out NoteMarks, 'cause don't want any show version info unless specifically requested
	$t configure -state normal
	if {$man(versiondiff) && $manx(normalize)=="-N"} {
		scan [time {set diffcnt [manVersion $w $t $f]}] "%d" msec
		if $manx(mondostats) {$t insert end "\ndiff: $diffcnt in [format %.5f [expr $msec/1000000.0]] sec" sc}
	}

	# Rebus - lines found by RosettaMan
	foreach {ls le} [$t tag ranges reb] {
		set s "$ls lineend"
		while {[set s [$t search -elide -backwards -regexp -nocase -count e " ($manx(rebus))" $s $ls]]!=""} {
			set s "$s+1c"; incr e -1
			if {[lsearch [$t tag names $s] manref]==-1} {
				set name "[string tolower [$t get $s $s+${e}c]]Rebus"
				$t delete $s $s+${e}c
				$t image create $s -image $name
			}
			set s "$s-1c"
		}
	}

	manHighlights $w get

	set manx(nb-cache) {}
	notemarks $w $t

	$t configure -state disabled
	manShowTagDist $w h2 3
	manShowTagDist $w manref 1 [$t tag cget manref -foreground]


	# whatis information -- find by scanning text => obsolete with NAME section crunching

	manWinstdout $w ""
	manWinstdout $w $manx(hv$w)

	cd $tmpdir
#	if {$manx(effcols)!=""} {
	file delete -force $manx(longtmp)
#}
	manShowManStatus $w
	wm title $w "$manx(title$w): $manx(man$w)"
	set manx(lastman) $manx(manfull$w)

	# for remote calls(?)
	return $manx(manfull$w)
}



# can't insert/delete text, just change tags
# maybe have RosettaMan make the time-consuming counts =>
#    but autosearch dominates and it's not so amenable (pass regexp, et cetera)
set manx(nb-cache) {}
proc notemarks {w t} {
	global man manx stat

	if {$manx(mode$w)!="man"} return

	# cached?
	if {$manx(nb-cache)!=""} {
		foreach {tag ranges} $manx(nb-cache) {
			if {$ranges!=""} {eval $t tag add $tag $ranges}
		}
		return
	}


	set fll [expr $man(columns)>2*$manx(screencols)]

#puts "*** in [set ccnow [clock clicks]]"; set cclast $ccnow

	# compile list of diffd lines so can quickly skip these lines
	foreach {s e} [$t tag ranges diffd] {
		for {set i [expr int($s)]; set e [expr int($e)]} {$i<$e} {incr i} {
			set diffd($i) 1
		}
	}
#puts "diffd lines [set ccnow [clock clicks]], [expr $cclast-$ccnow]"; set cclast $ccnow

	# command line options as NoteMarks
	if {$manx(tryoutline$w) && $man(options-show)!="never"} {
		# add them all
		# the ...+5c could spill into next line, which would be desired as would have option too short to be meaningful
		foreach {clos cloe} [$t tag ranges clo] {nb $t $man(options-show) $clos "$clos+5c"}
		# if firstvis, remove ones in already opened sections -- though at this point no sections opened!
		if {$man(options-show)=="firstvis"} {
			foreach now $manx(sectposns$w) next $manx(nextposns$w) {
				if {[$t tag cget "area$now" -elide]!="1"} {$t tag remove $man(options-show) $now $next}
			}
		}
	}
#puts "command line options [set ccnow [clock clicks]], [expr $cclast-$ccnow]"; set cclast $ccnow

	after 500 manAutosearch $w $t 1.0

	# if wasting vertical space and haven't shown Description, excerpt a few lines
	set alwaysex [expr {$man(manfill)=="in entirety"}]
	set exsects {}
	if {$manx(tryoutline$w) && [set tag $man(manfill-show)]!="never"} {
		foreach now $manx(sectposns$w) next $manx(nextposns$w) sect $manx(sectname$t) {
			if {[$t tag cget "area$now" -elide]=="1"} {
				# lsearch -regexp compares pattern to string in wrong order for this application
				foreach pat $man(manfill-sects) {if {[regexp -nocase $pat $sect]} {lappend exsects $now $next}}
			}
		}
	}
	set onlyonesect [expr [llength $exsects]<=2]

	set winfoheight [winfo height $t]
	foreach {now next} $exsects {
		set ybot [lsecond [$t bbox endcontent]]; # end-1l?
		if {$ybot=="" && !$alwaysex} break

		# size of description section in lines
		set maxl $manx(lcnt0$now); # don't include subsections
		set effmaxl $maxl; if {$fll} {set effmaxl [expr int($effmaxl*2.5)]}
		# would like to cancel excerpts for very long sections, but expect has 1159-line Commands that works great... maybe limit, ah, density?

		if {$ybot==""} {
			set fit 0
		} else {
			set h [font metrics [expr {$tag=="malwaysvis"?"textpro":"peek"}] -linespace]
#			if {$man(columns)>$manx(screencols)*2} {set maxlscreen [expr $maxlscreen/4]}; # average # screen lines in paragraph is, say, 4... could calculate this with metaindex...
			set fit [min $effmaxl [expr int(($winfoheight-$ybot)/$h)]]
#puts "min $effmaxl, expr int(($winfoheight-$ybot)/$h)"
		}

#puts "fit=$fit, maxl=$maxl, ybot=|$ybot|, sects = $exsects"
#if {$ybot!=""} {puts "expanded size = [expr int(([winfo height $t]-$ybot)/[font metrics $man(textfont) -linespace])]"}
		# if all lines fit with expanded section, do that
		if {$ybot!="" && $onlyonesect && 
#			int(($winfoheight-$ybot)/[font metrics $man(textfont) -linespace]) >= $maxl} {
			int(($winfoheight-$ybot)/[font metrics $man(textfont) -linespace]) >= $effmaxl} {
			manOutline2 $t "" $now

		# all lines of section fit (or almost fit), so show them
		} elseif {$fit>=$effmaxl-1 && $onlyonesect} {
			if {$fll} {
# WRONG
				nb $t $man(manfill-show) "$now+1l linestart" "$now+1l linestart+[expr $fit*$manx(screencols)]c"
			} else {
				$t tag add $man(manfill-show) "$now+1l linestart" "$now+${fit}l linestart"
			}

		# large section, show first lines of each "paragraph", with integer remainder going to first
		# doesn't always use rest of free space, but good enough
		} else {
#puts "start to count paragraphs [set ccnow [clock clicks]], [expr $cclast-$ccnow]"; set cclast $ccnow
			# count "paragraphs"
			set inx $now
			set pcnt 0
			while {[set inx [$t tag nextrange para1 $inx $next]]!=""} {
				set para($pcnt) [expr int([lfirst $inx])]
				incr pcnt; set inx [lsecond $inx]
			}
			set para($pcnt) [expr int([$t index $next])]


			# if enormous number of paragraphs, see if some seem more important
			# (you Perl guys better appreciate this)
#			if {$pcnt>30 && double($pcnt)/double($effmaxl)>0.1} {
#			if {$pcnt>=25} {
				set bcnt 0
				for {set i 0} {$i<$pcnt} {incr i} {
					if {[lsearch -regexp [$t tag names $para($i).1] "b|i"]!=-1} {
						set bpara($bcnt) $para($i); incr bcnt
					}
				}
				set bpara($bcnt) $para($pcnt)
				if {$bcnt>=5} {unset para; array set para [array get bpara]; set pcnt $bcnt}
DEBUG {puts "bcnt=$bcnt"}
				catch {unset bpara}
#			}
#puts "Perl review [set ccnow [clock clicks]], [expr $cclast-$ccnow]"; set cclast $ccnow


			set lcnt 0
#puts "lpp = $fit/$pcnt = [expr $fit/$pcnt]"
			if {$ybot=="" || !$pcnt || !$onlyonesect} {set lpp 1} else {set lpp [max 1 [expr $fit/$pcnt]]}
			$t tag configure $tag -relief [expr {$lpp>1?"raised":"flat"}]
#puts "\a*** $pcnt paragraphs, show $lpp lines per"

			# show first lpp lines in each paragraph, not counting lines already visible
			# stay within $fit or keep on truckin'.  maybe truckin' for malwaysvis only
			for {set p 0} {$p<$pcnt && ($alwaysex || $lpp+$lcnt<=$fit)} {incr p} {
				set lc 0; set pn [expr $para([expr 1+$p])-1]
				# iterate through lines in that paragraph
				for {set l $para($p)} {$l<$pn} {incr l} {
					if {[$t bbox $l.0]!="" || [info exists diffd($l)]} continue

					if {!$fll} {
						$t tag add $tag $l.0 $l.0+1l
						incr lc
					} else {
						# lines in terms of screencols
						scan [$t index "$l.0 lineend"] "%d.%d" junk scrnc
						set scrnl [min [expr $lpp-$lc] [max 1 [expr ($scrnc+$manx(screencols)-1)/$manx(screencols)]]]
						$t tag add $tag $l.0 $l.[expr $scrnl*$manx(screencols)]
						incr lc $scrnl
					}

					if {$lc==$lpp} break
				}
			}
#puts "show first $lpp [set ccnow [clock clicks]], [expr $cclast-$ccnow]"; set cclast $ccnow
			# give integer remainder to first paragraph, maybe leaking into next section
#puts "extra [expr $fit-$lcnt]"
#			if {$lcnt<$fit && $onlyonesect} {$t tag add $tag "$now lineend+1c" "$now lineend+1c+[expr $fit-$lcnt+$lpp]l"}
			if {$lcnt<$fit && $onlyonesect} {$t tag add $tag "$now lineend+1c" "$now lineend+1c" 0 [expr $fit-$lcnt+$lpp]}
		}
	}


	# if STILL have space, start opening up sections
	if $manx(tryoutline$w) {
		foreach now $manx(sectposns$w) {
			if {[set ybot [lsecond [$t bbox endcontent]]]==""} break
#			if {[set ybot [lsecond [$t bbox endcontent]]]==""} continue; # if so, check super
			if {[$t tag cget "area$now" -elide]!="1"} continue

			if {[expr $winfoheight-$ybot]<[expr $manx(lcnt0$now)*[font metrics $man(textfont) -linespace]]} break
			manOutline2 $t "" $now
		}
	}

	# cache
	# all at first viz
	# not search -- just catch the eye at first, not useful in subsequent navigation
	set cache {}; foreach tag $manx(show-ftags) {lappend cache $tag [$t tag ranges $tag]}
	set manx(nb-cache) $cache
# NO	$t tag lower hyper; # "one binding is invoked for each tag, in order from lowest-priority to highest priority"
}

proc manAutosearch {w t inx} {
	global man manx

	set autosearch [string trim $man(autosearch)]
	if {$autosearch==""} return

	# autosearch string
	set next [$t index $inx+200l]
	while {[set inx [$t search -regexp -nocase -forwards -count e -elide "(^|\[ \t\])($autosearch)" $inx+1c $next]]!=""} {
		# just first character?  catches eye but doesn't overwhelm
		$t tag add search $inx+1c
		if {$manx(tryoutline$w) && $man(search-show)!="never"} {
			nb $t $man(search-show) $inx+1c $inx+1c+${e}c; # no lines of context for autosearch
		}
	}

	if {[$t compare $next < end]} {after 500 manAutosearch $w $t $next} {manShowTagDist $w search}
}



# centralized show of region around NoteMark
# (used to be linestart .. lineend, but with lines as paragraphs that's too much)
proc nb {t tag start end {bcon 0} {fcon ""}} {
	global man manx

	if {$fcon==""} {set fcon $bcon}

	# widget lines == screen lines
	if {$man(columns)<2*$manx(screencols)} {$t tag add $tag "$start linestart-${bcon}l" "$end lineend+1c+${fcon}l"; return}

	if {$bcon==0} {set bcon 0.5}; if {$fcon==0} {set fcon 0.5}
	set s "$start-[expr int($manx(screencols)*$bcon)]c"; set smin "$start linestart"; if {[$t compare $s < $smin]} {set s $smin}
	set e "$end+[expr int($manx(screencols)*$fcon)]c"; set emax "$end lineend"
	if {[$t compare "$s+$manx(screencols)c" > $e]} {set e "$s+$manx(screencols)c"}
	if {[$t compare $e > $emax]} {set e $emax}
#	$t tag add $tag "$s wordstart" "$e wordend"
	$t tag add $tag $s $e; # cut into middle of words to emphasize it's an excerpt
	$t tag add $tag "$s lineend"; # linebreaks between disparate marks
}


# gather up command name, options, arguments
proc manPaste {t offset maxBytes} {
	set cmd "blowme "
	foreach {s e} [$t tag ranges cmd] {
		append cmd " " [$t get $s $e]
	}
	return $cmd
}


# pick a random manual page and show it
proc manShowRandom {w} {
	global man manx mani manc high

	expr srand([clock clicks])

	set sect ""
	set page TkMan

	switch -exact $man(randomscope) {
		all {
			# choose section
			while 1 {
				set sect [lindex $manx(manList) [expr int(rand()*[llength $manx(manList)])]]
				if {[lsearch $manx(specialvols) $sect]==-1} break
			}
			# choose page from that section
			while 1 {
				set dir [lindex $mani($sect,dirs) [expr int(rand()*[llength $mani($sect,dirs)])]]
				set page [lindex $manc($sect,$dir) [expr int(rand()*[llength $manc($sect,$dir)])]]
				if {[llength $manc($sect,$dir)]<=3 || ![regexp -nocase {list|intro} $page]} break
			}
		}
		shortcuts {
			if {[llength $man(shortcuts)]==0} {manWinstderr $w "The shortcuts list is empty"; return}
			set sect ""; # take from name
			set page [lindex $man(shortcuts) [expr int(rand()*[llength $man(shortcuts)])]]
		}
		history {
			if {[llength $manx(history$w)]==0} {manWinstderr $w "No pages seen: history empty"; return}
			set sect ""; # have the full path
			set page [lindex $manx(history$w) [expr int(rand()*[llength $manx(history$w)])]]
		}
		dups {
			set len [llength $manx(manhits)]
			if {$len<2} {manWinstderr $w "No pages in multiple matches list"; return}
			set sect ""; # have the full path
			set page [lindex $manx(manhits) [expr int(rand()*$len)]]
			manShowManFound $page 1 $w
			return
		}
		inpage {
			set t $w.show
			set manrefs [$t tag ranges manref]
			#$manx(mode$w)!="man" || 
			if {[llength $manrefs]==0} {
				# if no selection, choose random one from all pages
				set man(randomscope) all; manShowRandom $w; set man(randomscope) inpage
				return
			}
			set sect ""; # take from name
			set i [expr int(rand()*[llength $manrefs]/2)*2]
			set page [$t get [lindex $manrefs $i] [lindex $manrefs [expr 1+$i]]]
		}
		volume {
			set sect $manx(lastvol$w)
			if {[catch {set textlist $mani($sect,form)}] || [llength $textlist]<2} {manWinstderr $w "No last volume"; return}
			set cnt 0
			while 1 {
				set i [expr int(rand()*[llength $textlist]/2)*2]
				set page [lindex $textlist $i]; set tag [lindex $textlist [expr 1+$i]]
				if {$tag=="manref"} break
				if {$cnt<50} {incr cnt} else return
			}
			if {[llength $page]>1} {set page [lindex $page [expr int(rand()*[llength $page])]]}
		}
	}

	manShowMan $page $sect $w
	set manx(tmp-infomsg) [manWinstdout $w]

	if $manx(randomcont) { after 1000 manShowRandom $w }
}


#--------------------------------------------------
#
# manPrint -- kill trees
#
#--------------------------------------------------

proc manPrint {w {printer ""}} {
	global man manx stat env

	set t $w.show; set wi $w.info
# can't get here unless man page
#	if {$manx(mode$w)!="man" && $manx(mode$w)!="txt"} {
#		manWinstderr $w "TkMan only prints man pages."
#		return
#	}

	set f [string trim $manx(manfull$w)]
	if {$f=="" || ![file exists $f]} return
	set tail [zapZ [file tail $f]]; set name [file rootname $tail]; set sect [file extension $tail]
	if {$sect==""} {set sect [string index [file tail [file dirname $f]] $manx(dirnameindex)]}

	set tmp [manWinstdout $w]
	manWinstdout $w "Printing $f ..." 1
	# need to cd in case of trying to print .so pages
	set curdir [pwd]
	set topdir [file dirname $f]
	set printpipe $man(print)
	if {[regexp -- $man(catsig) $topdir]} {
		set printpipe $man(catprint)
		if {[tk_messageBox -title "NO GUARANTEES" -message "No troff source.  Try to reverse compile cat-only page?" -icon question -type yesno -default yes]=="yes"} {
			set printpipe "$manx(rman) -f roff -n $name -s $sect $man(subsect) | $man(print)"
		}
	}
	if {[regexp $man(catsig) $topdir] || [string match */man?* $topdir]} {
		set topdir [file dirname $topdir]
	}

	# try to move into $topdir, but don't complain if can't because it may not be necessary
	catch {cd $topdir}
DEBUG {puts stderr "print pipe = [manManPipe $f] | $printpipe"}

	set env(PRINTER) $printer; set env(LPDEST) $printer
	eval exec [manManPipe $f] | $printpipe
	manWinstdout $w $tmp
	cd $curdir
	incr stat(print)
}
