package biss.awt;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

/**
 * class to render images for postscript printing
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class PostImageConsumer
  implements ImageConsumer
{
	boolean IsComplete = false;
	int Width;
	int Height;
	int Pels[][];

PostImageConsumer(Image img) {
	ImageProducer ip = img.getSource();
	int t = 1000;

	ip.startProduction(this);
	while(t>0 && !IsComplete) {
		try { Thread.sleep(100); }
		catch (Exception e) {}
		t -= 100;
	}
	ip.removeConsumer( this);
}

public void imageComplete(int status) {
	IsComplete = true;
}

public void setColorModel(ColorModel model) {
}

public void setDimensions(int width, int height) {
	Width = width;
	Height = height;
	Pels = new int[width][height];
}

public void setHints(int hintflags) {
}

public void setPixels(int x1, int y1, int w, int h, 
               ColorModel model, byte pixels[], int off, int scansize) {
	int x, y, sx;
	int sy = off;
	int x2 = x1+w;
	int y2 = y1+h;

	for(y=y1; y<y2; y++) {
		sx = sy;
		for(x=x1; x<x2; x++) 
			Pels[x][y] = model.getRGB( pixels[sx++]);
		sy += scansize;
	}
}

public void setPixels(int x1, int y1, int w, int h, 
               ColorModel model, int pixels[], int off, int scansize) {
	int x, y, sx;
	int sy = off;
	int x2 = x1+w;
	int y2 = y1+h;

	for(y=y1; y<y2; y++) {
		sx = sy;
		for(x=x1; x<x2; x++) 
			Pels[x][y] = pixels[sx++];
		sy += scansize;
	}
}

public void setProperties(Hashtable props) {
}
}
