package biss.awt;

import biss.XorSet;
import biss.XorSetElement;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.util.Vector;

/**
 * replaces java.awt.Checkbox
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Checkbox
  extends Button
  implements CheckboxPeer, XorSetElement
{
	boolean LastState;
	XorSet ExOrs = null;

public Checkbox () {
	this( "");
}

public Checkbox ( String text ) {
	super( text);
	setBackground( Awt.WindowBackClr);
}

public Checkbox ( String pathName, String text ) {
	super( pathName, text);
	setBackground( Awt.WindowBackClr);
}

public Checkbox ( String text, boolean checked ) {
	this( text);
	Pushed = checked;
}

public Checkbox( java.awt.Checkbox peerTarget){
	// create peer object for java.awt.Checkbox
	this( peerTarget.getLabel(), peerTarget.getState() );

	if ( peerTarget.getCheckboxGroup() != null )
		ExOrs = new XorSet();

	setPeerTarget( peerTarget);
	LastState = peerTarget.getState();

	addNotify();
}

public boolean isChecked () {
	return Pushed;
}

public void mouse1Down( Event evt){
	if ( ! isEnabled() )
		return;
	LastState = Pushed;
	Pushed = true;
	redraw();
}

public void mouse1Up( Event evt){
	if ( (evt.x > 0) && (evt.y > 0) && (evt.x < Width) && (evt.y < Height) ){
		trigger();
	}
}

protected void redraw ( Graphics g ) {
	if ( Img != null){
		super.redraw( g);
		return;
	}

	int d = (ExOrs != null) ? Awt.CheckboxWidth + 3 : Awt.CheckboxWidth;
	int y = (Height -d) / 2;
	int x = d + 2*y + Awt.SysFontWidth / 2;
	int df = Awt.FocusMarkWidth;
	int w  = Fm.stringWidth( Text);

	blank( g);

	if ( EventHandler.HasFocus )
		GraphicsLib.drawFocusMark( g, Math.min( Width -df-2, x + Awt.SysFontWidth + w),
	                           Height-df-2, df );

	if ( ! OsDraw.isEmpty() ){
		OsDraw.notifyObservers( this);
		GraphicsLib.paintButton( g, 0, 0, Width, Height, Pushed, null);
		return;
	}

	if ( ExOrs != null )
		GraphicsLib.paintRadio( g, y, y, d, d, Pushed);
	else
		GraphicsLib.paintInstepBox( g, y, y, d, d,
	                            Pushed ? Awt.CheckboxSetClr : Awt.CheckboxUnsetClr );

	y = (Height + Fm.getHeight()) / 2 - Fm.getDescent(); 
	drawText( g, x, y);
}

public void setCheckboxGroup( CheckboxGroup g){
	//java.awt.peer.CheckboxPeer interface
}

public void setChecked ( boolean checked, boolean fire ) {

	if ( ! isEnabled() )
		return;

	Pushed = checked;
	LastState = Pushed;
	redraw();

	if ( Pushed && ExOrs != null && PeerTarget == null )
		ExOrs.setSelfSelected( this);

	if ( fire){
		OsAction.notifyObservers( this);

		if ( PeerTarget != null && LastState )
			peerEvent( Event.ACTION_EVENT, new Boolean( Pushed));
	}
}

public void setExclusive ( XorSet exclusiveSet ) {
	ExOrs = exclusiveSet;
	ExOrs.remember( this);
}

public void setState( boolean state){
	//java.awt.peer.CheckboxPeer interface
	if ( state != LastState )
		setChecked( state, true);
}

public void trigger(){
	boolean an = (ExOrs == null) || (LastState == false);

	if ( ! isEnabled() )	return;
	if ( an)							animate( false);

	if ( ExOrs == null)
		setChecked( !LastState, true);
	else if ( LastState == false)
		setChecked( true, true);

	if ( PeerTarget != null )
		((java.awt.Checkbox)PeerTarget).setState( LastState);
}

public void xorSelect () {

}

public void xorUnselect () {
	setChecked( false, false);
}
}
