package biss;

import java.util.Observable;

/**
 * Refined Observer class which is used to apply the Observer/Observable
 * pattern to arbitrary (not Observable derived) classes by means of
 * ObserverSocket fields
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class ObserverSocket
  extends Observable
{
	protected Object Category;
	protected Object ExtraArg;
	protected Object Owner;

public ObserverSocket( Object owner){
	Owner = owner;
}

public ObserverSocket( Object owner, Object category){
	Owner = owner;
	Category = category;
}

public Object getCategory(){
	return Category;
}

public Object getExtraArg(){
	return ExtraArg;
}

public Object getOwner(){
	return Owner;
}

public boolean hasCategory( Object obj){
	return obj.equals( Category);
}

public boolean hasExtraArg( Object obj){
	return obj.equals( ExtraArg);
}

public boolean hasOwner( Object obj){
	return obj.equals( Owner);
}

public boolean isEmpty(){
	return (countObservers() == 0);
}

public void notifyObservers(){
	notifyObservers( null, null);
}

public void notifyObservers ( Object arg ) {
	notifyObservers( arg, null );
}

public synchronized void notifyObservers( Object arg, Object extraArg ){
	setChanged();
	ExtraArg = extraArg;
	super.notifyObservers( arg);
	clearChanged();
}

public void setCategory( Object obj){
	Category = obj;
}

public void setExtraArg( Object obj){
	ExtraArg = obj;
}
}
